/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.hive.formats.compression.CompressionKind;
import io.trino.hive.orc.OrcConf;
import io.trino.plugin.hive.HiveCompressionCodec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.SequenceFile;

public final class CompressionConfigUtil {
    private CompressionConfigUtil() {
    }

    public static void configureCompression(Configuration config, HiveCompressionCodec compressionCodec) {
        boolean compression = compressionCodec != HiveCompressionCodec.NONE;
        config.setBoolean(HiveConf.ConfVars.COMPRESSRESULT.varname, compression);
        config.setBoolean("mapred.output.compress", compression);
        config.setBoolean("mapreduce.output.fileoutputformat.compress", compression);
        OrcConf.COMPRESS.setString(config, compressionCodec.getOrcCompressionKind().name());
        if (compressionCodec.getHiveCompressionKind().isPresent()) {
            config.set("mapred.output.compression.codec", ((CompressionKind)compressionCodec.getHiveCompressionKind().get()).getHadoopClassName());
            config.set("mapreduce.output.fileoutputformat.compress.codec", ((CompressionKind)compressionCodec.getHiveCompressionKind().get()).getHadoopClassName());
        } else {
            config.unset("mapred.output.compression.codec");
            config.unset("mapreduce.output.fileoutputformat.compress.codec");
        }
        config.set("parquet.compression", compressionCodec.getParquetCompressionCodec().name());
        compressionCodec.getAvroCompressionKind().ifPresent(kind -> config.set("avro.output.codec", kind.toString()));
        config.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
    }
}

