/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DataProviders;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.containers.Minio;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTrinoS3FileSystemAccessOperations
extends AbstractTestQueryFramework {
    private static final String BUCKET = "test-bucket";
    private Minio minio;
    private InMemorySpanExporter spanExporter;

    protected QueryRunner createQueryRunner() throws Exception {
        this.minio = (Minio)this.closeAfterClass((AutoCloseable)Minio.builder().build());
        this.minio.start();
        this.minio.createBucket(BUCKET);
        this.spanExporter = (InMemorySpanExporter)this.closeAfterClass((AutoCloseable)InMemorySpanExporter.create());
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)this.spanExporter)).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).build();
        return ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setMetastore(distributedQueryRunner -> {
            File baseDir = distributedQueryRunner.getCoordinator().getBaseDataDir().resolve("hive_data").toFile();
            return new FileHiveMetastore(new NodeVersion("testversion"), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveMetastoreConfig().isHideDeltaLakeTables(), new FileHiveMetastoreConfig().setCatalogDirectory(baseDir.toURI().toString()).setDisableLocationChecks(true).setMetastoreUser("test"));
        }).setHiveProperties((Map<String, String>)ImmutableMap.builder().put((Object)"hive.s3.aws-access-key", (Object)"accesskey").put((Object)"hive.s3.aws-secret-key", (Object)"secretkey").put((Object)"hive.s3.endpoint", (Object)this.minio.getMinioAddress()).put((Object)"hive.s3.path-style-access", (Object)"true").put((Object)"hive.non-managed-table-writes-enabled", (Object)"true").buildOrThrow()))).setOpenTelemetry((OpenTelemetry)openTelemetry))).setInitialSchemasLocationBase("s3://test-bucket"))).build();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.spanExporter = null;
        this.minio = null;
    }

    @Test(dataProvider="storageFormats")
    public void testSelectWithFilter(StorageFormat format) {
        this.assertUpdate("DROP TABLE IF EXISTS test_select_from_where");
        String tableLocation = TestTrinoS3FileSystemAccessOperations.randomTableLocation("test_select_from_where");
        this.assertUpdate("CREATE TABLE test_select_from_where WITH (format = '" + format + "', external_location = '" + tableLocation + "') AS SELECT 2 AS age", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_select_from_where WHERE age = 2", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"S3.GetObject", TestTrinoS3FileSystemAccessOperations.occurrences(format, 1, 2)).add((Object)"S3.ListObjectsV2").addCopies((Object)"S3.GetObjectMetadata", TestTrinoS3FileSystemAccessOperations.occurrences(format, 1, 0)).build());
        this.assertUpdate("DROP TABLE test_select_from_where");
    }

    @Test(dataProvider="storageFormats")
    public void testSelectPartitionTable(StorageFormat format) {
        this.assertUpdate("DROP TABLE IF EXISTS test_select_from_partition");
        String tableLocation = TestTrinoS3FileSystemAccessOperations.randomTableLocation("test_select_from_partition");
        this.assertUpdate("CREATE TABLE test_select_from_partition (data int, key varchar)WITH (partitioned_by = ARRAY['key'], format = '" + format + "', external_location = '" + tableLocation + "')");
        this.assertUpdate("INSERT INTO test_select_from_partition VALUES (1, 'part1'), (2, 'part2')", 2L);
        this.assertFileSystemAccesses("SELECT * FROM test_select_from_partition", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"S3.GetObject", TestTrinoS3FileSystemAccessOperations.occurrences(format, 2, 4)).addCopies((Object)"S3.ListObjectsV2", 2).addCopies((Object)"S3.GetObjectMetadata", TestTrinoS3FileSystemAccessOperations.occurrences(format, 2, 0)).build());
        this.assertFileSystemAccesses("SELECT * FROM test_select_from_partition WHERE key = 'part1'", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"S3.GetObject", TestTrinoS3FileSystemAccessOperations.occurrences(format, 1, 2)).add((Object)"S3.ListObjectsV2").addCopies((Object)"S3.GetObjectMetadata", TestTrinoS3FileSystemAccessOperations.occurrences(format, 1, 0)).build());
        this.assertUpdate("INSERT INTO test_select_from_partition VALUES (11, 'part1')", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_select_from_partition WHERE key = 'part1'", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"S3.GetObject", TestTrinoS3FileSystemAccessOperations.occurrences(format, 2, 4)).addCopies((Object)"S3.ListObjectsV2", 1).addCopies((Object)"S3.GetObjectMetadata", TestTrinoS3FileSystemAccessOperations.occurrences(format, 2, 0)).build());
        this.assertUpdate("DROP TABLE test_select_from_partition");
    }

    private static String randomTableLocation(String tableName) {
        return "s3://%s/%s/%s-%s".formatted(BUCKET, "tpch", tableName, TestingNames.randomNameSuffix());
    }

    private void assertFileSystemAccesses(@Language(value="SQL") String query, Multiset<String> expectedAccesses) {
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        this.spanExporter.reset();
        queryRunner.executeWithQueryId(queryRunner.getDefaultSession(), query);
        MultisetAssertions.assertMultisetsEqual(this.getOperations(), expectedAccesses);
    }

    private Multiset<String> getOperations() {
        return (Multiset)this.spanExporter.getFinishedSpanItems().stream().map(SpanData::getName).collect(Collectors.toCollection(HashMultiset::create));
    }

    @DataProvider
    public static Object[][] storageFormats() {
        return (Object[][])Arrays.stream(StorageFormat.values()).collect(DataProviders.toDataProvider());
    }

    private static int occurrences(StorageFormat tableType, int orcValue, int parquetValue) {
        Preconditions.checkArgument((orcValue != parquetValue ? 1 : 0) != 0, (Object)"No need to use Occurrences when ORC and Parquet");
        return switch (tableType) {
            default -> throw new IncompatibleClassChangeError();
            case StorageFormat.ORC -> orcValue;
            case StorageFormat.PARQUET -> parquetValue;
        };
    }

    static enum StorageFormat {
        ORC,
        PARQUET;

    }
}

