/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DataProviders;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.containers.Minio;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestHiveS3MinioQueries
extends AbstractTestQueryFramework {
    private Minio minio;

    protected QueryRunner createQueryRunner() throws Exception {
        this.minio = (Minio)this.closeAfterClass((AutoCloseable)Minio.builder().build());
        this.minio.start();
        return ((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setMetastore(queryRunner -> {
            File baseDir = queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data").toFile();
            return new FileHiveMetastore(new NodeVersion("testversion"), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveMetastoreConfig().isHideDeltaLakeTables(), new FileHiveMetastoreConfig().setCatalogDirectory(baseDir.toURI().toString()).setDisableLocationChecks(true).setMetastoreUser("test"));
        }).setHiveProperties((Map<String, String>)ImmutableMap.builder().put((Object)"hive.s3.aws-access-key", (Object)"accesskey").put((Object)"hive.s3.aws-secret-key", (Object)"secretkey").put((Object)"hive.s3.endpoint", (Object)this.minio.getMinioAddress()).put((Object)"hive.s3.path-style-access", (Object)"true").put((Object)"hive.non-managed-table-writes-enabled", (Object)"true").buildOrThrow()))).build();
    }

    @AfterClass(alwaysRun=true)
    public void cleanUp() {
        this.minio = null;
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testTableLocationTopOfTheBucket(boolean locationWithTrailingSlash) {
        String bucketName = "test-bucket-" + TestingNames.randomNameSuffix();
        this.minio.createBucket(bucketName);
        this.minio.writeFile("We are\nawesome at\nmultiple slashes.".getBytes(StandardCharsets.UTF_8), bucketName, "a_file");
        String location = "s3://%s%s".formatted(bucketName, locationWithTrailingSlash ? "/" : "");
        String tableName = "test_table_top_of_bucket_%s_%s".formatted(locationWithTrailingSlash, TestingNames.randomNameSuffix());
        String create = "CREATE TABLE %s (a varchar) WITH (format='TEXTFILE', external_location='%s')".formatted(tableName, location);
        if (!locationWithTrailingSlash) {
            this.assertQueryFails(create, "External location is not a valid file system URI: " + location);
            return;
        }
        this.assertUpdate(create);
        Assertions.assertThat((String)this.getDeclaredTableLocation(tableName)).isEqualTo(location);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE " + tableName))).matches("VALUES VARCHAR 'We are', 'awesome at', 'multiple slashes.'");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 'Aren''t we?'", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE " + tableName))).matches("VALUES VARCHAR 'We are', 'awesome at', 'multiple slashes.', 'Aren''t we?'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private String getDeclaredTableLocation(String tableName) {
        Object result;
        Pattern locationPattern = Pattern.compile(".*external_location = '(.*?)'.*", 32);
        Matcher matcher = locationPattern.matcher((String)(result = this.computeScalar("SHOW CREATE TABLE " + tableName)));
        if (matcher.find()) {
            String location = matcher.group(1);
            Verify.verify((!matcher.find() ? 1 : 0) != 0, (String)"Unexpected second match", (Object[])new Object[0]);
            return location;
        }
        throw new IllegalStateException("Location not found in: " + result);
    }
}

