/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet.write;

import io.trino.plugin.hive.parquet.write.TestDataWritableWriter;
import java.util.HashMap;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.write.DataWritableWriteSupport;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;

class TestDataWritableWriteSupport
extends WriteSupport<ParquetHiveRecord> {
    private TestDataWritableWriter writer;
    private MessageType schema;
    private final boolean singleLevelArray;
    private final DateTimeZone dateTimeZone;

    public TestDataWritableWriteSupport(boolean singleLevelArray, DateTimeZone dateTimeZone) {
        this.singleLevelArray = singleLevelArray;
        this.dateTimeZone = Objects.requireNonNull(dateTimeZone, "dateTimeZone is null");
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        this.schema = DataWritableWriteSupport.getSchema((Configuration)configuration);
        return new WriteSupport.WriteContext(this.schema, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.writer = new TestDataWritableWriter(recordConsumer, (GroupType)this.schema, this.singleLevelArray, this.dateTimeZone);
    }

    public void write(ParquetHiveRecord record) {
        this.writer.write(record);
    }
}

