/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.io.Resources;
import io.trino.Session;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import java.io.File;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestReadingTimeLogicalAnnotation {
    @Test
    public void testReadingTimeLogicalAnnotationAsBigInt() throws Exception {
        File parquetFile = new File(Resources.getResource((String)"parquet_file_with_time_logical_annotation").toURI());
        try (DistributedQueryRunner queryRunner = HiveQueryRunner.builder().build();
             QueryAssertions assertions = new QueryAssertions((QueryRunner)queryRunner);){
            queryRunner.execute(String.format("CREATE TABLE table_with_time_logical_annotation (\n    \"opens\" row(member0 bigint, member_1 varchar))\nWITH (\n    external_location = '%s',\n    format = 'PARQUET')\n", parquetFile.getAbsolutePath()));
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)assertions.query("SELECT opens.member0 FROM table_with_time_logical_annotation GROUP BY 1 ORDER BY 1 LIMIT 5"))).matches(MaterializedResult.resultBuilder((Session)queryRunner.getDefaultSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).row(new Object[]{21600000000L}).row(new Object[]{25200000000L}).row(new Object[]{28800000000L}).row(new Object[]{32400000000L}).build());
            queryRunner.execute("DROP TABLE table_with_time_logical_annotation");
        }
    }
}

