/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.plugin.hive.metastore.BooleanStatistics;
import io.trino.plugin.hive.metastore.DateStatistics;
import io.trino.plugin.hive.metastore.DecimalStatistics;
import io.trino.plugin.hive.metastore.DoubleStatistics;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.IntegerStatistics;
import io.trino.plugin.hive.metastore.thrift.ThriftSparkMetastoreUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftSparkMetastoreUtil {
    @Test
    public void testSparkLongStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_long.min", "1", "spark.sql.statistics.colStats.c_long.distinctCount", "4", "spark.sql.statistics.colStats.c_long.maxLen", "4", "spark.sql.statistics.colStats.c_long.avgLen", "4", "spark.sql.statistics.colStats.c_long.nullCount", "0", "spark.sql.statistics.colStats.c_long.version", "2", "spark.sql.statistics.colStats.c_long.max", "4");
        HiveColumnStatistics actualNotExists = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_long_not_exists", "bigint", null), columnStatistics, (long)4L);
        Assert.assertEquals((Object)actualNotExists, (Object)HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
        HiveColumnStatistics actual = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_long", "bigint", null), columnStatistics, (long)4L);
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(4L))).setNullsCount(0L).setDistinctValuesCount(4L).build());
    }

    @Test
    public void testSparkDoubleStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_double.min", "0.3", "spark.sql.statistics.colStats.c_double.distinctCount", "10", "spark.sql.statistics.colStats.c_double.maxLen", "4", "spark.sql.statistics.colStats.c_double.avgLen", "4", "spark.sql.statistics.colStats.c_double.nullCount", "1", "spark.sql.statistics.colStats.c_double.version", "2", "spark.sql.statistics.colStats.c_double.max", "3.3");
        HiveColumnStatistics actualNotExists = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_double_not_exists", "double", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actualNotExists, (Object)HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build());
        HiveColumnStatistics actual = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_double", "double", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(0.3), OptionalDouble.of(3.3))).setNullsCount(1L).setDistinctValuesCount(9L).build());
    }

    @Test
    public void testSparkDecimalStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_decimal.min", "0.3", "spark.sql.statistics.colStats.c_decimal.distinctCount", "10", "spark.sql.statistics.colStats.c_decimal.maxLen", "4", "spark.sql.statistics.colStats.c_decimal.avgLen", "4", "spark.sql.statistics.colStats.c_decimal.nullCount", "1", "spark.sql.statistics.colStats.c_decimal.version", "2", "spark.sql.statistics.colStats.c_decimal.max", "3.3");
        HiveColumnStatistics actualNotExists = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_decimal_not_exists", "decimal", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actualNotExists, (Object)HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build());
        HiveColumnStatistics actual = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_decimal", "decimal", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(new BigDecimal("0.3")), Optional.of(new BigDecimal("3.3")))).setNullsCount(1L).setDistinctValuesCount(9L).build());
    }

    @Test
    public void testSparkBooleanStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_bool.min", "false", "spark.sql.statistics.colStats.c_bool.distinctCount", "2", "spark.sql.statistics.colStats.c_bool.maxLen", "1", "spark.sql.statistics.colStats.c_bool.avgLen", "1", "spark.sql.statistics.colStats.c_bool.nullCount", "1", "spark.sql.statistics.colStats.c_bool.version", "2", "spark.sql.statistics.colStats.c_bool.max", "true");
        HiveColumnStatistics actualNotExists = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_bool_not_exists", "boolean", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actualNotExists, (Object)HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
        HiveColumnStatistics actual = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_bool", "boolean", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).setNullsCount(1L).build());
    }

    @Test
    public void testSparkDateStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_date.min", "2000-01-01", "spark.sql.statistics.colStats.c_date.distinctCount", "10", "spark.sql.statistics.colStats.c_date.maxLen", "4", "spark.sql.statistics.colStats.c_date.avgLen", "4", "spark.sql.statistics.colStats.c_date.nullCount", "3", "spark.sql.statistics.colStats.c_date.version", "2", "spark.sql.statistics.colStats.c_date.max", "2030-12-31");
        HiveColumnStatistics actualNotExists = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_date_not_exists", "date", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actualNotExists, (Object)HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build());
        HiveColumnStatistics actual = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_date", "date", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.of(2000, 1, 1)), Optional.of(LocalDate.of(2030, 12, 31)))).setNullsCount(3L).setDistinctValuesCount(7L).build());
    }

    @Test
    public void testSparkStringStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_char.distinctCount", "3", "spark.sql.statistics.colStats.c_char.avgLen", "10", "spark.sql.statistics.colStats.char_col.maxLen", "10", "spark.sql.statistics.colStats.c_char.nullCount", "7", "spark.sql.statistics.colStats.c_char.version", "2");
        HiveColumnStatistics actualNotExists = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_char_not_exists", "string", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actualNotExists, (Object)HiveColumnStatistics.builder().build());
        HiveColumnStatistics actual = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_char", "string", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setNullsCount(7L).setDistinctValuesCount(3L).setTotalSizeInBytes(30L).build());
    }

    @Test
    public void testSparkBinaryStatsToColumnStatistics() {
        Map<String, String> columnStatistics = Map.of("spark.sql.statistics.colStats.c_bin.distinctCount", "7", "spark.sql.statistics.colStats.c_bin.avgLen", "10", "spark.sql.statistics.colStats.c_bin.maxLen", "10", "spark.sql.statistics.colStats.c_bin.nullCount", "3", "spark.sql.statistics.colStats.c_bin.version", "2");
        HiveColumnStatistics actualNotExists = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_bin_not_exists", "binary", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actualNotExists, (Object)HiveColumnStatistics.builder().build());
        HiveColumnStatistics actual = ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics((FieldSchema)new FieldSchema("c_bin", "binary", null), columnStatistics, (long)10L);
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setNullsCount(3L).setTotalSizeInBytes(70L).setMaxValueSizeInBytes(10L).build());
    }
}

