/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.trino.hive.thrift.metastore.BinaryColumnStatsData;
import io.trino.hive.thrift.metastore.BooleanColumnStatsData;
import io.trino.hive.thrift.metastore.ColumnStatisticsData;
import io.trino.hive.thrift.metastore.ColumnStatisticsObj;
import io.trino.hive.thrift.metastore.Date;
import io.trino.hive.thrift.metastore.DateColumnStatsData;
import io.trino.hive.thrift.metastore.DecimalColumnStatsData;
import io.trino.hive.thrift.metastore.DoubleColumnStatsData;
import io.trino.hive.thrift.metastore.LongColumnStatsData;
import io.trino.hive.thrift.metastore.StringColumnStatsData;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.metastore.BooleanStatistics;
import io.trino.plugin.hive.metastore.DateStatistics;
import io.trino.plugin.hive.metastore.DecimalStatistics;
import io.trino.plugin.hive.metastore.DoubleStatistics;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.IntegerStatistics;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftMetastoreUtil {
    @Test
    public void testLongStatsToColumnStatistics() {
        LongColumnStatsData longColumnStatsData = new LongColumnStatsData();
        longColumnStatsData.setLowValue(0L);
        longColumnStatsData.setHighValue(100L);
        longColumnStatsData.setNumNulls(1L);
        longColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "bigint", ColumnStatisticsData.longStats((LongColumnStatsData)longColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(1000L));
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(0L), OptionalLong.of(100L))).setNullsCount(1L).setDistinctValuesCount(19L).build());
    }

    @Test
    public void testEmptyLongStatsToColumnStatistics() {
        LongColumnStatsData emptyLongColumnStatsData = new LongColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "bigint", ColumnStatisticsData.longStats((LongColumnStatsData)emptyLongColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
    }

    @Test
    public void testDoubleStatsToColumnStatistics() {
        DoubleColumnStatsData doubleColumnStatsData = new DoubleColumnStatsData();
        doubleColumnStatsData.setLowValue(0.0);
        doubleColumnStatsData.setHighValue(100.0);
        doubleColumnStatsData.setNumNulls(1L);
        doubleColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)doubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(1000L));
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(0.0), OptionalDouble.of(100.0))).setNullsCount(1L).setDistinctValuesCount(19L).build());
    }

    @Test
    public void testEmptyDoubleStatsToColumnStatistics() {
        DoubleColumnStatsData emptyDoubleColumnStatsData = new DoubleColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)emptyDoubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build());
    }

    @Test
    public void testDecimalStatsToColumnStatistics() {
        DecimalColumnStatsData decimalColumnStatsData = new DecimalColumnStatsData();
        BigDecimal low = new BigDecimal("0");
        decimalColumnStatsData.setLowValue(ThriftMetastoreUtil.toMetastoreDecimal((BigDecimal)low));
        BigDecimal high = new BigDecimal("100");
        decimalColumnStatsData.setHighValue(ThriftMetastoreUtil.toMetastoreDecimal((BigDecimal)high));
        decimalColumnStatsData.setNumNulls(1L);
        decimalColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "decimal", ColumnStatisticsData.decimalStats((DecimalColumnStatsData)decimalColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(1000L));
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(low), Optional.of(high))).setNullsCount(1L).setDistinctValuesCount(19L).build());
    }

    @Test
    public void testEmptyDecimalStatsToColumnStatistics() {
        DecimalColumnStatsData emptyDecimalColumnStatsData = new DecimalColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "decimal", ColumnStatisticsData.decimalStats((DecimalColumnStatsData)emptyDecimalColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build());
    }

    @Test
    public void testBooleanStatsToColumnStatistics() {
        BooleanColumnStatsData booleanColumnStatsData = new BooleanColumnStatsData();
        booleanColumnStatsData.setNumTrues(100L);
        booleanColumnStatsData.setNumFalses(10L);
        booleanColumnStatsData.setNumNulls(0L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "boolean", ColumnStatisticsData.booleanStats((BooleanColumnStatsData)booleanColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.of(100L), OptionalLong.of(10L))).setNullsCount(0L).build());
    }

    @Test
    public void testImpalaGeneratedBooleanStatistics() {
        BooleanColumnStatsData statsData = new BooleanColumnStatsData(1L, -1L, 2L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "boolean", ColumnStatisticsData.booleanStats((BooleanColumnStatsData)statsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).setNullsCount(2L).build());
    }

    @Test
    public void testEmptyBooleanStatsToColumnStatistics() {
        BooleanColumnStatsData emptyBooleanColumnStatsData = new BooleanColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "boolean", ColumnStatisticsData.booleanStats((BooleanColumnStatsData)emptyBooleanColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
    }

    @Test
    public void testDateStatsToColumnStatistics() {
        DateColumnStatsData dateColumnStatsData = new DateColumnStatsData();
        dateColumnStatsData.setLowValue(new Date(1000L));
        dateColumnStatsData.setHighValue(new Date(2000L));
        dateColumnStatsData.setNumNulls(1L);
        dateColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "date", ColumnStatisticsData.dateStats((DateColumnStatsData)dateColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(1000L));
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(1000L)), Optional.of(LocalDate.ofEpochDay(2000L)))).setNullsCount(1L).setDistinctValuesCount(19L).build());
    }

    @Test
    public void testEmptyDateStatsToColumnStatistics() {
        DateColumnStatsData emptyDateColumnStatsData = new DateColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "date", ColumnStatisticsData.dateStats((DateColumnStatsData)emptyDateColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build());
    }

    @Test
    public void testStringStatsToColumnStatistics() {
        StringColumnStatsData stringColumnStatsData = new StringColumnStatsData();
        stringColumnStatsData.setMaxColLen(100L);
        stringColumnStatsData.setAvgColLen(23.333);
        stringColumnStatsData.setNumNulls(1L);
        stringColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "string", ColumnStatisticsData.stringStats((StringColumnStatsData)stringColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(2L));
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setMaxValueSizeInBytes(100L).setTotalSizeInBytes(23L).setNullsCount(1L).setDistinctValuesCount(1L).build());
    }

    @Test
    public void testEmptyStringColumnStatsData() {
        StringColumnStatsData emptyStringColumnStatsData = new StringColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "string", ColumnStatisticsData.stringStats((StringColumnStatsData)emptyStringColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().build());
    }

    @Test
    public void testBinaryStatsToColumnStatistics() {
        BinaryColumnStatsData binaryColumnStatsData = new BinaryColumnStatsData();
        binaryColumnStatsData.setMaxColLen(100L);
        binaryColumnStatsData.setAvgColLen(22.2);
        binaryColumnStatsData.setNumNulls(2L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "binary", ColumnStatisticsData.binaryStats((BinaryColumnStatsData)binaryColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(4L));
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().setMaxValueSizeInBytes(100L).setTotalSizeInBytes(44L).setNullsCount(2L).build());
    }

    @Test
    public void testEmptyBinaryStatsToColumnStatistics() {
        BinaryColumnStatsData emptyBinaryColumnStatsData = new BinaryColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "binary", ColumnStatisticsData.binaryStats((BinaryColumnStatsData)emptyBinaryColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual, (Object)HiveColumnStatistics.builder().build());
    }

    @Test
    public void testSingleDistinctValue() {
        DoubleColumnStatsData doubleColumnStatsData = new DoubleColumnStatsData();
        doubleColumnStatsData.setNumNulls(10L);
        doubleColumnStatsData.setNumDVs(1L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)doubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(10L));
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(10L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(0L));
        doubleColumnStatsData = new DoubleColumnStatsData();
        doubleColumnStatsData.setNumNulls(10L);
        doubleColumnStatsData.setNumDVs(1L);
        columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)doubleColumnStatsData));
        actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(11L));
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(10L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(1L));
    }

    @Test
    public void testSparkFallbackGetBasicStatistics() {
        Map<String, String> tableParameters = Map.of("spark.sql.statistics.numFiles", "1", "spark.sql.statistics.numRows", "2", "spark.sql.statistics.rawDataSize", "3", "spark.sql.statistics.totalSize", "4");
        HiveBasicStatistics actual = ThriftMetastoreUtil.getBasicStatisticsWithSparkFallback(tableParameters);
        Assert.assertEquals((Object)actual, (Object)new HiveBasicStatistics(OptionalLong.of(1L), OptionalLong.of(2L), OptionalLong.of(3L), OptionalLong.of(4L)));
        actual = ThriftMetastoreUtil.getHiveBasicStatistics(tableParameters);
        Assert.assertEquals((Object)actual, (Object)new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty()));
        tableParameters = Map.of("numFiles", "0", "numRows", "0", "rawDataSize", "0", "totalSize", "0", "spark.sql.statistics.numFiles", "1", "spark.sql.statistics.numRows", "2", "spark.sql.statistics.rawDataSize", "3", "spark.sql.statistics.totalSize", "4");
        actual = ThriftMetastoreUtil.getBasicStatisticsWithSparkFallback(tableParameters);
        Assert.assertEquals((Object)actual, (Object)new HiveBasicStatistics(OptionalLong.of(1L), OptionalLong.of(2L), OptionalLong.of(3L), OptionalLong.of(4L)));
        actual = ThriftMetastoreUtil.getHiveBasicStatistics(tableParameters);
        Assert.assertEquals((Object)actual, (Object)new HiveBasicStatistics(OptionalLong.of(0L), OptionalLong.of(0L), OptionalLong.of(0L), OptionalLong.of(0L)));
        tableParameters = Map.of("numFiles", "10", "numRows", "20", "rawDataSize", "30", "totalSize", "40", "spark.sql.statistics.numFiles", "1", "spark.sql.statistics.numRows", "2", "spark.sql.statistics.rawDataSize", "3", "spark.sql.statistics.totalSize", "4");
        actual = ThriftMetastoreUtil.getBasicStatisticsWithSparkFallback(tableParameters);
        Assert.assertEquals((Object)actual, (Object)new HiveBasicStatistics(OptionalLong.of(10L), OptionalLong.of(20L), OptionalLong.of(30L), OptionalLong.of(40L)));
    }

    @Test
    public void testBasicStatisticsRoundTrip() {
        TestThriftMetastoreUtil.testBasicStatisticsRoundTrip(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty()));
        TestThriftMetastoreUtil.testBasicStatisticsRoundTrip(new HiveBasicStatistics(OptionalLong.of(1L), OptionalLong.empty(), OptionalLong.of(2L), OptionalLong.empty()));
        TestThriftMetastoreUtil.testBasicStatisticsRoundTrip(new HiveBasicStatistics(OptionalLong.of(1L), OptionalLong.of(2L), OptionalLong.of(3L), OptionalLong.of(4L)));
    }

    private static void testBasicStatisticsRoundTrip(HiveBasicStatistics expected) {
        Assert.assertEquals((Object)ThriftMetastoreUtil.getHiveBasicStatistics((Map)ThriftMetastoreUtil.updateStatisticsParameters((Map)ImmutableMap.of(), (HiveBasicStatistics)expected)), (Object)expected);
    }

    @Test
    public void testListApplicableRoles() {
        TrinoPrincipal admin = new TrinoPrincipal(PrincipalType.USER, "admin");
        ImmutableMultimap inheritance = ImmutableMultimap.builder().put((Object)"a", (Object)"b1").put((Object)"a", (Object)"b2").put((Object)"b1", (Object)"d").put((Object)"b1", (Object)"e").put((Object)"b2", (Object)"d").put((Object)"b2", (Object)"e").put((Object)"d", (Object)"u").put((Object)"e", (Object)"w").build();
        Assertions.assertThat((Stream)ThriftMetastoreUtil.listApplicableRoles((HivePrincipal)new HivePrincipal(PrincipalType.ROLE, "a"), arg_0 -> TestThriftMetastoreUtil.lambda$testListApplicableRoles$1((Multimap)inheritance, admin, arg_0))).containsOnly((Object[])new RoleGrant[]{new RoleGrant(admin, "b1", false), new RoleGrant(admin, "b2", false), new RoleGrant(admin, "d", false), new RoleGrant(admin, "e", false), new RoleGrant(admin, "u", false), new RoleGrant(admin, "w", false)});
    }

    private static /* synthetic */ Set lambda$testListApplicableRoles$1(Multimap inheritance, TrinoPrincipal admin, HivePrincipal principal) {
        return (Set)inheritance.get((Object)principal.getName()).stream().map(name -> new RoleGrant(admin, name, false)).collect(ImmutableSet.toImmutableSet());
    }
}

