/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.trino.Session;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.CountingAccessHiveMetastore;
import io.trino.plugin.hive.metastore.CountingAccessHiveMetastoreUtil;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.UnimplementedHiveMetastore;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SchemaTableName;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DataProviders;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveMetastoreMetadataQueriesAccessOperations
extends AbstractTestQueryFramework {
    private static final int MAX_PREFIXES_COUNT = 20;
    private static final int TEST_SCHEMAS_COUNT = 21;
    private static final int TEST_TABLES_IN_SCHEMA_COUNT = 23;
    private static final int TEST_ALL_TABLES_COUNT = 483;
    private MockHiveMetastore mockMetastore;
    private CountingAccessHiveMetastore metastore;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().setCatalog("hive").setSchema(Optional.empty()).build()).setNodeCount(1).addCoordinatorProperty("optimizer.experimental-max-prefetched-information-schema-prefixes", Integer.toString(20)).build();
        this.mockMetastore = new MockHiveMetastore();
        this.metastore = new CountingAccessHiveMetastore(this.mockMetastore);
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(this.metastore));
        queryRunner.createCatalog("hive", "hive", (Map)ImmutableMap.of());
        return queryRunner;
    }

    @BeforeMethod
    public void resetMetastoreSetup() {
        this.mockMetastore.setAllTablesViewsImplemented(false);
    }

    @Test
    public void testSelectSchemasWithoutPredicate() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.schemata", (Multiset<?>)ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.schemas", (Multiset<?>)ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES)));
    }

    @Test
    public void testSelectSchemasWithFilterByInformationSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.schemata WHERE schema_name = 'information_schema'", (Multiset<?>)ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.schemas WHERE table_schem = 'information_schema'", (Multiset<?>)ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES)));
    }

    @Test
    public void testSelectSchemasWithLikeOverSchemaName() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.schemata WHERE schema_name LIKE 'test%'", (Multiset<?>)ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.schemas WHERE table_schem LIKE 'test%'", (Multiset<?>)ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES)));
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectTablesWithoutPredicate(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
    }

    @Test
    public void testSelectTablesWithFilterByInformationSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables WHERE table_schema = 'information_schema'", (Multiset<?>)ImmutableMultiset.of());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_schem = 'information_schema'", (Multiset<?>)ImmutableMultiset.of());
    }

    @Test
    public void testSelectTablesWithFilterBySchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables WHERE table_schema = 'test_schema_0'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_schem = 'test_schema_0'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE).build());
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectTablesWithLikeOverSchema(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables WHERE table_schema LIKE 'test%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_schem LIKE 'test%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectTablesWithFilterByTableName(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables WHERE table_name = 'test_table_0'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_name = 'test_table_0'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_name LIKE 'test\\_table\\_0' ESCAPE '\\'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_name LIKE 'test_table_0' ESCAPE '\\'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectTablesWithLikeOverTableName(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.tables WHERE table_name LIKE 'test%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_name LIKE 'test%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectViewsWithoutPredicate(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS)) : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
    }

    @Test
    public void testSelectViewsWithFilterByInformationSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views WHERE table_schema = 'information_schema'", (Multiset<?>)ImmutableMultiset.of());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW' AND table_schem = 'information_schema'", (Multiset<?>)ImmutableMultiset.of());
    }

    @Test
    public void testSelectViewsWithFilterBySchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views WHERE table_schema = 'test_schema_0'", (Multiset<?>)ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW' AND table_schem = 'test_schema_0'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE).build());
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectViewsWithLikeOverSchema(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views WHERE table_schema LIKE 'test%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW' AND table_schem LIKE 'test%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectViewsWithFilterByTableName(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views WHERE table_name = 'test_table_0'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW' AND table_name = 'test_table_0'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectViewsWithLikeOverTableName(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.views WHERE table_name LIKE 'test%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.tables WHERE table_type = 'VIEW' AND table_name LIKE 'test%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).build()));
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectColumnsWithoutPredicate(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build()));
    }

    @Test
    public void testSelectColumnsFilterByInformationSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_schema = 'information_schema'", (Multiset<?>)ImmutableMultiset.of());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem = 'information_schema'", (Multiset<?>)ImmutableMultiset.of());
    }

    @Test
    public void testSelectColumnsFilterBySchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_schema = 'test_schema_0'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 23).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem = 'test_schema_0'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 23).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem LIKE 'test\\_schema\\_0' ESCAPE '\\'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 23).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem LIKE 'test_schema_0' ESCAPE '\\'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 23).build());
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectColumnsWithLikeOverSchema(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_schema LIKE 'test%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem LIKE 'test%'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build());
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectColumnsFilterByTableName(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_name = 'test_table_0'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_name = 'test_table_0'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 21).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_name LIKE 'test\\_table\\_0' ESCAPE '\\'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 21).build());
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_name LIKE 'test_table_0' ESCAPE '\\'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 21).build());
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectColumnsWithLikeOverTableName(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_name LIKE 'test%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_name LIKE 'test%'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build());
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectColumnsFilterByColumn(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE column_name = 'name'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE column_name = 'name'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build()));
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testSelectColumnsWithLikeOverColumn(boolean allTablesViewsImplemented) {
        this.mockMetastore.setAllTablesViewsImplemented(allTablesViewsImplemented);
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE column_name LIKE 'n%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build()));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE column_name LIKE 'n%'", (Multiset<?>)(allTablesViewsImplemented ? ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build() : ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_ALL_VIEWS_FROM_DATABASE, 21).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 483).build()));
    }

    @Test
    public void testSelectColumnsFilterByTableAndSchema() {
        this.assertMetastoreInvocations("SELECT * FROM information_schema.columns WHERE table_schema = 'test_schema_0' AND table_name = 'test_table_0'", (Multiset<?>)ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_TABLE)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem = 'test_schema_0' AND table_name = 'test_table_0'", (Multiset<?>)ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_TABLE)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem LIKE 'test\\_schema\\_0' ESCAPE '\\' AND table_name LIKE 'test\\_table\\_0' ESCAPE '\\'", (Multiset<?>)ImmutableMultiset.of((Object)((Object)CountingAccessHiveMetastore.Method.GET_TABLE)));
        this.assertMetastoreInvocations("SELECT * FROM system.jdbc.columns WHERE table_schem LIKE 'test_schema_0' ESCAPE '\\' AND table_name LIKE 'test_table_0' ESCAPE '\\'", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_ALL_DATABASES).add((Object)CountingAccessHiveMetastore.Method.GET_ALL_TABLES_FROM_DATABASE).add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).build());
    }

    private void assertMetastoreInvocations(@Language(value="SQL") String query, Multiset<?> expectedInvocations) {
        CountingAccessHiveMetastoreUtil.assertMetastoreInvocations(this.metastore, this.getQueryRunner(), this.getQueryRunner().getDefaultSession(), query, expectedInvocations);
    }

    private static class MockHiveMetastore
    extends UnimplementedHiveMetastore {
        private static final List<String> SCHEMAS = (List)IntStream.range(0, 21).mapToObj(arg_0 -> MockHiveMetastore.lambda$static$0("test_schema_%d", arg_0)).collect(ImmutableList.toImmutableList());
        private static final List<String> TABLES_PER_SCHEMA = (List)IntStream.range(0, 23).mapToObj(arg_0 -> MockHiveMetastore.lambda$static$1("test_table_%d", arg_0)).collect(ImmutableList.toImmutableList());
        private static final ImmutableList<SchemaTableName> ALL_TABLES = (ImmutableList)SCHEMAS.stream().flatMap(schema -> TABLES_PER_SCHEMA.stream().map(table -> new SchemaTableName(schema, table))).collect(ImmutableList.toImmutableList());
        private boolean allTablesViewsImplemented;

        private MockHiveMetastore() {
        }

        @Override
        public List<String> getAllDatabases() {
            return SCHEMAS;
        }

        @Override
        public List<String> getAllTables(String databaseName) {
            return TABLES_PER_SCHEMA;
        }

        @Override
        public Optional<List<SchemaTableName>> getAllTables() {
            if (this.allTablesViewsImplemented) {
                return Optional.of(ALL_TABLES);
            }
            return Optional.empty();
        }

        @Override
        public List<String> getAllViews(String databaseName) {
            return ImmutableList.of();
        }

        @Override
        public Optional<List<SchemaTableName>> getAllViews() {
            if (this.allTablesViewsImplemented) {
                return Optional.of(ImmutableList.of());
            }
            return Optional.empty();
        }

        @Override
        public Optional<Table> getTable(String databaseName, String tableName) {
            return Optional.of(Table.builder().setDatabaseName(databaseName).setTableName(tableName).setDataColumns((List)ImmutableList.of((Object)new Column("id", HiveType.HIVE_INT, Optional.empty()), (Object)new Column("name", HiveType.HIVE_STRING, Optional.empty()))).setOwner(Optional.empty()).setTableType(TableType.MANAGED_TABLE.name()).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC)).setLocation(Optional.empty())).build());
        }

        public void setAllTablesViewsImplemented(boolean allTablesViewsImplemented) {
            this.allTablesViewsImplemented = allTablesViewsImplemented;
        }

        private static /* synthetic */ String lambda$static$1(String rec$, Object xva$0) {
            return "test_table_%d".formatted(xva$0);
        }

        private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
            return "test_schema_%d".formatted(xva$0);
        }
    }
}

