/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.slice.Slices;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.AbstractTestHive;
import io.trino.plugin.hive.AbstractTestHiveLocal;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.aws.AwsApiCallStats;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.glue.AwsSdkUtil;
import io.trino.plugin.hive.metastore.glue.DefaultGlueColumnStatisticsProviderFactory;
import io.trino.plugin.hive.metastore.glue.DefaultGlueMetastoreTableFilterProvider;
import io.trino.plugin.hive.metastore.glue.GlueClientUtil;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProviderFactory;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.PartitionFilterBuilder;
import io.trino.plugin.hive.metastore.glue.converter.GlueInputConverter;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingPageSinkId;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveGlueMetastore
extends AbstractTestHiveLocal {
    private static final Logger log = Logger.get(TestHiveGlueMetastore.class);
    private static final String PARTITION_KEY = "part_key_1";
    private static final String PARTITION_KEY2 = "part_key_2";
    private static final String TEST_DATABASE_NAME_PREFIX = "test_glue";
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS = ImmutableList.of((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT));
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)VarcharType.VARCHAR)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_TWO_KEYS = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("part_key_2", (Type)BigintType.BIGINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_TINYINT = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)TinyintType.TINYINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_SMALLINT = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)SmallintType.SMALLINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_INTEGER = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)IntegerType.INTEGER)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_BIGINT = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)BigintType.BIGINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_DECIMAL = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)PartitionFilterBuilder.DECIMAL_TYPE)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_DATE = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)DateType.DATE)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_TIMESTAMP = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)TimestampType.TIMESTAMP_MILLIS)).build();
    private static final List<String> VARCHAR_PARTITION_VALUES = ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01");
    protected static final HiveBasicStatistics HIVE_BASIC_STATISTICS = new HiveBasicStatistics(1000L, 5000L, 3000L, 4000L);
    protected static final HiveColumnStatistics INTEGER_COLUMN_STATISTICS = HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(-1000L), (OptionalLong)OptionalLong.of(1000L), (OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L));
    private HiveMetastoreClosure metastore;
    private AWSGlueAsync glueClient;

    public TestHiveGlueMetastore() {
        super(TEST_DATABASE_NAME_PREFIX + UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", ""));
    }

    protected AWSGlueAsync getGlueClient() {
        return this.glueClient;
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.initialize();
    }

    @BeforeClass
    public void setup() {
        this.metastore = new HiveMetastoreClosure(this.metastoreClient);
        this.glueClient = AWSGlueAsyncClientBuilder.defaultClient();
    }

    @Override
    protected HiveMetastore createMetastore(File tempDir) {
        GlueHiveMetastoreConfig glueConfig = new GlueHiveMetastoreConfig();
        glueConfig.setDefaultWarehouseDir(tempDir.toURI().toString());
        glueConfig.setAssumeCanonicalPartitionKeys(true);
        BoundedExecutor executor = new BoundedExecutor((Executor)this.executor, 10);
        GlueMetastoreStats stats = new GlueMetastoreStats();
        return new GlueHiveMetastore((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, glueConfig, (Executor)executor, (GlueColumnStatisticsProviderFactory)new DefaultGlueColumnStatisticsProviderFactory((Executor)executor, (Executor)executor), GlueClientUtil.createAsyncGlueClient((GlueHiveMetastoreConfig)glueConfig, (AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), (Set)ImmutableSet.of(), (RequestMetricCollector)stats.newRequestMetricsCollector()), stats, new DefaultGlueMetastoreTableFilterProvider(true).get());
    }

    @Test
    public void cleanupOrphanedDatabases() {
        long creationTimeMillisThreshold = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L);
        GlueHiveMetastore metastore = (GlueHiveMetastore)this.getMetastoreClient();
        GlueMetastoreStats stats = metastore.getStats();
        List orphanedDatabases = (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getDatabases(arg_0), (Object)new GetDatabasesRequest(), GetDatabasesRequest::setNextToken, GetDatabasesResult::getNextToken, (AwsApiCallStats)stats.getGetDatabases()).map(GetDatabasesResult::getDatabaseList).flatMap(Collection::stream).filter(database -> database.getName().startsWith(TEST_DATABASE_NAME_PREFIX) && database.getCreateTime().getTime() <= creationTimeMillisThreshold).map(Database::getName).collect(ImmutableList.toImmutableList());
        log.info("Found %s %s* databases that look orphaned, removing", new Object[]{orphanedDatabases.size(), TEST_DATABASE_NAME_PREFIX});
        orphanedDatabases.forEach(database -> {
            try {
                this.glueClient.deleteDatabase(new DeleteDatabaseRequest().withName(database));
            }
            catch (EntityNotFoundException e) {
                log.info("Database [%s] not found, could be removed by other cleanup process", new Object[]{database});
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to remove database [%s]", new Object[]{database});
            }
        });
    }

    @Override
    public void testRenameTable() {
    }

    @Override
    public void testUpdateTableColumnStatisticsEmptyOptionalFields() {
    }

    @Override
    public void testUpdatePartitionColumnStatisticsEmptyOptionalFields() {
    }

    @Override
    public void testUpdateBasicPartitionStatistics() throws Exception {
        SchemaTableName tableName = this.temporaryTable("update_basic_partition_statistics");
        try {
            this.createDummyPartitionedTable(tableName, STATISTICS_PARTITIONED_TABLE_COLUMNS);
            this.testUpdatePartitionStatistics(tableName, EMPTY_ROWCOUNT_STATISTICS, (List<PartitionStatistics>)ImmutableList.of((Object)BASIC_STATISTICS_1, (Object)BASIC_STATISTICS_2), (List<PartitionStatistics>)ImmutableList.of((Object)BASIC_STATISTICS_2, (Object)BASIC_STATISTICS_1));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Override
    public void testUpdatePartitionColumnStatistics() throws Exception {
        SchemaTableName tableName = this.temporaryTable("update_partition_column_statistics");
        try {
            this.createDummyPartitionedTable(tableName, STATISTICS_PARTITIONED_TABLE_COLUMNS);
            this.testUpdatePartitionStatistics(tableName, EMPTY_ROWCOUNT_STATISTICS, (List<PartitionStatistics>)ImmutableList.of((Object)STATISTICS_1_1, (Object)STATISTICS_1_2, (Object)STATISTICS_2), (List<PartitionStatistics>)ImmutableList.of((Object)STATISTICS_1_2, (Object)STATISTICS_1_1, (Object)STATISTICS_2));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Override
    public void testStorePartitionWithStatistics() throws Exception {
        this.testStorePartitionWithStatistics(STATISTICS_PARTITIONED_TABLE_COLUMNS, BASIC_STATISTICS_1, BASIC_STATISTICS_2, BASIC_STATISTICS_1, EMPTY_ROWCOUNT_STATISTICS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testGetPartitions() throws Exception {
        try {
            SchemaTableName tableName = this.temporaryTable("get_partitions");
            this.createDummyPartitionedTable(tableName, CREATE_TABLE_COLUMNS_PARTITIONED);
            HiveMetastore metastoreClient = this.getMetastoreClient();
            Optional partitionNames = metastoreClient.getPartitionNamesByFilter(tableName.getSchemaName(), tableName.getTableName(), (List)ImmutableList.of((Object)"ds"), TupleDomain.all());
            Assert.assertTrue((boolean)partitionNames.isPresent());
            Assert.assertEquals((Collection)((Collection)partitionNames.get()), (Collection)ImmutableList.of((Object)"ds=2016-01-01", (Object)"ds=2016-01-02"));
        }
        finally {
            this.dropTable(this.tablePartitionFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPartitionsWithFilterUsingReservedKeywordsAsColumnName() throws Exception {
        SchemaTableName tableName = this.temporaryTable("get_partitions_with_filter_using_reserved_keyword_column_name");
        try {
            String reservedKeywordPartitionColumnName = "key";
            String regularColumnPartitionName = "int_partition";
            ImmutableList columns = ImmutableList.builder().add((Object)new ColumnMetadata("t_string", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata(reservedKeywordPartitionColumnName, (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata(regularColumnPartitionName, (Type)BigintType.BIGINT)).build();
            ImmutableList partitionedBy = ImmutableList.of((Object)reservedKeywordPartitionColumnName, (Object)regularColumnPartitionName);
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, (List<ColumnMetadata>)columns, (List<String>)partitionedBy);
            HiveMetastoreClosure metastoreClient = new HiveMetastoreClosure(this.getMetastoreClient());
            Table table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
            String partitionName1 = FileUtils.makePartName((List)ImmutableList.of((Object)reservedKeywordPartitionColumnName, (Object)regularColumnPartitionName), (List)ImmutableList.of((Object)"value1", (Object)"1"));
            String partitionName2 = FileUtils.makePartName((List)ImmutableList.of((Object)reservedKeywordPartitionColumnName, (Object)regularColumnPartitionName), (List)ImmutableList.of((Object)"value2", (Object)"2"));
            List partitions = (List)ImmutableList.of((Object)partitionName1, (Object)partitionName2).stream().map(partitionName -> new PartitionWithStatistics(this.createDummyPartition(table, (String)partitionName), partitionName, PartitionStatistics.empty())).collect(ImmutableList.toImmutableList());
            metastoreClient.addPartitions(tableName.getSchemaName(), tableName.getTableName(), partitions);
            metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), partitionName1, currentStatistics -> ZERO_TABLE_STATISTICS);
            metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), partitionName2, currentStatistics -> ZERO_TABLE_STATISTICS);
            Optional partitionNames = metastoreClient.getPartitionNamesByFilter(tableName.getSchemaName(), tableName.getTableName(), (List)ImmutableList.of((Object)reservedKeywordPartitionColumnName, (Object)regularColumnPartitionName), TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)regularColumnPartitionName, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
            Assert.assertTrue((boolean)partitionNames.isPresent());
            Assert.assertEquals((Collection)((Collection)partitionNames.get()), (Collection)ImmutableList.of((Object)"key=value2/int_partition=2"));
            partitionNames = metastoreClient.getPartitionNamesByFilter(tableName.getSchemaName(), tableName.getTableName(), (List)ImmutableList.of((Object)reservedKeywordPartitionColumnName, (Object)regularColumnPartitionName), TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)reservedKeywordPartitionColumnName, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value1")))));
            Assert.assertTrue((boolean)partitionNames.isPresent());
            Assert.assertEquals((Collection)((Collection)partitionNames.get()), (Collection)ImmutableList.of((Object)"key=value1/int_partition=1", (Object)"key=value2/int_partition=2"));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testGetDatabasesLogsStats() {
        GlueHiveMetastore metastore = (GlueHiveMetastore)this.getMetastoreClient();
        GlueMetastoreStats stats = metastore.getStats();
        double initialCallCount = stats.getGetDatabases().getTime().getAllTime().getCount();
        long initialFailureCount = stats.getGetDatabases().getTotalFailures().getTotalCount();
        this.getMetastoreClient().getAllDatabases();
        Assertions.assertThat((double)stats.getGetDatabases().getTime().getAllTime().getCount()).isGreaterThan(initialCallCount);
        Assertions.assertThat((double)stats.getGetDatabases().getTime().getAllTime().getAvg()).isGreaterThan(0.0);
        Assert.assertEquals((long)stats.getGetDatabases().getTotalFailures().getTotalCount(), (long)initialFailureCount);
    }

    @Test
    public void testGetDatabaseFailureLogsStats() {
        GlueHiveMetastore metastore = (GlueHiveMetastore)this.getMetastoreClient();
        GlueMetastoreStats stats = metastore.getStats();
        long initialFailureCount = stats.getGetDatabase().getTotalFailures().getTotalCount();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getMetastoreClient().getDatabase(null)).isInstanceOf(TrinoException.class)).hasMessageStartingWith("Database name cannot be equal to null or empty");
        Assert.assertEquals((long)stats.getGetDatabase().getTotalFailures().getTotalCount(), (long)(initialFailureCount + 1L));
    }

    @Test
    public void testGetPartitionsFilterVarChar() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "2020-01-01").build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-02-01")), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-02-01"), (boolean)true, (Object)Slices.utf8Slice((String)"2020-03-01"), (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-03-01")), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "2020-01-01", "2020-02-01").build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-03-01")), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-01-01"), (Object)ImmutableList.of((Object)"2020-03-01", (Object)"2020-04-01"), (Object)ImmutableList.of((Object)"2020-02-01", (Object)"2020-03-01"), (Object)ImmutableList.of((Object)"2020-03-01", (Object)"2020-04-01"), (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01"), (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01"), (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01")));
    }

    @Test
    public void testGetPartitionsFilterBigInt() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addBigintValues(PARTITION_KEY, 1000L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)BigintType.BIGINT, (Object)100L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)BigintType.BIGINT, (Object)100L, (boolean)true, (Object)1000L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)100L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addBigintValues(PARTITION_KEY, 1L, 1000000L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)BigintType.BIGINT, (Object)1000L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_BIGINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"1000"), (Object)ImmutableList.of((Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"100", (Object)"1000"), (Object)ImmutableList.of((Object)"100", (Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"100"), (Object)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000")));
    }

    @Test
    public void testGetPartitionsFilterInteger() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addIntegerValues(PARTITION_KEY, 1000L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)IntegerType.INTEGER, (Object)100L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)IntegerType.INTEGER, (Object)100L, (boolean)true, (Object)1000L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)100L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addIntegerValues(PARTITION_KEY, 1L, 1000000L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)IntegerType.INTEGER, (Object)1000L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_INTEGER, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"1000"), (Object)ImmutableList.of((Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"100", (Object)"1000"), (Object)ImmutableList.of((Object)"100", (Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"100"), (Object)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000")));
    }

    @Test
    public void testGetPartitionsFilterSmallInt() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addSmallintValues(PARTITION_KEY, 1000L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)SmallintType.SMALLINT, (Object)100L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)SmallintType.SMALLINT, (Object)100L, (boolean)true, (Object)1000L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)SmallintType.SMALLINT, (Object)100L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addSmallintValues(PARTITION_KEY, 1L, 10000L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)SmallintType.SMALLINT, (Object)1000L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_SMALLINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"10000"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"1000"), (Object)ImmutableList.of((Object)"1000", (Object)"10000"), (Object)ImmutableList.of((Object)"100", (Object)"1000"), (Object)ImmutableList.of((Object)"100", (Object)"1000", (Object)"10000"), (Object)ImmutableList.of((Object)"1", (Object)"10000"), (Object)ImmutableList.of((Object)"1", (Object)"100"), (Object)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"10000")));
    }

    @Test
    public void testGetPartitionsFilterTinyInt() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addTinyintValues(PARTITION_KEY, 127L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)TinyintType.TINYINT, (Object)10L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)TinyintType.TINYINT, (Object)10L, (boolean)true, (Object)100L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)TinyintType.TINYINT, (Object)10L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addTinyintValues(PARTITION_KEY, 1L, 127L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)TinyintType.TINYINT, (Object)100L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TINYINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"10", (Object)"100", (Object)"127"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"127"), (Object)ImmutableList.of((Object)"100", (Object)"127"), (Object)ImmutableList.of((Object)"10", (Object)"100"), (Object)ImmutableList.of((Object)"10", (Object)"100", (Object)"127"), (Object)ImmutableList.of((Object)"1", (Object)"127"), (Object)ImmutableList.of((Object)"1", (Object)"10"), (Object)ImmutableList.of((Object)"1", (Object)"10", (Object)"100", (Object)"127")));
    }

    @Test
    public void testGetPartitionsFilterTinyIntNegatives() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addTinyintValues(PARTITION_KEY, -128L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)TinyintType.TINYINT, (Object)0L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)TinyintType.TINYINT, (Object)0L, (boolean)true, (Object)50L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)TinyintType.TINYINT, (Object)0L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addTinyintValues(PARTITION_KEY, 0L, -128L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)TinyintType.TINYINT, (Object)0L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TINYINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"-128", (Object)"0", (Object)"50", (Object)"100"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"-128"), (Object)ImmutableList.of((Object)"100", (Object)"50"), (Object)ImmutableList.of((Object)"0", (Object)"50"), (Object)ImmutableList.of((Object)"0", (Object)"100", (Object)"50"), (Object)ImmutableList.of((Object)"-128", (Object)"0"), (Object)ImmutableList.of((Object)"-128"), (Object)ImmutableList.of((Object)"-128", (Object)"0", (Object)"100", (Object)"50")));
    }

    @Test
    public void testGetPartitionsFilterDecimal() throws Exception {
        String value1 = "1.000";
        String value2 = "10.134";
        String value3 = "25.111";
        String value4 = "30.333";
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addDecimalValues(PARTITION_KEY, value1).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf(value2)), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf(value2), (boolean)true, (Object)PartitionFilterBuilder.decimalOf(value3), (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf(value3)), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addDecimalValues(PARTITION_KEY, value1, value4).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf("25.5")), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_DECIMAL, PARTITION_KEY, (List<String>)ImmutableList.of((Object)value1, (Object)value2, (Object)value3, (Object)value4), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)value1), (Object)ImmutableList.of((Object)value3, (Object)value4), (Object)ImmutableList.of((Object)value2, (Object)value3), (Object)ImmutableList.of((Object)value3, (Object)value4), (Object)ImmutableList.of((Object)value1, (Object)value4), (Object)ImmutableList.of((Object)value1, (Object)value2, (Object)value3), (Object)ImmutableList.of((Object)value1, (Object)value2, (Object)value3, (Object)value4)));
    }

    @Test
    public void testGetPartitionsFilterDate() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addDateValues(PARTITION_KEY, 18000L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)DateType.DATE, (Object)19000L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)DateType.DATE, (Object)19000L, (boolean)true, (Object)20000L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)DateType.DATE, (Object)19000L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addDateValues(PARTITION_KEY, 18000L, 21000L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)DateType.DATE, (Object)20000L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_DATE, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000")));
    }

    @Test
    public void testGetPartitionsFilterTwoPartitionKeys() throws Exception {
        TupleDomain<String> equalsFilter = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "2020-03-01").addBigintValues(PARTITION_KEY2, 300L).build();
        TupleDomain<String> rangeFilter = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-02-01")), new Range[0]).addRanges(PARTITION_KEY2, Range.greaterThan((Type)BigintType.BIGINT, (Object)200L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TWO_KEYS, (List<String>)ImmutableList.of((Object)PARTITION_KEY, (Object)PARTITION_KEY2), (List<PartitionValues>)ImmutableList.of((Object)PartitionValues.make("2020-01-01", "100"), (Object)PartitionValues.make("2020-02-01", "200"), (Object)PartitionValues.make("2020-03-01", "300"), (Object)PartitionValues.make("2020-04-01", "400")), (List<TupleDomain<String>>)ImmutableList.of(equalsFilter, rangeFilter, (Object)TupleDomain.all()), (List<List<PartitionValues>>)ImmutableList.of((Object)ImmutableList.of((Object)PartitionValues.make("2020-03-01", "300")), (Object)ImmutableList.of((Object)PartitionValues.make("2020-03-01", "300"), (Object)PartitionValues.make("2020-04-01", "400")), (Object)ImmutableList.of((Object)PartitionValues.make("2020-01-01", "100"), (Object)PartitionValues.make("2020-02-01", "200"), (Object)PartitionValues.make("2020-03-01", "300"), (Object)PartitionValues.make("2020-04-01", "400"))));
    }

    @Test
    public void testGetPartitionsFilterMaxLengthWildcard() throws Exception {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "x".repeat(2048)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<TupleDomain<String>>)ImmutableList.of(filter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01")));
    }

    @Test
    public void testGetPartitionsFilterTwoPartitionKeysPartialQuery() throws Exception {
        TupleDomain<String> equalsFilter = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "x".repeat(2048)).addBigintValues(PARTITION_KEY2, 300L).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TWO_KEYS, (List<String>)ImmutableList.of((Object)PARTITION_KEY, (Object)PARTITION_KEY2), (List<PartitionValues>)ImmutableList.of((Object)PartitionValues.make("2020-01-01", "100"), (Object)PartitionValues.make("2020-02-01", "200"), (Object)PartitionValues.make("2020-03-01", "300"), (Object)PartitionValues.make("2020-04-01", "400")), (List<TupleDomain<String>>)ImmutableList.of(equalsFilter), (List<List<PartitionValues>>)ImmutableList.of((Object)ImmutableList.of((Object)PartitionValues.make("2020-03-01", "300"))));
    }

    @Test
    public void testGetPartitionsFilterNone() throws Exception {
        TupleDomain<String> noneFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.none((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.none(), noneFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of()));
    }

    @Test
    public void testGetPartitionsFilterNotNull() throws Exception {
        TupleDomain<String> notNullFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.notNull((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<TupleDomain<String>>)ImmutableList.of(notNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01")));
    }

    @Test
    public void testGetPartitionsFilterIsNull() throws Exception {
        TupleDomain<String> isNullFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.onlyNull((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<TupleDomain<String>>)ImmutableList.of(isNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of()));
    }

    @Test
    public void testGetPartitionsFilterIsNullWithValue() throws Exception {
        ArrayList<String> partitionList = new ArrayList<String>();
        partitionList.add("100");
        partitionList.add(null);
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, partitionList, (List<TupleDomain<String>>)ImmutableList.of(new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.onlyNull((Type)VarcharType.VARCHAR)).build()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"__HIVE_DEFAULT_PARTITION__")));
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, partitionList, (List<TupleDomain<String>>)ImmutableList.of(new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"100"), (Object[])new Object[0]), (boolean)true)).build()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"100", (Object)"__HIVE_DEFAULT_PARTITION__")));
    }

    @Test
    public void testGetPartitionsFilterEqualsOrIsNullWithValue() throws Exception {
        TupleDomain<String> equalsOrIsNullFilter = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "2020-03-01").addDomain(PARTITION_KEY, Domain.onlyNull((Type)VarcharType.VARCHAR)).build();
        ArrayList<String> partitionList = new ArrayList<String>();
        partitionList.add("2020-01-01");
        partitionList.add("2020-02-01");
        partitionList.add("2020-03-01");
        partitionList.add(null);
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, partitionList, (List<TupleDomain<String>>)ImmutableList.of(equalsOrIsNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-03-01", (Object)"__HIVE_DEFAULT_PARTITION__")));
    }

    @Test
    public void testGetPartitionsFilterIsNotNull() throws Exception {
        TupleDomain<String> isNotNullFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.notNull((Type)VarcharType.VARCHAR)).build();
        ArrayList<String> partitionList = new ArrayList<String>();
        partitionList.add("100");
        partitionList.add(null);
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, partitionList, (List<TupleDomain<String>>)ImmutableList.of(isNotNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"100")));
    }

    @Test(dataProvider="unsupportedNullPushdownTypes")
    public void testGetPartitionsFilterUnsupportedIsNull(List<ColumnMetadata> columnMetadata, Type type, String partitionValue) throws Exception {
        TupleDomain<String> isNullFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.onlyNull((Type)type)).build();
        ArrayList<String> partitionList = new ArrayList<String>();
        partitionList.add(partitionValue);
        partitionList.add(null);
        this.doGetPartitionsFilterTest(columnMetadata, PARTITION_KEY, partitionList, (List<TupleDomain<String>>)ImmutableList.of(isNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)partitionValue, (Object)"__HIVE_DEFAULT_PARTITION__")));
    }

    @Test(dataProvider="unsupportedNullPushdownTypes")
    public void testGetPartitionsFilterUnsupportedIsNotNull(List<ColumnMetadata> columnMetadata, Type type, String partitionValue) throws Exception {
        TupleDomain<String> isNotNullFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.notNull((Type)type)).build();
        ArrayList<String> partitionList = new ArrayList<String>();
        partitionList.add(partitionValue);
        partitionList.add(null);
        this.doGetPartitionsFilterTest(columnMetadata, PARTITION_KEY, partitionList, (List<TupleDomain<String>>)ImmutableList.of(isNotNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)partitionValue, (Object)"__HIVE_DEFAULT_PARTITION__")));
    }

    @DataProvider
    public Object[][] unsupportedNullPushdownTypes() {
        return new Object[][]{{CREATE_TABLE_COLUMNS_PARTITIONED_TINYINT, TinyintType.TINYINT, "127"}, {CREATE_TABLE_COLUMNS_PARTITIONED_SMALLINT, SmallintType.SMALLINT, "32767"}, {CREATE_TABLE_COLUMNS_PARTITIONED_INTEGER, IntegerType.INTEGER, "2147483647"}, {CREATE_TABLE_COLUMNS_PARTITIONED_BIGINT, BigintType.BIGINT, "9223372036854775807"}, {CREATE_TABLE_COLUMNS_PARTITIONED_DECIMAL, PartitionFilterBuilder.DECIMAL_TYPE, "12345.12345"}, {CREATE_TABLE_COLUMNS_PARTITIONED_DATE, DateType.DATE, "2022-07-11"}, {CREATE_TABLE_COLUMNS_PARTITIONED_TIMESTAMP, TimestampType.TIMESTAMP_MILLIS, "2022-07-11 01:02:03.123"}};
    }

    @Test
    public void testGetPartitionsFilterEqualsAndIsNotNull() throws Exception {
        TupleDomain<String> equalsAndIsNotNullFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.notNull((Type)VarcharType.VARCHAR)).addBigintValues(PARTITION_KEY2, 300L).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TWO_KEYS, (List<String>)ImmutableList.of((Object)PARTITION_KEY, (Object)PARTITION_KEY2), (List<PartitionValues>)ImmutableList.of((Object)PartitionValues.make("2020-01-01", "100"), (Object)PartitionValues.make("2020-02-01", "200"), (Object)PartitionValues.make("2020-03-01", "300"), (Object)PartitionValues.make(null, "300")), (List<TupleDomain<String>>)ImmutableList.of(equalsAndIsNotNullFilter), (List<List<PartitionValues>>)ImmutableList.of((Object)ImmutableList.of((Object)PartitionValues.make("2020-03-01", "300"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateStatisticsOnCreate() {
        SchemaTableName tableName = this.temporaryTable("update_statistics_create");
        try (AbstractTestHive.Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ImmutableList columns = ImmutableList.of((Object)new ColumnMetadata("a_column", (Type)BigintType.BIGINT));
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, (List)columns, TestHiveGlueMetastore.createTableProperties(HiveStorageFormat.TEXTFILE));
            ConnectorOutputTableHandle createTableHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, createTableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            MaterializedResult data = MaterializedResult.resultBuilder((ConnectorSession)session, (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{2L}).row(new Object[]{3L}).row(new Object[]{4L}).row(new Object[]{5L}).build();
            sink.appendPage(data.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            ComputedStatistics statistics = ComputedStatistics.builder((List)ImmutableList.of(), (List)ImmutableList.of()).addTableStatistic(TableStatisticType.ROW_COUNT, this.singleValueBlock(5L)).addColumnStatistic(HiveColumnStatisticType.MIN_VALUE.createColumnStatisticMetadata("a_column"), this.singleValueBlock(1L)).addColumnStatistic(HiveColumnStatisticType.MAX_VALUE.createColumnStatisticMetadata("a_column"), this.singleValueBlock(1L)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES.createColumnStatisticMetadata("a_column"), this.singleValueBlock(1L)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES.createColumnStatisticMetadata("a_column"), this.singleValueBlock(1L)).build();
            metadata.finishCreateTable(session, createTableHandle, fragments, (Collection)ImmutableList.of((Object)statistics));
            transaction.commit();
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdatePartitionedStatisticsOnCreate() {
        SchemaTableName tableName = this.temporaryTable("update_partitioned_statistics_create");
        try (AbstractTestHive.Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ImmutableList columns = ImmutableList.of((Object)new ColumnMetadata("a_column", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("part_column", (Type)BigintType.BIGINT));
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, (List)columns, TestHiveGlueMetastore.createTableProperties(HiveStorageFormat.TEXTFILE, (Iterable<String>)ImmutableList.of((Object)"part_column")));
            ConnectorOutputTableHandle createTableHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, createTableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            MaterializedResult data = MaterializedResult.resultBuilder((ConnectorSession)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 1L}).row(new Object[]{3L, 1L}).row(new Object[]{4L, 2L}).row(new Object[]{5L, 2L}).build();
            sink.appendPage(data.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            ComputedStatistics statistics1 = ComputedStatistics.builder((List)ImmutableList.of((Object)"part_column"), (List)ImmutableList.of((Object)this.singleValueBlock(1L))).addTableStatistic(TableStatisticType.ROW_COUNT, this.singleValueBlock(3L)).addColumnStatistic(HiveColumnStatisticType.MIN_VALUE.createColumnStatisticMetadata("a_column"), this.singleValueBlock(1L)).addColumnStatistic(HiveColumnStatisticType.MAX_VALUE.createColumnStatisticMetadata("a_column"), this.singleValueBlock(1L)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES.createColumnStatisticMetadata("a_column"), this.singleValueBlock(1L)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES.createColumnStatisticMetadata("a_column"), this.singleValueBlock(1L)).build();
            ComputedStatistics statistics2 = ComputedStatistics.builder((List)ImmutableList.of((Object)"part_column"), (List)ImmutableList.of((Object)this.singleValueBlock(2L))).addTableStatistic(TableStatisticType.ROW_COUNT, this.singleValueBlock(2L)).addColumnStatistic(HiveColumnStatisticType.MIN_VALUE.createColumnStatisticMetadata("a_column"), this.singleValueBlock(4L)).addColumnStatistic(HiveColumnStatisticType.MAX_VALUE.createColumnStatisticMetadata("a_column"), this.singleValueBlock(4L)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES.createColumnStatisticMetadata("a_column"), this.singleValueBlock(4L)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES.createColumnStatisticMetadata("a_column"), this.singleValueBlock(4L)).build();
            metadata.finishCreateTable(session, createTableHandle, fragments, (Collection)ImmutableList.of((Object)statistics1, (Object)statistics2));
            transaction.commit();
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatisticsLargeNumberOfColumns() throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_statistics_large_number_of_columns");
        try {
            ImmutableList.Builder columns = ImmutableList.builder();
            ImmutableMap.Builder columnStatistics = ImmutableMap.builder();
            for (int i = 1; i < 1500; ++i) {
                String columnName = "t_bigint " + i + "_" + String.join((CharSequence)"", Collections.nCopies(240, "x"));
                columns.add((Object)new ColumnMetadata(columnName, (Type)BigintType.BIGINT));
                columnStatistics.put((Object)columnName, (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(-1000 - i), (OptionalLong)OptionalLong.of(1000 + i), (OptionalLong)OptionalLong.of(i), (OptionalLong)OptionalLong.of(2L * (long)i)));
            }
            PartitionStatistics partitionStatistics = PartitionStatistics.builder().setBasicStatistics(HIVE_BASIC_STATISTICS).setColumnStatistics((Map)columnStatistics.buildOrThrow()).build();
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, (List<ColumnMetadata>)columns.build());
            this.testUpdateTableStatistics(tableName, ZERO_TABLE_STATISTICS, partitionStatistics);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatisticsLongColumnNames() throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_statistics_long_column_name");
        try {
            String columnName1 = String.join((CharSequence)"", Collections.nCopies(255, "x"));
            String columnName2 = String.join((CharSequence)"", Collections.nCopies(255, "\u04c6"));
            String columnName3 = String.join((CharSequence)"", Collections.nCopies(255, "\u00f6"));
            List<ColumnMetadata> columns = List.of(new ColumnMetadata(columnName1, (Type)BigintType.BIGINT), new ColumnMetadata(columnName2, (Type)BigintType.BIGINT), new ColumnMetadata(columnName3, (Type)BigintType.BIGINT));
            Map<String, HiveColumnStatistics> columnStatistics = Map.of(columnName1, INTEGER_COLUMN_STATISTICS, columnName2, INTEGER_COLUMN_STATISTICS, columnName3, INTEGER_COLUMN_STATISTICS);
            PartitionStatistics partitionStatistics = PartitionStatistics.builder().setBasicStatistics(HIVE_BASIC_STATISTICS).setColumnStatistics(columnStatistics).build();
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, columns);
            Assertions.assertThat((Object)this.metastore.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)ZERO_TABLE_STATISTICS);
            this.testUpdateTableStatistics(tableName, ZERO_TABLE_STATISTICS, partitionStatistics);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatisticsColumnModification() throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_statistics_column_modification");
        try {
            List<ColumnMetadata> columns = List.of(new ColumnMetadata("column1", (Type)BigintType.BIGINT), new ColumnMetadata("column2", (Type)BigintType.BIGINT), new ColumnMetadata("column3", (Type)BigintType.BIGINT));
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, columns);
            Map<String, HiveColumnStatistics> columnStatistics = Map.of("column1", INTEGER_COLUMN_STATISTICS, "column2", INTEGER_COLUMN_STATISTICS);
            PartitionStatistics partitionStatistics = PartitionStatistics.builder().setBasicStatistics(HIVE_BASIC_STATISTICS).setColumnStatistics(columnStatistics).build();
            this.metastore.updateTableStatistics(tableName.getSchemaName(), tableName.getTableName(), AcidTransaction.NO_ACID_TRANSACTION, actualStatistics -> {
                Assertions.assertThat((Object)actualStatistics).isEqualTo((Object)ZERO_TABLE_STATISTICS);
                return partitionStatistics;
            });
            Assertions.assertThat((Object)this.metastore.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)partitionStatistics);
            this.metastore.renameColumn(tableName.getSchemaName(), tableName.getTableName(), "column1", "column4");
            Assertions.assertThat((Object)this.metastore.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)new PartitionStatistics(HIVE_BASIC_STATISTICS, Map.of("column2", INTEGER_COLUMN_STATISTICS)));
            this.metastore.dropColumn(tableName.getSchemaName(), tableName.getTableName(), "column2");
            Assertions.assertThat((Object)this.metastore.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)new PartitionStatistics(HIVE_BASIC_STATISTICS, Map.of()));
            this.metastore.addColumn(tableName.getSchemaName(), tableName.getTableName(), "column5", HiveType.HIVE_INT, "comment");
            Assertions.assertThat((Object)this.metastore.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)new PartitionStatistics(HIVE_BASIC_STATISTICS, Map.of()));
            this.metastore.renameColumn(tableName.getSchemaName(), tableName.getTableName(), "column4", "column1");
            Assertions.assertThat((Object)this.metastore.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)new PartitionStatistics(HIVE_BASIC_STATISTICS, Map.of("column1", INTEGER_COLUMN_STATISTICS)));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatisticsPartitionedTableColumnModification() throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_partitioned_table_statistics_column_modification");
        try {
            List<ColumnMetadata> columns = List.of(new ColumnMetadata("column1", (Type)BigintType.BIGINT), new ColumnMetadata("column2", (Type)BigintType.BIGINT), new ColumnMetadata("ds", (Type)VarcharType.VARCHAR));
            Map<String, HiveColumnStatistics> columnStatistics = Map.of("column1", INTEGER_COLUMN_STATISTICS, "column2", INTEGER_COLUMN_STATISTICS);
            PartitionStatistics partitionStatistics = PartitionStatistics.builder().setBasicStatistics(HIVE_BASIC_STATISTICS).setColumnStatistics(columnStatistics).build();
            this.createDummyPartitionedTable(tableName, columns);
            GlueHiveMetastore metastoreClient = (GlueHiveMetastore)this.getMetastoreClient();
            double countBefore = metastoreClient.getStats().getBatchUpdatePartition().getTime().getAllTime().getCount();
            this.metastore.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), "ds=2016-01-01", actualStatistics -> partitionStatistics);
            Assertions.assertThat((double)metastoreClient.getStats().getBatchUpdatePartition().getTime().getAllTime().getCount()).isEqualTo(countBefore + 1.0);
            PartitionStatistics tableStatistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), Map.of());
            Assertions.assertThat((Object)this.metastore.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)tableStatistics);
            Assertions.assertThat((Map)this.metastore.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), Set.of("ds=2016-01-01"))).isEqualTo(Map.of("ds=2016-01-01", partitionStatistics));
            this.metastore.renameColumn(tableName.getSchemaName(), tableName.getTableName(), "column1", "column4");
            Assertions.assertThat((Object)this.metastore.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)tableStatistics);
            Assertions.assertThat((Map)this.metastore.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), Set.of("ds=2016-01-01"))).isEqualTo(Map.of("ds=2016-01-01", partitionStatistics));
            this.metastore.dropColumn(tableName.getSchemaName(), tableName.getTableName(), "column2");
            Assertions.assertThat((Object)this.metastore.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)tableStatistics);
            Assertions.assertThat((Map)this.metastore.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), Set.of("ds=2016-01-01"))).isEqualTo(Map.of("ds=2016-01-01", partitionStatistics));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidColumnStatisticsMetadata() throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_statistics_invalid_column_metadata");
        try {
            List<ColumnMetadata> columns = List.of(new ColumnMetadata("column1", (Type)BigintType.BIGINT));
            Map<String, HiveColumnStatistics> columnStatistics = Map.of("column1", INTEGER_COLUMN_STATISTICS);
            PartitionStatistics partitionStatistics = PartitionStatistics.builder().setBasicStatistics(HIVE_BASIC_STATISTICS).setColumnStatistics(columnStatistics).build();
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, columns);
            this.metastore.updateTableStatistics(tableName.getSchemaName(), tableName.getTableName(), AcidTransaction.NO_ACID_TRANSACTION, actualStatistics -> {
                Assertions.assertThat((Object)actualStatistics).isEqualTo((Object)ZERO_TABLE_STATISTICS);
                return partitionStatistics;
            });
            Table table = (Table)this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).get();
            TableInput tableInput = GlueInputConverter.convertTable((Table)table);
            tableInput.setParameters((Map)ImmutableMap.builder().putAll(tableInput.getParameters()).put((Object)"column_stats_bad_data", (Object)"bad data").buildOrThrow());
            this.getGlueClient().updateTable(new UpdateTableRequest().withDatabaseName(tableName.getSchemaName()).withTableInput(tableInput));
            Assertions.assertThat((Object)this.metastore.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)partitionStatistics);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Override
    public void testPartitionColumnProperties() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> super.testPartitionColumnProperties()).isInstanceOf(TrinoException.class)).hasMessageStartingWith("Parameters not supported for partition columns (Service: AWSGlue; Status Code: 400; Error Code: InvalidInputException;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlueObjectsWithoutStorageDescriptor() {
        SchemaTableName table = this.temporaryTable("test_missing_storage_descriptor");
        DeleteTableRequest deleteTableRequest = new DeleteTableRequest().withDatabaseName(table.getSchemaName()).withName(table.getTableName());
        try {
            Supplier<TableInput> resetTableInput = () -> new TableInput().withStorageDescriptor(null).withName(table.getTableName()).withTableType(TableType.EXTERNAL_TABLE.name());
            TableInput tableInput = resetTableInput.get();
            this.glueClient.createTable(new CreateTableRequest().withDatabaseName(this.database).withTableInput(tableInput));
            Assertions.assertThatThrownBy(() -> this.metastore.getTable(table.getSchemaName(), table.getTableName())).hasMessageStartingWith("Table StorageDescriptor is null for table");
            this.glueClient.deleteTable(deleteTableRequest);
            tableInput = resetTableInput.get().withParameters((Map)ImmutableMap.of((Object)"table_type", (Object)"iceberg"));
            this.glueClient.createTable(new CreateTableRequest().withDatabaseName(this.database).withTableInput(tableInput));
            Assert.assertTrue((boolean)HiveUtil.isIcebergTable((Table)((Table)this.metastore.getTable(table.getSchemaName(), table.getTableName()).orElseThrow())));
            this.glueClient.deleteTable(deleteTableRequest);
            tableInput = resetTableInput.get().withParameters((Map)ImmutableMap.of((Object)"spark.sql.sources.provider", (Object)"delta"));
            this.glueClient.createTable(new CreateTableRequest().withDatabaseName(this.database).withTableInput(tableInput));
            Assert.assertTrue((boolean)HiveUtil.isDeltaLakeTable((Table)((Table)this.metastore.getTable(table.getSchemaName(), table.getTableName()).orElseThrow())));
            this.glueClient.deleteTable(deleteTableRequest);
            tableInput = resetTableInput.get().withTableType(TableType.VIRTUAL_VIEW.name()).withViewOriginalText("/* Presto Materialized View: eyJvcmlnaW5hbFNxbCI6IlNFTEVDVCAxIiwiY29sdW1ucyI6W3sibmFtZSI6ImEiLCJ0eXBlIjoiaW50ZWdlciJ9XX0= */").withViewExpandedText("Presto Materialized View").withParameters((Map)ImmutableMap.of((Object)"presto_view", (Object)"true", (Object)"comment", (Object)"Presto Materialized View"));
            this.glueClient.createTable(new CreateTableRequest().withDatabaseName(this.database).withTableInput(tableInput));
            Assert.assertTrue((boolean)ViewReaderUtil.isTrinoMaterializedView((Table)((Table)this.metastore.getTable(table.getSchemaName(), table.getTableName()).orElseThrow())));
            this.materializedViews.add(table);
            try (AbstractTestHive.Transaction transaction = this.newTransaction();){
                ConnectorSession session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                Assertions.assertThat((List)metadata.listViews(session, Optional.empty())).doesNotContain((Object[])new SchemaTableName[]{table});
                Assertions.assertThat((List)metadata.listViews(session, Optional.of(table.getSchemaName()))).doesNotContain((Object[])new SchemaTableName[]{table});
                Assertions.assertThat((Optional)metadata.getView(session, table)).isEmpty();
            }
            finally {
                this.materializedViews.remove(table);
            }
        }
        finally {
            this.glueClient.deleteTable(new DeleteTableRequest().withDatabaseName(table.getSchemaName()).withName(table.getTableName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterColumnComment() throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_alter_column_comment");
        ImmutableList columns = ImmutableList.of((Object)new ColumnMetadata("first_column", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("second_column", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("partition_column", (Type)BigintType.BIGINT));
        this.createDummyPartitionedTable(tableName, (List<ColumnMetadata>)columns, (List<String>)ImmutableList.of((Object)"partition_column"), (List<PartitionValues>)ImmutableList.of());
        try {
            this.metastore.commentColumn(tableName.getSchemaName(), tableName.getTableName(), "second_column", Optional.of("second column comment"));
            this.metastore.commentColumn(tableName.getSchemaName(), tableName.getTableName(), "partition_column", Optional.of("partition column comment"));
            Table withComment = (Table)this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow();
            Assertions.assertThat((Optional)((Column)withComment.getColumn("first_column").orElseThrow()).getComment()).isEmpty();
            Assertions.assertThat((Optional)((Column)withComment.getColumn("second_column").orElseThrow()).getComment()).isEqualTo(Optional.of("second column comment"));
            Assertions.assertThat((Optional)((Column)withComment.getColumn("partition_column").orElseThrow()).getComment()).isEqualTo(Optional.of("partition column comment"));
            this.metastore.commentColumn(tableName.getSchemaName(), tableName.getTableName(), "second_column", Optional.empty());
            withComment = (Table)this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow();
            Assertions.assertThat((Optional)((Column)withComment.getColumn("first_column").orElseThrow()).getComment()).isEmpty();
            Assertions.assertThat((Optional)((Column)withComment.getColumn("second_column").orElseThrow()).getComment()).isEmpty();
            Assertions.assertThat((Optional)((Column)withComment.getColumn("partition_column").orElseThrow()).getComment()).isEqualTo(Optional.of("partition column comment"));
        }
        finally {
            this.glueClient.deleteTable(new DeleteTableRequest().withDatabaseName(tableName.getSchemaName()).withName(tableName.getTableName()));
        }
    }

    private Block singleValueBlock(long value) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1);
        BigintType.BIGINT.writeLong(blockBuilder, value);
        return blockBuilder.build();
    }

    private void doGetPartitionsFilterTest(List<ColumnMetadata> columnMetadata, String partitionColumnName, List<String> partitionStringValues, List<TupleDomain<String>> filterList, List<List<String>> expectedSingleValueList) throws Exception {
        List partitionValuesList = (List)partitionStringValues.stream().map(xva$0 -> PartitionValues.make(xva$0)).collect(ImmutableList.toImmutableList());
        List expectedPartitionValuesList = (List)expectedSingleValueList.stream().map(expectedValue -> (ImmutableList)expectedValue.stream().map(xva$0 -> PartitionValues.make(xva$0)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        this.doGetPartitionsFilterTest(columnMetadata, (List<String>)ImmutableList.of((Object)partitionColumnName), partitionValuesList, filterList, expectedPartitionValuesList);
    }

    private void doGetPartitionsFilterTest(List<ColumnMetadata> columnMetadata, List<String> partitionColumnNames, List<PartitionValues> partitionValues, List<TupleDomain<String>> filterList, List<List<PartitionValues>> expectedValuesList) throws Exception {
        try (CloseableSchamaTableName closeableTableName = new CloseableSchamaTableName(this.temporaryTable("get_partitions"));){
            SchemaTableName tableName = closeableTableName.getSchemaTableName();
            this.createDummyPartitionedTable(tableName, columnMetadata, partitionColumnNames, partitionValues);
            HiveMetastore metastoreClient = this.getMetastoreClient();
            for (int i = 0; i < filterList.size(); ++i) {
                TupleDomain<String> filter = filterList.get(i);
                List<PartitionValues> expectedValues = expectedValuesList.get(i);
                List expectedResults = (List)expectedValues.stream().map(expectedPartitionValues -> FileUtils.makePartName((List)partitionColumnNames, expectedPartitionValues.getValues())).collect(ImmutableList.toImmutableList());
                Optional partitionNames = metastoreClient.getPartitionNamesByFilter(tableName.getSchemaName(), tableName.getTableName(), partitionColumnNames, filter);
                Assert.assertTrue((boolean)partitionNames.isPresent());
                Assert.assertEquals((Collection)((Collection)partitionNames.get()), (Collection)expectedResults, (String)String.format("lists \nactual: %s\nexpected: %s\nmismatch for filter %s (input index %d)\n", partitionNames.get(), expectedResults, filter, i));
            }
        }
    }

    private void createDummyPartitionedTable(SchemaTableName tableName, List<ColumnMetadata> columns, List<String> partitionColumnNames, List<PartitionValues> partitionValues) throws Exception {
        this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, columns, partitionColumnNames);
        HiveMetastoreClosure metastoreClient = new HiveMetastoreClosure(this.getMetastoreClient());
        Table table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        ArrayList partitions = new ArrayList();
        ArrayList partitionNames = new ArrayList();
        partitionValues.stream().map(partitionValue -> FileUtils.makePartName((List)partitionColumnNames, partitionValue.values)).forEach(partitionName -> {
            partitions.add(new PartitionWithStatistics(this.createDummyPartition(table, (String)partitionName), partitionName, PartitionStatistics.empty()));
            partitionNames.add(partitionName);
        });
        metastoreClient.addPartitions(tableName.getSchemaName(), tableName.getTableName(), partitions);
        partitionNames.forEach(partitionName -> metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), partitionName, currentStatistics -> ZERO_TABLE_STATISTICS));
    }

    private static class PartitionValues {
        private final List<String> values;

        private static PartitionValues make(String ... values) {
            return new PartitionValues(Arrays.asList(values));
        }

        private PartitionValues(List<String> values) {
            this.values = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(values, "values is null")));
        }

        public List<String> getValues() {
            return this.values;
        }
    }

    private class CloseableSchamaTableName
    implements AutoCloseable {
        private final SchemaTableName schemaTableName;

        private CloseableSchamaTableName(SchemaTableName schemaTableName) {
            this.schemaTableName = schemaTableName;
        }

        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public void close() {
            TestHiveGlueMetastore.this.dropTable(this.schemaTableName);
        }
    }
}

