/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.glue.GlueExpressionUtil;
import io.trino.plugin.hive.metastore.glue.PartitionFilterBuilder;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGlueExpressionUtil {
    private static Column getColumn(String name, String type) {
        return new Column(name, HiveType.valueOf((String)type), Optional.empty());
    }

    @Test
    public void testBuildGlueExpressionDomainEqualsSingleValue() {
        Domain domain = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-01-01"));
        Optional foo = GlueExpressionUtil.buildGlueExpressionForSingleDomain((String)"foo", (Domain)domain, (boolean)true);
        Assert.assertEquals((String)((String)foo.get()), (String)"((foo = '2020-01-01'))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainEqualsSingleValue() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues("col1", "2020-01-01").addStringValues("col2", "2020-02-20").build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1", (Object)"col2"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)"((col1 = '2020-01-01')) AND ((col2 = '2020-02-20'))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainEqualsAndInClause() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues("col1", "2020-01-01").addStringValues("col2", "2020-02-20", "2020-02-28").build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1", (Object)"col2"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)"((col1 = '2020-01-01')) AND ((col2 in ('2020-02-20', '2020-02-28')))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainExtraDomain() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues("col1", "2020-01-01").addStringValues("col2", "2020-02-20", "2020-02-28").build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)"((col1 = '2020-01-01'))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainRange() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues("col1", "2020-01-01").addRanges("col2", Range.greaterThan((Type)BigintType.BIGINT, (Object)100L), new Range[0]).addRanges("col2", Range.lessThan((Type)BigintType.BIGINT, (Object)0L), new Range[0]).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1", (Object)"col2"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)"((col1 = '2020-01-01')) AND ((col2 < 0) OR (col2 > 100))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainEqualAndRangeLong() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addBigintValues("col1", 3L).addRanges("col1", Range.greaterThan((Type)BigintType.BIGINT, (Object)100L), new Range[0]).addRanges("col1", Range.lessThan((Type)BigintType.BIGINT, (Object)0L), new Range[0]).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)"((col1 < 0) OR (col1 > 100) OR (col1 = 3))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainEqualAndRangeString() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues("col1", "2020-01-01", "2020-01-31").addRanges("col1", Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-03-01"), (boolean)true, (Object)Slices.utf8Slice((String)"2020-03-31"), (boolean)true), new Range[0]).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)"((col1 >= '2020-03-01' AND col1 <= '2020-03-31') OR (col1 in ('2020-01-01', '2020-01-31')))");
    }

    @Test
    public void testBuildGlueExpressionExtraColumn() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues("col1", "2020-01-01").build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1", (Object)"col2"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)"((col1 = '2020-01-01'))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainIsNull() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addDomain("col1", Domain.onlyNull((Type)VarcharType.VARCHAR)).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)String.format("(col1 = '%s')", "__HIVE_DEFAULT_PARTITION__"));
    }

    @Test
    public void testBuildGlueExpressionTupleDomainNotNull() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addDomain("col1", Domain.notNull((Type)VarcharType.VARCHAR)).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)String.format("(col1 <> '%s')", "__HIVE_DEFAULT_PARTITION__"));
    }

    @Test
    public void testBuildGlueExpressionTupleDomainEqualsOrIsNull() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues("col1", "2020-01-01").addDomain("col1", Domain.onlyNull((Type)VarcharType.VARCHAR)).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)String.format("((col1 = '2020-01-01') OR (col1 = '%s'))", "__HIVE_DEFAULT_PARTITION__"));
    }

    @Test
    public void testBuildGlueExpressionTupleDomainEqualsAndIsNotNull() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues("col1", "2020-01-01").addDomain("col2", Domain.notNull((Type)VarcharType.VARCHAR)).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1", (Object)"col2"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)String.format("((col1 = '2020-01-01')) AND (col2 <> '%s')", "__HIVE_DEFAULT_PARTITION__"));
    }

    @Test
    public void testBuildGlueExpressionMaxLengthNone() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues("col1", "x".repeat(101)).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true, (int)100);
        Assert.assertEquals((String)expression, (String)"");
    }

    @Test
    public void testBuildGlueExpressionMaxLengthOneColumn() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues("col1", "x".repeat(5)).addStringValues("col2", "x".repeat(25)).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1", (Object)"col2"), filter, (boolean)true, (int)20);
        Assert.assertEquals((String)expression, (String)"((col1 = 'xxxxx'))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainAll() {
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), (TupleDomain)TupleDomain.all(), (boolean)true);
        Assert.assertEquals((String)expression, (String)"");
    }

    @Test
    public void testDecimalConverstion() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addDecimalValues("col1", "10.134").build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)"((col1 = 10.13400))");
    }

    @Test
    public void testBigintConversion() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addBigintValues("col1", Long.MAX_VALUE).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)String.format("((col1 = %d))", Long.MAX_VALUE));
    }

    @Test
    public void testIntegerConversion() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addIntegerValues("col1", (Long)Integer.MAX_VALUE).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)String.format("((col1 = %d))", Integer.MAX_VALUE));
    }

    @Test
    public void testSmallintConversion() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addIntegerValues("col1", 32767L).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)String.format("((col1 = %d))", (short)Short.MAX_VALUE));
    }

    @Test
    public void testTinyintConversion() {
        TupleDomain<String> filter = new PartitionFilterBuilder().addIntegerValues("col1", 127L).build();
        String expression = GlueExpressionUtil.buildGlueExpression((List)ImmutableList.of((Object)"col1"), filter, (boolean)true);
        Assert.assertEquals((String)expression, (String)String.format("((col1 = %d))", (byte)127));
    }
}

