/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.trino.spi.security.PrincipalType;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFileHiveMetastore {
    private Path tmpDir;
    private FileHiveMetastore metastore;

    @BeforeClass
    public void setUp() throws IOException {
        this.tmpDir = Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]);
        this.metastore = new FileHiveMetastore(new NodeVersion("testversion"), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveMetastoreConfig().isHideDeltaLakeTables(), new FileHiveMetastoreConfig().setCatalogDirectory(this.tmpDir.toString()).setDisableLocationChecks(true));
        this.metastore.createDatabase(Database.builder().setDatabaseName("default").setOwnerName(Optional.of("test")).setOwnerType(Optional.of(PrincipalType.USER)).build());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.tmpDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        this.metastore = null;
        this.tmpDir = null;
    }

    @Test
    public void testPreserveHudiInputFormat() {
        StorageFormat storageFormat = StorageFormat.create((String)ParquetHiveSerDe.class.getName(), (String)"org.apache.hudi.hadoop.HoodieParquetInputFormat", (String)MapredParquetOutputFormat.class.getName());
        Table table = Table.builder().setDatabaseName("default").setTableName("some_table_name" + TestingNames.randomNameSuffix()).setTableType(TableType.EXTERNAL_TABLE.name()).setOwner(Optional.of("public")).addDataColumn(new Column("foo", HiveType.HIVE_INT, Optional.empty())).setParameters((Map)ImmutableMap.of((Object)"serialization.format", (Object)"1", (Object)"EXTERNAL", (Object)"TRUE")).withStorage(storageBuilder -> storageBuilder.setStorageFormat(storageFormat).setLocation("file:///dev/null")).build();
        this.metastore.createTable(table, PrincipalPrivileges.NO_PRIVILEGES);
        Table saved = (Table)this.metastore.getTable(table.getDatabaseName(), table.getTableName()).orElseThrow();
        Assertions.assertThat((Object)saved.getStorage()).isEqualTo((Object)table.getStorage());
        this.metastore.dropTable(table.getDatabaseName(), table.getTableName(), false);
    }
}

