/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.cache;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.hive.metastore.cache.ImpersonationCachingConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestImpersonationCachingConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ImpersonationCachingConfig)ConfigAssertions.recordDefaults(ImpersonationCachingConfig.class)).setUserMetastoreCacheTtl(new Duration(0.0, TimeUnit.SECONDS)).setUserMetastoreCacheMaximumSize(1000L));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.user-metastore-cache-ttl", (Object)"2h").put((Object)"hive.user-metastore-cache-maximum-size", (Object)"5").buildOrThrow();
        ImpersonationCachingConfig expected = new ImpersonationCachingConfig().setUserMetastoreCacheTtl(new Duration(2.0, TimeUnit.HOURS)).setUserMetastoreCacheMaximumSize(5L);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

