/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

@ThreadSafe
public class CountingAccessHiveMetastore
implements HiveMetastore {
    private final HiveMetastore delegate;
    private final ConcurrentHashMultiset<Method> methodInvocations = ConcurrentHashMultiset.create();

    public CountingAccessHiveMetastore(HiveMetastore delegate) {
        this.delegate = delegate;
    }

    public Multiset<Method> getMethodInvocations() {
        return ImmutableMultiset.copyOf(this.methodInvocations);
    }

    public void resetCounters() {
        this.methodInvocations.clear();
    }

    public Optional<Table> getTable(String databaseName, String tableName) {
        this.methodInvocations.add((Object)Method.GET_TABLE);
        return this.delegate.getTable(databaseName, tableName);
    }

    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    public List<String> getAllDatabases() {
        this.methodInvocations.add((Object)Method.GET_ALL_DATABASES);
        return this.delegate.getAllDatabases();
    }

    public Optional<Database> getDatabase(String databaseName) {
        this.methodInvocations.add((Object)Method.GET_DATABASE);
        return this.delegate.getDatabase(databaseName);
    }

    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        this.methodInvocations.add((Object)Method.GET_TABLES_WITH_PARAMETER);
        return this.delegate.getTablesWithParameter(databaseName, parameterKey, parameterValue);
    }

    public List<String> getAllViews(String databaseName) {
        this.methodInvocations.add((Object)Method.GET_ALL_VIEWS_FROM_DATABASE);
        return this.delegate.getAllViews(databaseName);
    }

    public Optional<List<SchemaTableName>> getAllViews() {
        Optional allViews = this.delegate.getAllViews();
        if (allViews.isPresent()) {
            this.methodInvocations.add((Object)Method.GET_ALL_VIEWS);
        }
        return allViews;
    }

    public void createDatabase(Database database) {
        this.methodInvocations.add((Object)Method.CREATE_DATABASE);
        this.delegate.createDatabase(database);
    }

    public void dropDatabase(String databaseName, boolean deleteData) {
        throw new UnsupportedOperationException();
    }

    public void renameDatabase(String databaseName, String newDatabaseName) {
        throw new UnsupportedOperationException();
    }

    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        throw new UnsupportedOperationException();
    }

    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        this.methodInvocations.add((Object)Method.CREATE_TABLE);
        this.delegate.createTable(table, principalPrivileges);
    }

    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        this.methodInvocations.add((Object)Method.DROP_TABLE);
        this.delegate.dropTable(databaseName, tableName, deleteData);
    }

    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        this.methodInvocations.add((Object)Method.REPLACE_TABLE);
        this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges);
    }

    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        throw new UnsupportedOperationException();
    }

    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        throw new UnsupportedOperationException();
    }

    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        throw new UnsupportedOperationException();
    }

    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        throw new UnsupportedOperationException();
    }

    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        throw new UnsupportedOperationException();
    }

    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        throw new UnsupportedOperationException();
    }

    public void dropColumn(String databaseName, String tableName, String columnName) {
        throw new UnsupportedOperationException();
    }

    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        this.methodInvocations.add((Object)Method.GET_PARTITION);
        return this.delegate.getPartition(table, partitionValues);
    }

    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        this.methodInvocations.add((Object)Method.GET_PARTITION_NAMES_BY_FILTER);
        return this.delegate.getPartitionNamesByFilter(databaseName, tableName, columnNames, partitionKeysFilter);
    }

    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        this.methodInvocations.add((Object)Method.GET_PARTITIONS_BY_NAMES);
        return this.delegate.getPartitionsByNames(table, partitionNames);
    }

    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.methodInvocations.add((Object)Method.ADD_PARTITIONS);
        this.delegate.addPartitions(databaseName, tableName, partitions);
    }

    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        throw new UnsupportedOperationException();
    }

    public void createRole(String role, String grantor) {
        throw new UnsupportedOperationException();
    }

    public void dropRole(String role) {
        throw new UnsupportedOperationException();
    }

    public Set<String> listRoles() {
        throw new UnsupportedOperationException();
    }

    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new UnsupportedOperationException();
    }

    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new UnsupportedOperationException();
    }

    public Set<RoleGrant> listGrantedPrincipals(String role) {
        throw new UnsupportedOperationException();
    }

    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        throw new UnsupportedOperationException();
    }

    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        throw new UnsupportedOperationException();
    }

    public PartitionStatistics getTableStatistics(Table table) {
        this.methodInvocations.add((Object)Method.GET_TABLE_STATISTICS);
        return this.delegate.getTableStatistics(table);
    }

    public Map<String, PartitionStatistics> getPartitionStatistics(Table table, List<Partition> partitions) {
        this.methodInvocations.add((Object)Method.GET_PARTITION_STATISTICS);
        return this.delegate.getPartitionStatistics(table, partitions);
    }

    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        this.methodInvocations.add((Object)Method.UPDATE_TABLE_STATISTICS);
        this.delegate.updateTableStatistics(databaseName, tableName, transaction, update);
    }

    public void updatePartitionStatistics(Table table, Map<String, Function<PartitionStatistics, PartitionStatistics>> updates) {
        this.methodInvocations.add((Object)Method.UPDATE_PARTITION_STATISTICS);
        this.delegate.updatePartitionStatistics(table, updates);
    }

    public List<String> getAllTables(String databaseName) {
        this.methodInvocations.add((Object)Method.GET_ALL_TABLES_FROM_DATABASE);
        return this.delegate.getAllTables(databaseName);
    }

    public Optional<List<SchemaTableName>> getAllTables() {
        Optional allTables = this.delegate.getAllTables();
        if (allTables.isPresent()) {
            this.methodInvocations.add((Object)Method.GET_ALL_TABLES);
        }
        return allTables;
    }

    public static enum Method {
        CREATE_DATABASE,
        CREATE_TABLE,
        GET_ALL_DATABASES,
        GET_DATABASE,
        GET_TABLE,
        GET_ALL_TABLES,
        GET_ALL_TABLES_FROM_DATABASE,
        GET_TABLES_WITH_PARAMETER,
        GET_TABLE_STATISTICS,
        GET_ALL_VIEWS,
        GET_ALL_VIEWS_FROM_DATABASE,
        UPDATE_TABLE_STATISTICS,
        ADD_PARTITIONS,
        GET_PARTITION_NAMES_BY_FILTER,
        GET_PARTITIONS_BY_NAMES,
        GET_PARTITION,
        GET_PARTITION_STATISTICS,
        UPDATE_PARTITION_STATISTICS,
        REPLACE_TABLE,
        DROP_TABLE;

    }
}

