/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import io.trino.filesystem.Location;
import io.trino.plugin.hive.fs.HiveFileIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveFileIterator {
    @Test
    public void testRelativeHiddenPathDetection() {
        Assert.assertTrue((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root-path/.hidden/child"), (Location)Location.of((String)"file:///root-path")));
        Assert.assertTrue((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root-path/_hidden.txt"), (Location)Location.of((String)"file:///root-path")));
        Assert.assertTrue((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root-path/.hidden/child"), (Location)Location.of((String)"file:///root-path/")));
        Assert.assertTrue((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root-path/_hidden.txt"), (Location)Location.of((String)"file:///root-path/")));
        Assert.assertFalse((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root/.hidden/listing-root/file.txt"), (Location)Location.of((String)"file:///root/.hidden/listing-root")));
        Assert.assertFalse((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root/hidden-ending_/file.txt"), (Location)Location.of((String)"file:///root/hidden-ending_")));
        Assert.assertFalse((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Location)Location.of((String)"file:///root/With spaces and | pipes/.hidden/file.txt"), (Location)Location.of((String)"file:///root/With spaces and | pipes/.hidden")));
    }

    @Test
    public void testHiddenFileNameDetection() {
        Assert.assertFalse((boolean)HiveFileIterator.isHiddenFileOrDirectory((Location)Location.of((String)"file:///parent/.hidden/ignore-parent-directories.txt")));
        Assert.assertTrue((boolean)HiveFileIterator.isHiddenFileOrDirectory((Location)Location.of((String)"file:///parent/visible/_hidden-file.txt")));
    }

    @Test
    public void testHiddenDetectionEdgeCases() {
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"/.leading-slash-hidden/file.txt", (int)0));
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"/.leading-slash-hidden-directory/", (int)0));
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"_root-hidden/file.txt", (int)0));
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"_root-hidden/directory/", (int)0));
        Assert.assertFalse((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"root//multi-slash/", (int)0));
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"root/child/.slash-hidden/file.txt", (int)0));
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"root/child/.slash-hidden/parent/file.txt", (int)0));
    }
}

