/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.filesystem.Location;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public abstract class BaseCachingDirectoryListerTest<C extends DirectoryLister>
extends AbstractTestQueryFramework {
    private C directoryLister;
    private FileHiveMetastore fileHiveMetastore;

    protected QueryRunner createQueryRunner() throws Exception {
        return this.createQueryRunner((Map<String, String>)ImmutableMap.of((Object)"hive.allow-register-partition-procedure", (Object)"true"));
    }

    protected QueryRunner createQueryRunner(Map<String, String> properties) throws Exception {
        Path temporaryMetastoreDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)temporaryMetastoreDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        this.directoryLister = this.createDirectoryLister();
        return ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setHiveProperties(properties).setMetastore(distributedQueryRunner -> {
            this.fileHiveMetastore = TestingFileHiveMetastore.createTestingFileHiveMetastore(temporaryMetastoreDirectory.toFile());
            return this.fileHiveMetastore;
        }))).setDirectoryLister((DirectoryLister)this.directoryLister))).build();
    }

    protected abstract C createDirectoryLister();

    protected abstract boolean isCached(C var1, Location var2);

    @Test
    public void testCacheInvalidationIsAppliedSpecificallyOnTheNonPartitionedTableBeingChanged() {
        this.assertUpdate("CREATE TABLE partial_cache_invalidation_table1 (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO partial_cache_invalidation_table1 VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM partial_cache_invalidation_table1", "VALUES (6)");
        String cachedTable1Location = this.getTableLocation("tpch", "partial_cache_invalidation_table1");
        Assertions.assertThat((boolean)this.isCached(cachedTable1Location)).isTrue();
        this.assertUpdate("CREATE TABLE partial_cache_invalidation_table2 (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO partial_cache_invalidation_table2 VALUES (11), (12)", 2L);
        this.assertQuery("SELECT sum(col1) FROM partial_cache_invalidation_table2", "VALUES (23)");
        String cachedTable2Location = this.getTableLocation("tpch", "partial_cache_invalidation_table2");
        Assertions.assertThat((boolean)this.isCached(cachedTable2Location)).isTrue();
        this.assertUpdate("INSERT INTO partial_cache_invalidation_table1 VALUES (4), (5)", 2L);
        Assertions.assertThat((boolean)this.isCached(cachedTable1Location)).isFalse();
        Assertions.assertThat((boolean)this.isCached(cachedTable2Location)).isTrue();
        this.assertQuery("SELECT sum(col1) FROM partial_cache_invalidation_table1", "VALUES (15)");
        this.assertQuery("SELECT sum(col1) FROM partial_cache_invalidation_table2", "VALUES (23)");
        this.assertUpdate("DROP TABLE partial_cache_invalidation_table1");
        this.assertUpdate("DROP TABLE partial_cache_invalidation_table2");
    }

    @Test
    public void testCacheInvalidationIsAppliedOnTheEntireCacheOnPartitionedTableDrop() {
        this.assertUpdate("CREATE TABLE full_cache_invalidation_non_partitioned_table (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO full_cache_invalidation_non_partitioned_table VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM full_cache_invalidation_non_partitioned_table", "VALUES (6)");
        String nonPartitionedTableLocation = this.getTableLocation("tpch", "full_cache_invalidation_non_partitioned_table");
        Assertions.assertThat((boolean)this.isCached(nonPartitionedTableLocation)).isTrue();
        this.assertUpdate("CREATE TABLE full_cache_invalidation_partitioned_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO full_cache_invalidation_partitioned_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2')", 4L);
        this.assertQuery("SELECT col2, sum(col1) FROM full_cache_invalidation_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7)");
        String partitionedTableGroup1PartitionLocation = this.getPartitionLocation("tpch", "full_cache_invalidation_partitioned_table", (List<String>)ImmutableList.of((Object)"group1"));
        String partitionedTableGroup2PartitionLocation = this.getPartitionLocation("tpch", "full_cache_invalidation_partitioned_table", (List<String>)ImmutableList.of((Object)"group2"));
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup1PartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup2PartitionLocation)).isTrue();
        this.assertUpdate("INSERT INTO full_cache_invalidation_non_partitioned_table VALUES (4), (5)", 2L);
        Assertions.assertThat((boolean)this.isCached(nonPartitionedTableLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup1PartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup2PartitionLocation)).isTrue();
        this.assertUpdate("DROP TABLE full_cache_invalidation_partitioned_table");
        Assertions.assertThat((boolean)this.isCached(nonPartitionedTableLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup1PartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup2PartitionLocation)).isFalse();
        this.assertQuery("SELECT sum(col1) FROM full_cache_invalidation_non_partitioned_table", "VALUES (15)");
        this.assertUpdate("DROP TABLE full_cache_invalidation_non_partitioned_table");
    }

    @Test
    public void testCacheInvalidationIsAppliedSpecificallyOnPartitionDropped() {
        this.assertUpdate("CREATE TABLE partition_path_cache_invalidation_non_partitioned_table (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO partition_path_cache_invalidation_non_partitioned_table VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM partition_path_cache_invalidation_non_partitioned_table", "VALUES (6)");
        String nonPartitionedTableLocation = this.getTableLocation("tpch", "partition_path_cache_invalidation_non_partitioned_table");
        Assertions.assertThat((boolean)this.isCached(nonPartitionedTableLocation)).isTrue();
        this.assertUpdate("CREATE TABLE partition_path_cache_invalidation_partitioned_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO partition_path_cache_invalidation_partitioned_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2')", 4L);
        this.assertQuery("SELECT col2, sum(col1) FROM partition_path_cache_invalidation_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7)");
        String partitionedTableGroup1PartitionLocation = this.getPartitionLocation("tpch", "partition_path_cache_invalidation_partitioned_table", (List<String>)ImmutableList.of((Object)"group1"));
        String partitionedTableGroup2PartitionLocation = this.getPartitionLocation("tpch", "partition_path_cache_invalidation_partitioned_table", (List<String>)ImmutableList.of((Object)"group2"));
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup1PartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup2PartitionLocation)).isTrue();
        this.assertUpdate("DELETE FROM partition_path_cache_invalidation_partitioned_table WHERE col2='group1'");
        Assertions.assertThat((boolean)this.isCached(nonPartitionedTableLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup1PartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(partitionedTableGroup2PartitionLocation)).isTrue();
        this.assertQuery("SELECT sum(col1) FROM partition_path_cache_invalidation_non_partitioned_table", "VALUES (6)");
        this.assertQuery("SELECT col2, sum(col1) FROM partition_path_cache_invalidation_partitioned_table GROUP BY col2", "VALUES ('group2', 7)");
        this.assertUpdate("DROP TABLE partition_path_cache_invalidation_non_partitioned_table");
        this.assertUpdate("DROP TABLE partition_path_cache_invalidation_partitioned_table");
    }

    @Test
    public void testInsertIntoNonPartitionedTable() {
        this.assertUpdate("CREATE TABLE insert_into_non_partitioned_table (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO insert_into_non_partitioned_table VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM insert_into_non_partitioned_table", "VALUES (6)");
        Assertions.assertThat((boolean)this.isCached(this.getTableLocation("tpch", "insert_into_non_partitioned_table"))).isTrue();
        this.assertUpdate("INSERT INTO insert_into_non_partitioned_table VALUES (4), (5)", 2L);
        Assertions.assertThat((boolean)this.isCached(this.getTableLocation("tpch", "insert_into_non_partitioned_table"))).isFalse();
        this.assertQuery("SELECT sum(col1) FROM insert_into_non_partitioned_table", "VALUES (15)");
        this.assertUpdate("DROP TABLE insert_into_non_partitioned_table");
    }

    @Test
    public void testInsertIntoPartitionedTable() {
        this.assertUpdate("CREATE TABLE insert_into_partitioned_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO insert_into_partitioned_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2')", 4L);
        this.assertQuery("SELECT col2, sum(col1) FROM insert_into_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7)");
        String tableGroup1PartitionLocation = this.getPartitionLocation("tpch", "insert_into_partitioned_table", (List<String>)ImmutableList.of((Object)"group1"));
        String tableGroup2PartitionLocation = this.getPartitionLocation("tpch", "insert_into_partitioned_table", (List<String>)ImmutableList.of((Object)"group2"));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation)).isTrue();
        this.assertUpdate("INSERT INTO insert_into_partitioned_table  VALUES (5, 'group2'), (6, 'group3')", 2L);
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation)).isFalse();
        this.assertQuery("SELECT col2, sum(col1) FROM insert_into_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 12), ('group3', 6)");
        this.assertUpdate("DROP TABLE insert_into_partitioned_table");
    }

    @Test
    public void testDropPartition() {
        this.assertUpdate("CREATE TABLE delete_from_partitioned_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO delete_from_partitioned_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2'), (5, 'group3')", 5L);
        this.assertQuery("SELECT col2, sum(col1) FROM delete_from_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7), ('group3', 5)");
        String tableGroup1PartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"group1"));
        String tableGroup2PartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"group2"));
        String tableGroup3PartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"group3"));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation)).isTrue();
        this.assertUpdate("DELETE FROM delete_from_partitioned_table WHERE col2 = 'group1' OR col2 = 'group2'");
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup3PartitionLocation)).isTrue();
        this.assertQuery("SELECT col2, sum(col1) FROM delete_from_partitioned_table GROUP BY col2", "VALUES ('group3', 5)");
        this.assertUpdate("DROP TABLE delete_from_partitioned_table");
    }

    @Test
    public void testDropMultiLevelPartition() {
        this.assertUpdate("CREATE TABLE delete_from_partitioned_table (clicks bigint, day date, country varchar) WITH (format = 'ORC', partitioned_by = ARRAY['day', 'country'])");
        this.assertUpdate("INSERT INTO delete_from_partitioned_table VALUES (1000, DATE '2022-02-01', 'US'), (2000, DATE '2022-02-01', 'US'), (4000, DATE '2022-02-02', 'US'), (1500, DATE '2022-02-01', 'AT'), (2500, DATE '2022-02-02', 'AT')", 5L);
        this.assertQuery("SELECT day, country, sum(clicks) FROM delete_from_partitioned_table GROUP BY day, country", "VALUES (DATE '2022-02-01', 'US', 3000), (DATE '2022-02-02', 'US', 4000), (DATE '2022-02-01', 'AT', 1500), (DATE '2022-02-02', 'AT', 2500)");
        String table20220201UsPartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"2022-02-01", (Object)"US"));
        String table20220202UsPartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"2022-02-02", (Object)"US"));
        String table20220201AtPartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"2022-02-01", (Object)"AT"));
        String table20220202AtPartitionLocation = this.getPartitionLocation("tpch", "delete_from_partitioned_table", (List<String>)ImmutableList.of((Object)"2022-02-02", (Object)"AT"));
        Assertions.assertThat((boolean)this.isCached(table20220201UsPartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(table20220202UsPartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(table20220201AtPartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(table20220202AtPartitionLocation)).isTrue();
        this.assertUpdate("DELETE FROM delete_from_partitioned_table WHERE day = DATE '2022-02-01'");
        Assertions.assertThat((boolean)this.isCached(table20220201UsPartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(table20220202UsPartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(table20220201AtPartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(table20220202AtPartitionLocation)).isTrue();
        this.assertUpdate("DELETE FROM delete_from_partitioned_table WHERE country = 'US'");
        Assertions.assertThat((boolean)this.isCached(table20220202UsPartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(table20220202AtPartitionLocation)).isTrue();
        this.assertQuery("SELECT day, country, sum(clicks) FROM delete_from_partitioned_table GROUP BY day, country", "VALUES (DATE '2022-02-02', 'AT', 2500)");
        this.assertUpdate("DROP TABLE delete_from_partitioned_table");
    }

    @Test
    public void testUnregisterRegisterPartition() {
        this.assertUpdate("CREATE TABLE register_unregister_partition_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO register_unregister_partition_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2')", 4L);
        this.assertQuery("SELECT col2, sum(col1) FROM register_unregister_partition_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7)");
        String tableGroup1PartitionLocation = this.getPartitionLocation("tpch", "register_unregister_partition_table", (List<String>)ImmutableList.of((Object)"group1"));
        String tableGroup2PartitionLocation = this.getPartitionLocation("tpch", "register_unregister_partition_table", (List<String>)ImmutableList.of((Object)"group2"));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation)).isTrue();
        List paths = this.getQueryRunner().execute(this.getSession(), "SELECT \"$path\" FROM register_unregister_partition_table WHERE col2 = 'group1' LIMIT 1").toTestTypes().getMaterializedRows();
        String group1PartitionPath = Location.of((String)((String)((MaterializedRow)paths.get(0)).getField(0))).parentDirectory().toString();
        this.assertUpdate(String.format("CALL system.unregister_partition('%s', '%s', ARRAY['col2'], ARRAY['group1'])", "tpch", "register_unregister_partition_table"));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation)).isTrue();
        this.assertQuery("SELECT col2, sum(col1) FROM register_unregister_partition_table GROUP BY col2", "VALUES ('group2', 7)");
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation)).isTrue();
        this.assertUpdate(String.format("CALL system.register_partition('%s', '%s', ARRAY['col2'], ARRAY['group1'], '%s')", "tpch", "register_unregister_partition_table", group1PartitionPath));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation)).isTrue();
        this.assertQuery("SELECT col2, sum(col1) FROM register_unregister_partition_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7)");
        this.assertUpdate("DROP TABLE register_unregister_partition_table");
    }

    @Test
    public void testRenameTable() {
        this.assertUpdate("CREATE TABLE table_to_be_renamed (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO table_to_be_renamed VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM table_to_be_renamed", "VALUES (6)");
        String tableLocation = this.getTableLocation("tpch", "table_to_be_renamed");
        Assertions.assertThat((boolean)this.isCached(tableLocation)).isTrue();
        this.assertUpdate("ALTER TABLE table_to_be_renamed RENAME TO table_renamed");
        Assertions.assertThat((boolean)this.isCached(tableLocation)).isFalse();
        this.assertUpdate("DROP TABLE table_renamed");
    }

    @Test
    public void testDropTable() {
        this.assertUpdate("CREATE TABLE table_to_be_dropped (col1 int) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO table_to_be_dropped VALUES (1), (2), (3)", 3L);
        this.assertQuery("SELECT sum(col1) FROM table_to_be_dropped", "VALUES (6)");
        String tableLocation = this.getTableLocation("tpch", "table_to_be_dropped");
        Assertions.assertThat((boolean)this.isCached(tableLocation)).isTrue();
        this.assertUpdate("DROP TABLE table_to_be_dropped");
        Assertions.assertThat((boolean)this.isCached(tableLocation)).isFalse();
    }

    @Test
    public void testDropPartitionedTable() {
        this.assertUpdate("CREATE TABLE drop_partitioned_table (col1 int, col2 varchar) WITH (format = 'ORC', partitioned_by = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO drop_partitioned_table VALUES (1, 'group1'), (2, 'group1'), (3, 'group2'), (4, 'group2'), (5, 'group3')", 5L);
        this.assertQuery("SELECT col2, sum(col1) FROM drop_partitioned_table GROUP BY col2", "VALUES ('group1', 3), ('group2', 7), ('group3', 5)");
        String tableGroup1PartitionLocation = this.getPartitionLocation("tpch", "drop_partitioned_table", (List<String>)ImmutableList.of((Object)"group1"));
        String tableGroup2PartitionLocation = this.getPartitionLocation("tpch", "drop_partitioned_table", (List<String>)ImmutableList.of((Object)"group2"));
        String tableGroup3PartitionLocation = this.getPartitionLocation("tpch", "drop_partitioned_table", (List<String>)ImmutableList.of((Object)"group3"));
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation)).isTrue();
        Assertions.assertThat((boolean)this.isCached(tableGroup3PartitionLocation)).isTrue();
        this.assertUpdate("DROP TABLE drop_partitioned_table");
        Assertions.assertThat((boolean)this.isCached(tableGroup1PartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup2PartitionLocation)).isFalse();
        Assertions.assertThat((boolean)this.isCached(tableGroup3PartitionLocation)).isFalse();
    }

    protected Optional<Table> getTable(String schemaName, String tableName) {
        return this.fileHiveMetastore.getTable(schemaName, tableName);
    }

    protected void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        this.fileHiveMetastore.createTable(table, principalPrivileges);
    }

    protected void dropTable(String schemaName, String tableName, boolean deleteData) {
        this.fileHiveMetastore.dropTable(schemaName, tableName, deleteData);
    }

    protected String getTableLocation(String schemaName, String tableName) {
        return this.getTable(schemaName, tableName).map(table -> table.getStorage().getLocation()).orElseThrow(() -> new NoSuchElementException(String.format("The table %s.%s could not be found", schemaName, tableName)));
    }

    protected String getPartitionLocation(String schemaName, String tableName, List<String> partitionValues) {
        Table table = this.getTable(schemaName, tableName).orElseThrow(() -> new NoSuchElementException(String.format("The table %s.%s could not be found", schemaName, tableName)));
        return this.fileHiveMetastore.getPartition(table, partitionValues).map(partition -> partition.getStorage().getLocation()).orElseThrow(() -> new NoSuchElementException(String.format("The partition %s from the table %s.%s could not be found", partitionValues, schemaName, tableName)));
    }

    protected boolean isCached(String path) {
        return this.isCached(this.directoryLister, Location.of((String)path));
    }
}

