/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slices;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestTimestampCoercer {
    @Test(dataProvider="timestampValuesProvider")
    public void testTimestampToVarchar(String timestampValue, String hiveTimestampValue) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampValue);
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, new LongTimestamp(timestamp.getEpochMicros(), timestamp.getPicosOfMicros()), VarcharType.createUnboundedVarcharType(), hiveTimestampValue);
    }

    @Test(dataProvider="timestampValuesProvider")
    public void testVarcharToShortTimestamp(String timestampValue, String hiveTimestampValue) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampValue);
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_MICROS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        TestTimestampCoercer.assertVarcharToShortTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)hiveTimestampValue), (Type)TimestampType.TIMESTAMP_MICROS, timestamp.getEpochMicros());
    }

    @Test(dataProvider="timestampValuesProvider")
    public void testVarcharToLongTimestamp(String timestampValue, String hiveTimestampValue) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampValue);
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        TestTimestampCoercer.assertVarcharToLongTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)hiveTimestampValue), (Type)TimestampType.TIMESTAMP_PICOS, new LongTimestamp(timestamp.getEpochMicros(), timestamp.getPicosOfMicros()));
    }

    @Test
    public void testTimestampToSmallerVarchar() {
        LocalDateTime localDateTime = LocalDateTime.parse("2023-04-11T05:16:12.345678876");
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        LongTimestamp longTimestamp = new LongTimestamp(timestamp.getEpochMicros(), timestamp.getPicosOfMicros());
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)1), "2");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)2), "20");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)3), "202");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)4), "2023");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)5), "2023-");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)6), "2023-0");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)7), "2023-04");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)8), "2023-04-");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)9), "2023-04-1");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)10), "2023-04-11");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)11), "2023-04-11 ");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)12), "2023-04-11 0");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)13), "2023-04-11 05");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)14), "2023-04-11 05:");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)15), "2023-04-11 05:1");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)16), "2023-04-11 05:16");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)17), "2023-04-11 05:16:");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)18), "2023-04-11 05:16:1");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)19), "2023-04-11 05:16:12");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)20), "2023-04-11 05:16:12.");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)21), "2023-04-11 05:16:12.3");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)22), "2023-04-11 05:16:12.34");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)23), "2023-04-11 05:16:12.345");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)24), "2023-04-11 05:16:12.3456");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)25), "2023-04-11 05:16:12.34567");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)26), "2023-04-11 05:16:12.345678");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)27), "2023-04-11 05:16:12.3456788");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)28), "2023-04-11 05:16:12.34567887");
        TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, longTimestamp, VarcharType.createVarcharType((int)29), "2023-04-11 05:16:12.345678876");
    }

    @Test
    public void testHistoricalLongTimestampToVarchar() {
        LocalDateTime localDateTime = LocalDateTime.parse("1899-12-31T23:59:59.999999999");
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTimestampCoercer.assertLongTimestampToVarcharCoercions(TimestampType.TIMESTAMP_PICOS, new LongTimestamp(timestamp.getEpochMicros(), timestamp.getPicosOfMicros()), VarcharType.createUnboundedVarcharType(), "1899-12-31 23:59:59.999999999")).isInstanceOf(TrinoException.class)).hasMessageContaining("Coercion on historical dates is not supported");
    }

    @Test(dataProvider="invalidValue")
    public void testInvalidVarcharToShortTimestamp(String invalidValue) {
        TestTimestampCoercer.assertVarcharToShortTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)invalidValue), (Type)TimestampType.TIMESTAMP_MICROS, null);
    }

    @Test(dataProvider="invalidValue")
    public void testInvalidVarcharLongTimestamp(String invalidValue) {
        TestTimestampCoercer.assertVarcharToLongTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)invalidValue), (Type)TimestampType.TIMESTAMP_MICROS, null);
    }

    @Test
    public void testHistoricalVarcharToShortTimestamp() {
        LocalDateTime localDateTime = LocalDateTime.parse("1899-12-31T23:59:59.999999");
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_MICROS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTimestampCoercer.assertVarcharToShortTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)"1899-12-31 23:59:59.999999"), (Type)TimestampType.TIMESTAMP_MICROS, timestamp.getEpochMicros())).isInstanceOf(TrinoException.class)).hasMessageContaining("Coercion on historical dates is not supported");
    }

    @Test
    public void testHistoricalVarcharToLongTimestamp() {
        LocalDateTime localDateTime = LocalDateTime.parse("1899-12-31T23:59:59.999999");
        SqlTimestamp timestamp = SqlTimestamp.fromSeconds((int)TimestampType.TIMESTAMP_PICOS.getPrecision(), (long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)localDateTime.get(ChronoField.NANO_OF_SECOND));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTimestampCoercer.assertVarcharToShortTimestampCoercions((Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)"1899-12-31 23:59:59.999999"), (Type)TimestampType.TIMESTAMP_PICOS, timestamp.getEpochMicros())).isInstanceOf(TrinoException.class)).hasMessageContaining("Coercion on historical dates is not supported");
    }

    @DataProvider
    public Object[][] timestampValuesProvider() {
        return new Object[][]{{"1900-01-01T00:00:00.000", "1900-01-01 00:00:00"}, {"1958-01-01T13:18:03.123", "1958-01-01 13:18:03.123"}, {"2019-03-18T10:01:17.987", "2019-03-18 10:01:17.987"}, {"2018-10-28T01:33:17.456", "2018-10-28 01:33:17.456"}, {"2018-10-28T03:33:33.333", "2018-10-28 03:33:33.333"}, {"1970-01-01T00:00:00.000", "1970-01-01 00:00:00"}, {"1970-01-01T00:13:42.000", "1970-01-01 00:13:42"}, {"2018-04-01T02:13:55.123", "2018-04-01 02:13:55.123"}, {"2018-03-25T03:17:17.000", "2018-03-25 03:17:17"}, {"1986-01-01T00:13:07.000", "1986-01-01 00:13:07"}, {"1969-12-31T23:59:59.123456", "1969-12-31 23:59:59.123456"}};
    }

    @DataProvider
    public Object[][] invalidValue() {
        return new Object[][]{{"Invalid timestamp"}, {"2022"}, {"2001-04-01T00:13:42.000"}, {"2001-14-01 00:13:42.000"}, {"2001-01-32 00:13:42.000"}, {"2001-04-01 23:59:60.000"}, {"2001-04-01 23:60:01.000"}, {"2001-04-01 27:01:01.000"}};
    }

    public static void assertLongTimestampToVarcharCoercions(TimestampType fromType, LongTimestamp valueToBeCoerced, VarcharType toType, String expectedValue) {
        TestTimestampCoercer.assertCoercions((Type)fromType, valueToBeCoerced, (Type)toType, Slices.utf8Slice((String)expectedValue), HiveTimestampPrecision.NANOSECONDS);
    }

    public static void assertVarcharToShortTimestampCoercions(Type fromType, Object valueToBeCoerced, Type toType, Object expectedValue) {
        TestTimestampCoercer.assertCoercions(fromType, valueToBeCoerced, toType, expectedValue, HiveTimestampPrecision.MICROSECONDS);
    }

    public static void assertVarcharToLongTimestampCoercions(Type fromType, Object valueToBeCoerced, Type toType, Object expectedValue) {
        TestTimestampCoercer.assertCoercions(fromType, valueToBeCoerced, toType, expectedValue, HiveTimestampPrecision.NANOSECONDS);
    }

    public static void assertCoercions(Type fromType, Object valueToBeCoerced, Type toType, Object expectedValue, HiveTimestampPrecision timestampPrecision) {
        Block coercedValue = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveType.toHiveType((Type)fromType), (HiveType)HiveType.toHiveType((Type)toType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(timestampPrecision, false)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)fromType, (Object)valueToBeCoerced));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)toType, (Block)coercedValue)).isEqualTo(expectedValue);
    }
}

