/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slices;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.testing.DataProviders;
import io.trino.type.InternalTypeManager;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDoubleToVarcharCoercions {
    @Test(dataProvider="doubleValues")
    public void testDoubleToVarcharCoercions(Double doubleValue, boolean treatNaNAsNull) {
        TestDoubleToVarcharCoercions.assertCoercions((Type)DoubleType.DOUBLE, doubleValue, (Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)doubleValue.toString()), treatNaNAsNull);
    }

    @Test(dataProvider="doubleValues")
    public void testDoubleSmallerVarcharCoercions(Double doubleValue, boolean treatNaNAsNull) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDoubleToVarcharCoercions.assertCoercions((Type)DoubleType.DOUBLE, doubleValue, (Type)VarcharType.createVarcharType((int)1), doubleValue.toString(), treatNaNAsNull)).isInstanceOf(TrinoException.class)).hasMessageContaining("Varchar representation of %s exceeds varchar(1) bounds", new Object[]{doubleValue});
    }

    @Test
    public void testNaNToVarcharCoercions() {
        TestDoubleToVarcharCoercions.assertCoercions((Type)DoubleType.DOUBLE, Double.NaN, (Type)VarcharType.createUnboundedVarcharType(), null, true);
        TestDoubleToVarcharCoercions.assertCoercions((Type)DoubleType.DOUBLE, Double.NaN, (Type)VarcharType.createUnboundedVarcharType(), Slices.utf8Slice((String)"NaN"), false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDoubleToVarcharCoercions.assertCoercions((Type)DoubleType.DOUBLE, Double.NaN, (Type)VarcharType.createVarcharType((int)1), "NaN", false)).isInstanceOf(TrinoException.class)).hasMessageContaining("Varchar representation of NaN exceeds varchar(1) bounds");
    }

    @DataProvider
    public Object[][] doubleValues() {
        return DataProviders.cartesianProduct((Object[][][])new Object[][][]{(Object[][])Stream.of(Double.NEGATIVE_INFINITY, Double.MIN_VALUE, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.parseDouble("123456789.12345678")).collect(DataProviders.toDataProvider()), DataProviders.trueFalse()});
    }

    public static void assertCoercions(Type fromType, Object valueToBeCoerced, Type toType, Object expectedValue, boolean treatNaNAsNull) {
        Block coercedValue = ((TypeCoercer)CoercionUtils.createCoercer((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveType)HiveType.toHiveType((Type)fromType), (HiveType)HiveType.toHiveType((Type)toType), (CoercionUtils.CoercionContext)new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, treatNaNAsNull)).orElseThrow()).apply(Utils.nativeValueToBlock((Type)fromType, (Object)valueToBeCoerced));
        Assertions.assertThat((Object)Utils.blockToNativeValue((Type)toType, (Block)coercedValue)).isEqualTo(expectedValue);
    }
}

