/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.benchmark;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.filesystem.local.LocalOutputFile;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hive.formats.encodings.ColumnEncodingFactory;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.TextColumnEncodingFactory;
import io.trino.hive.formats.rcfile.RcFileWriter;
import io.trino.orc.OrcDataSink;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcWriteValidation;
import io.trino.orc.OrcWriter;
import io.trino.orc.OrcWriterOptions;
import io.trino.orc.OrcWriterStats;
import io.trino.orc.OutputStreamOrcDataSink;
import io.trino.orc.metadata.OrcType;
import io.trino.parquet.writer.ParquetSchemaConverter;
import io.trino.parquet.writer.ParquetWriter;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.benchmark.AbstractFileFormat;
import io.trino.plugin.hive.benchmark.FileFormat;
import io.trino.plugin.hive.benchmark.FormatWriter;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTimeZone;

public final class StandardFileFormats {
    public static final FileFormat TRINO_RCBINARY = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.RCBINARY;
        }

        @Override
        public HivePageSourceFactory getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return new RcFilePageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig().setRcfileTimeZone("UTC"));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoRcFileFormatWriter(targetFile, columnTypes, (ColumnEncodingFactory)new BinaryColumnEncodingFactory(DateTimeZone.UTC), compressionCodec);
        }
    };
    public static final FileFormat TRINO_RCTEXT = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.RCTEXT;
        }

        @Override
        public HivePageSourceFactory getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return new RcFilePageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig().setRcfileTimeZone("UTC"));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoRcFileFormatWriter(targetFile, columnTypes, (ColumnEncodingFactory)new TextColumnEncodingFactory(), compressionCodec);
        }
    };
    public static final FileFormat TRINO_ORC = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.ORC;
        }

        @Override
        public HivePageSourceFactory getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new FileFormatDataSourceStats(), DateTimeZone.UTC);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoOrcFormatWriter(targetFile, columnNames, columnTypes, compressionCodec);
        }
    };
    public static final FileFormat TRINO_PARQUET = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.PARQUET;
        }

        @Override
        public HivePageSourceFactory getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return new ParquetPageSourceFactory((TrinoFileSystemFactory)new HdfsFileSystemFactory(hdfsEnvironment, HiveTestUtils.HDFS_FILE_SYSTEM_STATS), new FileFormatDataSourceStats(), new ParquetReaderConfig(), new HiveConfig());
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoParquetFormatWriter(targetFile, columnNames, columnTypes, compressionCodec);
        }
    };

    private StandardFileFormats() {
    }

    private static class PrestoRcFileFormatWriter
    implements FormatWriter {
        private final RcFileWriter writer;

        public PrestoRcFileFormatWriter(File targetFile, List<Type> types, ColumnEncodingFactory encoding, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new RcFileWriter((OutputStream)new FileOutputStream(targetFile), types, encoding, compressionCodec.getHiveCompressionKind(), (Map)ImmutableMap.of(), true);
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoOrcFormatWriter
    implements FormatWriter {
        private final OrcWriter writer;

        public PrestoOrcFormatWriter(File targetFile, List<String> columnNames, List<Type> types, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new OrcWriter((OrcDataSink)OutputStreamOrcDataSink.create((TrinoOutputFile)new LocalOutputFile(targetFile)), columnNames, types, OrcType.createRootOrcType(columnNames, types), compressionCodec.getOrcCompressionKind(), new OrcWriterOptions(), (Map)ImmutableMap.of(), false, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoParquetFormatWriter
    implements FormatWriter {
        private final ParquetWriter writer;

        public PrestoParquetFormatWriter(File targetFile, List<String> columnNames, List<Type> types, HiveCompressionCodec compressionCodec) throws IOException {
            ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter(types, columnNames, true, true);
            this.writer = new ParquetWriter((OutputStream)new FileOutputStream(targetFile), schemaConverter.getMessageType(), schemaConverter.getPrimitiveTypes(), ParquetWriterOptions.builder().build(), compressionCodec.getParquetCompressionCodec(), "test-version", Optional.of(DateTimeZone.getDefault()), Optional.empty());
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

