/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.benchmark;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.benchmark.FileFormat;
import io.trino.plugin.hive.benchmark.TestData;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.tpch.TpchColumn;
import io.trino.tpch.TpchEntity;
import io.trino.tpch.TpchTable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.util.Statistics;

public final class BenchmarkFileFormatsUtils {
    public static final long MIN_DATA_SIZE = DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();

    private BenchmarkFileFormatsUtils() {
    }

    @SafeVarargs
    public static <E extends TpchEntity> TestData createTpchDataSet(FileFormat format, TpchTable<E> tpchTable, TpchColumn<E> ... columns) {
        return BenchmarkFileFormatsUtils.createTpchDataSet(format, tpchTable, ImmutableList.copyOf((Object[])columns));
    }

    public static <E extends TpchEntity> TestData createTpchDataSet(FileFormat format, TpchTable<E> tpchTable, List<TpchColumn<E>> columns) {
        List<String> columnNames = columns.stream().map(TpchColumn::getColumnName).collect(Collectors.toList());
        List<Type> columnTypes = columns.stream().map(BenchmarkFileFormatsUtils::getColumnType).map(type -> format.supportsDate() || !DateType.DATE.equals(type) ? type : VarcharType.createUnboundedVarcharType()).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(columnTypes);
        ImmutableList.Builder pages = ImmutableList.builder();
        long dataSize = 0L;
        for (TpchEntity row : tpchTable.createGenerator(10.0, 1, 1)) {
            pageBuilder.declarePosition();
            block8: for (int i = 0; i < columns.size(); ++i) {
                TpchColumn<E> column = columns.get(i);
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                switch (column.getType().getBase()) {
                    case IDENTIFIER: {
                        BigintType.BIGINT.writeLong(blockBuilder, column.getIdentifier(row));
                        continue block8;
                    }
                    case INTEGER: {
                        IntegerType.INTEGER.writeLong(blockBuilder, (long)column.getInteger(row));
                        continue block8;
                    }
                    case DATE: {
                        if (format.supportsDate()) {
                            DateType.DATE.writeLong(blockBuilder, (long)column.getDate(row));
                            continue block8;
                        }
                        VarcharType.createUnboundedVarcharType().writeSlice(blockBuilder, Slices.utf8Slice((String)column.getString(row)));
                        continue block8;
                    }
                    case DOUBLE: {
                        DecimalType.createDecimalType((int)12, (int)2).writeLong(blockBuilder, column.getIdentifier(row));
                        continue block8;
                    }
                    case VARCHAR: {
                        VarcharType.createUnboundedVarcharType().writeSlice(blockBuilder, Slices.utf8Slice((String)column.getString(row)));
                    }
                }
            }
            if (!pageBuilder.isFull()) continue;
            Page page = pageBuilder.build();
            pages.add((Object)page);
            pageBuilder.reset();
            if ((dataSize += page.getSizeInBytes()) < MIN_DATA_SIZE) continue;
            break;
        }
        if (!pageBuilder.isEmpty()) {
            pages.add((Object)pageBuilder.build());
        }
        return new TestData(columnNames, columnTypes, (List<Page>)pages.build());
    }

    public static Type getColumnType(TpchColumn<?> input) {
        switch (input.getType().getBase()) {
            case IDENTIFIER: {
                return BigintType.BIGINT;
            }
            case INTEGER: {
                return IntegerType.INTEGER;
            }
            case DATE: {
                return DateType.DATE;
            }
            case DOUBLE: {
                return DecimalType.createDecimalType((int)12, (int)2);
            }
            case VARCHAR: {
                return VarcharType.createUnboundedVarcharType();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + input.getType());
    }

    public static void printResults(Collection<RunResult> results) {
        for (RunResult result : results) {
            Statistics inputSizeStats = ((Result)result.getSecondaryResults().get("inputSize")).getStatistics();
            Statistics outputSizeStats = ((Result)result.getSecondaryResults().get("outputSize")).getStatistics();
            double compressionRatio = inputSizeStats.getSum() / outputSizeStats.getSum();
            String compression = result.getParams().getParam("compression");
            String fileFormat = result.getParams().getParam("benchmarkFileFormat");
            String dataSet = result.getParams().getParam("dataSet");
            System.out.printf("  %-10s  %-30s  %-10s  %-25s  %2.2f  %10s \u00b1 %11s (%5.2f%%) (N = %d, \u03b1 = 99.9%%)\n", result.getPrimaryResult().getLabel(), dataSet, compression, fileFormat, compressionRatio, BenchmarkFileFormatsUtils.toHumanReadableSpeed((long)inputSizeStats.getMean()), BenchmarkFileFormatsUtils.toHumanReadableSpeed((long)inputSizeStats.getMeanErrorAt(0.999)), inputSizeStats.getMeanErrorAt(0.999) * 100.0 / inputSizeStats.getMean(), inputSizeStats.getN());
        }
        System.out.println();
    }

    public static String toHumanReadableSpeed(long bytesPerSecond) {
        String humanReadableSpeed = bytesPerSecond < 10240L ? String.format("%dB/s", bytesPerSecond) : (bytesPerSecond < 0xA00000L ? String.format("%.1fkB/s", Float.valueOf((float)bytesPerSecond / 1024.0f)) : (bytesPerSecond < 0x280000000L ? String.format("%.1fMB/s", Float.valueOf((float)bytesPerSecond / 1048576.0f)) : String.format("%.1fGB/s", Float.valueOf((float)bytesPerSecond / 1.0737418E9f))));
        return humanReadableSpeed;
    }

    public static int nextRandomBetween(Random random, int min, int max) {
        return min + random.nextInt(max - min);
    }

    public static File createTempDir(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

