/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.benchmark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.Location;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveTypeName;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.benchmark.FileFormat;
import io.trino.plugin.hive.benchmark.TestData;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.planner.TestingConnectorTransactionHandle;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.mapred.JobConf;

public abstract class AbstractFileFormat
implements FileFormat {
    static final JobConf conf = new JobConf(ConfigurationInstantiator.newEmptyConfiguration());

    @Override
    public boolean supportsDate() {
        return true;
    }

    @Override
    public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
        return AbstractFileFormat.createPageSource(this.getHivePageSourceFactory(hdfsEnvironment), session, targetFile, columnNames, columnTypes, this.getFormat());
    }

    @Override
    public ConnectorPageSource createGenericReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<ColumnHandle> readColumns, List<String> schemaColumnNames, List<Type> schemaColumnTypes) {
        HivePageSourceProvider factory = new HivePageSourceProvider(InternalTypeManager.TESTING_TYPE_MANAGER, new HiveConfig(), (Set)ImmutableSet.of((Object)this.getHivePageSourceFactory(hdfsEnvironment)));
        Properties schema = AbstractFileFormat.createSchema(this.getFormat(), schemaColumnNames, schemaColumnTypes);
        HiveSplit split = new HiveSplit("", targetFile.getPath(), 0L, targetFile.length(), targetFile.length(), targetFile.lastModified(), schema, (List)ImmutableList.of(), (List)ImmutableList.of(), OptionalInt.empty(), OptionalInt.empty(), false, TableToPartitionMapping.empty(), Optional.empty(), Optional.empty(), Optional.empty(), SplitWeight.standard());
        return factory.createPageSource((ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, session, (ConnectorSplit)split, (ConnectorTableHandle)new HiveTableHandle("schema_name", "table_name", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty()), readColumns, DynamicFilter.EMPTY);
    }

    @Override
    public boolean supports(TestData testData) {
        return true;
    }

    static ConnectorPageSource createPageSource(HivePageSourceFactory pageSourceFactory, ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveStorageFormat format) {
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes should have the same size");
        List<HiveColumnHandle> readColumns = AbstractFileFormat.getBaseColumns(columnNames, columnTypes);
        Properties schema = AbstractFileFormat.createSchema(format, columnNames, columnTypes);
        Optional readerPageSourceWithProjections = pageSourceFactory.createPageSource(session, Location.of((String)targetFile.getAbsolutePath()), 0L, targetFile.length(), targetFile.length(), schema, readColumns, TupleDomain.all(), Optional.empty(), OptionalInt.empty(), false, AcidTransaction.NO_ACID_TRANSACTION);
        Preconditions.checkState((boolean)readerPageSourceWithProjections.isPresent(), (Object)"readerPageSourceWithProjections is not present");
        Preconditions.checkState((boolean)((ReaderPageSource)readerPageSourceWithProjections.get()).getReaderColumns().isEmpty(), (Object)"projection should not be required");
        return ((ReaderPageSource)readerPageSourceWithProjections.get()).get();
    }

    static List<HiveColumnHandle> getBaseColumns(List<String> columnNames, List<Type> columnTypes) {
        return (List)IntStream.range(0, columnNames.size()).boxed().map(index -> HiveColumnHandle.createBaseColumn((String)((String)columnNames.get((int)index)), (int)index, (HiveType)HiveType.toHiveType((Type)((Type)columnTypes.get((int)index))), (Type)((Type)columnTypes.get((int)index)), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty())).collect(ImmutableList.toImmutableList());
    }

    static Properties createSchema(HiveStorageFormat format, List<String> columnNames, List<Type> columnTypes) {
        Properties schema = new Properties();
        schema.setProperty("serialization.lib", format.getSerde());
        schema.setProperty("file.inputformat", format.getInputFormat());
        schema.setProperty("columns", String.join((CharSequence)",", columnNames));
        schema.setProperty("columns.types", columnTypes.stream().map(HiveType::toHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
        return schema;
    }

    static {
        conf.set("fs.file.impl", "org.apache.hadoop.fs.RawLocalFileSystem");
    }
}

