/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.avro;

import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.local.LocalFileSystem;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.avro.AvroHiveFileUtils;
import io.trino.plugin.hive.avro.TrinoAvroSerDe;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAvroSchemaGeneration {
    @Test
    public void testOldVsNewSchemaGeneration() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("name", "testingTable");
        properties.setProperty("columns", "a,b");
        properties.setProperty("columns.types", Stream.of(HiveType.HIVE_INT, HiveType.HIVE_STRING).map(HiveType::getTypeInfo).map(TypeInfo::toString).collect(Collectors.joining(",")));
        Schema actual = AvroHiveFileUtils.determineSchemaOrThrowException((TrinoFileSystem)new LocalFileSystem(Path.of("/", new String[0])), (Properties)properties);
        Schema expected = new TrinoAvroSerDe().determineSchemaOrReturnErrorSchema(ConfigurationInstantiator.newEmptyConfiguration(), properties);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testOldVsNewSchemaGenerationWithNested() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("name", "testingTable");
        properties.setProperty("columns", "a,b");
        properties.setProperty("columns.types", Stream.of(HiveType.toHiveType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)VarcharType.VARCHAR)})), HiveType.HIVE_STRING).map(HiveType::getTypeInfo).map(TypeInfo::toString).collect(Collectors.joining(",")));
        Schema actual = AvroHiveFileUtils.determineSchemaOrThrowException((TrinoFileSystem)new LocalFileSystem(Path.of("/", new String[0])), (Properties)properties);
        Schema expected = new TrinoAvroSerDe().determineSchemaOrReturnErrorSchema(ConfigurationInstantiator.newEmptyConfiguration(), properties);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }
}

