/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.hive.BaseS3AndGlueMetastoreTest;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveS3AndGlueMetastoreTest
extends BaseS3AndGlueMetastoreTest {
    public TestHiveS3AndGlueMetastoreTest() {
        super("partitioned_by", "external_location", Objects.requireNonNull(System.getenv("S3_BUCKET"), "Environment S3_BUCKET was not set"));
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.metastore = GlueHiveMetastore.createTestingGlueHiveMetastore((Path)Path.of(this.schemaPath(), new String[0]));
        Session session = this.createSession(Optional.of(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))));
        DistributedQueryRunner queryRunner = ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder(session).setCreateTpchSchemas(false).addHiveProperty("hive.security", "allow-all"))).addHiveProperty("hive.non-managed-table-writes-enabled", "true"))).setMetastore(runner -> this.metastore))).build();
        queryRunner.execute("CREATE SCHEMA " + this.schemaName + " WITH (location = '" + this.schemaPath() + "')");
        return queryRunner;
    }

    private Session createSession(Optional<SelectedRole> role) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)"hive").withConnectorRoles((Map)role.map(selectedRole -> ImmutableMap.of((Object)"hive", (Object)selectedRole)).orElse(ImmutableMap.of())).build()).setCatalog("hive").setSchema(this.schemaName).build();
    }

    @Override
    protected Session sessionForOptimize() {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "non_transactional_optimize_enabled", "true").build();
    }

    @Override
    protected void validateDataFiles(String partitionColumn, String tableName, String location) {
        this.getActiveFiles(tableName).forEach(dataFile -> {
            Object locationDirectory = location.endsWith("/") ? location : location + "/";
            Object partitionPart = partitionColumn.isEmpty() ? "" : partitionColumn + "=[a-z0-9]+/";
            Assertions.assertThat((String)dataFile).matches((CharSequence)("^" + (String)locationDirectory + (String)partitionPart + "[a-zA-Z0-9_-]+$"));
            this.verifyPathExist((String)dataFile);
        });
    }

    @Override
    protected void validateMetadataFiles(String location) {
    }

    @Override
    protected Set<String> getAllDataFilesFromTableDirectory(String tableLocation) {
        return new HashSet<String>(this.getTableFiles(tableLocation));
    }

    @Override
    protected void validateFilesAfterOptimize(String location, Set<String> initialFiles, Set<String> updatedFiles) {
        Assertions.assertThat(updatedFiles).hasSizeLessThan(initialFiles.size());
        Assertions.assertThat(this.getAllDataFilesFromTableDirectory(location)).isEqualTo(updatedFiles);
    }

    @Override
    @Test(dataProvider="locationPatternsDataProvider")
    public void testBasicOperationsWithProvidedTableLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        String tableName = "test_basic_operations_" + TestingNames.randomNameSuffix();
        String location = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        String partitionQueryPart = partitioned ? ",partitioned_by = ARRAY['col_int']" : "";
        String create = "CREATE TABLE " + tableName + "(col_str, col_int)WITH (external_location = '" + location + "'" + partitionQueryPart + ") AS VALUES ('str1', 1), ('str2', 2), ('str3', 3)";
        if (locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.DOUBLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TRIPLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TWO_TRAILING_SLASHES) {
            this.assertQueryFails(create, "\\QUnsupported location that cannot be internally represented: " + location);
            return;
        }
        this.assertUpdate(create, 3L);
        try (BaseS3AndGlueMetastoreTest.UncheckedCloseable ignored = this.onClose("DROP TABLE " + tableName);){
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3)");
            String actualTableLocation = this.getTableLocation(tableName);
            Assertions.assertThat((String)actualTableLocation).isEqualTo(location);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('str4', 4)", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)");
            Assertions.assertThat(this.getTableFiles(actualTableLocation)).isNotEmpty();
            this.validateDataFiles(partitioned ? "col_int" : "", tableName, actualTableLocation);
        }
    }

    @Test(dataProvider="locationPatternsDataProvider")
    public void testBasicOperationsWithProvidedTableLocationNonCTAS(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        String tableName = "test_basic_operations_" + TestingNames.randomNameSuffix();
        String location = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        String partitionQueryPart = partitioned ? ",partitioned_by = ARRAY['col_int']" : "";
        String create = "CREATE TABLE " + tableName + "(col_str varchar, col_int integer) WITH (external_location = '" + location + "' " + partitionQueryPart + ")";
        if (locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.DOUBLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TRIPLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TWO_TRAILING_SLASHES) {
            this.assertQueryFails(create, "\\QUnsupported location that cannot be internally represented: " + location);
            return;
        }
        this.assertUpdate(create);
        try (BaseS3AndGlueMetastoreTest.UncheckedCloseable ignored = this.onClose("DROP TABLE " + tableName);){
            String actualTableLocation = this.getTableLocation(tableName);
            Assertions.assertThat((String)actualTableLocation).isEqualTo(location);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)", 4L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)");
            Assertions.assertThat(this.getTableFiles(actualTableLocation)).isNotEmpty();
            this.validateDataFiles(partitioned ? "col_int" : "", tableName, actualTableLocation);
        }
    }

    @Override
    @Test(dataProvider="locationPatternsDataProvider")
    public void testBasicOperationsWithProvidedSchemaLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        String actualTableLocation;
        String schemaName = "test_basic_operations_schema_" + TestingNames.randomNameSuffix();
        String schemaLocation = locationPattern.locationForSchema(this.bucketName, schemaName);
        String tableName = "test_basic_operations_table_" + TestingNames.randomNameSuffix();
        String qualifiedTableName = schemaName + "." + tableName;
        String partitionQueryPart = partitioned ? " WITH (partitioned_by = ARRAY['col_int'])" : "";
        this.assertUpdate("CREATE SCHEMA " + schemaName + " WITH (location = '" + schemaLocation + "')");
        try (BaseS3AndGlueMetastoreTest.UncheckedCloseable ignoredDropSchema = this.onClose("DROP SCHEMA " + schemaName);){
            Assertions.assertThat((String)this.getSchemaLocation(schemaName)).isEqualTo(schemaLocation);
            this.assertUpdate("CREATE TABLE " + qualifiedTableName + "(col_str varchar, col_int int)" + partitionQueryPart);
            try (BaseS3AndGlueMetastoreTest.UncheckedCloseable ignoredDropTable = this.onClose("DROP TABLE " + qualifiedTableName);){
                String expectedTableLocation = ((String)(schemaLocation.endsWith("/") ? schemaLocation : schemaLocation + "/") + tableName).replaceAll("(?<!(s3:))/+", "/");
                actualTableLocation = ((Table)this.metastore.getTable(schemaName, tableName).orElseThrow()).getStorage().getLocation();
                Assertions.assertThat((String)actualTableLocation).matches((CharSequence)expectedTableLocation);
                this.assertUpdate("INSERT INTO " + qualifiedTableName + "  VALUES ('str1', 1), ('str2', 2), ('str3', 3)", 3L);
                this.assertQuery("SELECT * FROM " + qualifiedTableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3)");
                Assertions.assertThat(this.getTableFiles(actualTableLocation)).isNotEmpty();
                this.validateDataFiles(partitioned ? "col_int" : "", qualifiedTableName, actualTableLocation);
            }
            Assertions.assertThat(this.getTableFiles(actualTableLocation)).isEmpty();
        }
        this.validateFilesAfterDrop(actualTableLocation);
    }

    @Override
    @Test(dataProvider="locationPatternsDataProvider")
    public void testMergeWithProvidedTableLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
    }

    @Override
    public void testOptimizeWithProvidedTableLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        if (locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.DOUBLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TRIPLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TWO_TRAILING_SLASHES) {
            Assertions.assertThatThrownBy(() -> super.testOptimizeWithProvidedTableLocation(partitioned, locationPattern)).hasMessageStartingWith("Unsupported location that cannot be internally represented: ").hasStackTraceContaining("SQL: CREATE TABLE test_optimize_");
            return;
        }
        super.testOptimizeWithProvidedTableLocation(partitioned, locationPattern);
    }

    @Test(dataProvider="locationPatternsDataProvider")
    public void testAnalyzeWithProvidedTableLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        String tableName = "test_analyze_" + TestingNames.randomNameSuffix();
        String location = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        String partitionQueryPart = partitioned ? ",partitioned_by = ARRAY['col_int']" : "";
        String create = "CREATE TABLE " + tableName + "(col_str, col_int)WITH (external_location = '" + location + "'" + partitionQueryPart + ") AS VALUES ('str1', 1), ('str2', 2), ('str3', 3)";
        if (locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.DOUBLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TRIPLE_SLASH || locationPattern == BaseS3AndGlueMetastoreTest.LocationPattern.TWO_TRAILING_SLASHES) {
            this.assertQueryFails(create, "\\QUnsupported location that cannot be internally represented: " + location);
            return;
        }
        this.assertUpdate(create, 3L);
        try (BaseS3AndGlueMetastoreTest.UncheckedCloseable ignored = this.onClose("DROP TABLE " + tableName);){
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('str4', 4)", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)");
            if (partitioned) {
                this.assertQuery("SHOW STATS FOR " + tableName, "VALUES\n('col_str', 0.0, 1.0, 0.0, null, null, null),\n('col_int', null, 4.0, 0.0, null, 1, 4),\n(null, null, null, null, 4.0, null, null)");
            } else {
                this.assertQuery("SHOW STATS FOR " + tableName, "VALUES\n('col_str', 16.0, 3.0, 0.0, null, null, null),\n('col_int', null, 3.0, 0.0, null, 1, 4),\n(null, null, null, null, 4.0, null, null)");
            }
            this.assertUpdate("ANALYZE " + tableName, 4L);
            if (partitioned) {
                this.assertQuery("SHOW STATS FOR " + tableName, "VALUES\n('col_str', 16.0, 1.0, 0.0, null, null, null),\n('col_int', null, 4.0, 0.0, null, 1, 4),\n(null, null, null, null, 4.0, null, null)");
            } else {
                this.assertQuery("SHOW STATS FOR " + tableName, "VALUES\n('col_str', 16.0, 4.0, 0.0, null, null, null),\n('col_int', null, 4.0, 0.0, null, 1, 4),\n(null, null, null, null, 4.0, null, null)");
            }
        }
    }

    @Test
    public void testCreateTableWithIncorrectLocation() {
        String tableName = "test_create_table_with_incorrect_location_" + TestingNames.randomNameSuffix();
        String location = "s3://%s/%s/a#hash/%s".formatted(this.bucketName, this.schemaName, tableName);
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE " + tableName + "(col_str varchar, col_int integer) WITH (external_location = '" + location + "')")).hasMessageContaining("External location is not a valid file system URI").hasStackTraceContaining("Fragment is not allowed in a file system location");
    }

    @Test
    public void testCtasWithIncorrectLocation() {
        String tableName = "test_ctas_with_incorrect_location_" + TestingNames.randomNameSuffix();
        String location = "s3://%s/%s/a#hash/%s".formatted(this.bucketName, this.schemaName, tableName);
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE " + tableName + "(col_str, col_int) WITH (external_location = '" + location + "') AS VALUES ('str1', 1)")).hasMessageContaining("External location is not a valid file system URI").hasStackTraceContaining("Fragment is not allowed in a file system location");
    }

    @Test
    public void testSchemaNameEscape() {
        String schemaNameSuffix = TestingNames.randomNameSuffix();
        String schemaName = "../test_create_schema_escaped_" + schemaNameSuffix;
        String tableName = "test_table_schema_escaped_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA \"%2$s\" WITH (location = 's3://%1$s/%2$s')".formatted(this.bucketName, schemaName));
        try (BaseS3AndGlueMetastoreTest.UncheckedCloseable ignored = this.onClose("DROP SCHEMA \"" + schemaName + "\"");){
            this.assertQueryFails("CREATE TABLE \"" + schemaName + "\"." + tableName + " (col) AS VALUES 1", "Failed checking path: .*");
        }
    }
}

