/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.AbstractTestHiveLocal;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.InMemoryThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveInMemoryMetastore
extends AbstractTestHiveLocal {
    @Override
    protected HiveMetastore createMetastore(File tempDir) {
        File baseDir = new File(tempDir, "metastore");
        ThriftMetastoreConfig metastoreConfig = new ThriftMetastoreConfig();
        InMemoryThriftMetastore hiveMetastore = new InMemoryThriftMetastore(baseDir, metastoreConfig);
        return new BridgingHiveMetastore((ThriftMetastore)hiveMetastore);
    }

    @Override
    protected void createTestTable(Table table) throws Exception {
        Files.createDirectories(new File(URI.create(table.getStorage().getLocation())).toPath(), new FileAttribute[0]);
        super.createTestTable(table);
    }

    @Test
    public void forceTestNgToRespectSingleThreaded() {
    }

    @Override
    public void testMetadataDelete() {
    }

    @Override
    public void testTransactionDeleteInsert() {
    }

    @Override
    public void testHideDeltaLakeTables() {
        throw new SkipException("not supported");
    }

    @Override
    public void testDisallowQueryingOfIcebergTables() {
        throw new SkipException("not supported");
    }

    @Override
    public void testDataColumnProperties() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> super.testDataColumnProperties()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Persisting column properties is not supported: Column{name=id, type=bigint}");
    }

    @Override
    public void testPartitionColumnProperties() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> super.testPartitionColumnProperties()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Persisting column properties is not supported: Column{name=part_key, type=varchar(256)}");
    }
}

