/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Verify;
import io.trino.Session;
import io.trino.execution.DynamicFilterConfig;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.testing.AbstractTestJoinQueries;
import io.trino.testing.MaterializedResultWithQueryId;
import io.trino.testing.QueryRunner;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveDistributedJoinQueries
extends AbstractTestJoinQueries {
    protected QueryRunner createQueryRunner() throws Exception {
        Verify.verify((boolean)new DynamicFilterConfig().isEnableDynamicFiltering(), (String)"this class assumes dynamic filtering is enabled by default", (Object[])new Object[0]);
        return ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)HiveQueryRunner.builder().addExtraProperty("retry-policy", "NONE")).addHiveProperty("hive.dynamic-filtering.wait-timeout", "1h"))).setInitialTables(REQUIRED_TPCH_TABLES))).build();
    }

    @Test
    public void verifyDynamicFilteringEnabled() {
        this.assertQuery("SHOW SESSION LIKE 'enable_dynamic_filtering'", "VALUES ('enable_dynamic_filtering', 'true', 'true', 'boolean', 'Enable dynamic filtering')");
    }

    @Test
    public void testJoinWithEmptyBuildSide() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.BROADCAST.name()).build();
        MaterializedResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(session, "SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.totalprice = 123.4567");
        Assert.assertEquals((int)result.getResult().getRowCount(), (int)0);
    }
}

