/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCreateExternalTable
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.non-managed-table-writes-enabled", (Object)"true")).setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.CUSTOMER)))).build();
    }

    @Test
    public void testCreateExternalTableWithData() throws IOException {
        Path tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
        String tableLocation = tempDir.resolve("data").toUri().toString();
        String createTableSql = String.format("CREATE TABLE test_create_external WITH (external_location = '%s') AS SELECT * FROM tpch.tiny.nation", tableLocation);
        this.assertUpdate(createTableSql, 25L);
        MaterializedResult expected = this.computeActual("SELECT * FROM tpch.tiny.nation");
        MaterializedResult actual = this.computeActual("SELECT * FROM test_create_external");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
        MaterializedResult result = this.computeActual("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '/') FROM test_create_external");
        String tablePath = (String)result.getOnlyValue();
        Assertions.assertThat((String)tablePath).startsWith((CharSequence)tableLocation);
        this.assertUpdate("DROP TABLE test_create_external");
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testCreateExternalTableAsWithExistingDirectory() throws IOException {
        Path tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
        String createTableSql = String.format("CREATE TABLE test_create_external_exists WITH (external_location = '%s') AS SELECT * FROM tpch.tiny.nation", tempDir.toUri().toASCIIString());
        this.assertQueryFails(createTableSql, "Target directory for table '.*' already exists:.*");
    }

    @Test
    public void testCreateExternalTableOnNonExistingPath() throws Exception {
        Path tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        String tableName = "test_create_external_non_exists_" + TestingNames.randomNameSuffix();
        String createTableSql = String.format("CREATE TABLE %s.%s.%s (\n   col1 varchar,\n   col2 varchar\n)\nWITH (\n   external_location = '%s',\n   format = 'TEXTFILE'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), tableName, tempDir.toUri().toASCIIString());
        this.assertUpdate(createTableSql);
        String actual = (String)this.computeScalar("SHOW CREATE TABLE " + tableName);
        Assert.assertEquals((String)actual, (String)createTableSql);
        this.assertUpdate("DROP TABLE " + tableName);
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testCreateExternalTableOnExistingPathToFile() throws Exception {
        File tempFile = File.createTempFile("temp", ".tmp");
        tempFile.deleteOnExit();
        String tableName = "test_create_external_on_file_" + TestingNames.randomNameSuffix();
        String createTableSql = String.format("CREATE TABLE %s.%s.%s (\n    col1 varchar,\n    col2 varchar\n)WITH (\n    external_location = '%s',\n    format = 'TEXTFILE')\n", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), tableName, tempFile.toPath().toUri().toASCIIString());
        this.assertQueryFails(createTableSql, ".*Destination exists and is not a directory.*");
    }
}

