/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMetadata;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.trino.plugin.hive.HiveConnectorFactory;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.testing.TestingConnectorContext;
import io.trino.testing.TestingConnectorSession;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveConnectorFactory {
    @Test
    public void testGetClient() {
        TestHiveConnectorFactory.assertCreateConnector("thrift://localhost:1234");
        TestHiveConnectorFactory.assertCreateConnector("thrift://localhost:1234,thrift://192.0.2.3:5678");
        TestHiveConnectorFactory.assertCreateConnectorFails("abc", "metastoreUri scheme is missing: abc");
        TestHiveConnectorFactory.assertCreateConnectorFails("thrift://:8090", "metastoreUri host is missing: thrift://:8090");
        TestHiveConnectorFactory.assertCreateConnectorFails("thrift://localhost", "metastoreUri port is missing: thrift://localhost");
        TestHiveConnectorFactory.assertCreateConnectorFails("abc::", "metastoreUri scheme must be thrift: abc::");
        TestHiveConnectorFactory.assertCreateConnectorFails("", "metastoreUris must specify at least one URI");
        TestHiveConnectorFactory.assertCreateConnectorFails("thrift://localhost:1234,thrift://test-1", "metastoreUri port is missing: thrift://test-1");
    }

    private static void assertCreateConnector(String metastoreUri) {
        ImmutableMap config = ImmutableMap.of((Object)"hive.metastore.uri", (Object)metastoreUri);
        Connector connector = new HiveConnectorFactory().create("hive-test", (Map)config, (ConnectorContext)new TestingConnectorContext());
        ConnectorTransactionHandle transaction = connector.beginTransaction(IsolationLevel.READ_UNCOMMITTED, true, true);
        io.airlift.testing.Assertions.assertInstanceOf((Object)connector.getMetadata(TestingConnectorSession.SESSION, transaction), ClassLoaderSafeConnectorMetadata.class);
        io.airlift.testing.Assertions.assertInstanceOf((Object)connector.getSplitManager(), ClassLoaderSafeConnectorSplitManager.class);
        io.airlift.testing.Assertions.assertInstanceOf((Object)connector.getPageSourceProvider(), ConnectorPageSourceProvider.class);
        connector.commit(transaction);
    }

    private static void assertCreateConnectorFails(String metastoreUri, String exceptionString) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestHiveConnectorFactory.assertCreateConnector(metastoreUri)).isInstanceOf(RuntimeException.class)).hasMessageContaining(exceptionString);
    }
}

