/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.util.TestHiveUtil;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestHiveConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HiveConfig)ConfigAssertions.recordDefaults(HiveConfig.class)).setSingleStatementWritesOnly(false).setMaxSplitSize(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxPartitionsPerScan(1000000).setMaxPartitionsForEagerLoad(100000).setMaxOutstandingSplits(1000).setMaxOutstandingSplitsSize(DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxSplitIteratorThreads(1000).setPerTransactionMetastoreCacheMaximumSize(1000L).setMinPartitionBatchSize(10).setMaxPartitionBatchSize(100).setMaxInitialSplits(200).setMaxInitialSplitSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setSplitLoaderConcurrency(64).setMaxSplitsPerSecond(null).setDomainCompactionThreshold(1000).setTargetMaxFileSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setForceLocalScheduling(false).setMaxConcurrentFileSystemOperations(20).setMaxConcurrentMetastoreDrops(20).setMaxConcurrentMetastoreUpdates(20).setMaxPartitionDropsPerQuery(100000).setRecursiveDirWalkerEnabled(false).setIgnoreAbsentPartitions(false).setHiveStorageFormat(HiveStorageFormat.ORC).setHiveCompressionCodec(HiveCompressionOption.GZIP).setRespectTableFormat(true).setImmutablePartitions(false).setInsertExistingPartitionsBehavior(HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND).setCreateEmptyBucketFiles(false).setDeleteSchemaLocationsFallback(false).setSortedWritingEnabled(true).setPropagateTableScanSortingProperties(false).setMaxPartitionsPerWriter(100).setWriteValidationThreads(16).setValidateBucketing(true).setParallelPartitionedBucketedWrites(true).setTextMaxLineLength(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setOrcLegacyTimeZone(TimeZone.getDefault().getID()).setParquetTimeZone(TimeZone.getDefault().getID()).setUseParquetColumnNames(true).setRcfileTimeZone(TimeZone.getDefault().getID()).setRcfileWriterValidate(false).setSkipDeletionForAlter(false).setSkipTargetCleanupOnRollback(false).setBucketExecutionEnabled(true).setTableStatisticsEnabled(true).setOptimizeMismatchedBucketCount(false).setWritesToNonManagedTablesEnabled(false).setCreatesOfNonManagedTablesEnabled(true).setPartitionStatisticsSampleSize(100).setIgnoreCorruptedStatistics(false).setCollectColumnStatisticsOnWrite(true).setTemporaryStagingDirectoryEnabled(true).setTemporaryStagingDirectoryPath("/tmp/presto-${USER}").setDelegateTransactionalManagedTableLocationToMetastore(false).setFileStatusCacheExpireAfterWrite(new Duration(1.0, TimeUnit.MINUTES)).setFileStatusCacheMaxRetainedSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFileStatusCacheTables("").setPerTransactionFileStatusCacheMaxRetainedSize(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setTranslateHiveViews(false).setLegacyHiveViewTranslation(false).setHiveViewsRunAsInvoker(false).setHiveTransactionHeartbeatInterval(null).setHiveTransactionHeartbeatThreads(5).setAllowRegisterPartition(false).setQueryPartitionFilterRequired(false).setQueryPartitionFilterRequiredSchemas("").setProjectionPushdownEnabled(true).setDynamicFilteringWaitTimeout(new Duration(0.0, TimeUnit.MINUTES)).setTimestampPrecision(HiveTimestampPrecision.DEFAULT_PRECISION).setIcebergCatalogName(null).setSizeBasedSplitWeightsEnabled(true).setMinimumAssignedSplitWeight(0.05).setDeltaLakeCatalogName(null).setHudiCatalogName(null).setAutoPurge(false).setPartitionProjectionEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.single-statement-writes", (Object)"true").put((Object)"hive.max-split-size", (Object)"256MB").put((Object)"hive.max-partitions-per-scan", (Object)"123").put((Object)"hive.max-partitions-for-eager-load", (Object)"122").put((Object)"hive.max-outstanding-splits", (Object)"10").put((Object)"hive.max-outstanding-splits-size", (Object)"32MB").put((Object)"hive.max-split-iterator-threads", (Object)"10").put((Object)"hive.per-transaction-metastore-cache-maximum-size", (Object)"500").put((Object)"hive.metastore.partition-batch-size.min", (Object)"1").put((Object)"hive.metastore.partition-batch-size.max", (Object)"1000").put((Object)"hive.max-initial-splits", (Object)"10").put((Object)"hive.max-initial-split-size", (Object)"16MB").put((Object)"hive.split-loader-concurrency", (Object)"1").put((Object)"hive.max-splits-per-second", (Object)"1").put((Object)"hive.domain-compaction-threshold", (Object)"42").put((Object)"hive.target-max-file-size", (Object)"72MB").put((Object)"hive.recursive-directories", (Object)"true").put((Object)"hive.ignore-absent-partitions", (Object)"true").put((Object)"hive.storage-format", (Object)"SEQUENCEFILE").put((Object)"hive.compression-codec", (Object)"NONE").put((Object)"hive.respect-table-format", (Object)"false").put((Object)"hive.immutable-partitions", (Object)"true").put((Object)"hive.insert-existing-partitions-behavior", (Object)"OVERWRITE").put((Object)"hive.create-empty-bucket-files", (Object)"true").put((Object)"hive.delete-schema-locations-fallback", (Object)"true").put((Object)"hive.max-partitions-per-writers", (Object)"222").put((Object)"hive.write-validation-threads", (Object)"11").put((Object)"hive.validate-bucketing", (Object)"false").put((Object)"hive.parallel-partitioned-bucketed-writes", (Object)"false").put((Object)"hive.force-local-scheduling", (Object)"true").put((Object)"hive.max-concurrent-file-system-operations", (Object)"100").put((Object)"hive.max-concurrent-metastore-drops", (Object)"100").put((Object)"hive.max-concurrent-metastore-updates", (Object)"100").put((Object)"hive.max-partition-drops-per-query", (Object)"1000").put((Object)"hive.text.max-line-length", (Object)"13MB").put((Object)"hive.orc.time-zone", (Object)TestHiveUtil.nonDefaultTimeZone().getID()).put((Object)"hive.parquet.time-zone", (Object)TestHiveUtil.nonDefaultTimeZone().getID()).put((Object)"hive.parquet.use-column-names", (Object)"false").put((Object)"hive.rcfile.time-zone", (Object)TestHiveUtil.nonDefaultTimeZone().getID()).put((Object)"hive.rcfile.writer.validate", (Object)"true").put((Object)"hive.skip-deletion-for-alter", (Object)"true").put((Object)"hive.skip-target-cleanup-on-rollback", (Object)"true").put((Object)"hive.bucket-execution", (Object)"false").put((Object)"hive.sorted-writing", (Object)"false").put((Object)"hive.propagate-table-scan-sorting-properties", (Object)"true").put((Object)"hive.table-statistics-enabled", (Object)"false").put((Object)"hive.optimize-mismatched-bucket-count", (Object)"true").put((Object)"hive.non-managed-table-writes-enabled", (Object)"true").put((Object)"hive.non-managed-table-creates-enabled", (Object)"false").put((Object)"hive.partition-statistics-sample-size", (Object)"1234").put((Object)"hive.ignore-corrupted-statistics", (Object)"true").put((Object)"hive.collect-column-statistics-on-write", (Object)"false").put((Object)"hive.temporary-staging-directory-enabled", (Object)"false").put((Object)"hive.temporary-staging-directory-path", (Object)"updated").put((Object)"hive.delegate-transactional-managed-table-location-to-metastore", (Object)"true").put((Object)"hive.file-status-cache-tables", (Object)"foo.bar1, foo.bar2").put((Object)"hive.file-status-cache.max-retained-size", (Object)"1000B").put((Object)"hive.file-status-cache-expire-time", (Object)"30m").put((Object)"hive.per-transaction-file-status-cache.max-retained-size", (Object)"42B").put((Object)"hive.hive-views.enabled", (Object)"true").put((Object)"hive.hive-views.legacy-translation", (Object)"true").put((Object)"hive.hive-views.run-as-invoker", (Object)"true").put((Object)"hive.transaction-heartbeat-interval", (Object)"10s").put((Object)"hive.transaction-heartbeat-threads", (Object)"10").put((Object)"hive.allow-register-partition-procedure", (Object)"true").put((Object)"hive.query-partition-filter-required", (Object)"true").put((Object)"hive.query-partition-filter-required-schemas", (Object)"foo, bar").put((Object)"hive.projection-pushdown-enabled", (Object)"false").put((Object)"hive.dynamic-filtering.wait-timeout", (Object)"10s").put((Object)"hive.timestamp-precision", (Object)"NANOSECONDS").put((Object)"hive.iceberg-catalog-name", (Object)"iceberg").put((Object)"hive.size-based-split-weights-enabled", (Object)"false").put((Object)"hive.minimum-assigned-split-weight", (Object)"1.0").put((Object)"hive.delta-lake-catalog-name", (Object)"delta").put((Object)"hive.hudi-catalog-name", (Object)"hudi").put((Object)"hive.auto-purge", (Object)"true").put((Object)"hive.partition-projection-enabled", (Object)"true").buildOrThrow();
        HiveConfig expected = new HiveConfig().setSingleStatementWritesOnly(true).setMaxSplitSize(DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxPartitionsPerScan(123).setMaxPartitionsForEagerLoad(122).setMaxOutstandingSplits(10).setMaxOutstandingSplitsSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxSplitIteratorThreads(10).setPerTransactionMetastoreCacheMaximumSize(500L).setMinPartitionBatchSize(1).setMaxPartitionBatchSize(1000).setMaxInitialSplits(10).setMaxInitialSplitSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setSplitLoaderConcurrency(1).setMaxSplitsPerSecond(Integer.valueOf(1)).setDomainCompactionThreshold(42).setTargetMaxFileSize(DataSize.of((long)72L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setForceLocalScheduling(true).setMaxConcurrentFileSystemOperations(100).setMaxConcurrentMetastoreDrops(100).setMaxConcurrentMetastoreUpdates(100).setMaxPartitionDropsPerQuery(1000).setRecursiveDirWalkerEnabled(true).setIgnoreAbsentPartitions(true).setHiveStorageFormat(HiveStorageFormat.SEQUENCEFILE).setHiveCompressionCodec(HiveCompressionOption.NONE).setRespectTableFormat(false).setImmutablePartitions(true).setInsertExistingPartitionsBehavior(HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE).setCreateEmptyBucketFiles(true).setDeleteSchemaLocationsFallback(true).setMaxPartitionsPerWriter(222).setWriteValidationThreads(11).setValidateBucketing(false).setParallelPartitionedBucketedWrites(false).setTextMaxLineLength(DataSize.of((long)13L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setOrcLegacyTimeZone(TestHiveUtil.nonDefaultTimeZone().getID()).setParquetTimeZone(TestHiveUtil.nonDefaultTimeZone().getID()).setUseParquetColumnNames(false).setRcfileTimeZone(TestHiveUtil.nonDefaultTimeZone().getID()).setRcfileWriterValidate(true).setSkipDeletionForAlter(true).setSkipTargetCleanupOnRollback(true).setBucketExecutionEnabled(false).setSortedWritingEnabled(false).setPropagateTableScanSortingProperties(true).setTableStatisticsEnabled(false).setOptimizeMismatchedBucketCount(true).setWritesToNonManagedTablesEnabled(true).setCreatesOfNonManagedTablesEnabled(false).setPartitionStatisticsSampleSize(1234).setIgnoreCorruptedStatistics(true).setCollectColumnStatisticsOnWrite(false).setTemporaryStagingDirectoryEnabled(false).setTemporaryStagingDirectoryPath("updated").setDelegateTransactionalManagedTableLocationToMetastore(true).setFileStatusCacheTables("foo.bar1,foo.bar2").setFileStatusCacheMaxRetainedSize(DataSize.ofBytes((long)1000L)).setFileStatusCacheExpireAfterWrite(new Duration(30.0, TimeUnit.MINUTES)).setPerTransactionFileStatusCacheMaxRetainedSize(DataSize.ofBytes((long)42L)).setTranslateHiveViews(true).setLegacyHiveViewTranslation(true).setHiveViewsRunAsInvoker(true).setHiveTransactionHeartbeatInterval(new Duration(10.0, TimeUnit.SECONDS)).setHiveTransactionHeartbeatThreads(10).setAllowRegisterPartition(true).setQueryPartitionFilterRequired(true).setQueryPartitionFilterRequiredSchemas("foo, bar").setProjectionPushdownEnabled(false).setDynamicFilteringWaitTimeout(new Duration(10.0, TimeUnit.SECONDS)).setTimestampPrecision(HiveTimestampPrecision.NANOSECONDS).setIcebergCatalogName("iceberg").setSizeBasedSplitWeightsEnabled(false).setMinimumAssignedSplitWeight(1.0).setDeltaLakeCatalogName("delta").setHudiCatalogName("hudi").setAutoPurge(true).setPartitionProjectionEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

