/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import java.util.Map;
import org.testng.annotations.Test;

public class TestBucketedQueryWithManySplits
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)((HiveQueryRunner.Builder)HiveQueryRunner.builder().setNodeCount(1)).setExtraProperties((Map)ImmutableMap.of((Object)"query.schedule-split-batch-size", (Object)"1", (Object)"node-scheduler.max-splits-per-node", (Object)"1", (Object)"node-scheduler.min-pending-splits-per-task", (Object)"1"))).build();
    }

    @Test(timeOut=120000L)
    public void testBucketedQueryWithManySplits() {
        QueryRunner queryRunner = this.getQueryRunner();
        queryRunner.execute("CREATE TABLE tbl_a (col bigint, bucket bigint) WITH (bucketed_by=array['bucket'], bucket_count=10)");
        queryRunner.execute("CREATE TABLE tbl_b (col bigint, bucket bigint) WITH (bucketed_by=array['bucket'], bucket_count=10)");
        for (int i = 0; i < 50; ++i) {
            queryRunner.execute(String.format("INSERT INTO tbl_a VALUES (%s, %s)", i, i));
            queryRunner.execute(String.format("INSERT INTO tbl_b VALUES (%s, %s)", i, i));
        }
        this.assertQuery("WITH test_data AS  (SELECT bucket   FROM     (SELECT        bucket      FROM tbl_a      UNION ALL      SELECT        bucket      FROM tbl_b)    GROUP BY bucket) SELECT COUNT(1) FROM test_data", "VALUES 50");
        this.assertUpdate("DROP TABLE tbl_a");
        this.assertUpdate("DROP TABLE tbl_b");
    }
}

