/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Verify;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.plugin.hive.S3Assert;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DataProviders;
import io.trino.testing.TestingNames;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseS3AndGlueMetastoreTest
extends AbstractTestQueryFramework {
    private final String partitionByKeyword;
    private final String locationKeyword;
    protected final String bucketName;
    protected final String schemaName = "test_glue_s3_" + TestingNames.randomNameSuffix();
    protected HiveMetastore metastore;
    protected AmazonS3 s3;

    protected BaseS3AndGlueMetastoreTest(String partitionByKeyword, String locationKeyword, String bucketName) {
        this.partitionByKeyword = Objects.requireNonNull(partitionByKeyword, "partitionByKeyword is null");
        this.locationKeyword = Objects.requireNonNull(locationKeyword, "locationKeyword is null");
        this.bucketName = Objects.requireNonNull(bucketName, "bucketName is null");
    }

    @BeforeClass
    public void setUp() {
        this.s3 = (AmazonS3)AmazonS3ClientBuilder.standard().build();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.metastore != null) {
            this.metastore.dropDatabase(this.schemaName, true);
            this.metastore = null;
        }
        if (this.s3 != null) {
            this.s3.shutdown();
            this.s3 = null;
        }
    }

    @DataProvider
    public Object[][] locationPatternsDataProvider() {
        return DataProviders.cartesianProduct((Object[][][])new Object[][][]{DataProviders.trueFalse(), (Object[][])Stream.of(LocationPattern.values()).collect(DataProviders.toDataProvider())});
    }

    @Test(dataProvider="locationPatternsDataProvider")
    public void testBasicOperationsWithProvidedTableLocation(boolean partitioned, LocationPattern locationPattern) {
        String actualTableLocation;
        String tableName = "test_basic_operations_" + TestingNames.randomNameSuffix();
        String location = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        String partitionQueryPart = partitioned ? "," + this.partitionByKeyword + " = ARRAY['col_str']" : "";
        this.assertUpdate("CREATE TABLE " + tableName + "(col_str, col_int)WITH (location = '" + location + "'" + partitionQueryPart + ") AS VALUES ('str1', 1), ('str2', 2), ('str3', 3)", 3L);
        try (UncheckedCloseable ignored = this.onClose("DROP TABLE " + tableName);){
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3)");
            actualTableLocation = this.validateTableLocation(tableName, location);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('str4', 4)", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)");
            this.assertUpdate("UPDATE " + tableName + " SET col_str = 'other' WHERE col_int = 2", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('other', 2), ('str3', 3), ('str4', 4)");
            this.assertUpdate("DELETE FROM " + tableName + " WHERE col_int = 3", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('other', 2), ('str4', 4)");
            Assertions.assertThat(this.getTableFiles(actualTableLocation)).isNotEmpty();
            this.validateDataFiles(partitioned ? "col_str" : "", tableName, actualTableLocation);
            this.validateMetadataFiles(actualTableLocation);
        }
        this.validateFilesAfterDrop(actualTableLocation);
    }

    @Test(dataProvider="locationPatternsDataProvider")
    public void testBasicOperationsWithProvidedSchemaLocation(boolean partitioned, LocationPattern locationPattern) {
        String actualTableLocation;
        String schemaName = "test_basic_operations_schema_" + TestingNames.randomNameSuffix();
        String schemaLocation = locationPattern.locationForSchema(this.bucketName, schemaName);
        String tableName = "test_basic_operations_table_" + TestingNames.randomNameSuffix();
        String qualifiedTableName = schemaName + "." + tableName;
        String partitionQueryPart = partitioned ? "WITH (" + this.partitionByKeyword + " = ARRAY['col_str'])" : "";
        this.assertUpdate("CREATE SCHEMA " + schemaName + " WITH (location = '" + schemaLocation + "')");
        try (UncheckedCloseable ignoredDropSchema = this.onClose("DROP SCHEMA " + schemaName);){
            Assertions.assertThat((String)this.getSchemaLocation(schemaName)).isEqualTo(schemaLocation);
            this.assertUpdate("CREATE TABLE " + qualifiedTableName + "(col_int int, col_str varchar)" + partitionQueryPart);
            try (UncheckedCloseable ignoredDropTable = this.onClose("DROP TABLE " + qualifiedTableName);){
                String expectedTableLocationPattern = (String)(schemaLocation.endsWith("/") ? schemaLocation : schemaLocation + "/") + tableName + "-[a-z0-9]+";
                actualTableLocation = this.getTableLocation(qualifiedTableName);
                Assertions.assertThat((String)actualTableLocation).matches((CharSequence)expectedTableLocationPattern);
                this.assertUpdate("INSERT INTO " + qualifiedTableName + " (col_str, col_int) VALUES ('str1', 1), ('str2', 2), ('str3', 3)", 3L);
                this.assertQuery("SELECT col_str, col_int FROM " + qualifiedTableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3)");
                this.assertUpdate("UPDATE " + qualifiedTableName + " SET col_str = 'other' WHERE col_int = 2", 1L);
                this.assertQuery("SELECT col_str, col_int FROM " + qualifiedTableName, "VALUES ('str1', 1), ('other', 2), ('str3', 3)");
                this.assertUpdate("DELETE FROM " + qualifiedTableName + " WHERE col_int = 3", 1L);
                this.assertQuery("SELECT col_str, col_int FROM " + qualifiedTableName, "VALUES ('str1', 1), ('other', 2)");
                Assertions.assertThat(this.getTableFiles(actualTableLocation)).isNotEmpty();
                this.validateDataFiles(partitioned ? "col_str" : "", qualifiedTableName, actualTableLocation);
                this.validateMetadataFiles(actualTableLocation);
            }
            Assertions.assertThat(this.getTableFiles(actualTableLocation)).isEmpty();
        }
        Assertions.assertThat(this.getTableFiles(actualTableLocation)).isEmpty();
    }

    @Test(dataProvider="locationPatternsDataProvider")
    public void testMergeWithProvidedTableLocation(boolean partitioned, LocationPattern locationPattern) {
        String actualTableLocation;
        String tableName = "test_merge_" + TestingNames.randomNameSuffix();
        String location = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        String partitionQueryPart = partitioned ? "," + this.partitionByKeyword + " = ARRAY['col_str']" : "";
        this.assertUpdate("CREATE TABLE " + tableName + "(col_str, col_int)WITH (location = '" + location + "'" + partitionQueryPart + ") AS VALUES ('str1', 1), ('str2', 2), ('str3', 3)", 3L);
        try (UncheckedCloseable ignored = this.onClose("DROP TABLE " + tableName);){
            actualTableLocation = this.validateTableLocation(tableName, location);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3)");
            this.assertUpdate("MERGE INTO " + tableName + " USING (VALUES 1) t(x) ON false WHEN NOT MATCHED THEN INSERT VALUES ('str4', 4)", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)");
            this.assertUpdate("MERGE INTO " + tableName + " USING (VALUES 2) t(x) ON col_int = x WHEN MATCHED THEN UPDATE SET col_str = 'other'", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('other', 2), ('str3', 3), ('str4', 4)");
            this.assertUpdate("MERGE INTO " + tableName + " USING (VALUES 3) t(x) ON col_int = x WHEN MATCHED THEN DELETE", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('other', 2), ('str4', 4)");
            Assertions.assertThat(this.getTableFiles(actualTableLocation)).isNotEmpty();
            this.validateDataFiles(partitioned ? "col_str" : "", tableName, actualTableLocation);
            this.validateMetadataFiles(actualTableLocation);
        }
        this.validateFilesAfterDrop(actualTableLocation);
    }

    @Test(dataProvider="locationPatternsDataProvider")
    public void testOptimizeWithProvidedTableLocation(boolean partitioned, LocationPattern locationPattern) {
        String tableName = "test_optimize_" + TestingNames.randomNameSuffix();
        String location = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        String partitionQueryPart = partitioned ? "," + this.partitionByKeyword + " = ARRAY['value']" : "";
        String locationQueryPart = this.locationKeyword + "= '" + location + "'";
        this.assertUpdate("CREATE TABLE " + tableName + " (key integer, value varchar) WITH (" + locationQueryPart + partitionQueryPart + ")");
        try (UncheckedCloseable ignored = this.onClose("DROP TABLE " + tableName);){
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'one')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 'a//double_slash')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, 'a%percent')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (4, 'a//double_slash')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (5, 'a///triple_slash')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (6, 'trailing_slash/')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (7, 'two_trailing_slashes//')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (11, 'one')", 1L);
            Set<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(8);
            Session session = this.sessionForOptimize();
            this.computeActual(session, "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(key), listagg(value, ' ') WITHIN GROUP (ORDER BY value) FROM " + tableName))).matches("VALUES (BIGINT '39', VARCHAR 'a%percent a///triple_slash a//double_slash a//double_slash one one trailing_slash/ two_trailing_slashes//')");
            Set<String> updatedFiles = this.getActiveFiles(tableName);
            this.validateFilesAfterOptimize(this.getTableLocation(tableName), initialFiles, updatedFiles);
        }
    }

    protected Session sessionForOptimize() {
        return this.getSession();
    }

    protected void validateFilesAfterOptimize(String location, Set<String> initialFiles, Set<String> updatedFiles) {
        Assertions.assertThat(updatedFiles).hasSizeLessThan(initialFiles.size());
        Assertions.assertThat(this.getAllDataFilesFromTableDirectory(location)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
    }

    protected abstract void validateDataFiles(String var1, String var2, String var3);

    protected abstract void validateMetadataFiles(String var1);

    protected String validateTableLocation(String tableName, String expectedLocation) {
        String actualTableLocation = this.getTableLocation(tableName);
        Assertions.assertThat((String)actualTableLocation).isEqualTo(expectedLocation);
        return actualTableLocation;
    }

    protected void validateFilesAfterDrop(String location) {
        Assertions.assertThat(this.getTableFiles(location)).isEmpty();
    }

    protected abstract Set<String> getAllDataFilesFromTableDirectory(String var1);

    protected Set<String> getActiveFiles(String tableName) {
        return this.computeActual("SELECT \"$path\" FROM " + tableName).getOnlyColumnAsSet().stream().map(String.class::cast).collect(Collectors.toSet());
    }

    protected String getTableLocation(String tableName) {
        return this.findLocationInQuery("SHOW CREATE TABLE " + tableName);
    }

    protected String getSchemaLocation(String schemaName) {
        return (String)((Database)this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName))).getLocation().orElseThrow(() -> new IllegalArgumentException("Location is empty"));
    }

    private String findLocationInQuery(String query) {
        Pattern locationPattern = Pattern.compile(".*location = '(.*?)'.*", 32);
        Matcher m = locationPattern.matcher((String)this.computeActual(query).getOnlyValue());
        if (m.find()) {
            String location = m.group(1);
            Verify.verify((!m.find() ? 1 : 0) != 0, (String)"Unexpected second match", (Object[])new Object[0]);
            return location;
        }
        throw new IllegalStateException("Location not found in" + query + " result");
    }

    protected List<String> getTableFiles(String location) {
        Matcher matcher = Pattern.compile("s3://[^/]+/(.+)").matcher(location);
        Verify.verify((boolean)matcher.matches(), (String)"Does not match [%s]: [%s]", (Object)matcher.pattern(), (Object)location);
        String fileKey = matcher.group(1);
        ListObjectsV2Request req = new ListObjectsV2Request().withBucketName(this.bucketName).withPrefix(fileKey);
        return this.s3.listObjectsV2(req).getObjectSummaries().stream().map(S3ObjectSummary::getKey).map(key -> String.format("s3://%s/%s", this.bucketName, key)).toList();
    }

    protected UncheckedCloseable onClose(@Language(value="SQL") String sql) {
        Objects.requireNonNull(sql, "sql is null");
        return () -> this.assertUpdate(sql);
    }

    protected String schemaPath() {
        return "s3://%s/%s".formatted(this.bucketName, this.schemaName);
    }

    protected void verifyPathExist(String path) {
        ((S3Assert)Assertions.assertThat(S3Assert.s3Path(this.s3, path))).exists();
    }

    protected static enum LocationPattern {
        REGULAR("s3://%s/%s/regular/%s"),
        TRAILING_SLASH("s3://%s/%s/trailing_slash/%s/"),
        TWO_TRAILING_SLASHES("s3://%s/%s/two_trailing_slashes/%s//"),
        DOUBLE_SLASH("s3://%s/%s//double_slash/%s"),
        TRIPLE_SLASH("s3://%s/%s///triple_slash/%s"),
        PERCENT("s3://%s/%s/a%%percent/%s"),
        WHITESPACE("s3://%s/%s/a whitespace/%s"),
        TRAILING_WHITESPACE("s3://%s/%s/trailing_whitespace/%s ");

        private final String locationPattern;

        private LocationPattern(String locationPattern) {
            this.locationPattern = Objects.requireNonNull(locationPattern, "locationPattern is null");
        }

        public String locationForSchema(String bucketName, String schemaName) {
            return this.locationPattern.formatted(bucketName, "warehouse", schemaName);
        }

        public String locationForTable(String bucketName, String schemaName, String tableName) {
            return this.locationPattern.formatted(bucketName, schemaName, tableName);
        }
    }

    protected static interface UncheckedCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

