/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
abstract class AbstractTestHiveRoles
extends AbstractTestQueryFramework {
    private final boolean legacyCommands;

    AbstractTestHiveRoles(boolean legacyCommands) {
        this.legacyCommands = legacyCommands;
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)HiveQueryRunner.builder().addExtraProperty("deprecated.legacy-catalog-roles", String.valueOf(this.legacyCommands))).build();
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        for (String role : this.listRoles()) {
            this.executeFromAdmin(this.dropRoleSql(role));
        }
    }

    @Test
    public void testCreateRole() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of((Object)"role1", (Object)"admin"));
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of((Object)"role1", (Object)"admin"));
    }

    @Test
    public void testCreateDuplicateRole() {
        this.executeFromAdmin(this.createRoleSql("duplicate_role"));
        this.assertQueryFails(this.createAdminSession(), this.createRoleSql("duplicate_role"), ".*?Role 'duplicate_role' already exists");
    }

    @Test
    public void testCreateRoleWithAdminOption() {
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE role1 WITH ADMIN admin" + this.optionalCatalogDeclaration(), ".*?Hive Connector does not support WITH ADMIN statement");
    }

    @Test
    public void testCreateReservedRole() {
        this.assertQueryFails(this.createAdminSession(), this.createRoleSql("all"), "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
        this.assertQueryFails(this.createAdminSession(), this.createRoleSql("default"), "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
        this.assertQueryFails(this.createAdminSession(), this.createRoleSql("none"), "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
        this.assertQueryFails(this.createAdminSession(), this.createRoleSql("None"), "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
    }

    @Test
    public void testCreateRoleByNonAdminUser() {
        this.assertQueryFails(this.createUserSession("non_admin_user"), this.createRoleSql("role1"), "Access Denied: Cannot create role role1");
    }

    @Test
    public void testDropRole() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of((Object)"role1", (Object)"admin"));
        this.executeFromAdmin(this.dropRoleSql("role1"));
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of((Object)"admin"));
    }

    @Test
    public void testDropNonExistentRole() {
        this.assertQueryFails(this.createAdminSession(), this.dropRoleSql("non_existent_role"), ".*?Role 'non_existent_role' does not exist in catalog '.*'");
    }

    @Test
    public void testDropRoleByNonAdminUser() {
        this.assertQueryFails(this.createUserSession("non_admin_user"), this.dropRoleSql("role1"), "Access Denied: Cannot drop role role1");
    }

    @Test
    public void testListRolesByNonAdminUser() {
        this.assertQueryFails(this.createUserSession("non_admin_user"), "SELECT * FROM hive.information_schema.roles", "Access Denied: Cannot select from table information_schema.roles");
    }

    @Test
    public void testPublicRoleIsGrantedToAnyone() {
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("some_user"), (MaterializedResult)this.applicableRoles("some_user", "USER", "public", "NO"));
    }

    @Test
    public void testAdminRoleIsGrantedToAdmin() {
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("admin"), (MaterializedResult)this.applicableRoles("admin", "USER", "admin", "YES"));
    }

    @Test
    public void testGrantRoleToUser() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.grantRoleToUserSql("role1", "user"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO"));
    }

    @Test
    public void testGrantRoleToRole() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.createRoleSql("role2"));
        this.executeFromAdmin(this.grantRoleToUserSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToRoleSql("role2", "role1"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
    }

    @Test
    public void testGrantRoleWithAdminOption() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.createRoleSql("role2"));
        this.executeFromAdmin(this.grantRoleToUserWithAdminSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToRoleWithAdminSql("role2", "role1"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
    }

    @Test
    public void testGrantRoleMultipleTimes() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.createRoleSql("role2"));
        this.executeFromAdmin(this.grantRoleToUserSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToUserSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToRoleSql("role2", "role1"));
        this.executeFromAdmin(this.grantRoleToRoleSql("role2", "role1"));
        this.executeFromAdmin(this.grantRoleToUserWithAdminSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToUserWithAdminSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToRoleWithAdminSql("role2", "role1"));
        this.executeFromAdmin(this.grantRoleToRoleWithAdminSql("role2", "role1"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
    }

    @Test
    public void testGrantNonExistingRole() {
        this.assertQueryFails(this.grantRoleToUserSql("grant_revoke_role_existing_1", "grant_revoke_existing_user_1"), ".*?Role 'grant_revoke_role_existing_1' does not exist in catalog '.*'");
        this.executeFromAdmin(this.createRoleSql("grant_revoke_role_existing_1"));
        this.assertQueryFails(this.grantRoleToRoleSql("grant_revoke_role_existing_1", "grant_revoke_role_existing_2"), ".*?Role 'grant_revoke_role_existing_2' does not exist in catalog '.*'");
    }

    @Test
    public void testRevokeRoleFromUser() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.grantRoleToUserSql("role1", "user"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO"));
        this.executeFromAdmin(this.revokeRoleFromUserSql("role1", "user"));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeRoleFromRole() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.createRoleSql("role2"));
        this.executeFromAdmin(this.grantRoleToUserSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToRoleSql("role2", "role1"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
        this.executeFromAdmin(this.revokeRoleFromRoleSql("role2", "role1"));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO", "user", "USER", "role1", "NO"));
    }

    @Test
    public void testDropGrantedRole() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.grantRoleToUserSql("role1", "user"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO"));
        this.executeFromAdmin(this.dropRoleSql("role1"));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeTransitiveRoleFromUser() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.createRoleSql("role2"));
        this.executeFromAdmin(this.createRoleSql("role3"));
        this.executeFromAdmin(this.grantRoleToUserSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToRoleSql("role2", "role1"));
        this.executeFromAdmin(this.grantRoleToRoleSql("role3", "role2"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO", "role2", "ROLE", "role3", "NO"));
        this.executeFromAdmin(this.revokeRoleFromUserSql("role1", "user"));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeTransitiveRoleFromRole() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.createRoleSql("role2"));
        this.executeFromAdmin(this.createRoleSql("role3"));
        this.executeFromAdmin(this.grantRoleToUserSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToRoleSql("role2", "role1"));
        this.executeFromAdmin(this.grantRoleToRoleSql("role3", "role2"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO", "role2", "ROLE", "role3", "NO"));
        this.executeFromAdmin(this.revokeRoleFromRoleSql("role2", "role1"));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO", "user", "USER", "role1", "NO"));
    }

    @Test
    public void testDropTransitiveRole() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.createRoleSql("role2"));
        this.executeFromAdmin(this.createRoleSql("role3"));
        this.executeFromAdmin(this.grantRoleToUserSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToRoleSql("role2", "role1"));
        this.executeFromAdmin(this.grantRoleToRoleSql("role3", "role2"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO", "role2", "ROLE", "role3", "NO"));
        this.executeFromAdmin(this.dropRoleSql("role2"));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO", "user", "USER", "role1", "NO"));
    }

    @Test
    public void testRevokeAdminOption() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.createRoleSql("role2"));
        this.executeFromAdmin(this.grantRoleToUserWithAdminSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToRoleWithAdminSql("role2", "role1"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
        this.executeFromAdmin(this.revokeAdminOptionForRoleFromUserSql("role1", "user"));
        this.executeFromAdmin(this.revokeAdminOptionForRoleFromRoleSql("role2", "role1"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
    }

    @Test
    public void testRevokeRoleMultipleTimes() {
        this.executeFromAdmin(this.createRoleSql("role1"));
        this.executeFromAdmin(this.createRoleSql("role2"));
        this.executeFromAdmin(this.grantRoleToUserWithAdminSql("role1", "user"));
        this.executeFromAdmin(this.grantRoleToRoleWithAdminSql("role2", "role1"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
        this.executeFromAdmin(this.revokeAdminOptionForRoleFromUserSql("role1", "user"));
        this.executeFromAdmin(this.revokeAdminOptionForRoleFromUserSql("role1", "user"));
        this.executeFromAdmin(this.revokeAdminOptionForRoleFromRoleSql("role2", "role1"));
        this.executeFromAdmin(this.revokeAdminOptionForRoleFromRoleSql("role2", "role1"));
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
        this.executeFromAdmin(this.revokeRoleFromUserSql("role1", "user"));
        this.executeFromAdmin(this.revokeRoleFromUserSql("role1", "user"));
        this.executeFromAdmin(this.revokeRoleFromRoleSql("role2", "role1"));
        this.executeFromAdmin(this.revokeRoleFromRoleSql("role2", "role1"));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeNonExistingRole() {
        this.assertQueryFails(this.createAdminSession(), this.revokeRoleFromUserSql("grant_revoke_role_existing_1", "grant_revoke_existing_user_1"), ".*?Role 'grant_revoke_role_existing_1' does not exist in catalog '.*'");
        this.executeFromAdmin(this.createRoleSql("grant_revoke_role_existing_1"));
        this.assertQueryFails(this.createAdminSession(), this.revokeRoleFromRoleSql("grant_revoke_role_existing_1", "grant_revoke_role_existing_2"), ".*?Role 'grant_revoke_role_existing_2' does not exist in catalog '.*'");
    }

    @Test
    public void testSetRole() {
        this.executeFromAdmin(this.createRoleSql("set_role_1"));
        this.executeFromAdmin(this.createRoleSql("set_role_2"));
        this.executeFromAdmin(this.createRoleSql("set_role_3"));
        this.executeFromAdmin(this.createRoleSql("set_role_4"));
        this.executeFromAdmin(this.grantRoleToUserSql("set_role_1", "set_user_1"));
        this.executeFromAdmin(this.grantRoleToRoleSql("set_role_2", "set_role_1"));
        this.executeFromAdmin(this.grantRoleToRoleSql("set_role_3", "set_role_2"));
        Session unsetRole = Session.builder((Session)this.getSession()).setIdentity(Identity.ofUser((String)"set_user_1")).build();
        Session setRoleAll = Session.builder((Session)this.getSession()).setIdentity(Identity.forUser((String)"set_user_1").withConnectorRole("hive", new SelectedRole(SelectedRole.Type.ALL, Optional.empty())).build()).build();
        Session setRoleNone = Session.builder((Session)this.getSession()).setIdentity(Identity.forUser((String)"set_user_1").withConnectorRole("hive", new SelectedRole(SelectedRole.Type.NONE, Optional.empty())).build()).build();
        Session setRole1 = Session.builder((Session)this.getSession()).setIdentity(Identity.forUser((String)"set_user_1").withConnectorRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_1"))).build()).build();
        Session setRole2 = Session.builder((Session)this.getSession()).setIdentity(Identity.forUser((String)"set_user_1").withConnectorRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_2"))).build()).build();
        Session setRole3 = Session.builder((Session)this.getSession()).setIdentity(Identity.forUser((String)"set_user_1").withConnectorRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_3"))).build()).build();
        Session setRole4 = Session.builder((Session)this.getSession()).setIdentity(Identity.forUser((String)"set_user_1").withConnectorRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_4"))).build()).build();
        MaterializedResult actual = this.getQueryRunner().execute(unsetRole, "SELECT * FROM hive.information_schema.applicable_roles");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)unsetRole, (Type[])new Type[]{VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{"set_user_1", "USER", "public", "NO"}).row(new Object[]{"set_user_1", "USER", "set_role_1", "NO"}).row(new Object[]{"set_role_1", "ROLE", "set_role_2", "NO"}).row(new Object[]{"set_role_2", "ROLE", "set_role_3", "NO"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(unsetRole, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)unsetRole, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_1"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRoleAll, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRoleAll, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_1"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRoleNone, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRoleNone, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRole1, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRole1, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_1"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRole2, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRole2, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRole3, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRole3, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        this.assertQueryFails(setRole4, "SELECT * FROM hive.information_schema.enabled_roles", ".*?Cannot set role set_role_4");
        this.executeFromAdmin(this.dropRoleSql("set_role_1"));
        this.executeFromAdmin(this.dropRoleSql("set_role_2"));
        this.executeFromAdmin(this.dropRoleSql("set_role_3"));
        this.executeFromAdmin(this.dropRoleSql("set_role_4"));
    }

    private Set<String> listRoles() {
        return this.executeFromAdmin("SELECT * FROM hive.information_schema.roles").getMaterializedRows().stream().map(row -> row.getField(0).toString()).collect(Collectors.toSet());
    }

    private MaterializedResult listApplicableRoles(String user) {
        return this.executeFromUser(user, "SELECT * FROM hive.information_schema.applicable_roles");
    }

    private MaterializedResult applicableRoles(String ... values) {
        ImmutableList types = ImmutableList.of((Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType());
        int rowLength = types.size();
        Preconditions.checkArgument((values.length % rowLength == 0 ? 1 : 0) != 0);
        MaterializedResult.Builder result = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)types);
        Object[] row = null;
        for (int i = 0; i < values.length; ++i) {
            if (i % rowLength == 0) {
                if (row != null) {
                    result.row(row);
                }
                row = new Object[rowLength];
            }
            Preconditions.checkState((row != null ? 1 : 0) != 0);
            row[i % rowLength] = values[i];
        }
        if (row != null) {
            result.row(row);
        }
        return result.build();
    }

    private MaterializedResult executeFromAdmin(String sql) {
        return this.getQueryRunner().execute(this.createAdminSession(), sql);
    }

    private MaterializedResult executeFromUser(String user, String sql) {
        return this.getQueryRunner().execute(this.createUserSession(user), sql);
    }

    private Session createAdminSession() {
        return Session.builder((Session)this.getSession()).setIdentity(Identity.forUser((String)"admin").withConnectorRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
    }

    private Session createUserSession(String user) {
        return Session.builder((Session)this.getSession()).setIdentity(Identity.ofUser((String)user)).build();
    }

    private String dropRoleSql(String role) {
        return "DROP ROLE " + role + this.optionalCatalogDeclaration();
    }

    private String createRoleSql(String role) {
        return "CREATE ROLE " + role + this.optionalCatalogDeclaration();
    }

    private String grantRoleToUserSql(String role, String toUser) {
        return "GRANT " + role + " TO USER " + toUser + this.optionalCatalogDeclaration();
    }

    private String grantRoleToUserWithAdminSql(String role, String toUser) {
        return "GRANT " + role + " TO USER " + toUser + " WITH ADMIN OPTION " + this.optionalCatalogDeclaration();
    }

    private String grantRoleToRoleSql(String role, String toRole) {
        return "GRANT " + role + " TO ROLE " + toRole + this.optionalCatalogDeclaration();
    }

    private String grantRoleToRoleWithAdminSql(String role, String toRole) {
        return "GRANT " + role + " TO ROLE " + toRole + " WITH ADMIN OPTION " + this.optionalCatalogDeclaration();
    }

    private String revokeRoleFromUserSql(String role, String toUser) {
        return "REVOKE " + role + " FROM USER " + toUser + this.optionalCatalogDeclaration();
    }

    private String revokeAdminOptionForRoleFromUserSql(String role, String toUser) {
        return "REVOKE ADMIN OPTION FOR " + role + " FROM USER " + toUser + this.optionalCatalogDeclaration();
    }

    private String revokeRoleFromRoleSql(String role, String fromRole) {
        return "REVOKE " + role + " FROM ROLE " + fromRole + this.optionalCatalogDeclaration();
    }

    private String revokeAdminOptionForRoleFromRoleSql(String role, String fromRole) {
        return "REVOKE ADMIN OPTION FOR " + role + " FROM ROLE " + fromRole + this.optionalCatalogDeclaration();
    }

    private String optionalCatalogDeclaration() {
        return this.legacyCommands ? "" : " IN hive";
    }
}

