/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.hash.Hashing;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.net.HostAndPort;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.stats.CounterStat;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.HdfsNamenodeStats;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.operator.GroupByHashPageIndexerFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveEventClient;
import io.trino.plugin.hive.HiveInputInfo;
import io.trino.plugin.hive.HiveInsertTableHandle;
import io.trino.plugin.hive.HiveLocationService;
import io.trino.plugin.hive.HiveMetadataFactory;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.HiveNodePartitioningProvider;
import io.trino.plugin.hive.HiveNotReadableException;
import io.trino.plugin.hive.HiveOutputTableHandle;
import io.trino.plugin.hive.HivePageSinkProvider;
import io.trino.plugin.hive.HivePageSource;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HivePartitioningHandle;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveSplitManager;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveWriterStats;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.NoneHiveMaterializedViewMetadata;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.PartitionsSystemTableProvider;
import io.trino.plugin.hive.PropertiesSystemTableProvider;
import io.trino.plugin.hive.SortingFileWriterConfig;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.TableOfflineException;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.ViewAlreadyExistsException;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.aws.athena.PartitionProjectionService;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.fs.RemoteIterator;
import io.trino.plugin.hive.fs.TransactionScopeCachingDirectoryListerFactory;
import io.trino.plugin.hive.fs.TrinoFileStatus;
import io.trino.plugin.hive.fs.TrinoFileStatusRemoteIterator;
import io.trino.plugin.hive.line.LinePageSource;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.orc.OrcPageSource;
import io.trino.plugin.hive.parquet.ParquetPageSource;
import io.trino.plugin.hive.rcfile.RcFilePageSource;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetadata;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.Page;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.DiscretePredicates;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.connector.SortingProperty;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.Variable;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowFieldName;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingNodeManager;
import io.trino.testing.TestingPageSinkId;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.InternalTypeManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public abstract class AbstractTestHive {
    private static final Logger log = Logger.get(AbstractTestHive.class);
    protected static final String TEMPORARY_TABLE_PREFIX = "tmp_trino_test_";
    protected static final String INVALID_DATABASE = "totally_invalid_database_name";
    protected static final String INVALID_TABLE = "totally_invalid_table_name";
    protected static final String INVALID_COLUMN = "totally_invalid_column_name";
    protected static final String TEST_SERVER_VERSION = "test_version";
    private static final Type ARRAY_TYPE = HiveTestUtils.arrayType((Type)VarcharType.createUnboundedVarcharType());
    private static final Type MAP_TYPE = HiveTestUtils.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)BigintType.BIGINT);
    private static final Type ROW_TYPE = HiveTestUtils.rowType((List<NamedTypeSignature>)ImmutableList.of((Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_string")), VarcharType.createUnboundedVarcharType().getTypeSignature()), (Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_bigint")), BigintType.BIGINT.getTypeSignature()), (Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_boolean")), BooleanType.BOOLEAN.getTypeSignature())));
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS = ImmutableList.builder().add((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("t_string", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("t_tinyint", (Type)TinyintType.TINYINT)).add((Object)new ColumnMetadata("t_smallint", (Type)SmallintType.SMALLINT)).add((Object)new ColumnMetadata("t_integer", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("t_bigint", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("t_float", (Type)RealType.REAL)).add((Object)new ColumnMetadata("t_double", (Type)DoubleType.DOUBLE)).add((Object)new ColumnMetadata("t_boolean", (Type)BooleanType.BOOLEAN)).add((Object)new ColumnMetadata("t_array", ARRAY_TYPE)).add((Object)new ColumnMetadata("t_map", MAP_TYPE)).add((Object)new ColumnMetadata("t_row", ROW_TYPE)).build();
    private static final MaterializedResult CREATE_TABLE_DATA = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), TinyintType.TINYINT, SmallintType.SMALLINT, IntegerType.INTEGER, BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE, BooleanType.BOOLEAN, ARRAY_TYPE, MAP_TYPE, ROW_TYPE}).row(new Object[]{1L, "hello", (byte)45, (short)345, 234, 123L, Float.valueOf(-754.1985f), 43.5, true, ImmutableList.of((Object)"apple", (Object)"banana"), ImmutableMap.of((Object)"one", (Object)1L, (Object)"two", (Object)2L), ImmutableList.of((Object)"true", (Object)1L, (Object)true)}).row(new Object[]{2L, null, null, null, null, null, null, null, null, null, null, null}).row(new Object[]{3L, "bye", (byte)46, (short)346, 345, 456L, Float.valueOf(754.2008f), 98.1, false, ImmutableList.of((Object)"ape", (Object)"bear"), ImmutableMap.of((Object)"three", (Object)3L, (Object)"four", (Object)4L), ImmutableList.of((Object)"false", (Object)0L, (Object)false)}).build();
    protected static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("ds", (Type)VarcharType.createUnboundedVarcharType())).build();
    protected static final Set<String> COLUMN_NAMES_PARTITIONED = (Set)CREATE_TABLE_COLUMNS_PARTITIONED.stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
    protected static final Predicate<String> PARTITION_COLUMN_FILTER = columnName -> columnName.equals("ds") || columnName.startsWith("part_");
    private static final MaterializedResult CREATE_TABLE_PARTITIONED_DATA = new MaterializedResult(CREATE_TABLE_DATA.getMaterializedRows().stream().map(row -> new MaterializedRow(row.getPrecision(), (List)Lists.newArrayList((Iterable)Iterables.concat((Iterable)row.getFields(), (Iterable)ImmutableList.of((Object)("2015-07-0" + row.getField(0))))))).collect(Collectors.toList()), (List)ImmutableList.builder().addAll((Iterable)CREATE_TABLE_DATA.getTypes()).add((Object)VarcharType.createUnboundedVarcharType()).build());
    private static final String CREATE_TABLE_PARTITIONED_DATA_2ND_PARTITION_VALUE = "2015-07-04";
    private static final MaterializedResult CREATE_TABLE_PARTITIONED_DATA_2ND = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), TinyintType.TINYINT, SmallintType.SMALLINT, IntegerType.INTEGER, BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE, BooleanType.BOOLEAN, ARRAY_TYPE, MAP_TYPE, ROW_TYPE, VarcharType.createUnboundedVarcharType()}).row(new Object[]{4L, "hello", (byte)45, (short)345, 234, 123L, Float.valueOf(754.1985f), 43.5, true, ImmutableList.of((Object)"apple", (Object)"banana"), ImmutableMap.of((Object)"one", (Object)1L, (Object)"two", (Object)2L), ImmutableList.of((Object)"true", (Object)1L, (Object)true), "2015-07-04"}).row(new Object[]{5L, null, null, null, null, null, null, null, null, null, null, null, "2015-07-04"}).row(new Object[]{6L, "bye", (byte)46, (short)346, 345, 456L, Float.valueOf(-754.2008f), 98.1, false, ImmutableList.of((Object)"ape", (Object)"bear"), ImmutableMap.of((Object)"three", (Object)3L, (Object)"four", (Object)4L), ImmutableList.of((Object)"false", (Object)0L, (Object)false), "2015-07-04"}).build();
    private static final List<ColumnMetadata> MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE = ImmutableList.builder().add((Object)new ColumnMetadata("tinyint_to_smallint", (Type)TinyintType.TINYINT)).add((Object)new ColumnMetadata("tinyint_to_integer", (Type)TinyintType.TINYINT)).add((Object)new ColumnMetadata("tinyint_to_bigint", (Type)TinyintType.TINYINT)).add((Object)new ColumnMetadata("smallint_to_integer", (Type)SmallintType.SMALLINT)).add((Object)new ColumnMetadata("smallint_to_bigint", (Type)SmallintType.SMALLINT)).add((Object)new ColumnMetadata("integer_to_bigint", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("integer_to_varchar", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("varchar_to_integer", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("float_to_double", (Type)RealType.REAL)).add((Object)new ColumnMetadata("varchar_to_drop_in_row", (Type)VarcharType.createUnboundedVarcharType())).build();
    private static final List<ColumnMetadata> MISMATCH_SCHEMA_TABLE_BEFORE = ImmutableList.builder().addAll(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE).add((Object)new ColumnMetadata("struct_to_struct", (Type)AbstractTestHive.toRowType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE))).add((Object)new ColumnMetadata("list_to_list", (Type)HiveTestUtils.arrayType((Type)AbstractTestHive.toRowType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE)))).add((Object)new ColumnMetadata("map_to_map", (Type)HiveTestUtils.mapType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE.get(1).getType(), (Type)AbstractTestHive.toRowType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE)))).add((Object)new ColumnMetadata("ds", (Type)VarcharType.createUnboundedVarcharType())).build();
    private static final MaterializedResult MISMATCH_SCHEMA_PRIMITIVE_FIELDS_DATA_BEFORE = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{TinyintType.TINYINT, TinyintType.TINYINT, TinyintType.TINYINT, SmallintType.SMALLINT, SmallintType.SMALLINT, IntegerType.INTEGER, IntegerType.INTEGER, VarcharType.createUnboundedVarcharType(), RealType.REAL, VarcharType.createUnboundedVarcharType()}).row(new Object[]{(byte)-11, (byte)12, (byte)-13, (short)14, (short)15, -16, 17, "2147483647", Float.valueOf(18.0f), "2016-08-01"}).row(new Object[]{(byte)21, (byte)-22, (byte)23, (short)-24, (short)25, 26, -27, "asdf", Float.valueOf(-28.0f), "2016-08-02"}).row(new Object[]{(byte)-31, (byte)-32, (byte)33, (short)34, (short)-35, 36, 37, "-923", Float.valueOf(39.5f), "2016-08-03"}).row(new Object[]{null, (byte)42, (byte)43, (short)44, (short)-45, 46, 47, "2147483648", Float.valueOf(49.5f), "2016-08-03"}).build();
    private static final MaterializedResult MISMATCH_SCHEMA_TABLE_DATA_BEFORE = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)((Iterable)MISMATCH_SCHEMA_TABLE_BEFORE.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList()))).rows((List)MISMATCH_SCHEMA_PRIMITIVE_FIELDS_DATA_BEFORE.getMaterializedRows().stream().map(materializedRow -> {
        List result = materializedRow.getFields();
        List rowResult = materializedRow.getFields();
        result.add(rowResult);
        result.add(Arrays.asList(rowResult, null, rowResult));
        result.add(ImmutableMap.of(rowResult.get(1), (Object)rowResult));
        result.add(rowResult.get(9));
        return new MaterializedRow(materializedRow.getPrecision(), result);
    }).collect(ImmutableList.toImmutableList())).build();
    private static final List<ColumnMetadata> MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER = ImmutableList.builder().add((Object)new ColumnMetadata("tinyint_to_smallint", (Type)SmallintType.SMALLINT)).add((Object)new ColumnMetadata("tinyint_to_integer", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("tinyint_to_bigint", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("smallint_to_integer", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("smallint_to_bigint", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("integer_to_bigint", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("integer_to_varchar", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("varchar_to_integer", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("float_to_double", (Type)DoubleType.DOUBLE)).add((Object)new ColumnMetadata("varchar_to_drop_in_row", (Type)VarcharType.createUnboundedVarcharType())).build();
    private static final Type MISMATCH_SCHEMA_ROW_TYPE_APPEND = AbstractTestHive.toRowType((List<ColumnMetadata>)ImmutableList.builder().addAll(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER).add((Object)new ColumnMetadata(String.format("%s_append", MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER.get(0).getName()), MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER.get(0).getType())).build());
    private static final Type MISMATCH_SCHEMA_ROW_TYPE_DROP = AbstractTestHive.toRowType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER.subList(0, MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER.size() - 1));
    private static final List<ColumnMetadata> MISMATCH_SCHEMA_TABLE_AFTER = ImmutableList.builder().addAll(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER).add((Object)new ColumnMetadata("struct_to_struct", MISMATCH_SCHEMA_ROW_TYPE_APPEND)).add((Object)new ColumnMetadata("list_to_list", (Type)HiveTestUtils.arrayType(MISMATCH_SCHEMA_ROW_TYPE_APPEND))).add((Object)new ColumnMetadata("map_to_map", (Type)HiveTestUtils.mapType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER.get(1).getType(), MISMATCH_SCHEMA_ROW_TYPE_DROP))).add((Object)new ColumnMetadata("ds", (Type)VarcharType.createUnboundedVarcharType())).build();
    private static final MaterializedResult MISMATCH_SCHEMA_PRIMITIVE_FIELDS_DATA_AFTER = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{SmallintType.SMALLINT, IntegerType.INTEGER, BigintType.BIGINT, IntegerType.INTEGER, BigintType.BIGINT, BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), IntegerType.INTEGER, DoubleType.DOUBLE, VarcharType.createUnboundedVarcharType()}).row(new Object[]{(short)-11, 12, -13L, 14, 15L, -16L, "17", Integer.MAX_VALUE, 18.0, "2016-08-01"}).row(new Object[]{(short)21, -22, 23L, -24, 25L, 26L, "-27", null, -28.0, "2016-08-02"}).row(new Object[]{(short)-31, -32, 33L, 34, -35L, 36L, "37", -923, 39.5, "2016-08-03"}).row(new Object[]{null, 42, 43L, 44, -45L, 46L, "47", null, 49.5, "2016-08-03"}).build();
    private static final MaterializedResult MISMATCH_SCHEMA_TABLE_DATA_AFTER = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)((Iterable)MISMATCH_SCHEMA_TABLE_AFTER.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList()))).rows((List)MISMATCH_SCHEMA_PRIMITIVE_FIELDS_DATA_AFTER.getMaterializedRows().stream().map(materializedRow -> {
        List result = materializedRow.getFields();
        List appendFieldRowResult = materializedRow.getFields();
        appendFieldRowResult.add(null);
        List dropFieldRowResult = materializedRow.getFields().subList(0, materializedRow.getFields().size() - 1);
        result.add(appendFieldRowResult);
        result.add(Arrays.asList(appendFieldRowResult, null, appendFieldRowResult));
        result.add(ImmutableMap.of(result.get(1), dropFieldRowResult));
        result.add(result.get(9));
        return new MaterializedRow(materializedRow.getPrecision(), result);
    }).collect(ImmutableList.toImmutableList())).build();
    protected Set<HiveStorageFormat> createTableFormats = Sets.difference((Set)ImmutableSet.copyOf((Object[])HiveStorageFormat.values()), (Set)ImmutableSet.of((Object)HiveStorageFormat.AVRO, (Object)HiveStorageFormat.CSV, (Object)HiveStorageFormat.REGEX));
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();
    private static final JoinCompiler JOIN_COMPILER = new JoinCompiler(TYPE_OPERATORS);
    protected static final List<ColumnMetadata> STATISTICS_TABLE_COLUMNS = ImmutableList.builder().add((Object)new ColumnMetadata("t_boolean", (Type)BooleanType.BOOLEAN)).add((Object)new ColumnMetadata("t_bigint", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("t_integer", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("t_smallint", (Type)SmallintType.SMALLINT)).add((Object)new ColumnMetadata("t_tinyint", (Type)TinyintType.TINYINT)).add((Object)new ColumnMetadata("t_double", (Type)DoubleType.DOUBLE)).add((Object)new ColumnMetadata("t_float", (Type)RealType.REAL)).add((Object)new ColumnMetadata("t_string", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("t_varchar", (Type)VarcharType.createVarcharType((int)100))).add((Object)new ColumnMetadata("t_char", (Type)CharType.createCharType((int)5))).add((Object)new ColumnMetadata("t_varbinary", (Type)VarbinaryType.VARBINARY)).add((Object)new ColumnMetadata("t_date", (Type)DateType.DATE)).add((Object)new ColumnMetadata("t_timestamp", (Type)TimestampType.TIMESTAMP_MILLIS)).add((Object)new ColumnMetadata("t_short_decimal", (Type)DecimalType.createDecimalType((int)5, (int)2))).add((Object)new ColumnMetadata("t_long_decimal", (Type)DecimalType.createDecimalType((int)20, (int)3))).build();
    protected static final List<ColumnMetadata> STATISTICS_PARTITIONED_TABLE_COLUMNS = ImmutableList.builder().addAll(STATISTICS_TABLE_COLUMNS).add((Object)new ColumnMetadata("ds", (Type)VarcharType.VARCHAR)).build();
    protected static final PartitionStatistics ZERO_TABLE_STATISTICS = new PartitionStatistics(HiveBasicStatistics.createZeroStatistics(), (Map)ImmutableMap.of());
    protected static final PartitionStatistics EMPTY_ROWCOUNT_STATISTICS = ZERO_TABLE_STATISTICS.withBasicStatistics(ZERO_TABLE_STATISTICS.getBasicStatistics().withEmptyRowCount());
    protected static final PartitionStatistics BASIC_STATISTICS_1 = new PartitionStatistics(new HiveBasicStatistics(0L, 20L, 3L, 0L), (Map)ImmutableMap.of());
    protected static final PartitionStatistics BASIC_STATISTICS_2 = new PartitionStatistics(new HiveBasicStatistics(0L, 30L, 2L, 0L), (Map)ImmutableMap.of());
    protected static final PartitionStatistics STATISTICS_1 = new PartitionStatistics(BASIC_STATISTICS_1.getBasicStatistics(), (Map)ImmutableMap.builder().put((Object)"t_boolean", (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(5L), (OptionalLong)OptionalLong.of(6L), (OptionalLong)OptionalLong.of(3L))).put((Object)"t_bigint", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(1234L), (OptionalLong)OptionalLong.of(5678L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(5L))).put((Object)"t_integer", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(123L), (OptionalLong)OptionalLong.of(567L), (OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(4L))).put((Object)"t_smallint", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(12L), (OptionalLong)OptionalLong.of(56L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(6L))).put((Object)"t_tinyint", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(3L))).put((Object)"t_double", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(1234.25), (OptionalDouble)OptionalDouble.of(5678.58), (OptionalLong)OptionalLong.of(7L), (OptionalLong)OptionalLong.of(8L))).put((Object)"t_float", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(123.25), (OptionalDouble)OptionalDouble.of(567.58), (OptionalLong)OptionalLong.of(9L), (OptionalLong)OptionalLong.of(10L))).put((Object)"t_string", (Object)HiveColumnStatistics.createStringColumnStatistics((OptionalLong)OptionalLong.of(10L), (OptionalLong)OptionalLong.of(50L), (OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(7L))).put((Object)"t_varchar", (Object)HiveColumnStatistics.createStringColumnStatistics((OptionalLong)OptionalLong.of(100L), (OptionalLong)OptionalLong.of(230L), (OptionalLong)OptionalLong.of(5L), (OptionalLong)OptionalLong.of(3L))).put((Object)"t_char", (Object)HiveColumnStatistics.createStringColumnStatistics((OptionalLong)OptionalLong.of(5L), (OptionalLong)OptionalLong.of(50L), (OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(4L))).put((Object)"t_varbinary", (Object)HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(4L), (OptionalLong)OptionalLong.of(50L), (OptionalLong)OptionalLong.of(1L))).put((Object)"t_date", (Object)HiveColumnStatistics.createDateColumnStatistics(Optional.of(LocalDate.ofEpochDay(1L)), Optional.of(LocalDate.ofEpochDay(2L)), (OptionalLong)OptionalLong.of(7L), (OptionalLong)OptionalLong.of(6L))).put((Object)"t_timestamp", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(1234567L), (OptionalLong)OptionalLong.of(71234567L), (OptionalLong)OptionalLong.of(7L), (OptionalLong)OptionalLong.of(5L))).put((Object)"t_short_decimal", (Object)HiveColumnStatistics.createDecimalColumnStatistics(Optional.of(new BigDecimal(10)), Optional.of(new BigDecimal(12)), (OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(5L))).put((Object)"t_long_decimal", (Object)HiveColumnStatistics.createDecimalColumnStatistics(Optional.of(new BigDecimal("12345678901234567.123")), Optional.of(new BigDecimal("81234567890123456.123")), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(1L))).buildOrThrow());
    protected static final PartitionStatistics STATISTICS_1_1 = new PartitionStatistics(new HiveBasicStatistics(OptionalLong.of(0L), OptionalLong.of(15L), OptionalLong.empty(), OptionalLong.of(0L)), (Map)STATISTICS_1.getColumnStatistics().entrySet().stream().filter(entry -> ((String)entry.getKey()).hashCode() % 2 == 0).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
    protected static final PartitionStatistics STATISTICS_1_2 = new PartitionStatistics(new HiveBasicStatistics(OptionalLong.of(0L), OptionalLong.of(15L), OptionalLong.of(3L), OptionalLong.of(0L)), (Map)STATISTICS_1.getColumnStatistics().entrySet().stream().filter(entry -> ((String)entry.getKey()).hashCode() % 2 == 1).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
    protected static final PartitionStatistics STATISTICS_2 = new PartitionStatistics(BASIC_STATISTICS_2.getBasicStatistics(), (Map)ImmutableMap.builder().put((Object)"t_boolean", (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(4L), (OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(2L))).put((Object)"t_bigint", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(2345L), (OptionalLong)OptionalLong.of(6789L), (OptionalLong)OptionalLong.of(4L), (OptionalLong)OptionalLong.of(7L))).put((Object)"t_integer", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(234L), (OptionalLong)OptionalLong.of(678L), (OptionalLong)OptionalLong.of(5L), (OptionalLong)OptionalLong.of(6L))).put((Object)"t_smallint", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(23L), (OptionalLong)OptionalLong.of(65L), (OptionalLong)OptionalLong.of(7L), (OptionalLong)OptionalLong.of(5L))).put((Object)"t_tinyint", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(12L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L))).put((Object)"t_double", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(2345.25), (OptionalDouble)OptionalDouble.of(6785.58), (OptionalLong)OptionalLong.of(6L), (OptionalLong)OptionalLong.of(3L))).put((Object)"t_float", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(235.25), (OptionalDouble)OptionalDouble.of(676.58), (OptionalLong)OptionalLong.of(7L), (OptionalLong)OptionalLong.of(11L))).put((Object)"t_string", (Object)HiveColumnStatistics.createStringColumnStatistics((OptionalLong)OptionalLong.of(301L), (OptionalLong)OptionalLong.of(600L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(6L))).put((Object)"t_varchar", (Object)HiveColumnStatistics.createStringColumnStatistics((OptionalLong)OptionalLong.of(99L), (OptionalLong)OptionalLong.of(223L), (OptionalLong)OptionalLong.of(7L), (OptionalLong)OptionalLong.of(1L))).put((Object)"t_char", (Object)HiveColumnStatistics.createStringColumnStatistics((OptionalLong)OptionalLong.of(6L), (OptionalLong)OptionalLong.of(60L), (OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(3L))).put((Object)"t_varbinary", (Object)HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(10L), (OptionalLong)OptionalLong.of(2L))).put((Object)"t_date", (Object)HiveColumnStatistics.createDateColumnStatistics(Optional.of(LocalDate.ofEpochDay(2L)), Optional.of(LocalDate.ofEpochDay(3L)), (OptionalLong)OptionalLong.of(8L), (OptionalLong)OptionalLong.of(7L))).put((Object)"t_timestamp", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(2345671L), (OptionalLong)OptionalLong.of(12345677L), (OptionalLong)OptionalLong.of(9L), (OptionalLong)OptionalLong.of(1L))).put((Object)"t_short_decimal", (Object)HiveColumnStatistics.createDecimalColumnStatistics(Optional.of(new BigDecimal(11)), Optional.of(new BigDecimal(14)), (OptionalLong)OptionalLong.of(5L), (OptionalLong)OptionalLong.of(7L))).put((Object)"t_long_decimal", (Object)HiveColumnStatistics.createDecimalColumnStatistics(Optional.of(new BigDecimal("71234567890123456.123")), Optional.of(new BigDecimal("78123456789012345.123")), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(1L))).buildOrThrow());
    protected static final PartitionStatistics STATISTICS_EMPTY_OPTIONAL_FIELDS = new PartitionStatistics(new HiveBasicStatistics(OptionalLong.of(0L), OptionalLong.of(20L), OptionalLong.empty(), OptionalLong.of(0L)), (Map)ImmutableMap.builder().put((Object)"t_boolean", (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(4L), (OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(2L))).put((Object)"t_bigint", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(4L), (OptionalLong)OptionalLong.of(7L))).put((Object)"t_integer", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(5L), (OptionalLong)OptionalLong.of(6L))).put((Object)"t_smallint", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(7L), (OptionalLong)OptionalLong.of(5L))).put((Object)"t_tinyint", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L))).put((Object)"t_double", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.empty(), (OptionalDouble)OptionalDouble.empty(), (OptionalLong)OptionalLong.of(6L), (OptionalLong)OptionalLong.of(3L))).put((Object)"t_float", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.empty(), (OptionalDouble)OptionalDouble.empty(), (OptionalLong)OptionalLong.of(7L), (OptionalLong)OptionalLong.of(11L))).put((Object)"t_string", (Object)HiveColumnStatistics.createStringColumnStatistics((OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(6L))).put((Object)"t_varchar", (Object)HiveColumnStatistics.createStringColumnStatistics((OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(7L), (OptionalLong)OptionalLong.of(1L))).put((Object)"t_char", (Object)HiveColumnStatistics.createStringColumnStatistics((OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(3L))).put((Object)"t_varbinary", (Object)HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(2L))).put((Object)"t_timestamp", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(9L), (OptionalLong)OptionalLong.of(1L))).put((Object)"t_short_decimal", (Object)HiveColumnStatistics.createDecimalColumnStatistics(Optional.empty(), Optional.empty(), (OptionalLong)OptionalLong.of(5L), (OptionalLong)OptionalLong.of(7L))).put((Object)"t_long_decimal", (Object)HiveColumnStatistics.createDecimalColumnStatistics(Optional.empty(), Optional.empty(), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(1L))).buildOrThrow());
    protected String database;
    protected SchemaTableName tablePartitionFormat;
    protected SchemaTableName tableUnpartitioned;
    protected SchemaTableName tablePartitionedWithNull;
    protected SchemaTableName tableOffline;
    protected SchemaTableName tableNotReadable;
    protected SchemaTableName view;
    protected SchemaTableName invalidTable;
    protected SchemaTableName tableBucketedStringInt;
    protected SchemaTableName tableBucketedBigintBoolean;
    protected SchemaTableName tableBucketedDoubleFloat;
    protected SchemaTableName tablePartitionSchemaChange;
    protected SchemaTableName tablePartitionSchemaChangeNonCanonical;
    protected SchemaTableName tableBucketEvolution;
    protected ConnectorTableHandle invalidTableHandle;
    protected ColumnHandle dsColumn;
    protected ColumnHandle fileFormatColumn;
    protected ColumnHandle dummyColumn;
    protected ColumnHandle intColumn;
    protected ColumnHandle invalidColumnHandle;
    protected ColumnHandle pStringColumn;
    protected ColumnHandle pIntegerColumn;
    protected ConnectorTableProperties tablePartitionFormatProperties;
    protected ConnectorTableProperties tableUnpartitionedProperties;
    protected List<HivePartition> tablePartitionFormatPartitions;
    protected List<HivePartition> tableUnpartitionedPartitions;
    protected HdfsEnvironment hdfsEnvironment;
    protected LocationService locationService;
    protected CountingDirectoryLister countingDirectoryLister;
    protected HiveMetadataFactory metadataFactory;
    protected HiveTransactionManager transactionManager;
    protected HiveMetastore metastoreClient;
    protected ConnectorSplitManager splitManager;
    protected ConnectorPageSourceProvider pageSourceProvider;
    protected ConnectorPageSinkProvider pageSinkProvider;
    protected ConnectorNodePartitioningProvider nodePartitioningProvider;
    protected ExecutorService executor;
    private ScheduledExecutorService heartbeatService;
    private Path temporaryStagingDirectory;
    protected final Set<SchemaTableName> materializedViews = Sets.newConcurrentHashSet();

    private static RowType toRowType(List<ColumnMetadata> columns) {
        return HiveTestUtils.rowType((List)columns.stream().map(col -> new NamedTypeSignature(Optional.of(new RowFieldName(String.format("f_%s", col.getName()))), col.getType().getTypeSignature())).collect(ImmutableList.toImmutableList()));
    }

    @BeforeClass(alwaysRun=true)
    public void setupClass() throws Exception {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-%s"));
        this.heartbeatService = Executors.newScheduledThreadPool(1);
        this.temporaryStagingDirectory = Files.createTempDirectory("trino-staging-", new FileAttribute[0]);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        if (this.heartbeatService != null) {
            this.heartbeatService.shutdownNow();
            this.heartbeatService = null;
        }
        if (this.temporaryStagingDirectory != null) {
            try {
                MoreFiles.deleteRecursively((Path)this.temporaryStagingDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Error deleting %s", new Object[]{this.temporaryStagingDirectory});
            }
        }
    }

    protected void setupHive(String databaseName) {
        this.database = databaseName;
        this.tablePartitionFormat = new SchemaTableName(this.database, "trino_test_partition_format");
        this.tableUnpartitioned = new SchemaTableName(this.database, "trino_test_unpartitioned");
        this.tablePartitionedWithNull = new SchemaTableName(this.database, "trino_test_partitioned_with_null");
        this.tableOffline = new SchemaTableName(this.database, "trino_test_offline");
        this.tableNotReadable = new SchemaTableName(this.database, "trino_test_not_readable");
        this.view = new SchemaTableName(this.database, "trino_test_view");
        this.invalidTable = new SchemaTableName(this.database, INVALID_TABLE);
        this.tableBucketedStringInt = new SchemaTableName(this.database, "trino_test_bucketed_by_string_int");
        this.tableBucketedBigintBoolean = new SchemaTableName(this.database, "trino_test_bucketed_by_bigint_boolean");
        this.tableBucketedDoubleFloat = new SchemaTableName(this.database, "trino_test_bucketed_by_double_float");
        this.tablePartitionSchemaChange = new SchemaTableName(this.database, "trino_test_partition_schema_change");
        this.tablePartitionSchemaChangeNonCanonical = new SchemaTableName(this.database, "trino_test_partition_schema_change_non_canonical");
        this.tableBucketEvolution = new SchemaTableName(this.database, "trino_test_bucket_evolution");
        this.invalidTableHandle = new HiveTableHandle(this.database, INVALID_TABLE, (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        this.dsColumn = HiveColumnHandle.createBaseColumn((String)"ds", (int)-1, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        this.fileFormatColumn = HiveColumnHandle.createBaseColumn((String)"file_format", (int)-1, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        this.dummyColumn = HiveColumnHandle.createBaseColumn((String)"dummy", (int)-1, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        this.intColumn = HiveColumnHandle.createBaseColumn((String)"t_int", (int)-1, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        this.invalidColumnHandle = HiveColumnHandle.createBaseColumn((String)INVALID_COLUMN, (int)0, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        this.pStringColumn = HiveColumnHandle.createBaseColumn((String)"p_string", (int)-1, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        this.pIntegerColumn = HiveColumnHandle.createBaseColumn((String)"p_integer", (int)-1, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)this.dsColumn, (Object)this.fileFormatColumn, (Object)this.dummyColumn);
        this.tablePartitionFormatPartitions = ImmutableList.builder().add((Object)new HivePartition(this.tablePartitionFormat, "ds=2012-12-29/file_format=textfile/dummy=1", (Map)ImmutableMap.builder().put((Object)this.dsColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29"))).put((Object)this.fileFormatColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"textfile"))).put((Object)this.dummyColumn, (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)1L)).buildOrThrow())).add((Object)new HivePartition(this.tablePartitionFormat, "ds=2012-12-29/file_format=sequencefile/dummy=2", (Map)ImmutableMap.builder().put((Object)this.dsColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29"))).put((Object)this.fileFormatColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"sequencefile"))).put((Object)this.dummyColumn, (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)2L)).buildOrThrow())).add((Object)new HivePartition(this.tablePartitionFormat, "ds=2012-12-29/file_format=rctext/dummy=3", (Map)ImmutableMap.builder().put((Object)this.dsColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29"))).put((Object)this.fileFormatColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rctext"))).put((Object)this.dummyColumn, (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)3L)).buildOrThrow())).add((Object)new HivePartition(this.tablePartitionFormat, "ds=2012-12-29/file_format=rcbinary/dummy=4", (Map)ImmutableMap.builder().put((Object)this.dsColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29"))).put((Object)this.fileFormatColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rcbinary"))).put((Object)this.dummyColumn, (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)4L)).buildOrThrow())).build();
        this.tableUnpartitionedPartitions = ImmutableList.of((Object)new HivePartition(this.tableUnpartitioned));
        this.tablePartitionFormatProperties = new ConnectorTableProperties(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.dsColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29")), (Range[])new Range[0]), (boolean)false), (Object)this.fileFormatColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"textfile")), (Range[])new Range[]{Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"sequencefile")), Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rctext")), Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rcbinary"))}), (boolean)false), (Object)this.dummyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)1L), (Range[])new Range[]{Range.equal((Type)IntegerType.INTEGER, (Object)2L), Range.equal((Type)IntegerType.INTEGER, (Object)3L), Range.equal((Type)IntegerType.INTEGER, (Object)4L)}), (boolean)false))), Optional.empty(), Optional.of(new DiscretePredicates((List)partitionColumns, (Iterable)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.dsColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29")), (Range[])new Range[0]), (boolean)false), (Object)this.fileFormatColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"textfile")), (Range[])new Range[0]), (boolean)false), (Object)this.dummyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)1L), (Range[])new Range[0]), (boolean)false))), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.dsColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29")), (Range[])new Range[0]), (boolean)false), (Object)this.fileFormatColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"sequencefile")), (Range[])new Range[0]), (boolean)false), (Object)this.dummyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.dsColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29")), (Range[])new Range[0]), (boolean)false), (Object)this.fileFormatColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rctext")), (Range[])new Range[0]), (boolean)false), (Object)this.dummyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)3L), (Range[])new Range[0]), (boolean)false))), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.dsColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29")), (Range[])new Range[0]), (boolean)false), (Object)this.fileFormatColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rcbinary")), (Range[])new Range[0]), (boolean)false), (Object)this.dummyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)4L), (Range[])new Range[0]), (boolean)false)))))), (List)ImmutableList.of());
        this.tableUnpartitionedProperties = new ConnectorTableProperties();
    }

    protected final void setup(HostAndPort metastoreAddress, String databaseName) {
        HiveConfig hiveConfig = this.getHiveConfig().setParquetTimeZone("UTC").setRcfileTimeZone("UTC");
        this.hdfsEnvironment = HiveTestUtils.HDFS_ENVIRONMENT;
        CachingHiveMetastore metastore = CachingHiveMetastore.builder().delegate((HiveMetastore)new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(metastoreAddress).hiveConfig(hiveConfig).thriftMetastoreConfig(new ThriftMetastoreConfig().setAssumeCanonicalPartitionKeys(true)).hdfsEnvironment(this.hdfsEnvironment).build())).executor((Executor)this.executor).metadataCacheEnabled(true).statsCacheEnabled(true).cacheTtl(new Duration(1.0, TimeUnit.MINUTES)).refreshInterval(new Duration(15.0, TimeUnit.SECONDS)).maximumSize(10000L).cacheMissing(new CachingHiveMetastoreConfig().isCacheMissing()).partitionCacheEnabled(new CachingHiveMetastoreConfig().isPartitionCacheEnabled()).build();
        this.setup(databaseName, hiveConfig, (HiveMetastore)metastore, this.hdfsEnvironment);
    }

    protected final void setup(String databaseName, HiveConfig hiveConfig, HiveMetastore hiveMetastore, HdfsEnvironment hdfsConfiguration) {
        this.setupHive(databaseName);
        this.metastoreClient = hiveMetastore;
        this.hdfsEnvironment = hdfsConfiguration;
        HivePartitionManager partitionManager = new HivePartitionManager(hiveConfig);
        this.locationService = new HiveLocationService(this.hdfsEnvironment, hiveConfig);
        JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
        this.countingDirectoryLister = new CountingDirectoryLister();
        this.metadataFactory = new HiveMetadataFactory(new CatalogName("hive"), HiveMetastoreFactory.ofInstance((HiveMetastore)this.metastoreClient), HiveTestUtils.getDefaultHiveFileWriterFactories(hiveConfig, this.hdfsEnvironment), (TrinoFileSystemFactory)new HdfsFileSystemFactory(this.hdfsEnvironment, HiveTestUtils.HDFS_FILE_SYSTEM_STATS), this.hdfsEnvironment, partitionManager, 10, 10, 10, 100000L, false, false, false, true, true, false, false, 1000L, Optional.empty(), true, InternalTypeManager.TESTING_TYPE_MANAGER, MetadataProvider.NOOP_METADATA_PROVIDER, this.locationService, partitionUpdateCodec, this.executor, this.heartbeatService, TEST_SERVER_VERSION, (session, tableHandle) -> {
            if (!tableHandle.getTableName().contains("apply_redirection_tester")) {
                return Optional.empty();
            }
            return Optional.of(new TableScanRedirectApplicationResult(new CatalogSchemaTableName("hive", databaseName, "mock_redirection_target"), (Map)ImmutableMap.of(), TupleDomain.all()));
        }, (Set)ImmutableSet.of((Object)new PartitionsSystemTableProvider(partitionManager, InternalTypeManager.TESTING_TYPE_MANAGER), (Object)new PropertiesSystemTableProvider()), metastore -> new NoneHiveMaterializedViewMetadata(){

            public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
                return (List)AbstractTestHive.this.materializedViews.stream().filter(schemaName.map(name -> mvName -> mvName.getSchemaName().equals(name)).orElse(mvName -> true)).collect(ImmutableList.toImmutableList());
            }

            public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
                if (!viewName.getTableName().contains("materialized_view_tester")) {
                    return Optional.empty();
                }
                return Optional.of(new ConnectorMaterializedViewDefinition("dummy_view_sql", Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("abc", TypeId.of((String)"type"))), Optional.empty(), Optional.of("alice"), (Map)ImmutableMap.of()));
            }
        }, SqlStandardAccessControlMetadata::new, (DirectoryLister)this.countingDirectoryLister, new TransactionScopeCachingDirectoryListerFactory(hiveConfig), new PartitionProjectionService(hiveConfig, (Map)ImmutableMap.of(), (TypeManager)new TestingTypeManager()), true, HiveTimestampPrecision.DEFAULT_PRECISION);
        this.transactionManager = new HiveTransactionManager((TransactionalMetadataFactory)this.metadataFactory);
        this.splitManager = new HiveSplitManager(this.transactionManager, partitionManager, (TrinoFileSystemFactory)new HdfsFileSystemFactory(this.hdfsEnvironment, HiveTestUtils.HDFS_FILE_SYSTEM_STATS), new HdfsNamenodeStats(), (Executor)this.executor, new CounterStat(), 100, hiveConfig.getMaxOutstandingSplitsSize(), hiveConfig.getMinPartitionBatchSize(), hiveConfig.getMaxPartitionBatchSize(), hiveConfig.getMaxInitialSplits(), hiveConfig.getSplitLoaderConcurrency(), hiveConfig.getMaxSplitsPerSecond(), false, InternalTypeManager.TESTING_TYPE_MANAGER, hiveConfig.getMaxPartitionsPerScan());
        this.pageSinkProvider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(hiveConfig, this.hdfsEnvironment), (TrinoFileSystemFactory)new HdfsFileSystemFactory(this.hdfsEnvironment, HiveTestUtils.HDFS_FILE_SYSTEM_STATS), HiveTestUtils.PAGE_SORTER, HiveMetastoreFactory.ofInstance((HiveMetastore)this.metastoreClient), (PageIndexerFactory)new GroupByHashPageIndexerFactory(JOIN_COMPILER, TYPE_OPERATORS), InternalTypeManager.TESTING_TYPE_MANAGER, this.getHiveConfig(), this.getSortingFileWriterConfig(), this.locationService, partitionUpdateCodec, (NodeManager)new TestingNodeManager("fake-environment"), (EventClient)new HiveEventClient(), HiveTestUtils.getHiveSessionProperties(hiveConfig), new HiveWriterStats());
        this.pageSourceProvider = new HivePageSourceProvider(InternalTypeManager.TESTING_TYPE_MANAGER, hiveConfig, HiveTestUtils.getDefaultHivePageSourceFactories(this.hdfsEnvironment, hiveConfig));
        this.nodePartitioningProvider = new HiveNodePartitioningProvider((NodeManager)new TestingNodeManager("fake-environment"), InternalTypeManager.TESTING_TYPE_MANAGER);
    }

    protected HiveConfig getHiveConfig() {
        return new HiveConfig().setTemporaryStagingDirectoryPath(this.temporaryStagingDirectory.resolve("temp_path_").toAbsolutePath().toString());
    }

    protected SortingFileWriterConfig getSortingFileWriterConfig() {
        return new SortingFileWriterConfig().setMaxOpenSortFiles(10).setWriterSortBufferSize(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
    }

    protected ConnectorSession newSession() {
        return this.newSession((Map<String, Object>)ImmutableMap.of());
    }

    protected ConnectorSession newSession(Map<String, Object> propertyValues) {
        return TestingConnectorSession.builder().setPropertyMetadata(HiveTestUtils.getHiveSessionProperties(this.getHiveConfig()).getSessionProperties()).setPropertyValues(propertyValues).build();
    }

    protected Transaction newTransaction() {
        return new HiveTransaction(this.transactionManager);
    }

    @Test
    public void testGetDatabaseNames() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            List databases = metadata.listSchemaNames(this.newSession());
            Assert.assertTrue((boolean)databases.contains(this.database));
        }
    }

    @Test
    public void testGetTableNames() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            List tables = metadata.listTables(this.newSession(), Optional.of(this.database));
            Assert.assertTrue((boolean)tables.contains(this.tablePartitionFormat));
            Assert.assertTrue((boolean)tables.contains(this.tableUnpartitioned));
        }
    }

    @Test
    public void testGetAllTableNames() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            List tables = metadata.listTables(this.newSession(), Optional.empty());
            Assert.assertTrue((boolean)tables.contains(this.tablePartitionFormat));
            Assert.assertTrue((boolean)tables.contains(this.tableUnpartitioned));
        }
    }

    @Test
    public void testGetAllTableColumns() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            Map<SchemaTableName, List<ColumnMetadata>> allColumns = AbstractTestHive.listTableColumns(metadata, this.newSession(), new SchemaTablePrefix());
            Assert.assertTrue((boolean)allColumns.containsKey(this.tablePartitionFormat));
            Assert.assertTrue((boolean)allColumns.containsKey(this.tableUnpartitioned));
        }
    }

    @Test
    public void testGetAllTableColumnsInSchema() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            Map<SchemaTableName, List<ColumnMetadata>> allColumns = AbstractTestHive.listTableColumns(metadata, this.newSession(), new SchemaTablePrefix(this.database));
            Assert.assertTrue((boolean)allColumns.containsKey(this.tablePartitionFormat));
            Assert.assertTrue((boolean)allColumns.containsKey(this.tableUnpartitioned));
        }
    }

    @Test
    public void testListUnknownSchema() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            Assert.assertNull((Object)metadata.getTableHandle(session, new SchemaTableName(INVALID_DATABASE, INVALID_TABLE)));
            Assert.assertEquals((Collection)metadata.listTables(session, Optional.of(INVALID_DATABASE)), (Collection)ImmutableList.of());
            Assert.assertEquals(AbstractTestHive.listTableColumns(metadata, session, new SchemaTablePrefix(INVALID_DATABASE, INVALID_TABLE)), (Map)ImmutableMap.of());
            Assert.assertEquals((Collection)metadata.listViews(session, Optional.of(INVALID_DATABASE)), (Collection)ImmutableList.of());
            Assert.assertEquals((Map)metadata.getViews(session, Optional.of(INVALID_DATABASE)), (Map)ImmutableMap.of());
            Assert.assertEquals((Object)metadata.getView(session, new SchemaTableName(INVALID_DATABASE, INVALID_TABLE)), Optional.empty());
        }
    }

    @Test
    public void testGetPartitions() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            tableHandle = this.applyFilter(metadata, tableHandle, Constraint.alwaysTrue());
            ConnectorTableProperties properties = metadata.getTableProperties(this.newSession(), tableHandle);
            this.assertExpectedTableProperties(properties, this.tablePartitionFormatProperties);
            this.assertExpectedPartitions(tableHandle, this.tablePartitionFormatPartitions);
        }
    }

    @Test
    public void testGetPartitionsWithBindings() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            Constraint constraint = new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.intColumn, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L))));
            tableHandle = this.applyFilter(metadata, tableHandle, constraint);
            ConnectorTableProperties properties = metadata.getTableProperties(this.newSession(), tableHandle);
            this.assertExpectedTableProperties(properties, this.tablePartitionFormatProperties);
            this.assertExpectedPartitions(tableHandle, this.tablePartitionFormatPartitions);
        }
    }

    @Test
    public void testGetPartitionsWithFilter() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionedWithNull);
            Domain varcharSomeValue = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc"));
            Domain varcharOnlyNull = Domain.onlyNull((Type)VarcharType.VARCHAR);
            Domain varcharNotNull = Domain.notNull((Type)VarcharType.VARCHAR);
            Domain integerSomeValue = Domain.singleValue((Type)IntegerType.INTEGER, (Object)123L);
            Domain integerOnlyNull = Domain.onlyNull((Type)IntegerType.INTEGER);
            Domain integerNotNull = Domain.notNull((Type)IntegerType.INTEGER);
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, new Constraint(TupleDomain.all()))).containsOnly((Object[])new String[]{"p_string=__HIVE_DEFAULT_PARTITION__/p_integer=__HIVE_DEFAULT_PARTITION__", "p_string=abc/p_integer=123", "p_string=def/p_integer=456"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pStringColumn, varcharSomeValue)).containsOnly((Object[])new String[]{"p_string=abc/p_integer=123"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pIntegerColumn, integerSomeValue)).containsOnly((Object[])new String[]{"p_string=abc/p_integer=123"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pStringColumn, varcharOnlyNull)).containsOnly((Object[])new String[]{"p_string=__HIVE_DEFAULT_PARTITION__/p_integer=__HIVE_DEFAULT_PARTITION__"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pIntegerColumn, integerOnlyNull)).containsOnly((Object[])new String[]{"p_string=__HIVE_DEFAULT_PARTITION__/p_integer=__HIVE_DEFAULT_PARTITION__"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pStringColumn, varcharNotNull)).containsOnly((Object[])new String[]{"p_string=abc/p_integer=123", "p_string=def/p_integer=456"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pIntegerColumn, integerNotNull)).containsOnly((Object[])new String[]{"p_string=abc/p_integer=123", "p_string=def/p_integer=456"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pStringColumn, varcharOnlyNull.union(varcharSomeValue))).containsOnly((Object[])new String[]{"p_string=__HIVE_DEFAULT_PARTITION__/p_integer=__HIVE_DEFAULT_PARTITION__", "p_string=abc/p_integer=123"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pIntegerColumn, integerOnlyNull.union(integerSomeValue))).containsOnly((Object[])new String[]{"p_string=__HIVE_DEFAULT_PARTITION__/p_integer=__HIVE_DEFAULT_PARTITION__", "p_string=abc/p_integer=123"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pStringColumn, varcharSomeValue.complement().intersect(varcharNotNull))).containsOnly((Object[])new String[]{"p_string=def/p_integer=456"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pIntegerColumn, integerSomeValue.complement().intersect(integerNotNull))).containsOnly((Object[])new String[]{"p_string=def/p_integer=456"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pStringColumn, varcharSomeValue.complement())).containsOnly((Object[])new String[]{"p_string=__HIVE_DEFAULT_PARTITION__/p_integer=__HIVE_DEFAULT_PARTITION__", "p_string=def/p_integer=456"});
            org.assertj.core.api.Assertions.assertThat(this.getPartitionNamesByFilter(metadata, tableHandle, this.pIntegerColumn, integerSomeValue.complement())).containsOnly((Object[])new String[]{"p_string=__HIVE_DEFAULT_PARTITION__/p_integer=__HIVE_DEFAULT_PARTITION__", "p_string=def/p_integer=456"});
        }
    }

    private Set<String> getPartitionNamesByFilter(ConnectorMetadata metadata, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, Domain domain) {
        return this.getPartitionNamesByFilter(metadata, tableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)domain))));
    }

    private Set<String> getPartitionNamesByFilter(ConnectorMetadata metadata, ConnectorTableHandle tableHandle, Constraint constraint) {
        return (Set)((List)this.applyFilter(metadata, tableHandle, constraint).getPartitions().orElseThrow(() -> new IllegalStateException("No partitions"))).stream().map(HivePartition::getPartitionId).collect(ImmutableSet.toImmutableSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMismatchSchemaTable() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            if (storageFormat == HiveStorageFormat.JSON) continue;
            SchemaTableName temporaryMismatchSchemaTable = this.temporaryTable("mismatch_schema");
            try {
                this.doTestMismatchSchemaTable(temporaryMismatchSchemaTable, storageFormat, MISMATCH_SCHEMA_TABLE_BEFORE, MISMATCH_SCHEMA_TABLE_DATA_BEFORE, MISMATCH_SCHEMA_TABLE_AFTER, MISMATCH_SCHEMA_TABLE_DATA_AFTER);
            }
            finally {
                this.dropTable(temporaryMismatchSchemaTable);
            }
        }
    }

    protected void doTestMismatchSchemaTable(SchemaTableName schemaTableName, HiveStorageFormat storageFormat, List<ColumnMetadata> tableBefore, MaterializedResult dataBefore, List<ColumnMetadata> tableAfter, MaterializedResult dataAfter) throws Exception {
        MaterializedResult result;
        List<Object> columnHandles;
        Collection fragments;
        ConnectorPageSink sink;
        ConnectorInsertTableHandle insertTableHandle;
        ConnectorTableHandle tableHandle;
        ConnectorMetadata metadata;
        ConnectorSession session;
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        this.doCreateEmptyTable(schemaTableName, storageFormat, tableBefore);
        try (Transaction transaction = this.newTransaction();){
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, schemaTableName);
            insertTableHandle = metadata.beginInsert(session, tableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES);
            sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            sink.appendPage(dataBefore.toPage());
            fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session, insertTableHandle, fragments, (Collection)ImmutableList.of());
            transaction.commit();
        }
        transaction = this.newTransaction();
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            tableHandle = this.getTableHandle(metadata, schemaTableName);
            columnHandles = metadata.getColumnHandles(session, tableHandle).values().stream().filter(columnHandle -> !((HiveColumnHandle)columnHandle).isHidden()).collect(Collectors.toList());
            result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)dataBefore.getMaterializedRows());
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.newTransaction();
        try {
            session = this.newSession();
            PrincipalPrivileges principalPrivileges = this.testingPrincipalPrivilege(session);
            Table oldTable = (Table)transaction.getMetastore().getTable(schemaName, tableName).get();
            List dataColumns = tableAfter.stream().filter(columnMetadata -> !columnMetadata.getName().equals("ds")).map(columnMetadata -> new Column(columnMetadata.getName(), HiveType.toHiveType((Type)columnMetadata.getType()), Optional.empty())).collect(Collectors.toList());
            Table.Builder newTable = Table.builder((Table)oldTable).setDataColumns(dataColumns);
            transaction.getMetastore().replaceTable(schemaName, tableName, newTable.build(), principalPrivileges);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.newTransaction();
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            tableHandle = this.getTableHandle(metadata, schemaTableName);
            columnHandles = metadata.getColumnHandles(session, tableHandle).values().stream().filter(columnHandle -> !((HiveColumnHandle)columnHandle).isHidden()).collect(Collectors.toList());
            result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)dataAfter.getMaterializedRows());
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        try {
            transaction = this.newTransaction();
            try {
                session = this.newSession();
                metadata = transaction.getMetadata();
                tableHandle = this.getTableHandle(metadata, schemaTableName);
                insertTableHandle = metadata.beginInsert(session, tableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES);
                sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
                sink.appendPage(dataAfter.toPage());
                fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
                metadata.finishInsert(session, insertTableHandle, fragments, (Collection)ImmutableList.of());
                transaction.commit();
                Assert.fail((String)"expected exception");
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        catch (TrinoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH.toErrorCode());
        }
    }

    protected void assertExpectedTableProperties(ConnectorTableProperties actualProperties, ConnectorTableProperties expectedProperties) {
        Assert.assertEquals((Object)actualProperties.getPredicate(), (Object)expectedProperties.getPredicate());
        Assert.assertEquals((boolean)actualProperties.getDiscretePredicates().isPresent(), (boolean)expectedProperties.getDiscretePredicates().isPresent());
        actualProperties.getDiscretePredicates().ifPresent(actual -> {
            DiscretePredicates expected = (DiscretePredicates)expectedProperties.getDiscretePredicates().get();
            Assert.assertEquals((Collection)actual.getColumns(), (Collection)expected.getColumns());
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual.getPredicates(), (Iterable)expected.getPredicates());
        });
        Assert.assertEquals((Collection)actualProperties.getLocalProperties(), (Collection)expectedProperties.getLocalProperties());
    }

    protected void assertExpectedPartitions(ConnectorTableHandle table, Iterable<HivePartition> expectedPartitions) {
        Iterable actualPartitions = (Iterable)((HiveTableHandle)table).getPartitions().orElseThrow(AssertionError::new);
        ImmutableMap actualById = Maps.uniqueIndex((Iterable)actualPartitions, HivePartition::getPartitionId);
        ImmutableMap expectedById = Maps.uniqueIndex(expectedPartitions, HivePartition::getPartitionId);
        org.assertj.core.api.Assertions.assertThat((Map)actualById).isEqualTo((Object)expectedById);
        for (Map.Entry expected : expectedById.entrySet()) {
            HivePartition actualPartition = (HivePartition)actualById.get(expected.getKey());
            HivePartition expectedPartition = (HivePartition)expected.getValue();
            Assert.assertEquals((String)actualPartition.getPartitionId(), (String)expectedPartition.getPartitionId());
            Assert.assertEquals((Map)actualPartition.getKeys(), (Map)expectedPartition.getKeys());
            Assert.assertEquals((Object)actualPartition.getTableName(), (Object)expectedPartition.getTableName());
        }
    }

    @Test
    public void testGetPartitionNamesUnpartitioned() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableUnpartitioned);
            tableHandle = this.applyFilter(metadata, tableHandle, Constraint.alwaysTrue());
            ConnectorTableProperties properties = metadata.getTableProperties(this.newSession(), tableHandle);
            this.assertExpectedTableProperties(properties, new ConnectorTableProperties());
            this.assertExpectedPartitions(tableHandle, this.tableUnpartitionedPartitions);
        }
    }

    @Test
    public void testGetTableSchemaPartitionFormat() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(this.newSession(), this.getTableHandle(metadata, this.tablePartitionFormat));
            ImmutableMap map = Maps.uniqueIndex((Iterable)tableMetadata.getColumns(), ColumnMetadata::getName);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_string", (Type)VarcharType.createUnboundedVarcharType(), false);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_tinyint", (Type)TinyintType.TINYINT, false);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_smallint", (Type)SmallintType.SMALLINT, false);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_int", (Type)IntegerType.INTEGER, false);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_bigint", (Type)BigintType.BIGINT, false);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_float", (Type)RealType.REAL, false);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_double", (Type)DoubleType.DOUBLE, false);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_boolean", (Type)BooleanType.BOOLEAN, false);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "ds", (Type)VarcharType.createUnboundedVarcharType(), true);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "file_format", (Type)VarcharType.createUnboundedVarcharType(), true);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "dummy", (Type)IntegerType.INTEGER, true);
        }
    }

    @Test
    public void testGetTableSchemaUnpartitioned() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableUnpartitioned);
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(this.newSession(), tableHandle);
            ImmutableMap map = Maps.uniqueIndex((Iterable)tableMetadata.getColumns(), ColumnMetadata::getName);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_string", (Type)VarcharType.createUnboundedVarcharType(), false);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_tinyint", (Type)TinyintType.TINYINT, false);
        }
    }

    @Test
    public void testGetTableSchemaOffline() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            Map<SchemaTableName, List<ColumnMetadata>> columns = AbstractTestHive.listTableColumns(metadata, this.newSession(), this.tableOffline.toSchemaTablePrefix());
            Assert.assertEquals((int)columns.size(), (int)1);
            ImmutableMap map = Maps.uniqueIndex((Iterable)((Iterable)Iterables.getOnlyElement(columns.values())), ColumnMetadata::getName);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_string", (Type)VarcharType.createUnboundedVarcharType(), false);
        }
    }

    @Test
    public void testGetTableSchemaNotReadablePartition() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableNotReadable);
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(this.newSession(), tableHandle);
            ImmutableMap map = Maps.uniqueIndex((Iterable)tableMetadata.getColumns(), ColumnMetadata::getName);
            AbstractTestHive.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_string", (Type)VarcharType.createUnboundedVarcharType(), false);
        }
    }

    @Test
    public void testGetTableSchemaException() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            Assert.assertNull((Object)metadata.getTableHandle(this.newSession(), this.invalidTable));
        }
    }

    @Test
    public void testGetTableStatsBucketedStringInt() {
        this.assertTableStatsComputed(this.tableBucketedStringInt, (Set<String>)ImmutableSet.of((Object)"t_bigint", (Object)"t_boolean", (Object)"t_double", (Object)"t_float", (Object)"t_int", (Object)"t_smallint", (Object[])new String[]{"t_string", "t_tinyint", "ds"}));
    }

    @Test
    public void testGetTableStatsUnpartitioned() {
        this.assertTableStatsComputed(this.tableUnpartitioned, (Set<String>)ImmutableSet.of((Object)"t_string", (Object)"t_tinyint"));
    }

    private void assertTableStatsComputed(SchemaTableName tableName, Set<String> expectedColumnStatsColumns) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            String firstColumnName = expectedColumnStatsColumns.iterator().next();
            AbstractTestHive.verifyTableStatisticsWithColumns(metadata, session, AbstractTestHive.applyProjection(metadata, session, tableHandle, firstColumnName), (Set<String>)ImmutableSet.of((Object)firstColumnName));
            AbstractTestHive.verifyTableStatisticsWithColumns(metadata, session, tableHandle, expectedColumnStatsColumns);
        }
    }

    private static ConnectorTableHandle applyProjection(ConnectorMetadata metadata, ConnectorSession session, ConnectorTableHandle tableHandle, String columnName) {
        Map columnHandles = metadata.getColumnHandles(session, tableHandle);
        HiveColumnHandle firstColumn = (HiveColumnHandle)columnHandles.get(columnName);
        return (ConnectorTableHandle)((ProjectionApplicationResult)metadata.applyProjection(session, tableHandle, (List)ImmutableList.of((Object)new Variable("c1", firstColumn.getBaseType())), (Map)ImmutableMap.of((Object)"c1", (Object)firstColumn)).orElseThrow()).getHandle();
    }

    private static void verifyTableStatisticsWithColumns(ConnectorMetadata metadata, ConnectorSession session, ConnectorTableHandle tableHandle, Set<String> expectedColumnStatsColumns) {
        TableStatistics tableStatistics = metadata.getTableStatistics(session, tableHandle);
        Assert.assertFalse((boolean)tableStatistics.getRowCount().isUnknown(), (String)"row count is unknown");
        Map columnsStatistics = (Map)tableStatistics.getColumnStatistics().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HiveColumnHandle)entry.getKey()).getName(), Map.Entry::getValue));
        Assert.assertEquals(columnsStatistics.keySet(), expectedColumnStatsColumns, (String)"columns with statistics");
        Map columnHandles = metadata.getColumnHandles(session, tableHandle);
        columnsStatistics.forEach((columnName, columnStatistics) -> {
            ColumnHandle columnHandle = (ColumnHandle)columnHandles.get(columnName);
            Type columnType = metadata.getColumnMetadata(session, tableHandle, columnHandle).getType();
            Assert.assertFalse((boolean)columnStatistics.getNullsFraction().isUnknown(), (String)("unknown nulls fraction for " + columnName));
            Assert.assertFalse((boolean)columnStatistics.getDistinctValuesCount().isUnknown(), (String)("unknown distinct values count for " + columnName));
            if (columnType instanceof VarcharType) {
                Assert.assertFalse((boolean)columnStatistics.getDataSize().isUnknown(), (String)("unknown data size for " + columnName));
            } else {
                Assert.assertTrue((boolean)columnStatistics.getDataSize().isUnknown(), (String)("unknown data size for" + columnName));
            }
        });
    }

    @Test
    public void testGetPartitionSplitsBatch() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            ConnectorSplitSource splitSource = AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle);
            Assert.assertEquals((int)AbstractTestHive.getSplitCount(splitSource), (int)this.tablePartitionFormatPartitions.size());
        }
    }

    @Test
    public void testGetPartitionSplitsBatchUnpartitioned() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableUnpartitioned);
            ConnectorSplitSource splitSource = AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle);
            Assert.assertEquals((int)AbstractTestHive.getSplitCount(splitSource), (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerTransactionDirectoryListerCache() throws Exception {
        long initListCount = this.countingDirectoryLister.getListCount();
        SchemaTableName tableName = this.temporaryTable("per_transaction_listing_cache_test");
        ImmutableList columns = ImmutableList.of((Object)new Column("test", HiveType.HIVE_STRING, Optional.empty()));
        this.createEmptyTable(tableName, HiveStorageFormat.ORC, (List<Column>)columns, (List<Column>)ImmutableList.of());
        try {
            ConnectorTableHandle tableHandle;
            ConnectorSession session;
            ConnectorMetadata metadata;
            try (Transaction transaction = this.newTransaction();){
                metadata = transaction.getMetadata();
                session = this.newSession();
                metadata.beginQuery(session);
                tableHandle = this.getTableHandle(metadata, tableName);
                AbstractTestHive.getAllSplits(AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle));
                Assert.assertEquals((long)this.countingDirectoryLister.getListCount(), (long)(initListCount + 1L));
                AbstractTestHive.getAllSplits(AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle));
                Assert.assertEquals((long)this.countingDirectoryLister.getListCount(), (long)(initListCount + 1L));
            }
            transaction = this.newTransaction();
            try {
                metadata = transaction.getMetadata();
                session = this.newSession();
                metadata.beginQuery(session);
                tableHandle = this.getTableHandle(metadata, tableName);
                AbstractTestHive.getAllSplits(AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle));
                Assert.assertEquals((long)this.countingDirectoryLister.getListCount(), (long)(initListCount + 2L));
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test(expectedExceptions={TableNotFoundException.class})
    public void testGetPartitionSplitsBatchInvalidTable() {
        try (Transaction transaction = this.newTransaction();){
            AbstractTestHive.getSplits(this.splitManager, transaction, this.newSession(), this.invalidTableHandle);
        }
    }

    @Test
    public void testGetPartitionTableOffline() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            try {
                this.getTableHandle(metadata, this.tableOffline);
                Assert.fail((String)"expected TableOfflineException");
            }
            catch (TableOfflineException e) {
                Assert.assertEquals((Object)e.getTableName(), (Object)this.tableOffline);
            }
        }
    }

    @Test
    public void testGetPartitionSplitsTableNotReadablePartition() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableNotReadable);
            Assert.assertNotNull((Object)tableHandle);
            try {
                AbstractTestHive.getSplitCount(AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle));
                Assert.fail((String)"Expected HiveNotReadableException");
            }
            catch (HiveNotReadableException e) {
                org.assertj.core.api.Assertions.assertThat((Throwable)e).hasMessageMatching("Table '.*\\.trino_test_not_readable' is not readable: reason for not readable");
                Assert.assertEquals((Object)e.getTableName(), (Object)this.tableNotReadable);
                Assert.assertEquals((Object)e.getPartition(), Optional.empty());
            }
        }
    }

    @Test
    public void testBucketedTableStringInt() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableBucketedStringInt);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHive.indexColumns((List<ColumnHandle>)columnHandles);
            this.assertTableIsBucketed(tableHandle, transaction, session);
            String testString = "test";
            Integer testInt = 13;
            Short testSmallint = 12;
            ImmutableMap bindings = ImmutableMap.builder().put((Object)((ColumnHandle)columnHandles.get((Integer)columnIndex.get("t_int"))), (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)testInt)).put((Object)((ColumnHandle)columnHandles.get((Integer)columnIndex.get("t_string"))), (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)testString))).put((Object)((ColumnHandle)columnHandles.get((Integer)columnIndex.get("t_smallint"))), (Object)NullableValue.of((Type)SmallintType.SMALLINT, (Object)testSmallint)).buildOrThrow();
            MaterializedResult result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)bindings), OptionalInt.of(1), Optional.empty());
            boolean rowFound = false;
            for (MaterializedRow row : result) {
                if (!testString.equals(row.getField(((Integer)columnIndex.get("t_string")).intValue())) || !testInt.equals(row.getField(((Integer)columnIndex.get("t_int")).intValue())) || !testSmallint.equals(row.getField(((Integer)columnIndex.get("t_smallint")).intValue()))) continue;
                rowFound = true;
            }
            Assert.assertTrue((boolean)rowFound);
        }
    }

    @Test
    public void testBucketedTableBigintBoolean() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableBucketedBigintBoolean);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHive.indexColumns((List<ColumnHandle>)columnHandles);
            this.assertTableIsBucketed(tableHandle, transaction, session);
            ConnectorTableProperties properties = metadata.getTableProperties(this.newSession((Map<String, Object>)ImmutableMap.of((Object)"propagate_table_scan_sorting_properties", (Object)true)), tableHandle);
            Assert.assertTrue((boolean)properties.getLocalProperties().isEmpty());
            Assert.assertTrue((boolean)metadata.getTableProperties(this.newSession(), tableHandle).getLocalProperties().isEmpty());
            String testString = "test";
            Long testBigint = 89L;
            Boolean testBoolean = true;
            ImmutableMap bindings = ImmutableMap.builder().put((Object)((ColumnHandle)columnHandles.get((Integer)columnIndex.get("t_string"))), (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)testString))).put((Object)((ColumnHandle)columnHandles.get((Integer)columnIndex.get("t_bigint"))), (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)testBigint)).put((Object)((ColumnHandle)columnHandles.get((Integer)columnIndex.get("t_boolean"))), (Object)NullableValue.of((Type)BooleanType.BOOLEAN, (Object)testBoolean)).buildOrThrow();
            MaterializedResult result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)bindings), OptionalInt.of(1), Optional.empty());
            boolean rowFound = false;
            for (MaterializedRow row : result) {
                if (!testString.equals(row.getField(((Integer)columnIndex.get("t_string")).intValue())) || !testBigint.equals(row.getField(((Integer)columnIndex.get("t_bigint")).intValue())) || !testBoolean.equals(row.getField(((Integer)columnIndex.get("t_boolean")).intValue()))) continue;
                rowFound = true;
                break;
            }
            Assert.assertTrue((boolean)rowFound);
        }
    }

    @Test
    public void testBucketedTableDoubleFloat() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableBucketedDoubleFloat);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHive.indexColumns((List<ColumnHandle>)columnHandles);
            this.assertTableIsBucketed(tableHandle, transaction, session);
            float testFloatValue = 87.1f;
            double testDoubleValue = 88.2;
            ImmutableMap bindings = ImmutableMap.builder().put((Object)((ColumnHandle)columnHandles.get((Integer)columnIndex.get("t_float"))), (Object)NullableValue.of((Type)RealType.REAL, (Object)Float.floatToRawIntBits(testFloatValue))).put((Object)((ColumnHandle)columnHandles.get((Integer)columnIndex.get("t_double"))), (Object)NullableValue.of((Type)DoubleType.DOUBLE, (Object)testDoubleValue)).buildOrThrow();
            MaterializedResult result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)bindings), OptionalInt.of(1), Optional.empty());
            org.assertj.core.api.Assertions.assertThat((Iterable)result).anyMatch(row -> testFloatValue == ((Float)row.getField(((Integer)columnIndex.get("t_float")).intValue())).floatValue() && testDoubleValue == (Double)row.getField(((Integer)columnIndex.get("t_double")).intValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBucketedTableEvolutionWithDifferentReadBucketCount() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryBucketEvolutionTable = this.temporaryTable("bucket_evolution");
            try {
                this.doTestBucketedTableEvolutionWithDifferentReadCount(storageFormat, temporaryBucketEvolutionTable);
            }
            finally {
                this.dropTable(temporaryBucketEvolutionTable);
            }
        }
    }

    private void doTestBucketedTableEvolutionWithDifferentReadCount(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        int rowCount = 100;
        int bucketCount = 16;
        this.createEmptyTable(tableName, storageFormat, (List<Column>)ImmutableList.of((Object)new Column("id", HiveType.HIVE_LONG, Optional.empty()), (Object)new Column("name", HiveType.HIVE_STRING, Optional.empty())), (List<Column>)ImmutableList.of((Object)new Column("pk", HiveType.HIVE_STRING, Optional.empty())), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), HiveBucketing.BucketingVersion.BUCKETING_V1, 4, (List)ImmutableList.of())));
        MaterializedResult.Builder bucket8Builder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR});
        IntStream.range(0, rowCount).forEach(i -> bucket8Builder.row(new Object[]{(long)i, String.valueOf(i), "four"}));
        this.insertData(tableName, bucket8Builder.build());
        this.alterBucketProperty(tableName, Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), HiveBucketing.BucketingVersion.BUCKETING_V1, bucketCount, (List)ImmutableList.of())));
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            List<ConnectorSplit> splits = AbstractTestHive.getAllSplits(AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle));
            Assert.assertEquals((int)splits.size(), (int)16);
            ImmutableList.Builder allRows = ImmutableList.builder();
            for (ConnectorSplit split : splits) {
                ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, tableHandle, (List)columnHandles, DynamicFilter.EMPTY);
                try {
                    MaterializedResult intermediateResult = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles));
                    allRows.addAll((Iterable)intermediateResult.getMaterializedRows());
                }
                finally {
                    if (pageSource == null) continue;
                    pageSource.close();
                }
            }
            MaterializedResult result = new MaterializedResult((List)allRows.build(), HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles));
            Assert.assertEquals((int)result.getRowCount(), (int)rowCount);
            ImmutableMap<String, Integer> columnIndex = AbstractTestHive.indexColumns((List<ColumnHandle>)columnHandles);
            int nameColumnIndex = (Integer)columnIndex.get("name");
            int bucketColumnIndex = (Integer)columnIndex.get("$bucket");
            for (MaterializedRow row : result.getMaterializedRows()) {
                String name = (String)row.getField(nameColumnIndex);
                int bucket = (Integer)row.getField(bucketColumnIndex);
                Assert.assertEquals((int)bucket, (int)(Integer.parseInt(name) % bucketCount));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBucketedTableEvolution() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryBucketEvolutionTable = this.temporaryTable("bucket_evolution");
            try {
                this.doTestBucketedTableEvolution(storageFormat, temporaryBucketEvolutionTable);
            }
            finally {
                this.dropTable(temporaryBucketEvolutionTable);
            }
        }
    }

    private void doTestBucketedTableEvolution(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        int rowCount = 100;
        this.createEmptyTable(tableName, storageFormat, (List<Column>)ImmutableList.of((Object)new Column("id", HiveType.HIVE_LONG, Optional.empty()), (Object)new Column("name", HiveType.HIVE_STRING, Optional.empty())), (List<Column>)ImmutableList.of((Object)new Column("pk", HiveType.HIVE_STRING, Optional.empty())), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), HiveBucketing.BucketingVersion.BUCKETING_V1, 4, (List)ImmutableList.of())));
        MaterializedResult.Builder bucket4Builder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR});
        IntStream.range(0, rowCount).forEach(i -> bucket4Builder.row(new Object[]{(long)i, String.valueOf(i), "four"}));
        this.insertData(tableName, bucket4Builder.build());
        this.alterBucketProperty(tableName, Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), HiveBucketing.BucketingVersion.BUCKETING_V1, 16, (List)ImmutableList.of())));
        MaterializedResult.Builder bucket16Builder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR});
        IntStream.range(0, rowCount).forEach(i -> bucket16Builder.row(new Object[]{(long)i, String.valueOf(i), "sixteen"}));
        this.insertData(tableName, bucket16Builder.build());
        this.alterBucketProperty(tableName, Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), HiveBucketing.BucketingVersion.BUCKETING_V1, 8, (List)ImmutableList.of())));
        MaterializedResult.Builder bucket8Builder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR});
        IntStream.range(0, rowCount).forEach(i -> bucket8Builder.row(new Object[]{(long)i, String.valueOf(i), "eight"}));
        this.insertData(tableName, bucket8Builder.build());
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            Object columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            AbstractTestHive.assertBucketTableEvolutionResult(result, (List<ColumnHandle>)columnHandles, (Set<Integer>)ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object[])new Integer[]{6, 7}), rowCount);
            result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)HiveColumnHandle.bucketColumnHandle(), (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)6L))), OptionalInt.empty(), Optional.empty());
            AbstractTestHive.assertBucketTableEvolutionResult(result, (List<ColumnHandle>)columnHandles, (Set<Integer>)ImmutableSet.of((Object)6), rowCount);
            columnHandles = (List)metadata.getColumnHandles(session, tableHandle).values().stream().filter(columnHandle -> !"id".equals(((HiveColumnHandle)columnHandle).getName())).collect(ImmutableList.toImmutableList());
            result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)HiveColumnHandle.bucketColumnHandle(), (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)6L))), OptionalInt.empty(), Optional.empty());
            AbstractTestHive.assertBucketTableEvolutionResult(result, (List<ColumnHandle>)columnHandles, (Set<Integer>)ImmutableSet.of((Object)6), rowCount);
        }
    }

    private static void assertBucketTableEvolutionResult(MaterializedResult result, List<ColumnHandle> columnHandles, Set<Integer> bucketIds, int rowCount) {
        int bucketCount = 8;
        Set expectedIds = (Set)LongStream.range(0L, rowCount).filter(x -> bucketIds.contains(Math.toIntExact(x % (long)bucketCount))).boxed().collect(ImmutableSet.toImmutableSet());
        ImmutableMap<String, Integer> columnIndex = AbstractTestHive.indexColumns(columnHandles);
        OptionalInt idColumnIndex = columnIndex.containsKey("id") ? OptionalInt.of((Integer)columnIndex.get("id")) : OptionalInt.empty();
        int nameColumnIndex = (Integer)columnIndex.get("name");
        int bucketColumnIndex = (Integer)columnIndex.get("$bucket");
        HashMap<Long, Integer> idCount = new HashMap<Long, Integer>();
        for (MaterializedRow row : result.getMaterializedRows()) {
            String name = (String)row.getField(nameColumnIndex);
            int bucket = (Integer)row.getField(bucketColumnIndex);
            idCount.compute(Long.parseLong(name), (key, oldValue) -> oldValue == null ? 1 : oldValue + 1);
            Assert.assertEquals((int)bucket, (int)(Integer.parseInt(name) % bucketCount));
            if (!idColumnIndex.isPresent()) continue;
            long id = (Long)row.getField(idColumnIndex.getAsInt());
            Assert.assertEquals((long)Integer.parseInt(name), (long)id);
        }
        Assert.assertEquals((int)((Integer)idCount.values().stream().distinct().collect(MoreCollectors.onlyElement())), (int)3);
        Assert.assertEquals(idCount.keySet(), (Set)expectedIds);
    }

    @Test
    public void testBucketedSortedTableEvolution() throws Exception {
        SchemaTableName temporaryTable = this.temporaryTable("test_bucket_sorting_evolution");
        try {
            this.doTestBucketedSortedTableEvolution(temporaryTable);
        }
        finally {
            this.dropTable(temporaryTable);
        }
    }

    private void doTestBucketedSortedTableEvolution(SchemaTableName tableName) throws Exception {
        Object columnHandles;
        ConnectorTableHandle tableHandle;
        ConnectorSession session;
        ConnectorMetadata metadata;
        int rowCount = 100;
        this.createEmptyTable(tableName, HiveStorageFormat.ORC, (List<Column>)ImmutableList.of((Object)new Column("id", HiveType.HIVE_LONG, Optional.empty()), (Object)new Column("name", HiveType.HIVE_STRING, Optional.empty())), (List<Column>)ImmutableList.of((Object)new Column("pk", HiveType.HIVE_STRING, Optional.empty())), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), HiveBucketing.BucketingVersion.BUCKETING_V1, 4, (List)ImmutableList.of((Object)new SortingColumn("id", SortingColumn.Order.ASCENDING), (Object)new SortingColumn("name", SortingColumn.Order.ASCENDING)))));
        MaterializedResult.Builder sortedByIdNameBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR});
        IntStream.range(0, rowCount).forEach(i -> sortedByIdNameBuilder.row(new Object[]{(long)i, String.valueOf(i), "sorted_by_id_name"}));
        this.insertData(tableName, sortedByIdNameBuilder.build());
        this.alterBucketProperty(tableName, Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), HiveBucketing.BucketingVersion.BUCKETING_V1, 4, (List)ImmutableList.of((Object)new SortingColumn("name", SortingColumn.Order.ASCENDING)))));
        MaterializedResult.Builder sortedByNameBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR});
        IntStream.range(0, rowCount).forEach(i -> sortedByNameBuilder.row(new Object[]{(long)i, String.valueOf(i), "sorted_by_name"}));
        this.insertData(tableName, sortedByNameBuilder.build());
        this.alterBucketProperty(tableName, Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), HiveBucketing.BucketingVersion.BUCKETING_V1, 4, (List)ImmutableList.of((Object)new SortingColumn("id", SortingColumn.Order.ASCENDING)))));
        MaterializedResult.Builder sortedByIdBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR});
        IntStream.range(0, rowCount).forEach(i -> sortedByIdBuilder.row(new Object[]{(long)i, String.valueOf(i), "sorted_by_id"}));
        this.insertData(tableName, sortedByIdBuilder.build());
        try (Transaction transaction = this.newTransaction();){
            metadata = transaction.getMetadata();
            session = this.newSession();
            metadata.beginQuery(session);
            tableHandle = this.getTableHandle(metadata, tableName);
            columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            Assert.assertEquals((int)result.getRowCount(), (int)300);
        }
        transaction = this.newTransaction();
        try {
            metadata = transaction.getMetadata();
            session = this.newSession((Map<String, Object>)ImmutableMap.of((Object)"propagate_table_scan_sorting_properties", (Object)true));
            metadata.beginQuery(session);
            columnHandles = metadata.getColumnHandles(session, tableHandle);
            ConnectorTableProperties properties = metadata.getTableProperties(session, tableHandle);
            Assert.assertEquals((Collection)properties.getLocalProperties(), (Collection)ImmutableList.of((Object)new SortingProperty((Object)((ColumnHandle)columnHandles.get("id")), SortOrder.ASC_NULLS_FIRST)));
            ((AbstractThrowableAssert)org.assertj.core.api.Assertions.assertThatThrownBy(() -> this.lambda$doTestBucketedSortedTableEvolution$28(transaction, tableHandle, (Map)columnHandles, session)).isInstanceOf(TrinoException.class)).hasMessage("Hive table (%s) sorting by [id] is not compatible with partition (pk=sorted_by_name) sorting by [name]. This restriction can be avoided by disabling propagate_table_scan_sorting_properties.", new Object[]{tableName});
            MaterializedResult result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)ImmutableList.copyOf(columnHandles.values()), session, (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((ColumnHandle)columnHandles.get("pk")), (Object)Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"sorted_by_id_name"), (Object[])new Object[]{Slices.utf8Slice((String)"sorted_by_id")}), (boolean)false))), OptionalInt.empty(), Optional.empty());
            Assert.assertEquals((int)result.getRowCount(), (int)200);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBucketedTableValidation() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName table = this.temporaryTable("bucket_validation");
            try {
                this.doTestBucketedTableValidation(storageFormat, table);
            }
            finally {
                this.dropTable(table);
            }
        }
    }

    private void doTestBucketedTableValidation(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        this.prepareInvalidBuckets(storageFormat, tableName);
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession((Map<String, Object>)ImmutableMap.of((Object)"validate_bucketing", (Object)false));
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            Assert.assertEquals((int)result.getRowCount(), (int)87);
        }
        this.assertReadFailsWithMessageMatching(storageFormat, tableName, "Hive table is corrupt\\. File '.*/000002_0_.*' is for bucket 2, but contains a row for bucket 5.");
    }

    private void prepareInvalidBuckets(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        this.createEmptyTable(tableName, storageFormat, (List<Column>)ImmutableList.of((Object)new Column("id", HiveType.HIVE_LONG, Optional.empty()), (Object)new Column("name", HiveType.HIVE_STRING, Optional.empty())), (List<Column>)ImmutableList.of(), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), HiveBucketing.BucketingVersion.BUCKETING_V1, 8, (List)ImmutableList.of())));
        MaterializedResult.Builder dataBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR});
        for (long id = 0L; id < 100L; ++id) {
            dataBuilder.row(new Object[]{id, String.valueOf(id)});
        }
        this.insertData(tableName, dataBuilder.build());
        try (Transaction transaction = this.newTransaction();){
            Set<String> files = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            org.apache.hadoop.fs.Path bucket2 = (org.apache.hadoop.fs.Path)files.stream().map(org.apache.hadoop.fs.Path::new).filter(path -> path.getName().startsWith("000002_0_")).collect(MoreCollectors.onlyElement());
            org.apache.hadoop.fs.Path bucket5 = (org.apache.hadoop.fs.Path)files.stream().map(org.apache.hadoop.fs.Path::new).filter(path -> path.getName().startsWith("000005_0_")).collect(MoreCollectors.onlyElement());
            HdfsContext context = new HdfsContext(this.newSession());
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, bucket2);
            fileSystem.delete(bucket2, false);
            fileSystem.rename(bucket5, bucket2);
        }
    }

    protected void assertReadFailsWithMessageMatching(HiveStorageFormat storageFormat, SchemaTableName tableName, String regex) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat))).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_INVALID_BUCKET_FILES}).hasMessageMatching(regex);
        }
    }

    private void assertTableIsBucketed(ConnectorTableHandle tableHandle, Transaction transaction, ConnectorSession session) {
        List<ConnectorSplit> splits = this.getAllSplits(tableHandle, transaction, session);
        ((AbstractIntegerAssert)org.assertj.core.api.Assertions.assertThat((int)splits.size()).as("splits.size()", new Object[0])).isBetween(Integer.valueOf(31), Integer.valueOf(32));
        HashSet<String> paths = new HashSet<String>();
        for (ConnectorSplit split : splits) {
            Assert.assertTrue((boolean)paths.add(((HiveSplit)split).getPath()));
        }
    }

    @Test
    public void testGetRecords() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, tableHandle);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHive.indexColumns((List<ColumnHandle>)columnHandles);
            List<ConnectorSplit> splits = this.getAllSplits(tableHandle, transaction, session);
            Assert.assertEquals((int)splits.size(), (int)this.tablePartitionFormatPartitions.size());
            for (ConnectorSplit split : splits) {
                HiveSplit hiveSplit = (HiveSplit)split;
                List partitionKeys = hiveSplit.getPartitionKeys();
                String ds = ((HivePartitionKey)partitionKeys.get(0)).getValue();
                String fileFormat = ((HivePartitionKey)partitionKeys.get(1)).getValue();
                HiveStorageFormat fileType = HiveStorageFormat.valueOf((String)fileFormat.toUpperCase(Locale.ENGLISH));
                int dummyPartition = Integer.parseInt(((HivePartitionKey)partitionKeys.get(2)).getValue());
                long rowNumber = 0L;
                long completedBytes = 0L;
                ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, (ConnectorSplit)hiveSplit, tableHandle, (List)columnHandles, DynamicFilter.EMPTY);
                try {
                    MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles));
                    AbstractTestHive.assertPageSourceType(pageSource, fileType);
                    for (MaterializedRow row : result) {
                        try {
                            AbstractTestHive.assertValueTypes(row, tableMetadata.getColumns());
                        }
                        catch (RuntimeException e) {
                            throw new RuntimeException("row " + rowNumber, e);
                        }
                        Object value = row.getField(((Integer)columnIndex.get("t_string")).intValue());
                        if (++rowNumber % 19L == 0L) {
                            Assert.assertNull((Object)value);
                        } else if (rowNumber % 19L == 1L) {
                            Assert.assertEquals((Object)value, (Object)"");
                        } else {
                            Assert.assertEquals((Object)value, (Object)"test");
                        }
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_tinyint")).intValue()), (Object)((byte)(1L + rowNumber)));
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_smallint")).intValue()), (Object)((short)(2L + rowNumber)));
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_int")).intValue()), (Object)(3 + (int)rowNumber));
                        if (rowNumber % 13L == 0L) {
                            Assert.assertNull((Object)row.getField(((Integer)columnIndex.get("t_bigint")).intValue()));
                        } else {
                            Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_bigint")).intValue()), (Object)(4L + rowNumber));
                        }
                        Assert.assertEquals((double)((Float)row.getField(((Integer)columnIndex.get("t_float")).intValue())).floatValue(), (double)(5.1f + (float)rowNumber), (double)0.001);
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_double")).intValue()), (Object)(6.2 + (double)rowNumber));
                        if (rowNumber % 3L == 2L) {
                            Assert.assertNull((Object)row.getField(((Integer)columnIndex.get("t_boolean")).intValue()));
                        } else {
                            Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_boolean")).intValue()), (Object)(rowNumber % 3L != 0L ? 1 : 0));
                        }
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("ds")).intValue()), (Object)ds);
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("file_format")).intValue()), (Object)fileFormat);
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("dummy")).intValue()), (Object)dummyPartition);
                        long newCompletedBytes = pageSource.getCompletedBytes();
                        Assert.assertTrue((newCompletedBytes >= completedBytes ? 1 : 0) != 0);
                        Assert.assertTrue((newCompletedBytes <= hiveSplit.getLength() ? 1 : 0) != 0);
                        completedBytes = newCompletedBytes;
                    }
                    Assert.assertTrue((completedBytes <= hiveSplit.getLength() ? 1 : 0) != 0);
                    Assert.assertEquals((long)rowNumber, (long)100L);
                }
                finally {
                    if (pageSource == null) continue;
                    pageSource.close();
                }
            }
        }
    }

    @Test
    public void testGetPartialRecords() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHive.indexColumns((List<ColumnHandle>)columnHandles);
            List<ConnectorSplit> splits = this.getAllSplits(tableHandle, transaction, session);
            Assert.assertEquals((int)splits.size(), (int)this.tablePartitionFormatPartitions.size());
            for (ConnectorSplit split : splits) {
                HiveSplit hiveSplit = (HiveSplit)split;
                List partitionKeys = hiveSplit.getPartitionKeys();
                String ds = ((HivePartitionKey)partitionKeys.get(0)).getValue();
                String fileFormat = ((HivePartitionKey)partitionKeys.get(1)).getValue();
                HiveStorageFormat fileType = HiveStorageFormat.valueOf((String)fileFormat.toUpperCase(Locale.ENGLISH));
                int dummyPartition = Integer.parseInt(((HivePartitionKey)partitionKeys.get(2)).getValue());
                long rowNumber = 0L;
                try (ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, (ConnectorSplit)hiveSplit, tableHandle, (List)columnHandles, DynamicFilter.EMPTY);){
                    AbstractTestHive.assertPageSourceType(pageSource, fileType);
                    MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles));
                    for (MaterializedRow row : result) {
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_double")).intValue()), (Object)(6.2 + (double)(++rowNumber)));
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("ds")).intValue()), (Object)ds);
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("file_format")).intValue()), (Object)fileFormat);
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("dummy")).intValue()), (Object)dummyPartition);
                    }
                }
                Assert.assertEquals((long)rowNumber, (long)100L);
            }
        }
    }

    @Test
    public void testGetRecordsUnpartitioned() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableUnpartitioned);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHive.indexColumns((List<ColumnHandle>)columnHandles);
            List<ConnectorSplit> splits = this.getAllSplits(tableHandle, transaction, session);
            org.assertj.core.api.Assertions.assertThat(splits).hasSameSizeAs(this.tableUnpartitionedPartitions);
            for (ConnectorSplit split : splits) {
                HiveSplit hiveSplit = (HiveSplit)split;
                Assert.assertEquals((Collection)hiveSplit.getPartitionKeys(), (Collection)ImmutableList.of());
                long rowNumber = 0L;
                try (ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, tableHandle, (List)columnHandles, DynamicFilter.EMPTY);){
                    AbstractTestHive.assertPageSourceType(pageSource, HiveStorageFormat.TEXTFILE);
                    MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles));
                    for (MaterializedRow row : result) {
                        if (++rowNumber % 19L == 0L) {
                            Assert.assertNull((Object)row.getField(((Integer)columnIndex.get("t_string")).intValue()));
                        } else if (rowNumber % 19L == 1L) {
                            Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_string")).intValue()), (Object)"");
                        } else {
                            Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_string")).intValue()), (Object)"unpartitioned");
                        }
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_tinyint")).intValue()), (Object)((byte)(1L + rowNumber)));
                    }
                }
                Assert.assertEquals((long)rowNumber, (long)100L);
            }
        }
    }

    @Test(expectedExceptions={TrinoException.class}, expectedExceptionsMessageRegExp=".*The column 't_data' in table '.*\\.trino_test_partition_schema_change' is declared as type 'double', but partition 'ds=2012-12-29' declared column 't_data' as type 'string'.")
    public void testPartitionSchemaMismatch() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle table = this.getTableHandle(metadata, this.tablePartitionSchemaChange);
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            this.readTable(transaction, table, (List<ColumnHandle>)ImmutableList.of((Object)this.dsColumn), session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
        }
    }

    @Test(enabled=false)
    public void testPartitionSchemaNonCanonical() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle table = this.getTableHandle(metadata, this.tablePartitionSchemaChangeNonCanonical);
            ColumnHandle column = (ColumnHandle)metadata.getColumnHandles(session, table).get("t_boolean");
            Constraint constraint = new Constraint(TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)column, (Object)NullableValue.of((Type)BooleanType.BOOLEAN, (Object)false))));
            table = this.applyFilter(metadata, table, constraint);
            HivePartition partition = (HivePartition)Iterables.getOnlyElement((Iterable)((Iterable)((HiveTableHandle)table).getPartitions().orElseThrow(AssertionError::new)));
            Assert.assertEquals((String)this.getPartitionId(partition), (String)"t_boolean=0");
            ConnectorSplitSource splitSource = AbstractTestHive.getSplits(this.splitManager, transaction, session, table);
            ConnectorSplit split = (ConnectorSplit)Iterables.getOnlyElement(AbstractTestHive.getAllSplits(splitSource));
            ImmutableList columnHandles = ImmutableList.of((Object)column);
            try (ConnectorPageSource ignored = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, table, (List)columnHandles, DynamicFilter.EMPTY);){
                Assert.fail((String)"expected exception");
            }
            catch (TrinoException e) {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE.toErrorCode());
            }
        }
    }

    @Test
    public void testTypesTextFile() throws Exception {
        this.assertGetRecords("trino_test_types_textfile", HiveStorageFormat.TEXTFILE);
    }

    @Test
    public void testTypesSequenceFile() throws Exception {
        this.assertGetRecords("trino_test_types_sequencefile", HiveStorageFormat.SEQUENCEFILE);
    }

    @Test
    public void testTypesRcText() throws Exception {
        this.assertGetRecords("trino_test_types_rctext", HiveStorageFormat.RCTEXT);
    }

    @Test
    public void testTypesRcBinary() throws Exception {
        this.assertGetRecords("trino_test_types_rcbinary", HiveStorageFormat.RCBINARY);
    }

    @Test
    public void testTypesOrc() throws Exception {
        this.assertGetRecords("trino_test_types_orc", HiveStorageFormat.ORC);
    }

    @Test
    public void testTypesParquet() throws Exception {
        this.assertGetRecords("trino_test_types_parquet", HiveStorageFormat.PARQUET);
    }

    @Test
    public void testEmptyTextFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.TEXTFILE);
    }

    @Test
    public void testEmptySequenceFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.SEQUENCEFILE);
    }

    @Test
    public void testEmptyRcTextFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.RCTEXT);
    }

    @Test
    public void testEmptyRcBinaryFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.RCBINARY);
    }

    @Test
    public void testEmptyOrcFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.ORC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertEmptyFile(HiveStorageFormat format) throws Exception {
        SchemaTableName tableName = this.temporaryTable("empty_file");
        try {
            ImmutableList columns = ImmutableList.of((Object)new Column("test", HiveType.HIVE_STRING, Optional.empty()));
            this.createEmptyTable(tableName, format, (List<Column>)columns, (List<Column>)ImmutableList.of());
            try (Transaction transaction = this.newTransaction();){
                ConnectorSession session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                metadata.beginQuery(session);
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
                Table table = (Table)transaction.getMetastore().getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(AssertionError::new);
                HdfsContext context = new HdfsContext(session);
                org.apache.hadoop.fs.Path location = new org.apache.hadoop.fs.Path(table.getStorage().getLocation());
                Assert.assertTrue((boolean)this.listDirectory(context, location).isEmpty());
                this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.of(0), Optional.of(HiveStorageFormat.ORC));
                FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, location);
                Assert.assertTrue((boolean)fileSystem.createNewFile(new org.apache.hadoop.fs.Path(location, "empty-file")));
                Assert.assertEquals(this.listDirectory(context, location), (Collection)ImmutableList.of((Object)"empty-file"));
                MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.of(0), Optional.empty());
                Assert.assertEquals((int)result.getRowCount(), (int)0);
            }
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameTable() {
        SchemaTableName temporaryRenameTableOld = this.temporaryTable("rename_old");
        SchemaTableName temporaryRenameTableNew = this.temporaryTable("rename_new");
        try {
            ConnectorMetadata metadata;
            ConnectorSession session;
            this.createDummyTable(temporaryRenameTableOld);
            try (Transaction transaction = this.newTransaction();){
                session = this.newSession();
                metadata = transaction.getMetadata();
                metadata.renameTable(session, this.getTableHandle(metadata, temporaryRenameTableOld), temporaryRenameTableNew);
                transaction.commit();
            }
            transaction = this.newTransaction();
            try {
                session = this.newSession();
                metadata = transaction.getMetadata();
                Assert.assertNull((Object)metadata.getTableHandle(session, temporaryRenameTableOld));
                Assert.assertNotNull((Object)metadata.getTableHandle(session, temporaryRenameTableNew));
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        finally {
            this.dropTable(temporaryRenameTableOld);
            this.dropTable(temporaryRenameTableNew);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableCreation() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryCreateTable = this.temporaryTable("create");
            try {
                this.doCreateTable(temporaryCreateTable, storageFormat);
            }
            finally {
                this.dropTable(temporaryCreateTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testTableCreationWithTrailingSpaceInLocation() throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_table_creation_with_trailing_space_in_location_" + TestingNames.randomNameSuffix());
        String tableDefaultLocationWithTrailingSpace = null;
        try {
            ConnectorSession session;
            try (Transaction transaction = this.newTransaction();){
                session = this.newSession();
                SemiTransactionalHiveMetastore metastore = transaction.getMetastore();
                tableDefaultLocationWithTrailingSpace = HiveWriteUtils.getTableDefaultLocation((HdfsContext)new HdfsContext(session), (SemiTransactionalHiveMetastore)metastore, (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (String)tableName.getSchemaName(), (String)tableName.getTableName()) + " ";
                org.apache.hadoop.fs.Path dataFilePath = new org.apache.hadoop.fs.Path(tableDefaultLocationWithTrailingSpace, "foo.txt");
                FileSystem fs = this.hdfsEnvironment.getFileSystem(new HdfsContext(session), new org.apache.hadoop.fs.Path(tableDefaultLocationWithTrailingSpace));
                try (FSDataOutputStream outputStream = fs.create(dataFilePath);){
                    outputStream.write("hello\u0001world\nbye\u0001world".getBytes(StandardCharsets.UTF_8));
                }
                ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, (List)ImmutableList.builder().add((Object)new ColumnMetadata("t_string1", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("t_string2", (Type)VarcharType.VARCHAR)).build(), (Map)ImmutableMap.builder().putAll(AbstractTestHive.createTableProperties(HiveStorageFormat.TEXTFILE, (Iterable<String>)ImmutableList.of())).put((Object)"external_location", (Object)tableDefaultLocationWithTrailingSpace).buildOrThrow());
                ConnectorMetadata metadata = transaction.getMetadata();
                metadata.createTable(session, tableMetadata, false);
                transaction.commit();
            }
            transaction = this.newTransaction();
            try {
                session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                metadata.beginQuery(session);
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
                MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(HiveStorageFormat.TEXTFILE));
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"hello", "world"}).row(new Object[]{"bye", "world"}).build());
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
            this.dropTable(tableName);
            if (tableDefaultLocationWithTrailingSpace == null) return;
        }
        catch (Throwable throwable) {
            this.dropTable(tableName);
            if (tableDefaultLocationWithTrailingSpace == null) throw throwable;
            FileSystem fs = this.hdfsEnvironment.getFileSystem(new HdfsContext(HiveTestUtils.SESSION), new org.apache.hadoop.fs.Path(tableDefaultLocationWithTrailingSpace));
            fs.delete(new org.apache.hadoop.fs.Path(tableDefaultLocationWithTrailingSpace), true);
            throw throwable;
        }
        FileSystem fs = this.hdfsEnvironment.getFileSystem(new HdfsContext(HiveTestUtils.SESSION), new org.apache.hadoop.fs.Path(tableDefaultLocationWithTrailingSpace));
        fs.delete(new org.apache.hadoop.fs.Path(tableDefaultLocationWithTrailingSpace), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableCreationRollback() throws Exception {
        SchemaTableName temporaryCreateRollbackTable = this.temporaryTable("create_rollback");
        try {
            Location stagingPathRoot;
            try (Transaction transaction = this.newTransaction();){
                ConnectorSession session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(temporaryCreateRollbackTable, CREATE_TABLE_COLUMNS, AbstractTestHive.createTableProperties(HiveStorageFormat.RCBINARY));
                ConnectorOutputTableHandle outputHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES);
                ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, outputHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
                sink.appendPage(CREATE_TABLE_DATA.toPage());
                MoreFutures.getFutureValue((Future)sink.finish());
                stagingPathRoot = this.getStagingPathRoot(outputHandle);
                HdfsContext context = new HdfsContext(session);
                Assert.assertFalse((boolean)this.listAllDataFiles(context, stagingPathRoot).isEmpty());
                transaction.rollback();
            }
            HdfsContext context = new HdfsContext(this.newSession());
            Assert.assertTrue((boolean)this.listAllDataFiles(context, stagingPathRoot).isEmpty());
            try (Transaction transaction = this.newTransaction();){
                ConnectorSession session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                Assert.assertNull((Object)metadata.getTableHandle(session, temporaryCreateRollbackTable));
            }
        }
        finally {
            this.dropTable(temporaryCreateRollbackTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableCreationIgnoreExisting() {
        ImmutableList columns = ImmutableList.of((Object)new Column("dummy", HiveType.valueOf((String)"uniontype<smallint,tinyint>"), Optional.empty()));
        SchemaTableName schemaTableName = this.temporaryTable("create");
        ConnectorSession session = this.newSession();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        PrincipalPrivileges privileges = this.testingPrincipalPrivilege(session);
        try {
            Table table;
            Location targetPath;
            try (Transaction transaction = this.newTransaction();){
                LocationService locationService = this.getLocationService();
                targetPath = locationService.forNewTable(transaction.getMetastore(), session, schemaName, tableName);
                Table table2 = AbstractTestHive.createSimpleTable(schemaTableName, (List<Column>)columns, session, targetPath, "q1");
                transaction.getMetastore().createTable(session, table2, privileges, Optional.empty(), Optional.empty(), false, ZERO_TABLE_STATISTICS, false);
                Optional tableHandle = transaction.getMetastore().getTable(schemaName, tableName);
                Assert.assertTrue((boolean)tableHandle.isPresent());
                transaction.commit();
            }
            try {
                transaction = this.newTransaction();
                try {
                    table = AbstractTestHive.createSimpleTable(schemaTableName, (List<Column>)columns, session, targetPath.appendSuffix("_2"), "q2");
                    transaction.getMetastore().createTable(session, table, privileges, Optional.empty(), Optional.empty(), false, ZERO_TABLE_STATISTICS, false);
                    transaction.commit();
                    Assert.fail((String)"Expected exception");
                }
                finally {
                    if (transaction != null) {
                        transaction.close();
                    }
                }
            }
            catch (TrinoException e) {
                Assertions.assertInstanceOf((Object)((Object)e), TableAlreadyExistsException.class);
            }
            transaction = this.newTransaction();
            try {
                table = AbstractTestHive.createSimpleTable(schemaTableName, (List<Column>)columns, session, targetPath.appendSuffix("_3"), "q3");
                transaction.getMetastore().createTable(session, table, privileges, Optional.empty(), Optional.empty(), true, ZERO_TABLE_STATISTICS, false);
                transaction.commit();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
            columns = ImmutableList.of((Object)new Column("new_column", HiveType.valueOf((String)"string"), Optional.empty()));
            try {
                transaction = this.newTransaction();
                try {
                    table = AbstractTestHive.createSimpleTable(schemaTableName, (List<Column>)columns, session, targetPath.appendSuffix("_4"), "q4");
                    transaction.getMetastore().createTable(session, table, privileges, Optional.empty(), Optional.empty(), true, ZERO_TABLE_STATISTICS, false);
                    transaction.commit();
                    Assert.fail((String)"Expected exception");
                }
                finally {
                    if (transaction != null) {
                        transaction.close();
                    }
                }
            }
            catch (TrinoException e) {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.TRANSACTION_CONFLICT.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)String.format("Table already exists with a different schema: '%s'", schemaTableName.getTableName()));
            }
        }
        finally {
            this.dropTable(schemaTableName);
        }
    }

    private static Table createSimpleTable(SchemaTableName schemaTableName, List<Column> columns, ConnectorSession session, Location targetPath, String queryId) {
        String tableOwner = session.getUser();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        return Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(Optional.of(tableOwner)).setTableType(TableType.MANAGED_TABLE.name()).setParameters((Map)ImmutableMap.of((Object)"presto_version", (Object)TEST_SERVER_VERSION, (Object)"presto_query_id", (Object)queryId)).setDataColumns(columns).withStorage(storage -> storage.setLocation(targetPath.toString()).setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC)).setSerdeParameters((Map)ImmutableMap.of())).build();
    }

    @Test
    public void testBucketSortedTables() throws Exception {
        SchemaTableName table = this.temporaryTable("create_sorted");
        try {
            this.doTestBucketSortedTables(table);
        }
        finally {
            this.dropTable(table);
        }
    }

    private void doTestBucketSortedTables(SchemaTableName table) throws IOException {
        int bucketCount = 3;
        int expectedRowCount = 0;
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(table, (List)ImmutableList.builder().add((Object)new ColumnMetadata("id", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("value_asc", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("value_desc", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("ds", (Type)VarcharType.VARCHAR)).build(), (Map)ImmutableMap.builder().put((Object)"format", (Object)HiveStorageFormat.RCBINARY).put((Object)"partitioned_by", (Object)ImmutableList.of((Object)"ds")).put((Object)"bucketed_by", (Object)ImmutableList.of((Object)"id")).put((Object)"bucket_count", (Object)bucketCount).put((Object)"sorted_by", (Object)ImmutableList.builder().add((Object)new SortingColumn("value_asc", SortingColumn.Order.ASCENDING)).add((Object)new SortingColumn("value_desc", SortingColumn.Order.DESCENDING)).build()).buildOrThrow());
            ConnectorOutputTableHandle outputHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, outputHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            List types = tableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(Collectors.toList());
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int i = 0; i < 50; ++i) {
                MaterializedResult.Builder builder = MaterializedResult.resultBuilder((ConnectorSession)session, types);
                for (int j = 0; j < 1000; ++j) {
                    builder.row(new Object[]{Hashing.sha256().hashLong(random.nextLong()).toString(), "test" + random.nextInt(100), random.nextLong(100000L), "2018-04-01"});
                    ++expectedRowCount;
                }
                sink.appendPage(builder.build().toPage());
            }
            HdfsContext context = new HdfsContext(session);
            HiveConfig config = this.getHiveConfig();
            Location stagingPathRoot = config.isTemporaryStagingDirectoryEnabled() ? Location.of((String)config.getTemporaryStagingDirectoryPath().replace("${USER}", context.getIdentity().getUser())) : this.getStagingPathRoot(outputHandle);
            ((AbstractCollectionAssert)org.assertj.core.api.Assertions.assertThat(this.listAllDataFiles(context, stagingPathRoot)).filteredOn(file -> file.contains(".tmp-sort."))).size().isGreaterThan(bucketCount * this.getSortingFileWriterConfig().getMaxOpenSortFiles() * 2);
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            for (String file2 : this.listAllDataFiles(context, stagingPathRoot)) {
                org.assertj.core.api.Assertions.assertThat((String)file2).doesNotContain(new CharSequence[]{".tmp-sort."});
            }
            metadata.finishCreateTable(session, outputHandle, fragments, (Collection)ImmutableList.of());
            transaction.commit();
        }
        transaction = this.newTransaction();
        try {
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, table);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ConnectorTableProperties properties = metadata.getTableProperties(this.newSession((Map<String, Object>)ImmutableMap.of((Object)"propagate_table_scan_sorting_properties", (Object)true, (Object)"bucket_execution_enabled", (Object)false)), tableHandle);
            ImmutableMap<String, Integer> columnIndex = AbstractTestHive.indexColumns((List<ColumnHandle>)columnHandles);
            Assert.assertEquals((Collection)properties.getLocalProperties(), (Collection)ImmutableList.of((Object)new SortingProperty((Object)((ColumnHandle)columnHandles.get((Integer)columnIndex.get("value_asc"))), SortOrder.ASC_NULLS_FIRST), (Object)new SortingProperty((Object)((ColumnHandle)columnHandles.get((Integer)columnIndex.get("value_desc"))), SortOrder.DESC_NULLS_LAST)));
            org.assertj.core.api.Assertions.assertThat((List)metadata.getTableProperties(this.newSession(), tableHandle).getLocalProperties()).isEmpty();
            List<ConnectorSplit> splits = this.getAllSplits(tableHandle, transaction, session);
            org.assertj.core.api.Assertions.assertThat(splits).hasSize(bucketCount);
            int actualRowCount = 0;
            for (ConnectorSplit split : splits) {
                ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, tableHandle, (List)columnHandles, DynamicFilter.EMPTY);
                try {
                    String lastValueAsc = null;
                    long lastValueDesc = -1L;
                    while (!pageSource.isFinished()) {
                        Page page = pageSource.getNextPage();
                        if (page == null) continue;
                        for (int i = 0; i < page.getPositionCount(); ++i) {
                            Block blockAsc = page.getBlock(1);
                            Block blockDesc = page.getBlock(2);
                            Assert.assertFalse((boolean)blockAsc.isNull(i));
                            Assert.assertFalse((boolean)blockDesc.isNull(i));
                            String valueAsc = VarcharType.VARCHAR.getSlice(blockAsc, i).toStringUtf8();
                            if (lastValueAsc != null) {
                                Assertions.assertGreaterThanOrEqual((Comparable)((Object)valueAsc), (Comparable)((Object)lastValueAsc));
                                if (valueAsc.equals(lastValueAsc)) {
                                    long valueDesc = BigintType.BIGINT.getLong(blockDesc, i);
                                    if (lastValueDesc != -1L) {
                                        Assertions.assertLessThanOrEqual((Comparable)Long.valueOf(valueDesc), (Comparable)Long.valueOf(lastValueDesc));
                                    }
                                    lastValueDesc = valueDesc;
                                } else {
                                    lastValueDesc = -1L;
                                }
                            }
                            lastValueAsc = valueAsc;
                            ++actualRowCount;
                        }
                    }
                }
                finally {
                    if (pageSource == null) continue;
                    pageSource.close();
                }
            }
            org.assertj.core.api.Assertions.assertThat((int)actualRowCount).isEqualTo(expectedRowCount);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsert() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryInsertTable = this.temporaryTable("insert");
            try {
                this.doInsert(storageFormat, temporaryInsertTable);
            }
            finally {
                this.dropTable(temporaryInsertTable);
            }
        }
    }

    @Test
    public void testInsertOverwriteUnpartitioned() throws Exception {
        SchemaTableName table = this.temporaryTable("insert_overwrite");
        try {
            this.doInsertOverwriteUnpartitioned(table);
        }
        finally {
            this.dropTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertIntoNewPartition() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryInsertIntoNewPartitionTable = this.temporaryTable("insert_new_partitioned");
            try {
                this.doInsertIntoNewPartition(storageFormat, temporaryInsertIntoNewPartitionTable);
            }
            finally {
                this.dropTable(temporaryInsertIntoNewPartitionTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertIntoExistingPartition() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryInsertIntoExistingPartitionTable = this.temporaryTable("insert_existing_partitioned");
            try {
                this.doInsertIntoExistingPartition(storageFormat, temporaryInsertIntoExistingPartitionTable);
            }
            finally {
                this.dropTable(temporaryInsertIntoExistingPartitionTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertIntoExistingPartitionEmptyStatistics() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryInsertIntoExistingPartitionTable = this.temporaryTable("insert_existing_partitioned_empty_statistics");
            try {
                this.doInsertIntoExistingPartitionEmptyStatistics(storageFormat, temporaryInsertIntoExistingPartitionTable);
            }
            finally {
                this.dropTable(temporaryInsertIntoExistingPartitionTable);
            }
        }
    }

    @Test
    public void testInsertUnsupportedWriteType() throws Exception {
        SchemaTableName temporaryInsertUnsupportedWriteType = this.temporaryTable("insert_unsupported_type");
        try {
            this.doInsertUnsupportedWriteType(HiveStorageFormat.ORC, temporaryInsertUnsupportedWriteType);
        }
        finally {
            this.dropTable(temporaryInsertUnsupportedWriteType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataDelete() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryMetadataDeleteTable = this.temporaryTable("metadata_delete");
            try {
                this.doTestMetadataDelete(storageFormat, temporaryMetadataDeleteTable);
            }
            finally {
                this.dropTable(temporaryMetadataDeleteTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyTableCreation() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryCreateEmptyTable = this.temporaryTable("create_empty");
            try {
                this.doCreateEmptyTable(temporaryCreateEmptyTable, storageFormat, CREATE_TABLE_COLUMNS);
            }
            finally {
                this.dropTable(temporaryCreateEmptyTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateEmptyTableShouldNotCreateStagingDirectory() throws IOException {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryCreateEmptyTable = this.temporaryTable("create_empty");
            try {
                ImmutableList columns = ImmutableList.of((Object)new Column("test", HiveType.HIVE_STRING, Optional.empty()));
                Transaction transaction = this.newTransaction();
                try {
                    String temporaryStagingPrefix = "hive-temporary-staging-prefix-" + UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
                    ConnectorSession session = this.newSession();
                    String tableOwner = session.getUser();
                    String schemaName = temporaryCreateEmptyTable.getSchemaName();
                    String tableName = temporaryCreateEmptyTable.getTableName();
                    HiveConfig hiveConfig = this.getHiveConfig().setTemporaryStagingDirectoryPath(temporaryStagingPrefix).setTemporaryStagingDirectoryEnabled(true);
                    HiveLocationService locationService = new HiveLocationService(this.hdfsEnvironment, hiveConfig);
                    Location targetPath = locationService.forNewTable(transaction.getMetastore(), session, schemaName, tableName);
                    Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(Optional.of(tableOwner)).setTableType(TableType.MANAGED_TABLE.name()).setParameters((Map)ImmutableMap.of((Object)"presto_version", (Object)TEST_SERVER_VERSION, (Object)"presto_query_id", (Object)session.getQueryId())).setDataColumns((List)columns);
                    tableBuilder.getStorageBuilder().setLocation(targetPath.toString()).setStorageFormat(StorageFormat.create((String)storageFormat.getSerde(), (String)storageFormat.getInputFormat(), (String)storageFormat.getOutputFormat()));
                    transaction.getMetastore().createTable(session, tableBuilder.build(), this.testingPrincipalPrivilege(tableOwner, session.getUser()), Optional.empty(), Optional.empty(), true, ZERO_TABLE_STATISTICS, false);
                    transaction.commit();
                    HdfsContext context = new HdfsContext(session);
                    org.apache.hadoop.fs.Path temporaryRoot = new org.apache.hadoop.fs.Path(targetPath.toString(), temporaryStagingPrefix);
                    FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, temporaryRoot);
                    Assert.assertFalse((boolean)fileSystem.exists(temporaryRoot), (String)String.format("Temporary staging directory %s is created.", temporaryRoot));
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
            finally {
                this.dropTable(temporaryCreateEmptyTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testViewCreation() {
        SchemaTableName temporaryCreateView = this.temporaryTable("create_view");
        try {
            this.verifyViewCreation(temporaryCreateView);
        }
        finally {
            try (Transaction transaction = this.newTransaction();){
                ConnectorMetadata metadata = transaction.getMetadata();
                metadata.dropView(this.newSession(), temporaryCreateView);
                transaction.commit();
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    @Test
    public void testCreateTableUnsupportedType() {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            try {
                Transaction transaction = this.newTransaction();
                try {
                    ConnectorSession session = this.newSession();
                    ConnectorMetadata metadata = transaction.getMetadata();
                    ImmutableList columns = ImmutableList.of((Object)new ColumnMetadata("dummy", (Type)HyperLogLogType.HYPER_LOG_LOG));
                    ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(this.invalidTable, (List)columns, AbstractTestHive.createTableProperties(storageFormat));
                    metadata.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES);
                    Assert.fail((String)("create table with unsupported type should fail for storage format " + storageFormat));
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
            catch (TrinoException e) {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHideDeltaLakeTables() {
        ConnectorSession session = this.newSession();
        SchemaTableName tableName = this.temporaryTable("trino_delta_lake_table");
        Table.Builder table = Table.builder().setDatabaseName(tableName.getSchemaName()).setTableName(tableName.getTableName()).setOwner(Optional.of(session.getUser())).setTableType(TableType.MANAGED_TABLE.name()).setPartitionColumns(List.of(new Column("a_partition_column", HiveType.HIVE_INT, Optional.empty()))).setDataColumns(List.of(new Column("a_column", HiveType.HIVE_STRING, Optional.empty()))).setParameter("spark.sql.sources.provider", "delta");
        table.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.PARQUET)).setLocation(HiveWriteUtils.getTableDefaultLocation((Database)((Database)this.metastoreClient.getDatabase(tableName.getSchemaName()).orElseThrow()), (HdfsContext)new HdfsContext(session.getIdentity()), (HdfsEnvironment)this.hdfsEnvironment, (String)tableName.getSchemaName(), (String)tableName.getTableName()).toString());
        this.metastoreClient.createTable(table.build(), PrincipalPrivileges.NO_PRIVILEGES);
        try {
            ConnectorMetadata metadata;
            try (Transaction transaction = this.newTransaction();){
                metadata = transaction.getMetadata();
                metadata.beginQuery(session);
                org.assertj.core.api.Assertions.assertThatThrownBy(() -> this.getTableHandle(metadata, tableName)).hasMessage(String.format("Cannot query Delta Lake table '%s'", tableName));
            }
            transaction = this.newTransaction();
            try {
                metadata = transaction.getMetadata();
                metadata.beginQuery(session);
                SchemaTableName propertiesTableName = new SchemaTableName(tableName.getSchemaName(), String.format("%s$properties", tableName.getTableName()));
                org.assertj.core.api.Assertions.assertThat((Optional)metadata.getSystemTable(this.newSession(), propertiesTableName)).isEmpty();
                SchemaTableName partitionsTableName = new SchemaTableName(tableName.getSchemaName(), String.format("%s$partitions", tableName.getTableName()));
                org.assertj.core.api.Assertions.assertThat((Optional)metadata.getSystemTable(this.newSession(), partitionsTableName)).isEmpty();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
            transaction = this.newTransaction();
            try {
                metadata = transaction.getMetadata();
                org.assertj.core.api.Assertions.assertThat((List)metadata.listTables(session, Optional.empty())).doesNotContain((Object[])new SchemaTableName[]{tableName});
                org.assertj.core.api.Assertions.assertThat((List)metadata.listTables(session, Optional.of(tableName.getSchemaName()))).doesNotContain((Object[])new SchemaTableName[]{tableName});
                org.assertj.core.api.Assertions.assertThat(AbstractTestHive.listTableColumns(metadata, session, new SchemaTablePrefix(tableName.getSchemaName())).keySet()).doesNotContain((Object[])new SchemaTableName[]{tableName});
                org.assertj.core.api.Assertions.assertThat(AbstractTestHive.listTableColumns(metadata, session, new SchemaTablePrefix(tableName.getSchemaName(), tableName.getTableName())).keySet()).doesNotContain((Object[])new SchemaTableName[]{tableName});
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        finally {
            this.metastoreClient.dropTable(tableName.getSchemaName(), tableName.getTableName(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowQueryingOfIcebergTables() {
        ConnectorSession session = this.newSession();
        SchemaTableName tableName = this.temporaryTable("trino_iceberg_table");
        Table.Builder table = Table.builder().setDatabaseName(tableName.getSchemaName()).setTableName(tableName.getTableName()).setOwner(Optional.of(session.getUser())).setTableType(TableType.MANAGED_TABLE.name()).setPartitionColumns(List.of(new Column("a_partition_column", HiveType.HIVE_INT, Optional.empty()))).setDataColumns(List.of(new Column("a_column", HiveType.HIVE_STRING, Optional.empty()))).setParameter("table_type", "iceberg");
        table.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.PARQUET)).setLocation(HiveWriteUtils.getTableDefaultLocation((Database)((Database)this.metastoreClient.getDatabase(tableName.getSchemaName()).orElseThrow()), (HdfsContext)new HdfsContext(session.getIdentity()), (HdfsEnvironment)this.hdfsEnvironment, (String)tableName.getSchemaName(), (String)tableName.getTableName()).toString());
        this.metastoreClient.createTable(table.build(), PrincipalPrivileges.NO_PRIVILEGES);
        try {
            ConnectorMetadata metadata;
            try (Transaction transaction = this.newTransaction();){
                metadata = transaction.getMetadata();
                metadata.beginQuery(session);
                org.assertj.core.api.Assertions.assertThatThrownBy(() -> this.getTableHandle(metadata, tableName)).hasMessage(String.format("Cannot query Iceberg table '%s'", tableName));
            }
            transaction = this.newTransaction();
            try {
                metadata = transaction.getMetadata();
                metadata.beginQuery(session);
                SchemaTableName propertiesTableName = new SchemaTableName(tableName.getSchemaName(), String.format("%s$properties", tableName.getTableName()));
                org.assertj.core.api.Assertions.assertThat((Optional)metadata.getSystemTable(this.newSession(), propertiesTableName)).isEmpty();
                SchemaTableName partitionsTableName = new SchemaTableName(tableName.getSchemaName(), String.format("%s$partitions", tableName.getTableName()));
                org.assertj.core.api.Assertions.assertThat((Optional)metadata.getSystemTable(this.newSession(), partitionsTableName)).isEmpty();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        finally {
            this.metastoreClient.dropTable(tableName.getSchemaName(), tableName.getTableName(), true);
        }
    }

    @Test
    public void testUpdateBasicTableStatistics() throws Exception {
        SchemaTableName tableName = this.temporaryTable("update_basic_table_statistics");
        try {
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, STATISTICS_TABLE_COLUMNS);
            this.testUpdateTableStatistics(tableName, ZERO_TABLE_STATISTICS, BASIC_STATISTICS_1, BASIC_STATISTICS_2);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testUpdateTableColumnStatistics() throws Exception {
        SchemaTableName tableName = this.temporaryTable("update_table_column_statistics");
        try {
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, STATISTICS_TABLE_COLUMNS);
            this.testUpdateTableStatistics(tableName, ZERO_TABLE_STATISTICS, STATISTICS_1_1, STATISTICS_1_2, STATISTICS_2);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testUpdateTableColumnStatisticsEmptyOptionalFields() throws Exception {
        SchemaTableName tableName = this.temporaryTable("update_table_column_statistics_empty_optional_fields");
        try {
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, STATISTICS_TABLE_COLUMNS);
            this.testUpdateTableStatistics(tableName, ZERO_TABLE_STATISTICS, STATISTICS_EMPTY_OPTIONAL_FIELDS);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    protected void testUpdateTableStatistics(SchemaTableName tableName, PartitionStatistics initialStatistics, PartitionStatistics ... statistics) {
        HiveMetastoreClosure metastoreClient = new HiveMetastoreClosure(this.getMetastoreClient());
        org.assertj.core.api.Assertions.assertThat((Object)metastoreClient.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)initialStatistics);
        AtomicReference<PartitionStatistics> expectedStatistics = new AtomicReference<PartitionStatistics>(initialStatistics);
        for (PartitionStatistics partitionStatistics : statistics) {
            metastoreClient.updateTableStatistics(tableName.getSchemaName(), tableName.getTableName(), AcidTransaction.NO_ACID_TRANSACTION, actualStatistics -> {
                org.assertj.core.api.Assertions.assertThat((Object)actualStatistics).isEqualTo(expectedStatistics.get());
                return partitionStatistics;
            });
            org.assertj.core.api.Assertions.assertThat((Object)metastoreClient.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)partitionStatistics);
            expectedStatistics.set(partitionStatistics);
        }
        org.assertj.core.api.Assertions.assertThat((Object)metastoreClient.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)expectedStatistics.get());
        metastoreClient.updateTableStatistics(tableName.getSchemaName(), tableName.getTableName(), AcidTransaction.NO_ACID_TRANSACTION, actualStatistics -> {
            org.assertj.core.api.Assertions.assertThat((Object)actualStatistics).isEqualTo(expectedStatistics.get());
            return initialStatistics;
        });
        org.assertj.core.api.Assertions.assertThat((Object)metastoreClient.getTableStatistics(tableName.getSchemaName(), tableName.getTableName(), Optional.empty())).isEqualTo((Object)initialStatistics);
    }

    @Test
    public void testUpdateBasicPartitionStatistics() throws Exception {
        SchemaTableName tableName = this.temporaryTable("update_basic_partition_statistics");
        try {
            this.createDummyPartitionedTable(tableName, STATISTICS_PARTITIONED_TABLE_COLUMNS);
            this.testUpdatePartitionStatistics(tableName, ZERO_TABLE_STATISTICS, (List<PartitionStatistics>)ImmutableList.of((Object)BASIC_STATISTICS_1, (Object)BASIC_STATISTICS_2), (List<PartitionStatistics>)ImmutableList.of((Object)BASIC_STATISTICS_2, (Object)BASIC_STATISTICS_1));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testUpdatePartitionColumnStatistics() throws Exception {
        SchemaTableName tableName = this.temporaryTable("update_partition_column_statistics");
        try {
            this.createDummyPartitionedTable(tableName, STATISTICS_PARTITIONED_TABLE_COLUMNS);
            this.testUpdatePartitionStatistics(tableName, ZERO_TABLE_STATISTICS, (List<PartitionStatistics>)ImmutableList.of((Object)STATISTICS_1_1, (Object)STATISTICS_1_2, (Object)STATISTICS_2), (List<PartitionStatistics>)ImmutableList.of((Object)STATISTICS_1_2, (Object)STATISTICS_1_1, (Object)STATISTICS_2));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testUpdatePartitionColumnStatisticsEmptyOptionalFields() throws Exception {
        SchemaTableName tableName = this.temporaryTable("update_partition_column_statistics");
        try {
            this.createDummyPartitionedTable(tableName, STATISTICS_PARTITIONED_TABLE_COLUMNS);
            this.testUpdatePartitionStatistics(tableName, ZERO_TABLE_STATISTICS, (List<PartitionStatistics>)ImmutableList.of((Object)STATISTICS_EMPTY_OPTIONAL_FIELDS), (List<PartitionStatistics>)ImmutableList.of((Object)STATISTICS_EMPTY_OPTIONAL_FIELDS));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataColumnProperties() throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_column_properties");
        HiveMetastoreClosure metastoreClient = new HiveMetastoreClosure(this.getMetastoreClient());
        try {
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, List.of(new ColumnMetadata("id", (Type)BigintType.BIGINT), new ColumnMetadata("part_key", (Type)VarcharType.createVarcharType((int)256))));
            Table table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow();
            ((MapAssert)((ObjectAssert)org.assertj.core.api.Assertions.assertThat((List)table.getDataColumns()).singleElement()).extracting(Column::getProperties, InstanceOfAssertFactories.MAP)).isEmpty();
            ((MapAssert)((ObjectAssert)org.assertj.core.api.Assertions.assertThat((List)table.getPartitionColumns()).singleElement()).extracting(Column::getProperties, InstanceOfAssertFactories.MAP)).isEmpty();
            String columnPropertyValue = "data column value ,;.!??? \" ' {} [] non-printable \u0000 \u0001 spaces \n\r\t\f hiragana \u3060 emoji \ud83e\udd37\u200d\u2642\ufe0f  x";
            metastoreClient.replaceTable(tableName.getSchemaName(), tableName.getTableName(), Table.builder((Table)table).setDataColumns(List.of(new Column("id", HiveType.HIVE_LONG, Optional.empty(), Map.of("data prop", columnPropertyValue)))).build(), PrincipalPrivileges.NO_PRIVILEGES);
            table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow();
            ((MapAssert)((ObjectAssert)org.assertj.core.api.Assertions.assertThat((List)table.getDataColumns()).singleElement()).extracting(Column::getProperties, InstanceOfAssertFactories.MAP)).isEqualTo(Map.of("data prop", columnPropertyValue));
            ((MapAssert)((ObjectAssert)org.assertj.core.api.Assertions.assertThat((List)table.getPartitionColumns()).singleElement()).extracting(Column::getProperties, InstanceOfAssertFactories.MAP)).isEmpty();
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionColumnProperties() throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_column_properties");
        HiveMetastoreClosure metastoreClient = new HiveMetastoreClosure(this.getMetastoreClient());
        try {
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, List.of(new ColumnMetadata("id", (Type)BigintType.BIGINT), new ColumnMetadata("part_key", (Type)VarcharType.createVarcharType((int)256))));
            Table table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow();
            ((MapAssert)((ObjectAssert)org.assertj.core.api.Assertions.assertThat((List)table.getDataColumns()).singleElement()).extracting(Column::getProperties, InstanceOfAssertFactories.MAP)).isEmpty();
            ((MapAssert)((ObjectAssert)org.assertj.core.api.Assertions.assertThat((List)table.getPartitionColumns()).singleElement()).extracting(Column::getProperties, InstanceOfAssertFactories.MAP)).isEmpty();
            String columnPropertyValue = "partition column value ,;.!??? \" ' {} [] non-printable \u0000 \u0001 spaces \n\r\t\f hiragana \u3060 emoji \ud83e\udd37\u200d\u2642\ufe0f  x";
            metastoreClient.replaceTable(tableName.getSchemaName(), tableName.getTableName(), Table.builder((Table)table).setPartitionColumns(List.of(new Column("part_key", HiveType.valueOf((String)"varchar(256)"), Optional.empty(), Map.of("partition prop", columnPropertyValue)))).build(), PrincipalPrivileges.NO_PRIVILEGES);
            table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow();
            ((MapAssert)((ObjectAssert)org.assertj.core.api.Assertions.assertThat((List)table.getDataColumns()).singleElement()).extracting(Column::getProperties, InstanceOfAssertFactories.MAP)).isEmpty();
            ((MapAssert)((ObjectAssert)org.assertj.core.api.Assertions.assertThat((List)table.getPartitionColumns()).singleElement()).extracting(Column::getProperties, InstanceOfAssertFactories.MAP)).isEqualTo(Map.of("partition prop", columnPropertyValue));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testInputInfoWhenTableIsPartitioned() throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_input_info_with_partitioned_table");
        try {
            this.createDummyPartitionedTable(tableName, STATISTICS_PARTITIONED_TABLE_COLUMNS);
            this.assertInputInfo(tableName, new HiveInputInfo((List)ImmutableList.of(), true, Optional.of("ORC")));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testInputInfoWhenTableIsNotPartitioned() {
        SchemaTableName tableName = this.temporaryTable("test_input_info_without_partitioned_table");
        try {
            this.createDummyTable(tableName);
            this.assertInputInfo(tableName, new HiveInputInfo((List)ImmutableList.of(), false, Optional.of("TEXTFILE")));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testInputInfoWithParquetTableFormat() {
        SchemaTableName tableName = this.temporaryTable("test_input_info_with_parquet_table_format");
        try {
            this.createDummyTable(tableName, HiveStorageFormat.PARQUET);
            this.assertInputInfo(tableName, new HiveInputInfo((List)ImmutableList.of(), false, Optional.of("PARQUET")));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    private void assertInputInfo(SchemaTableName tableName, HiveInputInfo expectedInputInfo) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            HiveTableHandle tableHandle = (HiveTableHandle)metadata.getTableHandle(session, tableName);
            org.assertj.core.api.Assertions.assertThat((Optional)metadata.getInfo((ConnectorTableHandle)tableHandle)).isEqualTo(Optional.of(expectedInputInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIllegalStorageFormatDuringTableScan() {
        SchemaTableName schemaTableName = this.temporaryTable("test_illegal_storage_format");
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ImmutableList columns = ImmutableList.of((Object)new Column("pk", HiveType.HIVE_STRING, Optional.empty()));
            String tableOwner = session.getUser();
            String schemaName = schemaTableName.getSchemaName();
            String tableName = schemaTableName.getTableName();
            Location targetPath = this.locationService.forNewTable(transaction.getMetastore(), session, schemaName, tableName);
            Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(Optional.of(tableOwner)).setTableType(TableType.MANAGED_TABLE.name()).setParameters((Map)ImmutableMap.of((Object)"presto_version", (Object)TEST_SERVER_VERSION, (Object)"presto_query_id", (Object)session.getQueryId())).setDataColumns((List)columns).withStorage(storage -> storage.setLocation(targetPath.toString()).setStorageFormat(StorageFormat.createNullable(null, null, null)).setSerdeParameters((Map)ImmutableMap.of()));
            PrincipalPrivileges principalPrivileges = this.testingPrincipalPrivilege(tableOwner, session.getUser());
            transaction.getMetastore().createTable(session, tableBuilder.build(), principalPrivileges, Optional.empty(), Optional.empty(), true, ZERO_TABLE_STATISTICS, false);
            transaction.commit();
        }
        try {
            transaction = this.newTransaction();
            try {
                ConnectorMetadata metadata = transaction.getMetadata();
                Map<SchemaTableName, List<ColumnMetadata>> allColumns = AbstractTestHive.listTableColumns(metadata, this.newSession(), new SchemaTablePrefix(schemaTableName.getSchemaName()));
                Assert.assertTrue((boolean)allColumns.containsKey(schemaTableName));
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        finally {
            this.dropTable(schemaTableName);
        }
    }

    protected static Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorMetadata metadata, ConnectorSession session, SchemaTablePrefix prefix) {
        return (Map)Streams.stream((Iterator)metadata.streamTableColumns(session, prefix)).collect(ImmutableMap.toImmutableMap(TableColumnsMetadata::getTable, tableColumns -> (List)tableColumns.getColumns().orElseThrow(() -> new IllegalStateException("Table " + tableColumns.getTable() + " reported as redirected"))));
    }

    private void createDummyTable(SchemaTableName tableName) {
        this.createDummyTable(tableName, HiveStorageFormat.TEXTFILE);
    }

    private void createDummyTable(SchemaTableName tableName, HiveStorageFormat storageFormat) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ImmutableList columns = ImmutableList.of((Object)new ColumnMetadata("dummy", (Type)VarcharType.createUnboundedVarcharType()));
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, (List)columns, AbstractTestHive.createTableProperties(storageFormat));
            ConnectorOutputTableHandle handle = metadata.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES);
            metadata.finishCreateTable(session, handle, (Collection)ImmutableList.of(), (Collection)ImmutableList.of());
            transaction.commit();
        }
    }

    protected void createDummyPartitionedTable(SchemaTableName tableName, List<ColumnMetadata> columns) throws Exception {
        this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, columns);
        HiveMetastoreClosure metastoreClient = new HiveMetastoreClosure(this.getMetastoreClient());
        Table table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        ImmutableList firstPartitionValues = ImmutableList.of((Object)"2016-01-01");
        ImmutableList secondPartitionValues = ImmutableList.of((Object)"2016-01-02");
        String firstPartitionName = FileUtils.makePartName((List)ImmutableList.of((Object)"ds"), (List)firstPartitionValues);
        String secondPartitionName = FileUtils.makePartName((List)ImmutableList.of((Object)"ds"), (List)secondPartitionValues);
        List partitions = (List)ImmutableList.of((Object)firstPartitionName, (Object)secondPartitionName).stream().map(partitionName -> new PartitionWithStatistics(this.createDummyPartition(table, (String)partitionName), partitionName, PartitionStatistics.empty())).collect(ImmutableList.toImmutableList());
        metastoreClient.addPartitions(tableName.getSchemaName(), tableName.getTableName(), partitions);
        metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), firstPartitionName, currentStatistics -> ZERO_TABLE_STATISTICS);
        metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), secondPartitionName, currentStatistics -> ZERO_TABLE_STATISTICS);
    }

    protected void testUpdatePartitionStatistics(SchemaTableName tableName, PartitionStatistics initialStatistics, List<PartitionStatistics> firstPartitionStatistics, List<PartitionStatistics> secondPartitionStatistics) {
        Verify.verify((firstPartitionStatistics.size() == secondPartitionStatistics.size() ? 1 : 0) != 0);
        String firstPartitionName = "ds=2016-01-01";
        String secondPartitionName = "ds=2016-01-02";
        HiveMetastoreClosure metastoreClient = new HiveMetastoreClosure(this.getMetastoreClient());
        org.assertj.core.api.Assertions.assertThat((Map)metastoreClient.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), (Set)ImmutableSet.of((Object)firstPartitionName, (Object)secondPartitionName))).isEqualTo((Object)ImmutableMap.of((Object)firstPartitionName, (Object)initialStatistics, (Object)secondPartitionName, (Object)initialStatistics));
        AtomicReference<PartitionStatistics> expectedStatisticsPartition1 = new AtomicReference<PartitionStatistics>(initialStatistics);
        AtomicReference<PartitionStatistics> expectedStatisticsPartition2 = new AtomicReference<PartitionStatistics>(initialStatistics);
        for (int i = 0; i < firstPartitionStatistics.size(); ++i) {
            PartitionStatistics statisticsPartition1 = firstPartitionStatistics.get(i);
            PartitionStatistics statisticsPartition2 = secondPartitionStatistics.get(i);
            metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), firstPartitionName, actualStatistics -> {
                org.assertj.core.api.Assertions.assertThat((Object)actualStatistics).isEqualTo(expectedStatisticsPartition1.get());
                return statisticsPartition1;
            });
            metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), secondPartitionName, actualStatistics -> {
                org.assertj.core.api.Assertions.assertThat((Object)actualStatistics).isEqualTo(expectedStatisticsPartition2.get());
                return statisticsPartition2;
            });
            org.assertj.core.api.Assertions.assertThat((Map)metastoreClient.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), (Set)ImmutableSet.of((Object)firstPartitionName, (Object)secondPartitionName))).isEqualTo((Object)ImmutableMap.of((Object)firstPartitionName, (Object)statisticsPartition1, (Object)secondPartitionName, (Object)statisticsPartition2));
            expectedStatisticsPartition1.set(statisticsPartition1);
            expectedStatisticsPartition2.set(statisticsPartition2);
        }
        org.assertj.core.api.Assertions.assertThat((Map)metastoreClient.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), (Set)ImmutableSet.of((Object)firstPartitionName, (Object)secondPartitionName))).isEqualTo((Object)ImmutableMap.of((Object)firstPartitionName, (Object)expectedStatisticsPartition1.get(), (Object)secondPartitionName, (Object)expectedStatisticsPartition2.get()));
        metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), firstPartitionName, currentStatistics -> {
            org.assertj.core.api.Assertions.assertThat((Object)currentStatistics).isEqualTo(expectedStatisticsPartition1.get());
            return initialStatistics;
        });
        metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), secondPartitionName, currentStatistics -> {
            org.assertj.core.api.Assertions.assertThat((Object)currentStatistics).isEqualTo(expectedStatisticsPartition2.get());
            return initialStatistics;
        });
        org.assertj.core.api.Assertions.assertThat((Map)metastoreClient.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), (Set)ImmutableSet.of((Object)firstPartitionName, (Object)secondPartitionName))).isEqualTo((Object)ImmutableMap.of((Object)firstPartitionName, (Object)initialStatistics, (Object)secondPartitionName, (Object)initialStatistics));
    }

    @Test
    public void testStorePartitionWithStatistics() throws Exception {
        this.testStorePartitionWithStatistics(STATISTICS_PARTITIONED_TABLE_COLUMNS, STATISTICS_1, STATISTICS_2, STATISTICS_1_1, ZERO_TABLE_STATISTICS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testStorePartitionWithStatistics(List<ColumnMetadata> columns, PartitionStatistics statsForAllColumns1, PartitionStatistics statsForAllColumns2, PartitionStatistics statsForSubsetOfColumns, PartitionStatistics emptyStatistics) throws Exception {
        SchemaTableName tableName = this.temporaryTable("store_partition_with_statistics");
        try {
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, columns);
            HiveMetastoreClosure metastoreClient = new HiveMetastoreClosure(this.getMetastoreClient());
            Table table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
            ImmutableList partitionValues = ImmutableList.of((Object)"2016-01-01");
            String partitionName = FileUtils.makePartName((List)ImmutableList.of((Object)"ds"), (List)partitionValues);
            Partition partition = this.createDummyPartition(table, partitionName);
            metastoreClient.addPartitions(tableName.getSchemaName(), tableName.getTableName(), (List)ImmutableList.of((Object)new PartitionWithStatistics(partition, partitionName, statsForAllColumns1)));
            Assert.assertEquals((Object)((Partition)metastoreClient.getPartition(tableName.getSchemaName(), tableName.getTableName(), (List)partitionValues).get()).getStorage().getStorageFormat(), (Object)StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC));
            org.assertj.core.api.Assertions.assertThat((Map)metastoreClient.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), (Set)ImmutableSet.of((Object)partitionName))).isEqualTo((Object)ImmutableMap.of((Object)partitionName, (Object)statsForAllColumns1));
            Partition modifiedPartition = Partition.builder((Partition)partition).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.RCBINARY)).setLocation(this.partitionTargetPath(tableName, partitionName))).build();
            metastoreClient.alterPartition(tableName.getSchemaName(), tableName.getTableName(), new PartitionWithStatistics(modifiedPartition, partitionName, statsForAllColumns2));
            Assert.assertEquals((Object)((Partition)metastoreClient.getPartition(tableName.getSchemaName(), tableName.getTableName(), (List)partitionValues).get()).getStorage().getStorageFormat(), (Object)StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.RCBINARY));
            org.assertj.core.api.Assertions.assertThat((Map)metastoreClient.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), (Set)ImmutableSet.of((Object)partitionName))).isEqualTo((Object)ImmutableMap.of((Object)partitionName, (Object)statsForAllColumns2));
            modifiedPartition = Partition.builder((Partition)partition).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.TEXTFILE)).setLocation(this.partitionTargetPath(tableName, partitionName))).build();
            metastoreClient.alterPartition(tableName.getSchemaName(), tableName.getTableName(), new PartitionWithStatistics(modifiedPartition, partitionName, statsForSubsetOfColumns));
            org.assertj.core.api.Assertions.assertThat((Map)metastoreClient.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), (Set)ImmutableSet.of((Object)partitionName))).isEqualTo((Object)ImmutableMap.of((Object)partitionName, (Object)statsForSubsetOfColumns));
            modifiedPartition = Partition.builder((Partition)partition).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.TEXTFILE)).setLocation(this.partitionTargetPath(tableName, partitionName))).build();
            metastoreClient.alterPartition(tableName.getSchemaName(), tableName.getTableName(), new PartitionWithStatistics(modifiedPartition, partitionName, emptyStatistics));
            org.assertj.core.api.Assertions.assertThat((Map)metastoreClient.getPartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), (Set)ImmutableSet.of((Object)partitionName))).isEqualTo((Object)ImmutableMap.of((Object)partitionName, (Object)emptyStatistics));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    protected Partition createDummyPartition(Table table, String partitionName) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(HiveUtil.toPartitionValues((String)partitionName)).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC)).setLocation(this.partitionTargetPath(new SchemaTableName(table.getDatabaseName(), table.getTableName()), partitionName))).setParameters((Map)ImmutableMap.of((Object)"presto_version", (Object)"testversion", (Object)"presto_query_id", (Object)"20180101_123456_00001_x1y2z")).build();
    }

    protected String partitionTargetPath(SchemaTableName schemaTableName, String partitionName) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            SemiTransactionalHiveMetastore metastore = transaction.getMetastore();
            LocationService locationService = this.getLocationService();
            Table table = (Table)metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).get();
            LocationHandle handle = locationService.forExistingTable(metastore, session, table);
            String string = locationService.getPartitionWriteInfo(handle, Optional.empty(), partitionName).targetPath().toString();
            return string;
        }
    }

    @Test
    public void testPartitionStatisticsSampling() throws Exception {
        this.testPartitionStatisticsSampling(STATISTICS_PARTITIONED_TABLE_COLUMNS, STATISTICS_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testPartitionStatisticsSampling(List<ColumnMetadata> columns, PartitionStatistics statistics) throws Exception {
        SchemaTableName tableName = this.temporaryTable("test_partition_statistics_sampling");
        try {
            this.createDummyPartitionedTable(tableName, columns);
            HiveMetastoreClosure metastoreClient = new HiveMetastoreClosure(this.getMetastoreClient());
            metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), "ds=2016-01-01", actualStatistics -> statistics);
            metastoreClient.updatePartitionStatistics(tableName.getSchemaName(), tableName.getTableName(), "ds=2016-01-02", actualStatistics -> statistics);
            try (Transaction transaction = this.newTransaction();){
                ConnectorSession session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                ConnectorTableHandle tableHandle = metadata.getTableHandle(session, tableName);
                TableStatistics unsampledStatistics = metadata.getTableStatistics(this.sampleSize(2), tableHandle);
                TableStatistics sampledStatistics = metadata.getTableStatistics(this.sampleSize(1), tableHandle);
                Assert.assertEquals((Object)sampledStatistics, (Object)unsampledStatistics);
            }
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApplyProjection() throws Exception {
        ColumnMetadata bigIntColumn0 = new ColumnMetadata("int0", (Type)BigintType.BIGINT);
        ColumnMetadata bigIntColumn1 = new ColumnMetadata("int1", (Type)BigintType.BIGINT);
        RowType oneLevelRowType = AbstractTestHive.toRowType((List<ColumnMetadata>)ImmutableList.of((Object)bigIntColumn0, (Object)bigIntColumn1));
        ColumnMetadata oneLevelRow0 = new ColumnMetadata("onelevelrow0", (Type)oneLevelRowType);
        RowType twoLevelRowType = AbstractTestHive.toRowType((List<ColumnMetadata>)ImmutableList.of((Object)oneLevelRow0, (Object)bigIntColumn0, (Object)bigIntColumn1));
        ColumnMetadata twoLevelRow0 = new ColumnMetadata("twolevelrow0", (Type)twoLevelRowType);
        ImmutableList columnsForApplyProjectionTest = ImmutableList.of((Object)bigIntColumn0, (Object)bigIntColumn1, (Object)oneLevelRow0, (Object)twoLevelRow0);
        SchemaTableName tableName = this.temporaryTable("apply_projection_tester");
        this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, (List<ColumnMetadata>)columnsForApplyProjectionTest);
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List columnHandles = metadata.getColumnHandles(session, tableHandle).values().stream().filter(columnHandle -> !((HiveColumnHandle)columnHandle).isHidden()).collect(Collectors.toList());
            Assert.assertEquals((int)columnHandles.size(), (int)columnsForApplyProjectionTest.size());
            Map columnHandleMap = (Map)columnHandles.stream().collect(ImmutableMap.toImmutableMap(handle -> ((HiveColumnHandle)handle).getBaseColumnName(), Function.identity()));
            ImmutableMap columnHandlesWithSymbols = ImmutableMap.of((Object)"symbol_0", (Object)((ColumnHandle)columnHandleMap.get("int0")), (Object)"symbol_1", (Object)((ColumnHandle)columnHandleMap.get("int1")), (Object)"symbol_2", (Object)((ColumnHandle)columnHandleMap.get("onelevelrow0")), (Object)"symbol_3", (Object)((ColumnHandle)columnHandleMap.get("twolevelrow0")));
            Map symbolVariableMapping = (Map)columnHandlesWithSymbols.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> new Variable((String)e.getKey(), ((HiveColumnHandle)e.getValue()).getBaseType())));
            FieldDereference symbol2Field0 = new FieldDereference((Type)BigintType.BIGINT, (ConnectorExpression)symbolVariableMapping.get("symbol_2"), 0);
            FieldDereference symbol3Field0 = new FieldDereference((Type)oneLevelRowType, (ConnectorExpression)symbolVariableMapping.get("symbol_3"), 0);
            FieldDereference symbol3Field0Field0 = new FieldDereference((Type)BigintType.BIGINT, (ConnectorExpression)symbol3Field0, 0);
            FieldDereference symbol3Field1 = new FieldDereference((Type)BigintType.BIGINT, (ConnectorExpression)symbolVariableMapping.get("symbol_3"), 1);
            ImmutableMap inputAssignments = AbstractTestHive.getColumnHandlesFor((Map<String, ColumnHandle>)columnHandlesWithSymbols, (List<String>)ImmutableList.of((Object)"symbol_0", (Object)"symbol_1"));
            ImmutableList inputProjections = ImmutableList.of((Object)((ConnectorExpression)symbolVariableMapping.get("symbol_0")), (Object)((ConnectorExpression)symbolVariableMapping.get("symbol_1")));
            ImmutableMap expectedAssignments = ImmutableMap.of((Object)"symbol_0", (Object)BigintType.BIGINT, (Object)"symbol_1", (Object)BigintType.BIGINT);
            Optional projectionResult = metadata.applyProjection(session, tableHandle, (List)inputProjections, inputAssignments);
            AbstractTestHive.assertProjectionResult(projectionResult, false, (List<ConnectorExpression>)inputProjections, (Map<String, Type>)expectedAssignments);
            projectionResult = metadata.applyProjection(session, (ConnectorTableHandle)((ProjectionApplicationResult)projectionResult.get()).getHandle(), (List)inputProjections, inputAssignments);
            AbstractTestHive.assertProjectionResult(projectionResult, true, (List<ConnectorExpression>)ImmutableList.of(), (Map<String, Type>)ImmutableMap.of());
            projectionResult = metadata.applyProjection(session, (ConnectorTableHandle)((HiveTableHandle)tableHandle).withProjectedColumns((Set)ImmutableSet.copyOf(columnHandles)), (List)inputProjections, inputAssignments);
            AbstractTestHive.assertProjectionResult(projectionResult, false, (List<ConnectorExpression>)inputProjections, (Map<String, Type>)expectedAssignments);
            inputAssignments = AbstractTestHive.getColumnHandlesFor((Map<String, ColumnHandle>)columnHandlesWithSymbols, (List<String>)ImmutableList.of((Object)"symbol_2", (Object)"symbol_3"));
            inputProjections = ImmutableList.of((Object)symbol2Field0, (Object)symbol3Field0Field0, (Object)symbol3Field1);
            expectedAssignments = ImmutableMap.of((Object)"onelevelrow0#f_int0", (Object)BigintType.BIGINT, (Object)"twolevelrow0#f_onelevelrow0#f_int0", (Object)BigintType.BIGINT, (Object)"twolevelrow0#f_int0", (Object)BigintType.BIGINT);
            ImmutableList expectedProjections = ImmutableList.of((Object)new Variable("onelevelrow0#f_int0", (Type)BigintType.BIGINT), (Object)new Variable("twolevelrow0#f_onelevelrow0#f_int0", (Type)BigintType.BIGINT), (Object)new Variable("twolevelrow0#f_int0", (Type)BigintType.BIGINT));
            projectionResult = metadata.applyProjection(session, tableHandle, (List)inputProjections, inputAssignments);
            AbstractTestHive.assertProjectionResult(projectionResult, false, (List<ConnectorExpression>)expectedProjections, (Map<String, Type>)expectedAssignments);
            inputAssignments = AbstractTestHive.getColumnHandlesFor((Map<String, ColumnHandle>)columnHandlesWithSymbols, (List<String>)ImmutableList.of((Object)"symbol_2"));
            inputProjections = ImmutableList.of((Object)symbol2Field0, (Object)((ConnectorExpression)symbolVariableMapping.get("symbol_2")));
            projectionResult = metadata.applyProjection(session, tableHandle, (List)inputProjections, inputAssignments);
            expectedProjections = ImmutableList.of((Object)new Variable("onelevelrow0#f_int0", (Type)BigintType.BIGINT), (Object)((ConnectorExpression)symbolVariableMapping.get("symbol_2")));
            expectedAssignments = ImmutableMap.of((Object)"onelevelrow0#f_int0", (Object)BigintType.BIGINT, (Object)"symbol_2", (Object)oneLevelRowType);
            AbstractTestHive.assertProjectionResult(projectionResult, false, (List<ConnectorExpression>)expectedProjections, (Map<String, Type>)expectedAssignments);
            Assignment newlyCreatedColumn = (Assignment)Iterables.getOnlyElement((Iterable)((ProjectionApplicationResult)projectionResult.get()).getAssignments().stream().filter(handle -> handle.getVariable().equals("onelevelrow0#f_int0")).collect(Collectors.toList()));
            inputAssignments = ImmutableMap.builder().putAll(AbstractTestHive.getColumnHandlesFor((Map<String, ColumnHandle>)columnHandlesWithSymbols, (List<String>)ImmutableList.of((Object)"symbol_2"))).put((Object)newlyCreatedColumn.getVariable(), (Object)newlyCreatedColumn.getColumn()).buildOrThrow();
            inputProjections = ImmutableList.of((Object)symbol2Field0, (Object)new Variable("onelevelrow0#f_int0", (Type)BigintType.BIGINT));
            projectionResult = metadata.applyProjection(session, tableHandle, (List)inputProjections, (Map)inputAssignments);
            expectedProjections = ImmutableList.of((Object)new Variable("onelevelrow0#f_int0", (Type)BigintType.BIGINT), (Object)new Variable("onelevelrow0#f_int0", (Type)BigintType.BIGINT));
            expectedAssignments = ImmutableMap.of((Object)"onelevelrow0#f_int0", (Object)BigintType.BIGINT);
            AbstractTestHive.assertProjectionResult(projectionResult, false, (List<ConnectorExpression>)expectedProjections, (Map<String, Type>)expectedAssignments);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    private static Map<String, ColumnHandle> getColumnHandlesFor(Map<String, ColumnHandle> columnHandles, List<String> symbols) {
        return (Map)columnHandles.entrySet().stream().filter(e -> symbols.contains(e.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static void assertProjectionResult(Optional<ProjectionApplicationResult<ConnectorTableHandle>> projectionResult, boolean shouldBeEmpty, List<ConnectorExpression> expectedProjections, Map<String, Type> expectedAssignments) {
        if (shouldBeEmpty) {
            Assert.assertTrue((boolean)projectionResult.isEmpty(), (String)"expected projectionResult to be empty");
            return;
        }
        Assert.assertTrue((boolean)projectionResult.isPresent(), (String)"expected non-empty projection result");
        ProjectionApplicationResult<ConnectorTableHandle> result = projectionResult.get();
        Assert.assertEquals(expectedProjections, (Collection)result.getProjections());
        List assignments = result.getAssignments();
        ImmutableMap actualAssignments = Maps.uniqueIndex((Iterable)assignments, Assignment::getVariable);
        for (String variable : expectedAssignments.keySet()) {
            Type expectedType = expectedAssignments.get(variable);
            Assert.assertTrue((boolean)actualAssignments.containsKey(variable));
            Assert.assertEquals((Object)((Assignment)actualAssignments.get(variable)).getType(), (Object)expectedType);
            Assert.assertEquals((Object)((HiveColumnHandle)((Assignment)actualAssignments.get(variable)).getColumn()).getType(), (Object)expectedType);
        }
        Assert.assertEquals((int)actualAssignments.size(), (int)expectedAssignments.size());
        Assert.assertEquals((Set)((Set)actualAssignments.values().stream().map(Assignment::getColumn).collect(ImmutableSet.toImmutableSet())), (Set)((HiveTableHandle)result.getHandle()).getProjectedColumns());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApplyRedirection() throws Exception {
        SchemaTableName sourceTableName = this.temporaryTable("apply_redirection_tester");
        this.doCreateEmptyTable(sourceTableName, HiveStorageFormat.ORC, CREATE_TABLE_COLUMNS);
        SchemaTableName tableName = this.temporaryTable("apply_no_redirection_tester");
        this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, CREATE_TABLE_COLUMNS);
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            org.assertj.core.api.Assertions.assertThat((Optional)metadata.applyTableScanRedirect(session, this.getTableHandle(metadata, tableName))).isEmpty();
            Optional result = metadata.applyTableScanRedirect(session, this.getTableHandle(metadata, sourceTableName));
            org.assertj.core.api.Assertions.assertThat((Optional)result).isPresent();
            org.assertj.core.api.Assertions.assertThat((Object)((TableScanRedirectApplicationResult)result.get()).getDestinationTable()).isEqualTo((Object)new CatalogSchemaTableName("hive", this.database, "mock_redirection_target"));
        }
        finally {
            this.dropTable(sourceTableName);
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewMetadata() throws Exception {
        SchemaTableName sourceTableName = this.temporaryTable("materialized_view_tester");
        this.doCreateEmptyTable(sourceTableName, HiveStorageFormat.ORC, CREATE_TABLE_COLUMNS);
        SchemaTableName tableName = this.temporaryTable("mock_table");
        this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, CREATE_TABLE_COLUMNS);
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            org.assertj.core.api.Assertions.assertThat((Optional)metadata.getMaterializedView(session, tableName)).isEmpty();
            Optional result = metadata.getMaterializedView(session, sourceTableName);
            org.assertj.core.api.Assertions.assertThat((Optional)result).isPresent();
            org.assertj.core.api.Assertions.assertThat((String)((ConnectorMaterializedViewDefinition)result.get()).getOriginalSql()).isEqualTo("dummy_view_sql");
        }
        finally {
            this.dropTable(sourceTableName);
            this.dropTable(tableName);
        }
    }

    @Test
    public void testOrcPageSourceMetrics() throws Exception {
        SchemaTableName tableName = this.temporaryTable("orc_page_source_metrics");
        try {
            this.assertPageSourceMetrics(tableName, HiveStorageFormat.ORC, new Metrics((Map)ImmutableMap.of((Object)"OrcReaderCompressionFormat_SNAPPY", (Object)new LongCount(209L))));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testParquetPageSourceMetrics() throws Exception {
        SchemaTableName tableName = this.temporaryTable("parquet_page_source_metrics");
        try {
            this.assertPageSourceMetrics(tableName, HiveStorageFormat.PARQUET, new Metrics((Map)ImmutableMap.of((Object)"ParquetReaderCompressionFormat_SNAPPY", (Object)new LongCount(1157L))));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    private void assertPageSourceMetrics(SchemaTableName tableName, HiveStorageFormat storageFormat, Metrics expectedMetrics) throws Exception {
        this.createEmptyTable(tableName, storageFormat, (List<Column>)ImmutableList.of((Object)new Column("id", HiveType.HIVE_LONG, Optional.empty()), (Object)new Column("name", HiveType.HIVE_STRING, Optional.empty())), (List<Column>)ImmutableList.of());
        MaterializedResult.Builder inputDataBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR});
        IntStream.range(0, 100).forEach(i -> inputDataBuilder.row(new Object[]{(long)i, String.valueOf(i)}));
        this.insertData(tableName, inputDataBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"compression_codec", (Object)"SNAPPY"));
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            List<ConnectorSplit> splits = AbstractTestHive.getAllSplits(AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle));
            for (ConnectorSplit split : splits) {
                ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, tableHandle, (List)columnHandles, DynamicFilter.EMPTY);
                try {
                    MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles));
                    org.assertj.core.api.Assertions.assertThat((Object)pageSource.getMetrics()).isEqualTo((Object)expectedMetrics);
                }
                finally {
                    if (pageSource == null) continue;
                    pageSource.close();
                }
            }
        }
    }

    private ConnectorSession sampleSize(int sampleSize) {
        return HiveTestUtils.getHiveSession(this.getHiveConfig().setPartitionStatisticsSampleSize(sampleSize));
    }

    private void verifyViewCreation(SchemaTableName temporaryCreateView) {
        ConnectorMetadata metadata;
        this.doCreateView(temporaryCreateView, true);
        this.doCreateView(temporaryCreateView, true);
        try {
            this.doCreateView(temporaryCreateView, false);
            Assert.fail((String)"create existing should fail");
        }
        catch (ViewAlreadyExistsException e) {
            Assert.assertEquals((Object)e.getViewName(), (Object)temporaryCreateView);
        }
        try (Transaction transaction = this.newTransaction();){
            metadata = transaction.getMetadata();
            metadata.dropView(this.newSession(), temporaryCreateView);
            transaction.commit();
        }
        transaction = this.newTransaction();
        try {
            metadata = transaction.getMetadata();
            org.assertj.core.api.Assertions.assertThat((Optional)metadata.getView(this.newSession(), temporaryCreateView)).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Map)metadata.getViews(this.newSession(), Optional.of(temporaryCreateView.getSchemaName()))).doesNotContainKey((Object)temporaryCreateView);
            org.assertj.core.api.Assertions.assertThat((List)metadata.listViews(this.newSession(), Optional.of(temporaryCreateView.getSchemaName()))).doesNotContain((Object[])new SchemaTableName[]{temporaryCreateView});
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        try {
            transaction = this.newTransaction();
            try {
                metadata = transaction.getMetadata();
                metadata.dropView(this.newSession(), temporaryCreateView);
                Assert.fail((String)"drop non-existing should fail");
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        catch (ViewNotFoundException e) {
            Assert.assertEquals((Object)e.getViewName(), (Object)temporaryCreateView);
        }
        this.doCreateView(temporaryCreateView, false);
    }

    private void doCreateView(SchemaTableName viewName, boolean replace) {
        String viewData = "test data";
        ConnectorViewDefinition definition = new ConnectorViewDefinition(viewData, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), true);
        try (Transaction transaction = this.newTransaction();){
            transaction.getMetadata().createView(this.newSession(), viewName, definition, replace);
            transaction.commit();
        }
        transaction = this.newTransaction();
        try {
            ConnectorMetadata metadata = transaction.getMetadata();
            org.assertj.core.api.Assertions.assertThat((Optional)metadata.getView(this.newSession(), viewName)).map(ConnectorViewDefinition::getOriginalSql).contains((Object)viewData);
            Map views = metadata.getViews(this.newSession(), Optional.of(viewName.getSchemaName()));
            Assert.assertEquals((int)views.size(), (int)1);
            Assert.assertEquals((String)((ConnectorViewDefinition)views.get(viewName)).getOriginalSql(), (String)definition.getOriginalSql());
            Assert.assertTrue((boolean)metadata.listViews(this.newSession(), Optional.of(viewName.getSchemaName())).contains(viewName));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    protected void doCreateTable(SchemaTableName tableName, HiveStorageFormat storageFormat) throws Exception {
        String queryId;
        ConnectorMetadata metadata;
        ConnectorSession session;
        try (Transaction transaction = this.newTransaction();){
            session = this.newSession();
            metadata = transaction.getMetadata();
            queryId = session.getQueryId();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, CREATE_TABLE_COLUMNS, AbstractTestHive.createTableProperties(storageFormat));
            ConnectorOutputTableHandle outputHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, outputHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            sink.appendPage(CREATE_TABLE_DATA.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            HdfsContext context = new HdfsContext(session);
            for (String filePath : this.listAllDataFiles(context, this.getStagingPathRoot(outputHandle))) {
                org.assertj.core.api.Assertions.assertThat((String)new org.apache.hadoop.fs.Path(filePath).getName()).startsWith((CharSequence)session.getQueryId());
            }
            metadata.finishCreateTable(session, outputHandle, fragments, (Collection)ImmutableList.of());
            transaction.commit();
        }
        transaction = this.newTransaction();
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, this.getTableHandle(metadata, tableName));
            Assert.assertEquals(AbstractTestHive.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), CREATE_TABLE_COLUMNS);
            MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)CREATE_TABLE_DATA.getMaterializedRows());
            Table table = (Table)this.getMetastoreClient().getTable(tableName.getSchemaName(), tableName.getTableName()).get();
            Assert.assertEquals((String)((String)table.getParameters().get("presto_version")), (String)TEST_SERVER_VERSION);
            Assert.assertEquals((String)((String)table.getParameters().get("presto_query_id")), (String)queryId);
            HiveBasicStatistics statistics = AbstractTestHive.getBasicStatisticsForTable(transaction, tableName);
            Assert.assertEquals((long)statistics.getRowCount().getAsLong(), (long)CREATE_TABLE_DATA.getRowCount());
            Assert.assertEquals((long)statistics.getFileCount().getAsLong(), (long)1L);
            Assertions.assertGreaterThan((Comparable)Long.valueOf(statistics.getInMemoryDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
            Assertions.assertGreaterThan((Comparable)Long.valueOf(statistics.getOnDiskDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    protected void doCreateEmptyTable(SchemaTableName tableName, HiveStorageFormat storageFormat, List<ColumnMetadata> createTableColumns) throws Exception {
        List<String> partitionedBy = createTableColumns.stream().map(ColumnMetadata::getName).filter(PARTITION_COLUMN_FILTER).collect(Collectors.toList());
        this.doCreateEmptyTable(tableName, storageFormat, createTableColumns, partitionedBy);
    }

    protected void doCreateEmptyTable(SchemaTableName tableName, HiveStorageFormat storageFormat, List<ColumnMetadata> createTableColumns, List<String> partitionedBy) throws Exception {
        String queryId;
        ConnectorMetadata metadata;
        ConnectorSession session;
        try (Transaction transaction = this.newTransaction();){
            session = this.newSession();
            metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            queryId = session.getQueryId();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, createTableColumns, AbstractTestHive.createTableProperties(storageFormat, partitionedBy));
            metadata.createTable(session, tableMetadata, false);
            transaction.commit();
        }
        transaction = this.newTransaction();
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, this.getTableHandle(metadata, tableName));
            List expectedColumns = createTableColumns.stream().map(column -> ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setComment(Optional.ofNullable(column.getComment())).setExtraInfo(Optional.ofNullable(HiveUtil.columnExtraInfo((boolean)partitionedBy.contains(column.getName())))).build()).collect(Collectors.toList());
            Assert.assertEquals(AbstractTestHive.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), expectedColumns);
            Table table = (Table)transaction.getMetastore().getTable(tableName.getSchemaName(), tableName.getTableName()).get();
            Assert.assertEquals((String)table.getStorage().getStorageFormat().getInputFormat(), (String)storageFormat.getInputFormat());
            Assert.assertEquals((String)((String)table.getParameters().get("presto_version")), (String)TEST_SERVER_VERSION);
            Assert.assertEquals((String)((String)table.getParameters().get("presto_query_id")), (String)queryId);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            Assert.assertEquals((int)result.getRowCount(), (int)0);
            if (partitionedBy.isEmpty()) {
                HiveBasicStatistics statistics = AbstractTestHive.getBasicStatisticsForTable(transaction, tableName);
                Assert.assertEquals((long)statistics.getRowCount().getAsLong(), (long)0L);
                Assert.assertEquals((long)statistics.getFileCount().getAsLong(), (long)0L);
                Assert.assertEquals((long)statistics.getInMemoryDataSizeInBytes().getAsLong(), (long)0L);
                Assert.assertEquals((long)statistics.getOnDiskDataSizeInBytes().getAsLong(), (long)0L);
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void doInsert(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        Location stagingPathRoot;
        Set<String> existingFiles;
        Transaction transaction;
        this.doCreateEmptyTable(tableName, storageFormat, CREATE_TABLE_COLUMNS);
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)CREATE_TABLE_DATA.getTypes());
        for (int i = 0; i < 3; ++i) {
            this.insertData(tableName, CREATE_TABLE_DATA);
            transaction = this.newTransaction();
            try {
                ConnectorSession session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                metadata.beginQuery(session);
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
                ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, this.getTableHandle(metadata, tableName));
                Assert.assertEquals(AbstractTestHive.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), CREATE_TABLE_COLUMNS);
                resultBuilder.rows(CREATE_TABLE_DATA.getMaterializedRows());
                MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)resultBuilder.build().getMaterializedRows());
                HiveBasicStatistics tableStatistics = AbstractTestHive.getBasicStatisticsForTable(transaction, tableName);
                Assert.assertEquals((long)tableStatistics.getRowCount().orElse(0L), (long)((long)CREATE_TABLE_DATA.getRowCount() * ((long)i + 1L)));
                Assert.assertEquals((long)tableStatistics.getFileCount().getAsLong(), (long)((long)i + 1L));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(tableStatistics.getInMemoryDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(tableStatistics.getOnDiskDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                continue;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        transaction = this.newTransaction();
        try {
            existingFiles = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertFalse((boolean)existingFiles.isEmpty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        try (Transaction transaction2 = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction2.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session, tableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction2.getTransactionHandle(), session, insertTableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            sink.appendPage(CREATE_TABLE_DATA.toPage());
            sink.appendPage(CREATE_TABLE_DATA.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session, insertTableHandle, fragments, (Collection)ImmutableList.of());
            HiveBasicStatistics tableStatistics = AbstractTestHive.getBasicStatisticsForTable(transaction2, tableName);
            Assert.assertEquals((long)tableStatistics.getRowCount().getAsLong(), (long)((long)CREATE_TABLE_DATA.getRowCount() * 5L));
            try (Transaction otherTransaction = this.newTransaction();){
                HiveBasicStatistics otherTableStatistics = AbstractTestHive.getBasicStatisticsForTable(otherTransaction, tableName);
                Assert.assertEquals((long)otherTableStatistics.getRowCount().getAsLong(), (long)((long)CREATE_TABLE_DATA.getRowCount() * 3L));
            }
            Assert.assertEquals(this.listAllDataFiles(transaction2, tableName.getSchemaName(), tableName.getTableName()), existingFiles);
            stagingPathRoot = this.getStagingPathRoot(insertTableHandle);
            HdfsContext context = new HdfsContext(session);
            Set<String> tempFiles = this.listAllDataFiles(context, stagingPathRoot);
            Assert.assertTrue((!tempFiles.isEmpty() ? 1 : 0) != 0);
            for (String filePath : tempFiles) {
                org.assertj.core.api.Assertions.assertThat((String)new org.apache.hadoop.fs.Path(filePath).getName()).startsWith((CharSequence)session.getQueryId());
            }
            transaction2.rollback();
        }
        HdfsContext context = new HdfsContext(this.newSession());
        Assert.assertTrue((boolean)this.listAllDataFiles(context, stagingPathRoot).isEmpty());
        try (Transaction transaction3 = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction3.getMetadata();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction3, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)resultBuilder.build().getMaterializedRows());
            Assert.assertEquals(this.listAllDataFiles(transaction3, tableName.getSchemaName(), tableName.getTableName()), existingFiles);
        }
        transaction3 = this.newTransaction();
        try {
            HiveBasicStatistics statistics = AbstractTestHive.getBasicStatisticsForTable(transaction3, tableName);
            Assert.assertEquals((long)statistics.getRowCount().getAsLong(), (long)((long)CREATE_TABLE_DATA.getRowCount() * 3L));
            Assert.assertEquals((long)statistics.getFileCount().getAsLong(), (long)3L);
        }
        finally {
            if (transaction3 != null) {
                transaction3.close();
            }
        }
    }

    private void doInsertOverwriteUnpartitioned(SchemaTableName tableName) throws Exception {
        Location stagingPathRoot;
        Set<String> existingFiles;
        Transaction transaction;
        this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, CREATE_TABLE_COLUMNS);
        this.insertData(tableName, CREATE_TABLE_DATA);
        MaterializedResult.Builder overwriteDataBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)CREATE_TABLE_DATA.getTypes());
        MaterializedResult overwriteData = null;
        ImmutableMap overwriteProperties = ImmutableMap.of((Object)"insert_existing_partitions_behavior", (Object)"OVERWRITE");
        for (int i = 0; i < 3; ++i) {
            overwriteDataBuilder.rows(Lists.reverse((List)CREATE_TABLE_DATA.getMaterializedRows()));
            overwriteData = overwriteDataBuilder.build();
            this.insertData(tableName, overwriteData, (Map<String, Object>)overwriteProperties);
            transaction = this.newTransaction();
            try {
                ConnectorSession session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                metadata.beginQuery(session);
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
                ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, this.getTableHandle(metadata, tableName));
                Assert.assertEquals(AbstractTestHive.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), CREATE_TABLE_COLUMNS);
                MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)overwriteData.getMaterializedRows());
                HiveBasicStatistics tableStatistics = AbstractTestHive.getBasicStatisticsForTable(transaction, tableName);
                Assert.assertEquals((long)tableStatistics.getRowCount().getAsLong(), (long)overwriteData.getRowCount());
                Assert.assertEquals((long)tableStatistics.getFileCount().getAsLong(), (long)1L);
                Assertions.assertGreaterThan((Comparable)Long.valueOf(tableStatistics.getInMemoryDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(tableStatistics.getOnDiskDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                continue;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        transaction = this.newTransaction();
        try {
            existingFiles = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertFalse((boolean)existingFiles.isEmpty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        try (Transaction transaction2 = this.newTransaction();){
            ConnectorSession session = this.newSession((Map<String, Object>)overwriteProperties);
            ConnectorMetadata metadata = transaction2.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session, tableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction2.getTransactionHandle(), session, insertTableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            for (int i = 0; i < 4; ++i) {
                sink.appendPage(overwriteData.toPage());
            }
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session, insertTableHandle, fragments, (Collection)ImmutableList.of());
            HiveBasicStatistics tableStatistics = AbstractTestHive.getBasicStatisticsForTable(transaction2, tableName);
            Assert.assertEquals((long)tableStatistics.getRowCount().getAsLong(), (long)((long)overwriteData.getRowCount() * 4L));
            try (Transaction otherTransaction = this.newTransaction();){
                HiveBasicStatistics otherTableStatistics = AbstractTestHive.getBasicStatisticsForTable(otherTransaction, tableName);
                Assert.assertEquals((long)otherTableStatistics.getRowCount().getAsLong(), (long)overwriteData.getRowCount());
            }
            Assert.assertEquals(this.listAllDataFiles(transaction2, tableName.getSchemaName(), tableName.getTableName()), existingFiles);
            stagingPathRoot = this.getStagingPathRoot(insertTableHandle);
            HdfsContext context = new HdfsContext(session);
            Set<String> tempFiles = this.listAllDataFiles(context, stagingPathRoot);
            Assert.assertTrue((!tempFiles.isEmpty() ? 1 : 0) != 0);
            for (String filePath : tempFiles) {
                org.assertj.core.api.Assertions.assertThat((String)new org.apache.hadoop.fs.Path(filePath).getName()).startsWith((CharSequence)session.getQueryId());
            }
            transaction2.rollback();
        }
        HdfsContext context = new HdfsContext(this.newSession());
        Assert.assertTrue((boolean)this.listAllDataFiles(context, stagingPathRoot).isEmpty());
        try (Transaction transaction3 = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction3.getMetadata();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction3, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)overwriteData.getMaterializedRows());
            Assert.assertEquals(this.listAllDataFiles(transaction3, tableName.getSchemaName(), tableName.getTableName()), existingFiles);
        }
        transaction3 = this.newTransaction();
        try {
            HiveBasicStatistics statistics = AbstractTestHive.getBasicStatisticsForTable(transaction3, tableName);
            Assert.assertEquals((long)statistics.getRowCount().getAsLong(), (long)overwriteData.getRowCount());
            Assert.assertEquals((long)statistics.getFileCount().getAsLong(), (long)1L);
        }
        finally {
            if (transaction3 != null) {
                transaction3.close();
            }
        }
    }

    private Location getStagingPathRoot(ConnectorInsertTableHandle insertTableHandle) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)insertTableHandle;
        LocationService.WriteInfo writeInfo = this.getLocationService().getQueryWriteInfo(handle.getLocationHandle());
        if (writeInfo.writeMode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) {
            throw new AssertionError((Object)"writeMode is not STAGE_AND_MOVE_TO_TARGET_DIRECTORY");
        }
        return writeInfo.writePath();
    }

    private Location getStagingPathRoot(ConnectorOutputTableHandle outputTableHandle) {
        HiveOutputTableHandle handle = (HiveOutputTableHandle)outputTableHandle;
        return this.getLocationService().getQueryWriteInfo(handle.getLocationHandle()).writePath();
    }

    private Location getTargetPathRoot(ConnectorInsertTableHandle insertTableHandle) {
        HiveInsertTableHandle hiveInsertTableHandle = (HiveInsertTableHandle)insertTableHandle;
        return this.getLocationService().getQueryWriteInfo(hiveInsertTableHandle.getLocationHandle()).targetPath();
    }

    protected Set<String> listAllDataFiles(Transaction transaction, String schemaName, String tableName) throws IOException {
        HdfsContext hdfsContext = new HdfsContext(this.newSession());
        HashSet<String> existingFiles = new HashSet<String>();
        for (String location : AbstractTestHive.listAllDataPaths(transaction.getMetastore(), schemaName, tableName)) {
            existingFiles.addAll(this.listAllDataFiles(hdfsContext, Location.of((String)location)));
        }
        return existingFiles;
    }

    public static List<String> listAllDataPaths(SemiTransactionalHiveMetastore metastore, String schemaName, String tableName) {
        Optional partitionNames;
        ImmutableList.Builder locations = ImmutableList.builder();
        Table table = (Table)metastore.getTable(schemaName, tableName).get();
        if (table.getStorage().getLocation() != null) {
            locations.add((Object)table.getStorage().getLocation());
        }
        if ((partitionNames = metastore.getPartitionNames(schemaName, tableName)).isPresent()) {
            metastore.getPartitionsByNames(schemaName, tableName, (List)partitionNames.get()).values().stream().map(Optional::get).map(partition -> partition.getStorage().getLocation()).filter(location -> !location.startsWith(table.getStorage().getLocation())).forEach(arg_0 -> ((ImmutableList.Builder)locations).add(arg_0));
        }
        return locations.build();
    }

    protected Set<String> listAllDataFiles(HdfsContext context, Location location) throws IOException {
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(location.toString());
        HashSet<String> result = new HashSet<String>();
        FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, path);
        if (fileSystem.exists(path)) {
            for (FileStatus fileStatus : fileSystem.listStatus(path)) {
                if (fileStatus.getPath().getName().startsWith(".trino")) continue;
                if (fileStatus.isFile()) {
                    result.add(fileStatus.getPath().toString());
                    continue;
                }
                if (!fileStatus.isDirectory()) continue;
                result.addAll(this.listAllDataFiles(context, Location.of((String)fileStatus.getPath().toString())));
            }
        }
        return result;
    }

    private void doInsertIntoNewPartition(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        Location stagingPathRoot;
        ConnectorTableHandle tableHandle;
        ConnectorMetadata metadata;
        ConnectorSession session;
        Set<String> existingFiles;
        this.doCreateEmptyTable(tableName, storageFormat, CREATE_TABLE_COLUMNS_PARTITIONED);
        String queryId = this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
        try (Transaction transaction = this.newTransaction();){
            Table table = (Table)this.metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
            List partitionNames = (List)transaction.getMetastore().getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)partitionNames, (Iterable)((Iterable)CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows().stream().map(row -> "ds=" + row.getField(CREATE_TABLE_PARTITIONED_DATA.getTypes().size() - 1)).collect(ImmutableList.toImmutableList())));
            Map partitions = this.getMetastoreClient().getPartitionsByNames(table, partitionNames);
            Assert.assertEquals((int)partitions.size(), (int)partitionNames.size());
            for (String partitionName : partitionNames) {
                Partition partition = (Partition)((Optional)partitions.get(partitionName)).get();
                Assert.assertEquals((String)((String)partition.getParameters().get("presto_version")), (String)TEST_SERVER_VERSION);
                Assert.assertEquals((String)((String)partition.getParameters().get("presto_query_id")), (String)queryId);
            }
            ConnectorSession session2 = this.newSession();
            ConnectorMetadata metadata2 = transaction.getMetadata();
            metadata2.beginQuery(session2);
            ConnectorTableHandle tableHandle2 = this.getTableHandle(metadata2, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata2.getColumnHandles(session2, tableHandle2).values());
            MaterializedResult result = this.readTable(transaction, tableHandle2, columnHandles, session2, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows());
            existingFiles = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertFalse((boolean)existingFiles.isEmpty());
            for (String partitionName : partitionNames) {
                HiveBasicStatistics partitionStatistics = AbstractTestHive.getBasicStatisticsForPartition(transaction, tableName, COLUMN_NAMES_PARTITIONED, partitionName);
                Assert.assertEquals((long)partitionStatistics.getRowCount().getAsLong(), (long)1L);
                Assert.assertEquals((long)partitionStatistics.getFileCount().getAsLong(), (long)1L);
                Assertions.assertGreaterThan((Comparable)Long.valueOf(partitionStatistics.getInMemoryDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(partitionStatistics.getOnDiskDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
            }
        }
        try (Transaction transaction = this.newTransaction();){
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session, tableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES);
            stagingPathRoot = this.getStagingPathRoot(insertTableHandle);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            sink.appendPage(CREATE_TABLE_PARTITIONED_DATA_2ND.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session, insertTableHandle, fragments, (Collection)ImmutableList.of());
            HdfsContext context = new HdfsContext(session);
            Set<String> tempFiles = this.listAllDataFiles(context, this.getStagingPathRoot(insertTableHandle));
            Assert.assertTrue((!tempFiles.isEmpty() ? 1 : 0) != 0);
            for (String filePath : tempFiles) {
                org.assertj.core.api.Assertions.assertThat((String)new org.apache.hadoop.fs.Path(filePath).getName()).startsWith((CharSequence)session.getQueryId());
            }
            transaction.rollback();
        }
        transaction = this.newTransaction();
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows());
            Assert.assertEquals(this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName()), existingFiles);
            HdfsContext context = new HdfsContext(session);
            Assert.assertTrue((boolean)this.listAllDataFiles(context, stagingPathRoot).isEmpty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void doInsertUnsupportedWriteType(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        ImmutableList columns = ImmutableList.of((Object)new Column("dummy", HiveType.valueOf((String)"uniontype<smallint,tinyint>"), Optional.empty()));
        ImmutableList partitionColumns = ImmutableList.of((Object)new Column("name", HiveType.HIVE_STRING, Optional.empty()));
        this.createEmptyTable(tableName, storageFormat, (List<Column>)columns, (List<Column>)partitionColumns);
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            metadata.beginInsert(session, tableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES);
            Assert.fail((String)"expected failure");
        }
        catch (TrinoException e) {
            org.assertj.core.api.Assertions.assertThat((Throwable)e).hasMessageMatching("Inserting into Hive table .* with column type uniontype<smallint,tinyint> not supported");
        }
    }

    private void doInsertIntoExistingPartition(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        Location stagingPathRoot;
        ConnectorTableHandle tableHandle;
        Set<String> existingFiles;
        ConnectorSession session;
        MaterializedResult result;
        List<ColumnHandle> columnHandles;
        ConnectorMetadata metadata;
        this.doCreateEmptyTable(tableName, storageFormat, CREATE_TABLE_COLUMNS_PARTITIONED);
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)CREATE_TABLE_PARTITIONED_DATA.getTypes());
        for (int i = 0; i < 3; ++i) {
            this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
            try (Transaction transaction = this.newTransaction();){
                ConnectorSession session2 = this.newSession();
                metadata = transaction.getMetadata();
                metadata.beginQuery(session2);
                ConnectorTableHandle tableHandle2 = this.getTableHandle(metadata, tableName);
                List partitionNames = (List)transaction.getMetastore().getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)partitionNames, (Iterable)((Iterable)CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows().stream().map(row -> "ds=" + row.getField(CREATE_TABLE_PARTITIONED_DATA.getTypes().size() - 1)).collect(ImmutableList.toImmutableList())));
                columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session2, tableHandle2).values());
                resultBuilder.rows(CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows());
                result = this.readTable(transaction, tableHandle2, columnHandles, session2, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)resultBuilder.build().getMaterializedRows());
                for (String partitionName : partitionNames) {
                    HiveBasicStatistics statistics = AbstractTestHive.getBasicStatisticsForPartition(transaction, tableName, COLUMN_NAMES_PARTITIONED, partitionName);
                    Assert.assertEquals((long)statistics.getRowCount().getAsLong(), (long)((long)i + 1L));
                    Assert.assertEquals((long)statistics.getFileCount().getAsLong(), (long)((long)i + 1L));
                    Assertions.assertGreaterThan((Comparable)Long.valueOf(statistics.getInMemoryDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                    Assertions.assertGreaterThan((Comparable)Long.valueOf(statistics.getOnDiskDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                }
                continue;
            }
        }
        try (Transaction transaction = this.newTransaction();){
            metadata = transaction.getMetadata();
            session = this.newSession();
            existingFiles = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertFalse((boolean)existingFiles.isEmpty());
            tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session, tableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES);
            stagingPathRoot = this.getStagingPathRoot(insertTableHandle);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            sink.appendPage(CREATE_TABLE_PARTITIONED_DATA.toPage());
            sink.appendPage(CREATE_TABLE_PARTITIONED_DATA.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session, insertTableHandle, fragments, (Collection)ImmutableList.of());
            HdfsContext context = new HdfsContext(session);
            Set<String> tempFiles = this.listAllDataFiles(context, this.getStagingPathRoot(insertTableHandle));
            Assert.assertTrue((!tempFiles.isEmpty() ? 1 : 0) != 0);
            for (String string : tempFiles) {
                org.assertj.core.api.Assertions.assertThat((String)new org.apache.hadoop.fs.Path(string).getName()).startsWith((CharSequence)session.getQueryId());
            }
            List partitionNames = (List)transaction.getMetastore().getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            for (String partitionName : partitionNames) {
                HiveBasicStatistics partitionStatistics = AbstractTestHive.getBasicStatisticsForPartition(transaction, tableName, COLUMN_NAMES_PARTITIONED, partitionName);
                Assert.assertEquals((long)partitionStatistics.getRowCount().getAsLong(), (long)5L);
            }
            transaction.rollback();
        }
        transaction = this.newTransaction();
        try {
            metadata = transaction.getMetadata();
            session = this.newSession();
            metadata.beginQuery(session);
            tableHandle = this.getTableHandle(metadata, tableName);
            columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)resultBuilder.build().getMaterializedRows());
            Assert.assertEquals(this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName()), existingFiles);
            HdfsContext hdfsContext = new HdfsContext(session);
            Assert.assertTrue((boolean)this.listAllDataFiles(hdfsContext, stagingPathRoot).isEmpty());
            List partitionNames = (List)transaction.getMetastore().getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            for (String partitionName : partitionNames) {
                HiveBasicStatistics hiveBasicStatistics = AbstractTestHive.getBasicStatisticsForPartition(transaction, tableName, COLUMN_NAMES_PARTITIONED, partitionName);
                Assert.assertEquals((long)hiveBasicStatistics.getRowCount().getAsLong(), (long)3L);
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void doInsertIntoExistingPartitionEmptyStatistics(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        this.doCreateEmptyTable(tableName, storageFormat, CREATE_TABLE_COLUMNS_PARTITIONED);
        this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
        this.eraseStatistics(tableName);
        this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
        try (Transaction transaction = this.newTransaction();){
            List partitionNames = (List)transaction.getMetastore().getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            for (String partitionName : partitionNames) {
                HiveBasicStatistics statistics = AbstractTestHive.getBasicStatisticsForPartition(transaction, tableName, COLUMN_NAMES_PARTITIONED, partitionName);
                org.assertj.core.api.Assertions.assertThat((OptionalLong)statistics.getRowCount()).isNotPresent();
                org.assertj.core.api.Assertions.assertThat((OptionalLong)statistics.getInMemoryDataSizeInBytes()).isNotPresent();
            }
        }
    }

    private static HiveBasicStatistics getBasicStatisticsForTable(Transaction transaction, SchemaTableName table) {
        return transaction.getMetastore().getTableStatistics(table.getSchemaName(), table.getTableName(), Optional.empty()).getBasicStatistics();
    }

    private static HiveBasicStatistics getBasicStatisticsForPartition(Transaction transaction, SchemaTableName table, Set<String> columns, String partitionName) {
        return ((PartitionStatistics)transaction.getMetastore().getPartitionStatistics(table.getSchemaName(), table.getTableName(), columns, (Set)ImmutableSet.of((Object)partitionName)).get(partitionName)).getBasicStatistics();
    }

    private void eraseStatistics(SchemaTableName schemaTableName) {
        HiveMetastore metastoreClient = this.getMetastoreClient();
        metastoreClient.updateTableStatistics(schemaTableName.getSchemaName(), schemaTableName.getTableName(), AcidTransaction.NO_ACID_TRANSACTION, statistics -> new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of()));
        Table table = (Table)metastoreClient.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        List partitionColumns = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        if (!table.getPartitionColumns().isEmpty()) {
            List partitionNames = (List)metastoreClient.getPartitionNamesByFilter(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionColumns, TupleDomain.all()).orElse(ImmutableList.of());
            List partitions = (List)metastoreClient.getPartitionsByNames(table, partitionNames).values().stream().filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
            for (Partition partition : partitions) {
                metastoreClient.updatePartitionStatistics(table, FileUtils.makePartName((List)partitionColumns, (List)partition.getValues()), statistics -> new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of()));
            }
        }
    }

    private String insertData(SchemaTableName tableName, MaterializedResult data) throws Exception {
        return this.insertData(tableName, data, (Map<String, Object>)ImmutableMap.of());
    }

    private String insertData(SchemaTableName tableName, MaterializedResult data, Map<String, Object> sessionProperties) throws Exception {
        Location targetPath;
        Location writePath;
        String queryId;
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession(sessionProperties);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session, tableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES);
            queryId = session.getQueryId();
            writePath = this.getStagingPathRoot(insertTableHandle);
            targetPath = this.getTargetPathRoot(insertTableHandle);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            sink.appendPage(data.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session, insertTableHandle, fragments, (Collection)ImmutableList.of());
            transaction.commit();
        }
        if (!writePath.equals((Object)targetPath)) {
            HdfsContext context = new HdfsContext(this.newSession());
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, new org.apache.hadoop.fs.Path(writePath.toString()));
            Assert.assertFalse((boolean)fileSystem.exists(new org.apache.hadoop.fs.Path(writePath.toString())));
        }
        return queryId;
    }

    private void doTestMetadataDelete(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        ImmutableList columnHandles;
        HiveColumnHandle dsColumnHandle;
        ConnectorTableHandle tableHandle;
        ConnectorMetadata metadata;
        ConnectorSession session;
        this.doCreateEmptyTable(tableName, storageFormat, CREATE_TABLE_COLUMNS_PARTITIONED);
        this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
        MaterializedResult.Builder expectedResultBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)CREATE_TABLE_PARTITIONED_DATA.getTypes());
        expectedResultBuilder.rows(CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows());
        try (Transaction transaction = this.newTransaction();){
            session = this.newSession();
            metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            List partitionNames = (List)transaction.getMetastore().getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)partitionNames, (Iterable)((Iterable)CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows().stream().map(row -> "ds=" + row.getField(CREATE_TABLE_PARTITIONED_DATA.getTypes().size() - 1)).collect(ImmutableList.toImmutableList())));
            Set<String> filesAfterInsert = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertFalse((boolean)filesAfterInsert.isEmpty());
            ConnectorTableHandle tableHandle2 = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles2 = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle2).values());
            MaterializedResult result = this.readTable(transaction, tableHandle2, columnHandles2, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)expectedResultBuilder.build().getMaterializedRows());
        }
        transaction = this.newTransaction();
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, tableName);
            dsColumnHandle = (HiveColumnHandle)metadata.getColumnHandles(session, tableHandle).get("ds");
            session = this.newSession();
            TupleDomain tupleDomain = TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)dsColumnHandle, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2015-07-03"))));
            Constraint constraint = new Constraint(tupleDomain, tupleDomain.asPredicate(), ((Map)tupleDomain.getDomains().orElseThrow()).keySet());
            tableHandle = this.applyFilter(metadata, tableHandle, constraint);
            tableHandle = (ConnectorTableHandle)metadata.applyDelete(session, tableHandle).get();
            metadata.executeDelete(session, tableHandle);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.newTransaction();
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            tableHandle = this.getTableHandle(metadata, tableName);
            columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            HiveColumnHandle dsColumnHandle2 = (HiveColumnHandle)metadata.getColumnHandles(session, tableHandle).get("ds");
            int dsColumnOrdinalPosition = columnHandles.indexOf(dsColumnHandle2);
            ImmutableList expectedRows = (ImmutableList)expectedResultBuilder.build().getMaterializedRows().stream().filter(row -> !"2015-07-03".equals(row.getField(dsColumnOrdinalPosition))).collect(ImmutableList.toImmutableList());
            MaterializedResult actualAfterDelete = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterDelete.getMaterializedRows(), (Iterable)expectedRows);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.newTransaction();
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, tableName);
            dsColumnHandle = (HiveColumnHandle)metadata.getColumnHandles(session, tableHandle).get("ds");
            session = this.newSession();
            TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dsColumnHandle, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2015-07-01"), (boolean)true, (Object)Slices.utf8Slice((String)"2015-07-02"), (boolean)true), (Range[])new Range[0]), (boolean)false)));
            Constraint constraint2 = new Constraint(tupleDomain2, tupleDomain2.asPredicate(), ((Map)tupleDomain2.getDomains().orElseThrow()).keySet());
            tableHandle = this.applyFilter(metadata, tableHandle, constraint2);
            tableHandle = (ConnectorTableHandle)metadata.applyDelete(session, tableHandle).get();
            metadata.executeDelete(session, tableHandle);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.newTransaction();
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, tableName);
            columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            session = this.newSession();
            MaterializedResult actualAfterDelete2 = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterDelete2.getMaterializedRows(), (Iterable)ImmutableList.of());
            Set<String> filesAfterDelete = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertTrue((boolean)filesAfterDelete.isEmpty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    protected void assertGetRecords(String tableName, HiveStorageFormat hiveStorageFormat) throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, new SchemaTableName(this.database, tableName));
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, tableHandle);
            HiveSplit hiveSplit = this.getHiveSplit(tableHandle, transaction, session);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, (ConnectorSplit)hiveSplit, tableHandle, (List)columnHandles, DynamicFilter.EMPTY);
            this.assertGetRecords(hiveStorageFormat, tableMetadata, hiveSplit, pageSource, (List<? extends ColumnHandle>)columnHandles);
        }
    }

    protected HiveSplit getHiveSplit(ConnectorTableHandle tableHandle, Transaction transaction, ConnectorSession session) {
        List<ConnectorSplit> splits = this.getAllSplits(tableHandle, transaction, session);
        Assert.assertEquals((int)splits.size(), (int)1);
        return (HiveSplit)Iterables.getOnlyElement(splits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertGetRecords(HiveStorageFormat hiveStorageFormat, ConnectorTableMetadata tableMetadata, HiveSplit hiveSplit, ConnectorPageSource pageSource, List<? extends ColumnHandle> columnHandles) throws IOException {
        try {
            MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)this.newSession(), (ConnectorPageSource)pageSource, HiveTestUtils.getTypes(columnHandles));
            AbstractTestHive.assertPageSourceType(pageSource, hiveStorageFormat);
            ImmutableMap<String, Integer> columnIndex = AbstractTestHive.indexColumns(tableMetadata);
            long rowNumber = 0L;
            long completedBytes = 0L;
            for (MaterializedRow row : result) {
                ImmutableList expected2;
                ImmutableList expected1;
                SqlTimestamp expected;
                try {
                    AbstractTestHive.assertValueTypes(row, tableMetadata.getColumns());
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("row " + rowNumber, e);
                }
                Integer index = (Integer)columnIndex.get((Object)"t_string");
                Object value = row.getField(index.intValue());
                if (++rowNumber % 19L == 0L) {
                    Assert.assertNull((Object)value);
                } else if (rowNumber % 19L == 1L) {
                    Assert.assertEquals((Object)value, (Object)"");
                } else {
                    Assert.assertEquals((Object)value, (Object)"test");
                }
                Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get((Object)"t_tinyint")).intValue()), (Object)((byte)(1L + rowNumber)));
                Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get((Object)"t_smallint")).intValue()), (Object)((short)(2L + rowNumber)));
                Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get((Object)"t_int")).intValue()), (Object)((int)(3L + rowNumber)));
                index = (Integer)columnIndex.get((Object)"t_bigint");
                if (rowNumber % 13L == 0L) {
                    Assert.assertNull((Object)row.getField(index.intValue()));
                } else {
                    Assert.assertEquals((Object)row.getField(index.intValue()), (Object)(4L + rowNumber));
                }
                Assert.assertEquals((double)((Float)row.getField(((Integer)columnIndex.get((Object)"t_float")).intValue())).floatValue(), (double)(5.1f + (float)rowNumber), (double)0.001);
                Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get((Object)"t_double")).intValue()), (Object)(6.2 + (double)rowNumber));
                index = (Integer)columnIndex.get((Object)"t_boolean");
                if (rowNumber % 3L == 2L) {
                    Assert.assertNull((Object)row.getField(index.intValue()));
                } else {
                    Assert.assertEquals((Object)row.getField(index.intValue()), (Object)(rowNumber % 3L != 0L ? 1 : 0));
                }
                index = (Integer)columnIndex.get((Object)"t_timestamp");
                if (index != null) {
                    if (rowNumber % 17L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        expected = DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2011, (int)5, (int)6, (int)7, (int)8, (int)9, (int)123);
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)expected);
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_binary")) != null) {
                    if (rowNumber % 23L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)new SqlVarbinary("test binary".getBytes(StandardCharsets.UTF_8)));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_date")) != null) {
                    if (rowNumber % 37L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        expected = new SqlDate(Math.toIntExact(TimeUnit.MILLISECONDS.toDays(new DateTime(2013, 8, 9, 0, 0, 0, DateTimeZone.UTC).getMillis())));
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)expected);
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_varchar")) != null) {
                    value = row.getField(index.intValue());
                    if (rowNumber % 39L == 0L) {
                        Assert.assertNull((Object)value);
                    } else if (rowNumber % 39L == 1L) {
                        if (hiveStorageFormat == HiveStorageFormat.RCBINARY) {
                            Assert.assertNull((Object)value);
                        } else {
                            Assert.assertEquals((Object)value, (Object)"");
                        }
                    } else {
                        Assert.assertEquals((Object)value, (Object)"test varchar");
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_char")) != null) {
                    value = row.getField(index.intValue());
                    if (rowNumber % 41L == 0L) {
                        Assert.assertNull((Object)value);
                    } else {
                        Assert.assertEquals((Object)value, (Object)(rowNumber % 41L == 1L ? "                         " : "test char                "));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_map")) != null) {
                    if (rowNumber % 27L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)ImmutableMap.of((Object)"test key", (Object)"test value"));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_array_string")) != null) {
                    if (rowNumber % 29L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)ImmutableList.of((Object)"abc", (Object)"xyz", (Object)"data"));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_array_timestamp")) != null) {
                    if (rowNumber % 43L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        expected = DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.of(2011, 5, 6, 7, 8, 9, 123000000));
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)ImmutableList.of((Object)expected));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_array_struct")) != null) {
                    if (rowNumber % 31L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        expected1 = ImmutableList.of((Object)"test abc", (Object)0.1);
                        expected2 = ImmutableList.of((Object)"test xyz", (Object)0.2);
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)ImmutableList.of((Object)expected1, (Object)expected2));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_struct")) != null) {
                    if (rowNumber % 31L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        Assert.assertTrue((boolean)(row.getField(index.intValue()) instanceof List));
                        List values = (List)row.getField(index.intValue());
                        Assert.assertEquals((int)values.size(), (int)2);
                        Assert.assertEquals(values.get(0), (Object)"test abc");
                        Assert.assertEquals(values.get(1), (Object)0.1);
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_complex")) != null) {
                    if (rowNumber % 33L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        expected1 = ImmutableList.of((Object)"test abc", (Object)0.1);
                        expected2 = ImmutableList.of((Object)"test xyz", (Object)0.2);
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)expected1, (Object)expected2)));
                    }
                }
                Assert.assertNull((Object)row.getField(((Integer)columnIndex.get((Object)"new_column")).intValue()));
                long newCompletedBytes = pageSource.getCompletedBytes();
                Assert.assertTrue((newCompletedBytes >= completedBytes ? 1 : 0) != 0);
                Assertions.assertLessThanOrEqual((Comparable)Long.valueOf(newCompletedBytes), (Comparable)Long.valueOf(hiveSplit.getLength() + 102400L));
                completedBytes = newCompletedBytes;
            }
            Assertions.assertLessThanOrEqual((Comparable)Long.valueOf(completedBytes), (Comparable)Long.valueOf(hiveSplit.getLength() + 102400L));
            Assert.assertEquals((long)rowNumber, (long)100L);
        }
        finally {
            pageSource.close();
        }
    }

    protected void dropTable(SchemaTableName table) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle handle = metadata.getTableHandle(session, table);
            if (handle == null) {
                return;
            }
            metadata.dropTable(session, handle);
            try {
                metadata.dropTable(session, handle);
                Assert.fail((String)"expected NotFoundException");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            transaction.commit();
        }
    }

    protected ConnectorTableHandle getTableHandle(ConnectorMetadata metadata, SchemaTableName tableName) {
        ConnectorTableHandle handle = metadata.getTableHandle(this.newSession(), tableName);
        Preconditions.checkArgument((handle != null ? 1 : 0) != 0, (String)"table not found: %s", (Object)tableName);
        return handle;
    }

    private HiveTableHandle applyFilter(ConnectorMetadata metadata, ConnectorTableHandle tableHandle, Constraint constraint) {
        return metadata.applyFilter(this.newSession(), tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(HiveTableHandle.class::cast).orElseThrow(AssertionError::new);
    }

    protected MaterializedResult readTable(Transaction transaction, ConnectorTableHandle tableHandle, List<ColumnHandle> columnHandles, ConnectorSession session, TupleDomain<ColumnHandle> tupleDomain, OptionalInt expectedSplitCount, Optional<HiveStorageFormat> expectedStorageFormat) throws Exception {
        tableHandle = this.applyFilter(transaction.getMetadata(), tableHandle, new Constraint(tupleDomain));
        List<ConnectorSplit> splits = AbstractTestHive.getAllSplits(AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle));
        if (expectedSplitCount.isPresent()) {
            Assert.assertEquals((int)splits.size(), (int)expectedSplitCount.getAsInt());
        }
        ImmutableList.Builder allRows = ImmutableList.builder();
        for (ConnectorSplit split : splits) {
            ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, tableHandle, columnHandles, DynamicFilter.EMPTY);
            try {
                expectedStorageFormat.ifPresent(format -> AbstractTestHive.assertPageSourceType(pageSource, format));
                MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes(columnHandles));
                allRows.addAll((Iterable)result.getMaterializedRows());
            }
            finally {
                if (pageSource == null) continue;
                pageSource.close();
            }
        }
        return new MaterializedResult((List)allRows.build(), HiveTestUtils.getTypes(columnHandles));
    }

    protected HiveMetastore getMetastoreClient() {
        return this.metastoreClient;
    }

    protected LocationService getLocationService() {
        return this.locationService;
    }

    protected static int getSplitCount(ConnectorSplitSource splitSource) {
        int splitCount = 0;
        while (!splitSource.isFinished()) {
            splitCount += ((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)splitSource.getNextBatch(1000))).getSplits().size();
        }
        return splitCount;
    }

    private List<ConnectorSplit> getAllSplits(ConnectorTableHandle tableHandle, Transaction transaction, ConnectorSession session) {
        return AbstractTestHive.getAllSplits(AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle));
    }

    protected static List<ConnectorSplit> getAllSplits(ConnectorSplitSource splitSource) {
        ImmutableList.Builder splits = ImmutableList.builder();
        while (!splitSource.isFinished()) {
            splits.addAll((Iterable)((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)splitSource.getNextBatch(1000))).getSplits());
        }
        return splits.build();
    }

    protected static ConnectorSplitSource getSplits(ConnectorSplitManager splitManager, Transaction transaction, ConnectorSession session, ConnectorTableHandle tableHandle) {
        return splitManager.getSplits(transaction.getTransactionHandle(), session, tableHandle, DynamicFilter.EMPTY, Constraint.alwaysTrue());
    }

    protected String getPartitionId(Object partition) {
        return ((HivePartition)partition).getPartitionId();
    }

    protected static void assertPageSourceType(ConnectorPageSource pageSource, HiveStorageFormat hiveStorageFormat) {
        Assertions.assertInstanceOf((Object)((HivePageSource)pageSource).getPageSource(), AbstractTestHive.pageSourceType(hiveStorageFormat), (String)hiveStorageFormat.name());
    }

    private static Class<? extends ConnectorPageSource> pageSourceType(HiveStorageFormat hiveStorageFormat) {
        switch (hiveStorageFormat) {
            case RCTEXT: 
            case RCBINARY: {
                return RcFilePageSource.class;
            }
            case ORC: {
                return OrcPageSource.class;
            }
            case PARQUET: {
                return ParquetPageSource.class;
            }
            case CSV: 
            case JSON: 
            case OPENX_JSON: 
            case TEXTFILE: 
            case SEQUENCEFILE: {
                return LinePageSource.class;
            }
        }
        throw new AssertionError((Object)("File type does not use a PageSource: " + hiveStorageFormat));
    }

    private static void assertValueTypes(MaterializedRow row, List<ColumnMetadata> schema) {
        for (int columnIndex = 0; columnIndex < schema.size(); ++columnIndex) {
            ColumnMetadata column = schema.get(columnIndex);
            Object value = row.getField(columnIndex);
            if (value == null) continue;
            if (BooleanType.BOOLEAN.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Boolean.class);
                continue;
            }
            if (TinyintType.TINYINT.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Byte.class);
                continue;
            }
            if (SmallintType.SMALLINT.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Short.class);
                continue;
            }
            if (IntegerType.INTEGER.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Integer.class);
                continue;
            }
            if (BigintType.BIGINT.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Long.class);
                continue;
            }
            if (DoubleType.DOUBLE.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Double.class);
                continue;
            }
            if (RealType.REAL.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Float.class);
                continue;
            }
            if (column.getType() instanceof VarcharType) {
                Assertions.assertInstanceOf((Object)value, String.class);
                continue;
            }
            if (column.getType() instanceof CharType) {
                Assertions.assertInstanceOf((Object)value, String.class);
                continue;
            }
            if (VarbinaryType.VARBINARY.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, SqlVarbinary.class);
                continue;
            }
            if (TimestampType.TIMESTAMP_MILLIS.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, SqlTimestamp.class);
                continue;
            }
            if (TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, SqlTimestampWithTimeZone.class);
                continue;
            }
            if (DateType.DATE.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, SqlDate.class);
                continue;
            }
            if (column.getType() instanceof ArrayType || column.getType() instanceof RowType) {
                Assertions.assertInstanceOf((Object)value, List.class);
                continue;
            }
            if (column.getType() instanceof MapType) {
                Assertions.assertInstanceOf((Object)value, Map.class);
                continue;
            }
            Assert.fail((String)("Unknown primitive type " + columnIndex));
        }
    }

    private static void assertPrimitiveField(Map<String, ColumnMetadata> map, String name, Type type, boolean partitionKey) {
        Assert.assertTrue((boolean)map.containsKey(name));
        ColumnMetadata column = map.get(name);
        Assert.assertEquals((Object)column.getType(), (Object)type, (String)name);
        Assert.assertEquals((String)column.getExtraInfo(), (String)HiveUtil.columnExtraInfo((boolean)partitionKey));
    }

    protected static ImmutableMap<String, Integer> indexColumns(List<ColumnHandle> columnHandles) {
        ImmutableMap.Builder index = ImmutableMap.builder();
        int i = 0;
        for (ColumnHandle columnHandle : columnHandles) {
            HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)columnHandle;
            index.put((Object)hiveColumnHandle.getName(), (Object)i);
            ++i;
        }
        return index.buildOrThrow();
    }

    protected static ImmutableMap<String, Integer> indexColumns(ConnectorTableMetadata tableMetadata) {
        ImmutableMap.Builder index = ImmutableMap.builder();
        int i = 0;
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            index.put((Object)columnMetadata.getName(), (Object)i);
            ++i;
        }
        return index.buildOrThrow();
    }

    protected SchemaTableName temporaryTable(String tableName) {
        return AbstractTestHive.temporaryTable(this.database, tableName);
    }

    protected static SchemaTableName temporaryTable(String database, String tableName) {
        String randomName = UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
        return new SchemaTableName(database, TEMPORARY_TABLE_PREFIX + tableName + "_" + randomName);
    }

    protected static Map<String, Object> createTableProperties(HiveStorageFormat storageFormat) {
        return AbstractTestHive.createTableProperties(storageFormat, (Iterable<String>)ImmutableList.of());
    }

    protected static Map<String, Object> createTableProperties(HiveStorageFormat storageFormat, Iterable<String> partitionedBy) {
        return ImmutableMap.builder().put((Object)"format", (Object)storageFormat).put((Object)"partitioned_by", (Object)ImmutableList.copyOf(partitionedBy)).put((Object)"bucketed_by", (Object)ImmutableList.of()).put((Object)"bucket_count", (Object)0).put((Object)"sorted_by", (Object)ImmutableList.of()).buildOrThrow();
    }

    protected static List<ColumnHandle> filterNonHiddenColumnHandles(Collection<ColumnHandle> columnHandles) {
        return columnHandles.stream().filter(columnHandle -> !((HiveColumnHandle)columnHandle).isHidden()).collect(Collectors.toList());
    }

    protected static List<ColumnMetadata> filterNonHiddenColumnMetadata(Collection<ColumnMetadata> columnMetadatas) {
        return columnMetadatas.stream().filter(columnMetadata -> !columnMetadata.isHidden()).collect(Collectors.toList());
    }

    private void createEmptyTable(SchemaTableName schemaTableName, HiveStorageFormat hiveStorageFormat, List<Column> columns, List<Column> partitionColumns) throws Exception {
        this.createEmptyTable(schemaTableName, hiveStorageFormat, columns, partitionColumns, Optional.empty(), false);
    }

    private void createEmptyTable(SchemaTableName schemaTableName, HiveStorageFormat hiveStorageFormat, List<Column> columns, List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty) throws Exception {
        this.createEmptyTable(schemaTableName, hiveStorageFormat, columns, partitionColumns, bucketProperty, false);
    }

    protected void createEmptyTable(SchemaTableName schemaTableName, HiveStorageFormat hiveStorageFormat, List<Column> columns, List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, boolean isTransactional) throws Exception {
        org.apache.hadoop.fs.Path targetPath;
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            String tableOwner = session.getUser();
            String schemaName = schemaTableName.getSchemaName();
            String tableName = schemaTableName.getTableName();
            LocationService locationService = this.getLocationService();
            targetPath = new org.apache.hadoop.fs.Path(locationService.forNewTable(transaction.getMetastore(), session, schemaName, tableName).toString());
            ImmutableMap.Builder tableParamBuilder = ImmutableMap.builder().put((Object)"presto_version", (Object)TEST_SERVER_VERSION).put((Object)"presto_query_id", (Object)session.getQueryId());
            if (isTransactional) {
                tableParamBuilder.put((Object)"transactional", (Object)"true");
            }
            Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(Optional.of(tableOwner)).setTableType(TableType.MANAGED_TABLE.name()).setParameters((Map)tableParamBuilder.buildOrThrow()).setDataColumns(columns).setPartitionColumns(partitionColumns);
            tableBuilder.getStorageBuilder().setLocation(targetPath.toString()).setStorageFormat(StorageFormat.create((String)hiveStorageFormat.getSerde(), (String)hiveStorageFormat.getInputFormat(), (String)hiveStorageFormat.getOutputFormat())).setBucketProperty(bucketProperty).setSerdeParameters((Map)ImmutableMap.of());
            PrincipalPrivileges principalPrivileges = this.testingPrincipalPrivilege(tableOwner, session.getUser());
            transaction.getMetastore().createTable(session, tableBuilder.build(), principalPrivileges, Optional.empty(), Optional.empty(), true, ZERO_TABLE_STATISTICS, false);
            transaction.commit();
        }
        HdfsContext context = new HdfsContext(this.newSession());
        List<String> targetDirectoryList = this.listDirectory(context, targetPath);
        Assert.assertEquals(targetDirectoryList, (Collection)ImmutableList.of());
    }

    private void alterBucketProperty(SchemaTableName schemaTableName, Optional<HiveBucketProperty> bucketProperty) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            String tableOwner = session.getUser();
            String schemaName = schemaTableName.getSchemaName();
            String tableName = schemaTableName.getTableName();
            Optional table = transaction.getMetastore().getTable(schemaName, tableName);
            Table.Builder tableBuilder = Table.builder((Table)((Table)table.get()));
            tableBuilder.getStorageBuilder().setBucketProperty(bucketProperty);
            PrincipalPrivileges principalPrivileges = this.testingPrincipalPrivilege(tableOwner, session.getUser());
            transaction.getMetastore().replaceTable(schemaName, tableName, tableBuilder.build(), principalPrivileges);
            transaction.commit();
        }
    }

    protected PrincipalPrivileges testingPrincipalPrivilege(ConnectorSession session) {
        return this.testingPrincipalPrivilege(session.getUser(), session.getUser());
    }

    protected PrincipalPrivileges testingPrincipalPrivilege(String tableOwner, String grantor) {
        return new PrincipalPrivileges((Multimap)ImmutableMultimap.builder().put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true, new HivePrincipal(PrincipalType.USER, grantor), new HivePrincipal(PrincipalType.USER, grantor))).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, true, new HivePrincipal(PrincipalType.USER, grantor), new HivePrincipal(PrincipalType.USER, grantor))).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, true, new HivePrincipal(PrincipalType.USER, grantor), new HivePrincipal(PrincipalType.USER, grantor))).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, true, new HivePrincipal(PrincipalType.USER, grantor), new HivePrincipal(PrincipalType.USER, grantor))).build(), (Multimap)ImmutableMultimap.of());
    }

    private List<String> listDirectory(HdfsContext context, org.apache.hadoop.fs.Path path) throws IOException {
        FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, path);
        return Arrays.stream(fileSystem.listStatus(path)).map(FileStatus::getPath).map(org.apache.hadoop.fs.Path::getName).filter(name -> !name.startsWith(".trino")).collect(Collectors.toList());
    }

    @Test
    public void testTransactionDeleteInsert() throws Exception {
        this.doTestTransactionDeleteInsert(HiveStorageFormat.RCBINARY, true, (List<TransactionDeleteInsertTestCase>)ImmutableList.builder().add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_RIGHT_AWAY, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_DELETE, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_BEGIN_INSERT, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_APPEND_PAGE, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_SINK_FINISH, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_FINISH_INSERT, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.COMMIT, Optional.of(new AddPartitionFailure()))).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.COMMIT, Optional.of(new DirectoryRenameFailure()))).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.COMMIT, Optional.of(new FileRenameFailure()))).add((Object)new TransactionDeleteInsertTestCase(true, false, TransactionDeleteInsertTestTag.COMMIT, Optional.of(new DropPartitionFailure()))).add((Object)new TransactionDeleteInsertTestCase(true, true, TransactionDeleteInsertTestTag.COMMIT, Optional.empty())).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreferredInsertLayout() throws Exception {
        SchemaTableName tableName = this.temporaryTable("empty_partitioned_table");
        try {
            Column partitioningColumn = new Column("column2", HiveType.HIVE_STRING, Optional.empty());
            ImmutableList columns = ImmutableList.of((Object)new Column("column1", HiveType.HIVE_STRING, Optional.empty()), (Object)partitioningColumn);
            this.createEmptyTable(tableName, HiveStorageFormat.ORC, (List<Column>)columns, (List<Column>)ImmutableList.of((Object)partitioningColumn));
            try (Transaction transaction = this.newTransaction();){
                ConnectorMetadata metadata = transaction.getMetadata();
                ConnectorSession session = this.newSession();
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                Optional insertLayout = metadata.getInsertLayout(session, tableHandle);
                Assert.assertTrue((boolean)insertLayout.isPresent());
                Assert.assertFalse((boolean)((ConnectorTableLayout)insertLayout.get()).getPartitioning().isPresent());
                Assert.assertEquals((Collection)((ConnectorTableLayout)insertLayout.get()).getPartitionColumns(), (Collection)ImmutableList.of((Object)partitioningColumn.getName()));
            }
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testInsertBucketedTableLayout() throws Exception {
        this.insertBucketedTableLayout(false);
    }

    @Test
    public void testInsertBucketedTransactionalTableLayout() throws Exception {
        this.insertBucketedTableLayout(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertBucketedTableLayout(boolean transactional) throws Exception {
        SchemaTableName tableName = this.temporaryTable("empty_bucketed_table");
        try {
            ImmutableList columns = ImmutableList.of((Object)new Column("column1", HiveType.HIVE_STRING, Optional.empty()), (Object)new Column("column2", HiveType.HIVE_LONG, Optional.empty()));
            HiveBucketProperty bucketProperty = new HiveBucketProperty((List)ImmutableList.of((Object)"column1"), HiveBucketing.BucketingVersion.BUCKETING_V1, 4, (List)ImmutableList.of());
            this.createEmptyTable(tableName, HiveStorageFormat.ORC, (List<Column>)columns, (List<Column>)ImmutableList.of(), Optional.of(bucketProperty), transactional);
            try (Transaction transaction = this.newTransaction();){
                ConnectorMetadata metadata = transaction.getMetadata();
                ConnectorSession session = this.newSession();
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                Optional insertLayout = metadata.getInsertLayout(session, tableHandle);
                Assert.assertTrue((boolean)insertLayout.isPresent());
                HivePartitioningHandle partitioningHandle = new HivePartitioningHandle(bucketProperty.getBucketingVersion(), bucketProperty.getBucketCount(), (List)ImmutableList.of((Object)HiveType.HIVE_STRING), OptionalInt.empty(), false);
                Assert.assertEquals((Object)((ConnectorTableLayout)insertLayout.get()).getPartitioning(), Optional.of(partitioningHandle));
                Assert.assertEquals((Collection)((ConnectorTableLayout)insertLayout.get()).getPartitionColumns(), (Collection)ImmutableList.of((Object)"column1"));
                ConnectorBucketNodeMap connectorBucketNodeMap = (ConnectorBucketNodeMap)this.nodePartitioningProvider.getBucketNodeMapping(transaction.getTransactionHandle(), session, (ConnectorPartitioningHandle)partitioningHandle).orElseThrow();
                Assert.assertEquals((int)connectorBucketNodeMap.getBucketCount(), (int)4);
                Assert.assertFalse((boolean)connectorBucketNodeMap.hasFixedMapping());
            }
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testInsertPartitionedBucketedTableLayout() throws Exception {
        this.insertPartitionedBucketedTableLayout(false);
    }

    @Test
    public void testInsertPartitionedBucketedTransactionalTableLayout() throws Exception {
        this.insertPartitionedBucketedTableLayout(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertPartitionedBucketedTableLayout(boolean transactional) throws Exception {
        SchemaTableName tableName = this.temporaryTable("empty_partitioned_table");
        try {
            Column partitioningColumn = new Column("column2", HiveType.HIVE_LONG, Optional.empty());
            ImmutableList columns = ImmutableList.of((Object)new Column("column1", HiveType.HIVE_STRING, Optional.empty()), (Object)partitioningColumn);
            HiveBucketProperty bucketProperty = new HiveBucketProperty((List)ImmutableList.of((Object)"column1"), HiveBucketing.BucketingVersion.BUCKETING_V1, 4, (List)ImmutableList.of());
            this.createEmptyTable(tableName, HiveStorageFormat.ORC, (List<Column>)columns, (List<Column>)ImmutableList.of((Object)partitioningColumn), Optional.of(bucketProperty), transactional);
            try (Transaction transaction = this.newTransaction();){
                ConnectorMetadata metadata = transaction.getMetadata();
                ConnectorSession session = this.newSession();
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                Optional insertLayout = metadata.getInsertLayout(session, tableHandle);
                Assert.assertTrue((boolean)insertLayout.isPresent());
                HivePartitioningHandle partitioningHandle = new HivePartitioningHandle(bucketProperty.getBucketingVersion(), bucketProperty.getBucketCount(), (List)ImmutableList.of((Object)HiveType.HIVE_STRING), OptionalInt.empty(), true);
                Assert.assertEquals((Object)((ConnectorTableLayout)insertLayout.get()).getPartitioning(), Optional.of(partitioningHandle));
                Assert.assertEquals((Collection)((ConnectorTableLayout)insertLayout.get()).getPartitionColumns(), (Collection)ImmutableList.of((Object)"column1", (Object)"column2"));
                ConnectorBucketNodeMap connectorBucketNodeMap = (ConnectorBucketNodeMap)this.nodePartitioningProvider.getBucketNodeMapping(transaction.getTransactionHandle(), session, (ConnectorPartitioningHandle)partitioningHandle).orElseThrow();
                Assert.assertEquals((int)connectorBucketNodeMap.getBucketCount(), (int)32);
                Assert.assertFalse((boolean)connectorBucketNodeMap.hasFixedMapping());
            }
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testPreferredCreateTableLayout() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            Optional newTableLayout = metadata.getNewTableLayout(session, new ConnectorTableMetadata(new SchemaTableName("schema", "table"), (List)ImmutableList.of((Object)new ColumnMetadata("column1", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("column2", (Type)BigintType.BIGINT)), (Map)ImmutableMap.of((Object)"partitioned_by", (Object)ImmutableList.of((Object)"column2"), (Object)"bucketed_by", (Object)ImmutableList.of(), (Object)"bucket_count", (Object)0, (Object)"sorted_by", (Object)ImmutableList.of())));
            Assert.assertTrue((boolean)newTableLayout.isPresent());
            Assert.assertFalse((boolean)((ConnectorTableLayout)newTableLayout.get()).getPartitioning().isPresent());
            Assert.assertEquals((Collection)((ConnectorTableLayout)newTableLayout.get()).getPartitionColumns(), (Collection)ImmutableList.of((Object)"column2"));
        }
    }

    @Test
    public void testCreateBucketedTableLayout() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            Optional newTableLayout = metadata.getNewTableLayout(session, new ConnectorTableMetadata(new SchemaTableName("schema", "table"), (List)ImmutableList.of((Object)new ColumnMetadata("column1", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("column2", (Type)BigintType.BIGINT)), (Map)ImmutableMap.of((Object)"partitioned_by", (Object)ImmutableList.of(), (Object)"bucketed_by", (Object)ImmutableList.of((Object)"column1"), (Object)"bucket_count", (Object)10, (Object)"sorted_by", (Object)ImmutableList.of())));
            Assert.assertTrue((boolean)newTableLayout.isPresent());
            HivePartitioningHandle partitioningHandle = new HivePartitioningHandle(HiveBucketing.BucketingVersion.BUCKETING_V1, 10, (List)ImmutableList.of((Object)HiveType.HIVE_LONG), OptionalInt.empty(), false);
            Assert.assertEquals((Object)((ConnectorTableLayout)newTableLayout.get()).getPartitioning(), Optional.of(partitioningHandle));
            Assert.assertEquals((Collection)((ConnectorTableLayout)newTableLayout.get()).getPartitionColumns(), (Collection)ImmutableList.of((Object)"column1"));
            ConnectorBucketNodeMap connectorBucketNodeMap = (ConnectorBucketNodeMap)this.nodePartitioningProvider.getBucketNodeMapping(transaction.getTransactionHandle(), session, (ConnectorPartitioningHandle)partitioningHandle).orElseThrow();
            Assert.assertEquals((int)connectorBucketNodeMap.getBucketCount(), (int)10);
            Assert.assertFalse((boolean)connectorBucketNodeMap.hasFixedMapping());
        }
    }

    @Test
    public void testCreatePartitionedBucketedTableLayout() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            Optional newTableLayout = metadata.getNewTableLayout(session, new ConnectorTableMetadata(new SchemaTableName("schema", "table"), (List)ImmutableList.of((Object)new ColumnMetadata("column1", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("column2", (Type)BigintType.BIGINT)), (Map)ImmutableMap.of((Object)"partitioned_by", (Object)ImmutableList.of((Object)"column2"), (Object)"bucketed_by", (Object)ImmutableList.of((Object)"column1"), (Object)"bucket_count", (Object)10, (Object)"sorted_by", (Object)ImmutableList.of())));
            Assert.assertTrue((boolean)newTableLayout.isPresent());
            HivePartitioningHandle partitioningHandle = new HivePartitioningHandle(HiveBucketing.BucketingVersion.BUCKETING_V1, 10, (List)ImmutableList.of((Object)HiveType.HIVE_LONG), OptionalInt.empty(), true);
            Assert.assertEquals((Object)((ConnectorTableLayout)newTableLayout.get()).getPartitioning(), Optional.of(partitioningHandle));
            Assert.assertEquals((Collection)((ConnectorTableLayout)newTableLayout.get()).getPartitionColumns(), (Collection)ImmutableList.of((Object)"column1", (Object)"column2"));
            ConnectorBucketNodeMap connectorBucketNodeMap = (ConnectorBucketNodeMap)this.nodePartitioningProvider.getBucketNodeMapping(transaction.getTransactionHandle(), session, (ConnectorPartitioningHandle)partitioningHandle).orElseThrow();
            Assert.assertEquals((int)connectorBucketNodeMap.getBucketCount(), (int)32);
            Assert.assertFalse((boolean)connectorBucketNodeMap.hasFixedMapping());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNewDirectoryPermissions() throws Exception {
        SchemaTableName tableName = this.temporaryTable("empty_file");
        ImmutableList columns = ImmutableList.of((Object)new Column("test", HiveType.HIVE_STRING, Optional.empty()));
        this.createEmptyTable(tableName, HiveStorageFormat.ORC, (List<Column>)columns, (List<Column>)ImmutableList.of(), Optional.empty());
        try {
            Transaction transaction = this.newTransaction();
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            Table table = (Table)transaction.getMetastore().getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow();
            HdfsContext context = new HdfsContext(session);
            org.apache.hadoop.fs.Path location = new org.apache.hadoop.fs.Path(table.getStorage().getLocation());
            org.apache.hadoop.fs.Path defaultPath = new org.apache.hadoop.fs.Path(location + "/defaultperms");
            HiveWriteUtils.createDirectory((HdfsContext)context, (HdfsEnvironment)this.hdfsEnvironment, (org.apache.hadoop.fs.Path)defaultPath);
            FileStatus defaultFsStatus = this.hdfsEnvironment.getFileSystem(context, defaultPath).getFileStatus(defaultPath);
            Assert.assertEquals((int)defaultFsStatus.getPermission().toOctal(), (int)777);
            HdfsConfig configWithSkip = new HdfsConfig();
            configWithSkip.setNewDirectoryPermissions("skip");
            HdfsEnvironment hdfsEnvironmentWithSkip = new HdfsEnvironment((HdfsConfiguration)HiveTestUtils.HDFS_CONFIGURATION, configWithSkip, (HdfsAuthentication)new NoHdfsAuthentication());
            org.apache.hadoop.fs.Path skipPath = new org.apache.hadoop.fs.Path(location + "/skipperms");
            HiveWriteUtils.createDirectory((HdfsContext)context, (HdfsEnvironment)hdfsEnvironmentWithSkip, (org.apache.hadoop.fs.Path)skipPath);
            FileStatus skipFsStatus = hdfsEnvironmentWithSkip.getFileSystem(context, skipPath).getFileStatus(skipPath);
            Assert.assertEquals((int)skipFsStatus.getPermission().toOctal(), (int)755);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestTransactionDeleteInsert(HiveStorageFormat storageFormat, boolean allowInsertExisting, List<TransactionDeleteInsertTestCase> testCases) throws Exception {
        MaterializedResult beforeData = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{110L, "a", "alter1"}).row(new Object[]{120L, "a", "insert1"}).row(new Object[]{140L, "a", "drop1"}).row(new Object[]{210L, "b", "drop2"}).row(new Object[]{310L, "c", "alter2"}).row(new Object[]{320L, "c", "alter3"}).row(new Object[]{510L, "e", "drop3"}).row(new Object[]{610L, "f", "insert2"}).row(new Object[]{620L, "f", "insert3"}).build();
        Domain domainToDrop = Domain.create((ValueSet)ValueSet.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"alter1"), (Object[])new Object[]{Slices.utf8Slice((String)"alter2"), Slices.utf8Slice((String)"alter3"), Slices.utf8Slice((String)"drop1"), Slices.utf8Slice((String)"drop2"), Slices.utf8Slice((String)"drop3")}), (boolean)false);
        Object extraRowsForInsertExisting = ImmutableList.of();
        if (allowInsertExisting) {
            extraRowsForInsertExisting = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{121L, "a", "insert1"}).row(new Object[]{611L, "f", "insert2"}).row(new Object[]{621L, "f", "insert3"}).build().getMaterializedRows();
        }
        MaterializedResult insertData = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{111L, "a", "alter1"}).row(new Object[]{131L, "a", "add1"}).row(new Object[]{221L, "b", "add2"}).row(new Object[]{311L, "c", "alter2"}).row(new Object[]{321L, "c", "alter3"}).row(new Object[]{411L, "d", "add3"}).rows((List)extraRowsForInsertExisting).build();
        MaterializedResult afterData = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{120L, "a", "insert1"}).row(new Object[]{610L, "f", "insert2"}).row(new Object[]{620L, "f", "insert3"}).rows(insertData.getMaterializedRows()).build();
        for (TransactionDeleteInsertTestCase testCase : testCases) {
            SchemaTableName temporaryDeleteInsert = this.temporaryTable("delete_insert");
            try {
                this.createEmptyTable(temporaryDeleteInsert, storageFormat, (List<Column>)ImmutableList.of((Object)new Column("col1", HiveType.HIVE_LONG, Optional.empty())), (List<Column>)ImmutableList.of((Object)new Column("pk1", HiveType.HIVE_STRING, Optional.empty()), (Object)new Column("pk2", HiveType.HIVE_STRING, Optional.empty())));
                this.insertData(temporaryDeleteInsert, beforeData);
                try {
                    this.doTestTransactionDeleteInsert(storageFormat, temporaryDeleteInsert, domainToDrop, insertData, testCase.isExpectCommittedData() ? afterData : beforeData, testCase.getTag(), testCase.isExpectQuerySucceed(), testCase.getConflictTrigger());
                }
                catch (AssertionError e) {
                    throw new AssertionError(String.format("Test case: %s", testCase), (Throwable)((Object)e));
                }
            }
            finally {
                this.dropTable(temporaryDeleteInsert);
            }
        }
    }

    private void doTestTransactionDeleteInsert(HiveStorageFormat storageFormat, SchemaTableName tableName, Domain domainToDrop, MaterializedResult insertData, MaterializedResult expectedData, TransactionDeleteInsertTestTag tag, boolean expectQuerySucceed, Optional<ConflictTrigger> conflictTrigger) throws Exception {
        Location writePath = null;
        Location targetPath = null;
        try (Transaction transaction = this.newTransaction();){
            try {
                ConnectorMetadata metadata = transaction.getMetadata();
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                AbstractTestHive.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_RIGHT_AWAY);
                ConnectorSession session = this.newSession();
                HiveColumnHandle dsColumnHandle = (HiveColumnHandle)metadata.getColumnHandles(session, tableHandle).get("pk2");
                TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dsColumnHandle, (Object)domainToDrop));
                Constraint constraint = new Constraint(tupleDomain, tupleDomain.asPredicate(), ((Map)tupleDomain.getDomains().orElseThrow()).keySet());
                tableHandle = this.applyFilter(metadata, tableHandle, constraint);
                tableHandle = (ConnectorTableHandle)metadata.applyDelete(session, tableHandle).get();
                metadata.executeDelete(session, tableHandle);
                AbstractTestHive.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_DELETE);
                session = this.newSession();
                ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session, tableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES);
                AbstractTestHive.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_BEGIN_INSERT);
                writePath = this.getStagingPathRoot(insertTableHandle);
                targetPath = this.getTargetPathRoot(insertTableHandle);
                ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
                sink.appendPage(insertData.toPage());
                AbstractTestHive.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_APPEND_PAGE);
                Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
                AbstractTestHive.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_SINK_FINISH);
                metadata.finishInsert(session, insertTableHandle, fragments, (Collection)ImmutableList.of());
                AbstractTestHive.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_FINISH_INSERT);
                Assert.assertEquals((Object)((Object)tag), (Object)((Object)TransactionDeleteInsertTestTag.COMMIT));
                if (conflictTrigger.isPresent()) {
                    JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
                    List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> ((JsonCodec)partitionUpdateCodec).fromJson(arg_0)).collect(Collectors.toList());
                    conflictTrigger.get().triggerConflict(session, tableName, insertTableHandle, partitionUpdates);
                }
                transaction.commit();
                if (conflictTrigger.isPresent()) {
                    Assert.assertTrue((boolean)expectQuerySucceed);
                    conflictTrigger.get().verifyAndCleanup(session, tableName);
                }
            }
            catch (TestingRollbackException e) {
                transaction.rollback();
            }
            catch (TrinoException e) {
                Assert.assertFalse((boolean)expectQuerySucceed);
                if (conflictTrigger.isPresent()) {
                    conflictTrigger.get().verifyAndCleanup(this.newSession(), tableName);
                }
            }
        }
        if (writePath != null && !writePath.equals(targetPath)) {
            HdfsContext context = new HdfsContext(this.newSession());
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, new org.apache.hadoop.fs.Path(writePath.toString()));
            Assert.assertFalse((boolean)fileSystem.exists(new org.apache.hadoop.fs.Path(writePath.toString())));
        }
        transaction = this.newTransaction();
        try {
            List partitionNames = (List)transaction.getMetastore().getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)partitionNames, (Iterable)((Iterable)expectedData.getMaterializedRows().stream().map(row -> String.format("pk1=%s/pk2=%s", row.getField(1), row.getField(2))).distinct().collect(ImmutableList.toImmutableList())));
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)expectedData.getMaterializedRows());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private static void rollbackIfEquals(TransactionDeleteInsertTestTag tag, TransactionDeleteInsertTestTag expectedTag) {
        if (expectedTag == tag) {
            throw new TestingRollbackException();
        }
    }

    private /* synthetic */ void lambda$doTestBucketedSortedTableEvolution$28(Transaction transaction, ConnectorTableHandle tableHandle, Map columnHandles, ConnectorSession session) throws Throwable {
        this.readTable(transaction, tableHandle, (List<ColumnHandle>)ImmutableList.copyOf(columnHandles.values()), session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
    }

    private static class CountingDirectoryLister
    implements DirectoryLister {
        private final AtomicInteger listCount = new AtomicInteger();

        private CountingDirectoryLister() {
        }

        public RemoteIterator<TrinoFileStatus> listFilesRecursively(TrinoFileSystem fs, Table table, Location location) throws IOException {
            this.listCount.incrementAndGet();
            return new TrinoFileStatusRemoteIterator(fs.listFiles(location));
        }

        public int getListCount() {
            return this.listCount.get();
        }

        public void invalidate(Partition partition) {
        }

        public void invalidate(Table table) {
        }
    }

    static class HiveTransaction
    implements Transaction {
        private final HiveTransactionManager transactionManager;
        private final ConnectorTransactionHandle transactionHandle;
        private boolean closed;

        public HiveTransaction(HiveTransactionManager transactionManager) {
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            this.transactionHandle = new HiveTransactionHandle(false);
            transactionManager.begin(this.transactionHandle);
            this.getMetastore().testOnlyThrowOnCleanupFailures();
        }

        @Override
        public ConnectorMetadata getMetadata() {
            return this.transactionManager.get(this.transactionHandle, HiveTestUtils.SESSION.getIdentity());
        }

        @Override
        public SemiTransactionalHiveMetastore getMetastore() {
            return this.transactionManager.get(this.transactionHandle, HiveTestUtils.SESSION.getIdentity()).getMetastore();
        }

        @Override
        public ConnectorTransactionHandle getTransactionHandle() {
            return this.transactionHandle;
        }

        @Override
        public void commit() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.closed = true;
            this.transactionManager.commit(this.transactionHandle);
        }

        @Override
        public void rollback() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.closed = true;
            this.transactionManager.rollback(this.transactionHandle);
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.getMetastore().testOnlyCheckIsReadOnly();
                }
                finally {
                    this.rollback();
                }
            }
        }
    }

    protected static interface Transaction
    extends AutoCloseable {
        public ConnectorMetadata getMetadata();

        public SemiTransactionalHiveMetastore getMetastore();

        public ConnectorTransactionHandle getTransactionHandle();

        public void commit();

        public void rollback();

        @Override
        public void close();
    }

    protected static class TransactionDeleteInsertTestCase {
        private final boolean expectCommittedData;
        private final boolean expectQuerySucceed;
        private final TransactionDeleteInsertTestTag tag;
        private final Optional<ConflictTrigger> conflictTrigger;

        public TransactionDeleteInsertTestCase(boolean expectCommittedData, boolean expectQuerySucceed, TransactionDeleteInsertTestTag tag, Optional<ConflictTrigger> conflictTrigger) {
            this.expectCommittedData = expectCommittedData;
            this.expectQuerySucceed = expectQuerySucceed;
            this.tag = tag;
            this.conflictTrigger = conflictTrigger;
        }

        public boolean isExpectCommittedData() {
            return this.expectCommittedData;
        }

        public boolean isExpectQuerySucceed() {
            return this.expectQuerySucceed;
        }

        public TransactionDeleteInsertTestTag getTag() {
            return this.tag;
        }

        public Optional<ConflictTrigger> getConflictTrigger() {
            return this.conflictTrigger;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tag", (Object)this.tag).add("conflictTrigger", this.conflictTrigger.map(conflictTrigger -> conflictTrigger.getClass().getName())).add("expectCommittedData", this.expectCommittedData).add("expectQuerySucceed", this.expectQuerySucceed).toString();
        }
    }

    protected static enum TransactionDeleteInsertTestTag {
        ROLLBACK_RIGHT_AWAY,
        ROLLBACK_AFTER_DELETE,
        ROLLBACK_AFTER_BEGIN_INSERT,
        ROLLBACK_AFTER_APPEND_PAGE,
        ROLLBACK_AFTER_SINK_FINISH,
        ROLLBACK_AFTER_FINISH_INSERT,
        COMMIT;

    }

    protected class AddPartitionFailure
    implements ConflictTrigger {
        private final ImmutableList<String> copyPartitionFrom = ImmutableList.of((Object)"a", (Object)"insert1");
        private final String partitionNameToConflict = "pk1=b/pk2=add2";
        private Partition conflictPartition;

        protected AddPartitionFailure() {
        }

        @Override
        public void triggerConflict(ConnectorSession session, SchemaTableName tableName, ConnectorInsertTableHandle insertTableHandle, List<PartitionUpdate> partitionUpdates) {
            HiveMetastore metastoreClient = AbstractTestHive.this.getMetastoreClient();
            Table table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
            Optional partition = metastoreClient.getPartition(table, this.copyPartitionFrom);
            this.conflictPartition = Partition.builder((Partition)((Partition)partition.get())).setValues(HiveUtil.toPartitionValues((String)"pk1=b/pk2=add2")).build();
            metastoreClient.addPartitions(tableName.getSchemaName(), tableName.getTableName(), (List)ImmutableList.of((Object)new PartitionWithStatistics(this.conflictPartition, "pk1=b/pk2=add2", PartitionStatistics.empty())));
        }

        @Override
        public void verifyAndCleanup(ConnectorSession session, SchemaTableName tableName) {
            HiveMetastore metastoreClient = AbstractTestHive.this.getMetastoreClient();
            Table table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
            Optional actualPartition = metastoreClient.getPartition(table, HiveUtil.toPartitionValues((String)"pk1=b/pk2=add2"));
            Assert.assertEquals((String)((Partition)actualPartition.get()).getStorage().getLocation(), (String)this.conflictPartition.getStorage().getLocation());
            metastoreClient.dropPartition(tableName.getSchemaName(), tableName.getTableName(), this.conflictPartition.getValues(), false);
        }
    }

    protected class DirectoryRenameFailure
    implements ConflictTrigger {
        private HdfsContext context;
        private org.apache.hadoop.fs.Path path;

        protected DirectoryRenameFailure() {
        }

        @Override
        public void triggerConflict(ConnectorSession session, SchemaTableName tableName, ConnectorInsertTableHandle insertTableHandle, List<PartitionUpdate> partitionUpdates) {
            Location targetPath;
            Location writePath = AbstractTestHive.this.getStagingPathRoot(insertTableHandle);
            if (writePath.equals((Object)(targetPath = AbstractTestHive.this.getTargetPathRoot(insertTableHandle)))) {
                throw new TestingRollbackException();
            }
            this.path = new org.apache.hadoop.fs.Path(targetPath.appendPath("pk1=b").appendPath("pk2=add2").toString());
            this.context = new HdfsContext(session);
            HiveWriteUtils.createDirectory((HdfsContext)this.context, (HdfsEnvironment)AbstractTestHive.this.hdfsEnvironment, (org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(this.path.toString()));
        }

        @Override
        public void verifyAndCleanup(ConnectorSession session, SchemaTableName tableName) throws IOException {
            Assert.assertEquals(AbstractTestHive.this.listDirectory(this.context, this.path), (Collection)ImmutableList.of());
            AbstractTestHive.this.hdfsEnvironment.getFileSystem(this.context, this.path).delete(this.path, false);
        }
    }

    protected class FileRenameFailure
    implements ConflictTrigger {
        private HdfsContext context;
        private org.apache.hadoop.fs.Path path;

        protected FileRenameFailure() {
        }

        @Override
        public void triggerConflict(ConnectorSession session, SchemaTableName tableName, ConnectorInsertTableHandle insertTableHandle, List<PartitionUpdate> partitionUpdates) throws IOException {
            for (PartitionUpdate partitionUpdate : partitionUpdates) {
                if (!"pk2=insert2".equals(partitionUpdate.getTargetPath().fileName())) continue;
                this.path = new org.apache.hadoop.fs.Path(partitionUpdate.getTargetPath().toString(), (String)partitionUpdate.getFileNames().get(0));
                break;
            }
            Assert.assertNotNull((Object)this.path);
            this.context = new HdfsContext(session);
            FileSystem fileSystem = AbstractTestHive.this.hdfsEnvironment.getFileSystem(this.context, this.path);
            fileSystem.createNewFile(this.path);
        }

        @Override
        public void verifyAndCleanup(ConnectorSession session, SchemaTableName tableName) throws IOException {
            Assert.assertFalse((boolean)AbstractTestHive.this.hdfsEnvironment.getFileSystem(this.context, this.path).exists(this.path));
        }
    }

    protected class DropPartitionFailure
    implements ConflictTrigger {
        private final ImmutableList<String> partitionValueToConflict = ImmutableList.of((Object)"b", (Object)"drop2");

        protected DropPartitionFailure() {
        }

        @Override
        public void triggerConflict(ConnectorSession session, SchemaTableName tableName, ConnectorInsertTableHandle insertTableHandle, List<PartitionUpdate> partitionUpdates) {
            HiveMetastore metastoreClient = AbstractTestHive.this.getMetastoreClient();
            metastoreClient.dropPartition(tableName.getSchemaName(), tableName.getTableName(), this.partitionValueToConflict, false);
        }

        @Override
        public void verifyAndCleanup(ConnectorSession session, SchemaTableName tableName) {
        }
    }

    protected static interface ConflictTrigger {
        public void triggerConflict(ConnectorSession var1, SchemaTableName var2, ConnectorInsertTableHandle var3, List<PartitionUpdate> var4) throws IOException;

        public void verifyAndCleanup(ConnectorSession var1, SchemaTableName var2) throws IOException;
    }

    private static class TestingRollbackException
    extends RuntimeException {
        private TestingRollbackException() {
        }
    }
}

