/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.store.LogExactlyOnce;

@InterfaceAudience.Private
public class WeakReferenceMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(WeakReferenceMap.class);
    private final Map<K, WeakReference<V>> map = new ConcurrentHashMap<K, WeakReference<V>>();
    private final Function<? super K, ? extends V> factory;
    private final Consumer<? super K> referenceLost;
    private final AtomicLong referenceLostCount = new AtomicLong();
    private final AtomicLong entriesCreatedCount = new AtomicLong();
    private final LogExactlyOnce referenceLostDuringCreation = new LogExactlyOnce(LOG);

    public WeakReferenceMap(Function<? super K, ? extends V> factory, @.Nullable Consumer<? super K> referenceLost) {
        this.factory = Objects.requireNonNull(factory);
        this.referenceLost = referenceLost;
    }

    public String toString() {
        return "WeakReferenceMap{size=" + this.size() + ", referenceLostCount=" + this.referenceLostCount + ", entriesCreatedCount=" + this.entriesCreatedCount + '}';
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public WeakReference<V> lookup(K key) {
        return this.map.get(key);
    }

    public V get(K key) {
        WeakReference<V> currentWeakRef = this.lookup(key);
        V strongVal = this.resolve(currentWeakRef);
        if (strongVal != null) {
            return strongVal;
        }
        if (currentWeakRef != null) {
            this.map.remove(key, currentWeakRef);
            this.noteLost(key);
        }
        return this.create(key);
    }

    public V create(K key) {
        V resolvedStrongRef;
        this.entriesCreatedCount.incrementAndGet();
        V strongRef = Objects.requireNonNull(this.factory.apply(key), "factory returned a null instance");
        do {
            WeakReference<V> newWeakRef = new WeakReference<V>(strongRef);
            this.map.put(key, newWeakRef);
            WeakReference<V> retrievedWeakRef = this.map.get(key);
            resolvedStrongRef = this.resolve(retrievedWeakRef);
            if (resolvedStrongRef != null) continue;
            this.referenceLostDuringCreation.warn("reference to %s lost during creation", key);
            this.noteLost(key);
        } while (resolvedStrongRef == null);
        if (strongRef != resolvedStrongRef) {
            LOG.debug("Created instance for key {}: {} overwritten by {}", key, strongRef, resolvedStrongRef);
        }
        return resolvedStrongRef;
    }

    public V put(K key, V value) {
        return this.resolve(this.map.put(key, new WeakReference<V>(value)));
    }

    public V remove(K key) {
        return this.resolve(this.map.remove(key));
    }

    public boolean containsKey(K key) {
        WeakReference<V> current = this.lookup(key);
        return this.resolve(current) != null;
    }

    protected V resolve(WeakReference<V> r) {
        return r == null ? null : (V)r.get();
    }

    public int prune() {
        int count = 0;
        Iterator<Map.Entry<K, WeakReference<V>>> it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, WeakReference<V>> next = it.next();
            if (next.getValue().get() != null) continue;
            it.remove();
            ++count;
            this.noteLost(next.getKey());
        }
        return count;
    }

    private void noteLost(K key) {
        this.referenceLostCount.incrementAndGet();
        if (this.referenceLost != null) {
            this.referenceLost.accept(key);
        }
    }

    public final long getReferenceLostCount() {
        return this.referenceLostCount.get();
    }

    public final long getEntriesCreatedCount() {
        return this.entriesCreatedCount.get();
    }
}

