/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;

public class SaveSuccessFileStage
extends AbstractJobOrTaskStage<ManifestSuccessData, Path> {
    private static final Logger LOG = LoggerFactory.getLogger(SaveSuccessFileStage.class);

    public SaveSuccessFileStage(StageConfig stageConfig) {
        super(false, stageConfig, "job_stage_save_success_marker", false);
    }

    @Override
    protected String getStageName(ManifestSuccessData arguments) {
        return "committer_commit_job";
    }

    @Override
    protected Path executeStage(ManifestSuccessData successData) throws IOException {
        Path successFile = this.getStageConfig().getJobSuccessMarkerPath();
        Path successTempFile = new Path(this.getJobAttemptDir(), "_SUCCESS.tmp");
        LOG.debug("{}: Saving _SUCCESS file to {} via {}", successFile, this.getName(), successTempFile);
        this.save(successData, successTempFile, successFile);
        return successFile;
    }
}

