/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.trino.hadoop.$internal.org.apache.avro.util.Utf8;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobFinished;
import org.apache.hadoop.mapreduce.util.JobHistoryEventUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobFinishedEvent
implements HistoryEvent {
    private JobFinished datum = null;
    private JobID jobId;
    private long finishTime;
    private int succeededMaps;
    private int succeededReduces;
    private int failedMaps;
    private int failedReduces;
    private int killedMaps;
    private int killedReduces;
    private Counters mapCounters;
    private Counters reduceCounters;
    private Counters totalCounters;

    public JobFinishedEvent(JobID id, long finishTime, int succeededMaps, int succeededReduces, int failedMaps, int failedReduces, int killedMaps, int killedReduces, Counters mapCounters, Counters reduceCounters, Counters totalCounters) {
        this.jobId = id;
        this.finishTime = finishTime;
        this.succeededMaps = succeededMaps;
        this.succeededReduces = succeededReduces;
        this.failedMaps = failedMaps;
        this.failedReduces = failedReduces;
        this.killedMaps = killedMaps;
        this.killedReduces = killedReduces;
        this.mapCounters = mapCounters;
        this.reduceCounters = reduceCounters;
        this.totalCounters = totalCounters;
    }

    JobFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new JobFinished();
            this.datum.setJobid(new Utf8(this.jobId.toString()));
            this.datum.setFinishTime(this.finishTime);
            this.datum.setFinishedMaps(this.succeededMaps);
            this.datum.setFinishedReduces(this.succeededReduces);
            this.datum.setFailedMaps(this.failedMaps);
            this.datum.setFailedReduces(this.failedReduces);
            this.datum.setKilledMaps(this.killedMaps);
            this.datum.setKilledReduces(this.killedReduces);
            this.datum.setMapCounters(EventWriter.toAvro(this.mapCounters, "MAP_COUNTERS"));
            this.datum.setReduceCounters(EventWriter.toAvro(this.reduceCounters, "REDUCE_COUNTERS"));
            this.datum.setTotalCounters(EventWriter.toAvro(this.totalCounters, "TOTAL_COUNTERS"));
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object oDatum) {
        this.datum = (JobFinished)oDatum;
        this.jobId = JobID.forName(this.datum.getJobid().toString());
        this.finishTime = this.datum.getFinishTime();
        this.succeededMaps = this.datum.getFinishedMaps();
        this.succeededReduces = this.datum.getFinishedReduces();
        this.failedMaps = this.datum.getFailedMaps();
        this.failedReduces = this.datum.getFailedReduces();
        this.killedMaps = this.datum.getKilledMaps();
        this.killedReduces = this.datum.getKilledReduces();
        this.mapCounters = EventReader.fromAvro(this.datum.getMapCounters());
        this.reduceCounters = EventReader.fromAvro(this.datum.getReduceCounters());
        this.totalCounters = EventReader.fromAvro(this.datum.getTotalCounters());
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_FINISHED;
    }

    public JobID getJobid() {
        return this.jobId;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public int getSucceededMaps() {
        return this.succeededMaps;
    }

    public int getSucceededReduces() {
        return this.succeededReduces;
    }

    public int getFailedMaps() {
        return this.failedMaps;
    }

    public int getFailedReduces() {
        return this.failedReduces;
    }

    public int getKilledMaps() {
        return this.killedMaps;
    }

    public int getKilledReduces() {
        return this.killedReduces;
    }

    public Counters getTotalCounters() {
        return this.totalCounters;
    }

    public Counters getMapCounters() {
        return this.mapCounters;
    }

    public Counters getReduceCounters() {
        return this.reduceCounters;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("FINISH_TIME", (Object)this.getFinishTime());
        tEvent.addInfo("NUM_MAPS", (Object)(this.getSucceededMaps() + this.getFailedMaps() + this.getKilledMaps()));
        tEvent.addInfo("NUM_REDUCES", (Object)(this.getSucceededReduces() + this.getFailedReduces() + this.getKilledReduces()));
        tEvent.addInfo("FAILED_MAPS", (Object)this.getFailedMaps());
        tEvent.addInfo("FAILED_REDUCES", (Object)this.getFailedReduces());
        tEvent.addInfo("SUCCESSFUL_MAPS", (Object)this.getSucceededMaps());
        tEvent.addInfo("SUCCESSFUL_REDUCES", (Object)this.getSucceededReduces());
        tEvent.addInfo("KILLED_MAPS", (Object)this.getKilledMaps());
        tEvent.addInfo("KILLED_REDUCES", (Object)this.getKilledReduces());
        tEvent.addInfo("JOB_STATUS", (Object)"SUCCEEDED");
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        Set<TimelineMetric> jobMetrics = JobHistoryEventUtils.countersToTimelineMetric(this.getTotalCounters(), this.finishTime);
        jobMetrics.addAll(JobHistoryEventUtils.countersToTimelineMetric(this.getMapCounters(), this.finishTime, "MAP:"));
        jobMetrics.addAll(JobHistoryEventUtils.countersToTimelineMetric(this.getReduceCounters(), this.finishTime, "REDUCE:"));
        return jobMetrics;
    }
}

