/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReferenceCountMap<E extends ReferenceCounter> {
    private Map<E, E> referenceMap = new ConcurrentHashMap<E, E>();

    public E put(E key) {
        ReferenceCounter value = (ReferenceCounter)this.referenceMap.putIfAbsent(key, key);
        if (value == null) {
            value = key;
        }
        value.incrementAndGetRefCount();
        return (E)value;
    }

    public void remove(E key) {
        ReferenceCounter value = (ReferenceCounter)this.referenceMap.get(key);
        if (value != null && value.decrementAndGetRefCount() == 0) {
            this.referenceMap.remove(key);
        }
    }

    @VisibleForTesting
    public ImmutableList<E> getEntries() {
        return ((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.referenceMap.keySet())).build();
    }

    public long getReferenceCount(E key) {
        ReferenceCounter counter = (ReferenceCounter)this.referenceMap.get(key);
        if (counter != null) {
            return counter.getRefCount();
        }
        return 0L;
    }

    public int getUniqueElementsSize() {
        return this.referenceMap.size();
    }

    @VisibleForTesting
    public void clear() {
        this.referenceMap.clear();
    }

    public static interface ReferenceCounter {
        public int getRefCount();

        public int incrementAndGetRefCount();

        public int decrementAndGetRefCount();
    }
}

