/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.BinaryEditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.StatisticsEditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.TeeOutputStream;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.XmlEditsVisitor;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OfflineEditsVisitorFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OfflineEditsVisitor getEditsVisitor(String filename, String processor, boolean printToScreen) throws IOException {
        if (StringUtils.equalsIgnoreCase("binary", processor)) {
            return new BinaryEditsVisitor(filename);
        }
        OutputStream fout = Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        OutputStream out = null;
        try {
            OfflineEditsVisitor vis;
            if (!printToScreen) {
                out = fout;
            } else {
                OutputStream[] outs = new OutputStream[]{fout, System.out};
                out = new TeeOutputStream(outs);
            }
            if (StringUtils.equalsIgnoreCase("xml", processor)) {
                vis = new XmlEditsVisitor(out);
            } else if (StringUtils.equalsIgnoreCase("stats", processor)) {
                vis = new StatisticsEditsVisitor(out);
            } else {
                throw new IOException("Unknown processor " + processor + " (valid processors: xml, binary, stats)");
            }
            fout = null;
            out = null;
            OfflineEditsVisitor offlineEditsVisitor = vis;
            return offlineEditsVisitor;
        }
        finally {
            IOUtils.closeStream(fout);
            IOUtils.closeStream(out);
        }
    }
}

