/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.HAState;
import org.apache.hadoop.ipc.ObserverRetryOnActiveException;
import org.apache.hadoop.ipc.StandbyException;

@InterfaceAudience.Private
public class StandbyState
extends HAState {
    private final boolean isObserver;

    public StandbyState() {
        this(false);
    }

    public StandbyState(boolean isObserver) {
        super(isObserver ? HAServiceProtocol.HAServiceState.OBSERVER : HAServiceProtocol.HAServiceState.STANDBY);
        this.isObserver = isObserver;
    }

    @Override
    public void setState(HAContext context, HAState s2) throws ServiceFailedException {
        if (s2 == NameNode.ACTIVE_STATE || !this.isObserver && s2 == NameNode.OBSERVER_STATE || this.isObserver && s2 == NameNode.STANDBY_STATE) {
            this.setStateInternal(context, s2);
            return;
        }
        super.setState(context, s2);
    }

    @Override
    public void enterState(HAContext context) throws ServiceFailedException {
        try {
            context.startStandbyServices();
        }
        catch (IOException e) {
            throw new ServiceFailedException("Failed to start standby services", e);
        }
    }

    @Override
    public void prepareToExitState(HAContext context) throws ServiceFailedException {
        context.prepareToStopStandbyServices();
    }

    @Override
    public void exitState(HAContext context) throws ServiceFailedException {
        try {
            context.stopStandbyServices();
        }
        catch (IOException e) {
            throw new ServiceFailedException("Failed to stop standby services", e);
        }
    }

    @Override
    public void checkOperation(HAContext context, NameNode.OperationCategory op) throws StandbyException {
        if (op == NameNode.OperationCategory.UNCHECKED || op == NameNode.OperationCategory.READ && context.allowStaleReads()) {
            return;
        }
        String faq = ". Visit https://s.apache.org/sbnn-error";
        String msg = "Operation category " + (Object)((Object)op) + " is not supported in state " + context.getState() + faq;
        if (op == NameNode.OperationCategory.WRITE && this.isObserver) {
            throw new ObserverRetryOnActiveException(msg);
        }
        throw new StandbyException(msg);
    }

    @Override
    public boolean shouldPopulateReplQueues() {
        return false;
    }

    @Override
    public String toString() {
        return this.isObserver ? "observer" : "standby";
    }
}

