/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import io.trino.hadoop.$internal.org.apache.commons.cli.CommandLine;
import io.trino.hadoop.$internal.org.apache.commons.cli.HelpFormatter;
import io.trino.hadoop.$internal.org.apache.commons.codec.digest.DigestUtils;
import io.trino.hadoop.$internal.org.apache.commons.io.IOUtils;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.apache.hadoop.hdfs.tools.DiskBalancerCLI;

public class CancelCommand
extends Command {
    public CancelCommand(Configuration conf) {
        super(conf);
        this.addValidCommandParameters("cancel", "Cancels a running plan.");
        this.addValidCommandParameters("node", "Node to run the command against in node:port format.");
    }

    @Override
    public void execute(CommandLine cmd) throws Exception {
        LOG.info("Executing \"Cancel plan\" command.");
        Preconditions.checkState(cmd.hasOption("cancel"));
        this.verifyCommandOptions("cancel", cmd);
        if (cmd.hasOption("node")) {
            String nodeAddress = cmd.getOptionValue("node");
            String planHash = cmd.getOptionValue("cancel");
            this.cancelPlanUsingHash(nodeAddress, planHash);
        } else {
            String planFile = cmd.getOptionValue("cancel");
            Preconditions.checkArgument(planFile != null && !planFile.isEmpty(), "Invalid plan file specified.");
            String planData = null;
            try (FSDataInputStream plan = this.open(planFile);){
                planData = IOUtils.toString((InputStream)plan, StandardCharsets.UTF_8);
            }
            this.cancelPlan(planData);
        }
    }

    private void cancelPlan(String planData) throws IOException {
        Preconditions.checkNotNull(planData);
        NodePlan plan = NodePlan.parseJson(planData);
        String dataNodeAddress = plan.getNodeName() + ":" + plan.getPort();
        Preconditions.checkNotNull(dataNodeAddress);
        ClientDatanodeProtocol dataNode = this.getDataNodeProxy(dataNodeAddress);
        String planHash = DigestUtils.shaHex(planData);
        try {
            dataNode.cancelDiskBalancePlan(planHash);
        }
        catch (DiskBalancerException ex) {
            LOG.error("Cancelling plan on  {} failed. Result: {}, Message: {}", plan.getNodeName(), ex.getResult().toString(), ex.getMessage());
            throw ex;
        }
    }

    private void cancelPlanUsingHash(String nodeAddress, String hash) throws IOException {
        Preconditions.checkNotNull(nodeAddress);
        Preconditions.checkNotNull(hash);
        ClientDatanodeProtocol dataNode = this.getDataNodeProxy(nodeAddress);
        try {
            dataNode.cancelDiskBalancePlan(hash);
        }
        catch (DiskBalancerException ex) {
            LOG.error("Cancelling plan on  {} failed. Result: {}, Message: {}", nodeAddress, ex.getResult().toString(), ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void printHelp() {
        String header = "Cancel command cancels a running disk balancer operation.\n\n";
        String footer = "\nCancel command can be run via pointing to a plan file, or by reading the plan ID using the query command and then using planID and hostname. Examples of how to run this command are \nhdfs diskbalancer -cancel <planfile> \nhdfs diskbalancer -cancel <planID> -node <hostname>";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("hdfs diskbalancer -cancel <planFile> | -cancel <planID> -node <hostname>", header, DiskBalancerCLI.getCancelOptions(), footer);
    }
}

