/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import io.trino.hadoop.$internal.io.netty.channel.ChannelFutureListener;
import io.trino.hadoop.$internal.io.netty.channel.ChannelHandler;
import io.trino.hadoop.$internal.io.netty.channel.ChannelHandlerContext;
import io.trino.hadoop.$internal.io.netty.channel.SimpleChannelInboundHandler;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.DefaultHttpResponse;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpRequest;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpResponseStatus;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpVersion;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.QueryStringDecoder;
import io.trino.hadoop.$internal.io.netty.util.ReferenceCountUtil;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.HostRestrictingAuthorizationFilter;
import org.apache.hadoop.hdfs.server.datanode.web.DatanodeHttpServer;
import org.apache.hadoop.hdfs.web.resources.UserParam;

@InterfaceAudience.Private
@ChannelHandler.Sharable
final class HostRestrictingAuthorizationFilterHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(HostRestrictingAuthorizationFilterHandler.class);
    private final HostRestrictingAuthorizationFilter hostRestrictingAuthorizationFilter;

    public HostRestrictingAuthorizationFilterHandler(HostRestrictingAuthorizationFilter hostRestrictingAuthorizationFilter) {
        this.hostRestrictingAuthorizationFilter = hostRestrictingAuthorizationFilter;
    }

    public HostRestrictingAuthorizationFilterHandler() {
        Configuration conf = new Configuration();
        this.hostRestrictingAuthorizationFilter = HostRestrictingAuthorizationFilterHandler.initializeState(conf);
    }

    public static HostRestrictingAuthorizationFilter initializeState(Configuration conf) {
        String confName = "dfs.web.authentication.host.allow.rules";
        String confValue = conf.get(confName);
        confValue = confValue == null ? "" : confValue;
        ImmutableMap<String, String> confMap = ImmutableMap.of("host.allow.rules", confValue);
        DatanodeHttpServer.MapBasedFilterConfig fc = new DatanodeHttpServer.MapBasedFilterConfig(HostRestrictingAuthorizationFilter.class.getName(), confMap);
        HostRestrictingAuthorizationFilter hostRestrictingAuthorizationFilter = new HostRestrictingAuthorizationFilter();
        try {
            hostRestrictingAuthorizationFilter.init(fc);
        }
        catch (ServletException e) {
            throw new IllegalStateException("Failed to initialize HostRestrictingAuthorizationFilter.", e);
        }
        return hostRestrictingAuthorizationFilter;
    }

    private static void sendResponseAndClose(ChannelHandlerContext ctx, DefaultHttpResponse resp) {
        resp.headers().set("Connection", (Object)"close");
        ctx.writeAndFlush(resp).addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        this.hostRestrictingAuthorizationFilter.handleInteraction(new NettyHttpInteraction(ctx, req));
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Exception in " + this.getClass().getSimpleName(), cause);
        HostRestrictingAuthorizationFilterHandler.sendResponseAndClose(ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
    }

    private static final class NettyHttpInteraction
    implements HostRestrictingAuthorizationFilter.HttpInteraction {
        private final ChannelHandlerContext ctx;
        private final HttpRequest req;
        private boolean committed = false;

        public NettyHttpInteraction(ChannelHandlerContext ctx, HttpRequest req) {
            this.ctx = ctx;
            this.req = req;
        }

        @Override
        public boolean isCommitted() {
            return this.committed;
        }

        @Override
        public String getRemoteAddr() {
            return ((InetSocketAddress)this.ctx.channel().remoteAddress()).getAddress().getHostAddress();
        }

        @Override
        public String getQueryString() {
            try {
                return new URI(this.req.getUri()).getQuery();
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        @Override
        public String getRequestURI() {
            String uri;
            return uri.substring(0, (uri = this.req.getUri()).indexOf("?") >= 0 ? uri.indexOf("?") : uri.length());
        }

        @Override
        public String getRemoteUser() {
            QueryStringDecoder queryString = new QueryStringDecoder(this.req.getUri());
            List<String> p = queryString.parameters().get("user.name");
            String user = p == null ? null : p.get(0);
            return (String)new UserParam(user).getValue();
        }

        @Override
        public String getMethod() {
            return this.req.getMethod().name();
        }

        @Override
        public void proceed() {
            ReferenceCountUtil.retain(this.req);
            this.ctx.fireChannelRead(this.req);
        }

        @Override
        public void sendError(int code, String message) {
            HttpResponseStatus status = new HttpResponseStatus(code, message);
            HostRestrictingAuthorizationFilterHandler.sendResponseAndClose(this.ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, status));
            this.committed = true;
        }
    }
}

