/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.LightWeightResizableGSet;

class ReplicaMap {
    private final AutoCloseableLock readLock;
    private final AutoCloseableLock writeLock;
    private final Map<String, LightWeightResizableGSet<Block, ReplicaInfo>> map = new HashMap<String, LightWeightResizableGSet<Block, ReplicaInfo>>();

    ReplicaMap(AutoCloseableLock readLock, AutoCloseableLock writeLock) {
        if (readLock == null || writeLock == null) {
            throw new HadoopIllegalArgumentException("Lock to synchronize on cannot be null");
        }
        this.readLock = readLock;
        this.writeLock = writeLock;
    }

    ReplicaMap(ReadWriteLock lock) {
        this(new AutoCloseableLock(lock.readLock()), new AutoCloseableLock(lock.writeLock()));
    }

    String[] getBlockPoolList() {
        try (AutoCloseableLock l = this.readLock.acquire();){
            String[] stringArray = this.map.keySet().toArray(new String[this.map.keySet().size()]);
            return stringArray;
        }
    }

    private void checkBlockPool(String bpid) {
        if (bpid == null) {
            throw new IllegalArgumentException("Block Pool Id is null");
        }
    }

    private void checkBlock(Block b) {
        if (b == null) {
            throw new IllegalArgumentException("Block is null");
        }
    }

    ReplicaInfo get(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        ReplicaInfo replicaInfo = this.get(bpid, block.getBlockId());
        if (replicaInfo != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
            return replicaInfo;
        }
        return null;
    }

    ReplicaInfo get(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.readLock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m3 = this.map.get(bpid);
            ReplicaInfo replicaInfo = m3 != null ? (ReplicaInfo)m3.get(new Block(blockId)) : null;
            return replicaInfo;
        }
    }

    ReplicaInfo add(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m3 = this.map.get(bpid);
            if (m3 == null) {
                m3 = new LightWeightResizableGSet();
                this.map.put(bpid, m3);
            }
            ReplicaInfo replicaInfo2 = m3.put(replicaInfo);
            return replicaInfo2;
        }
    }

    ReplicaInfo addAndGet(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            ReplicaInfo oldReplicaInfo;
            LightWeightResizableGSet<Block, ReplicaInfo> m3 = this.map.get(bpid);
            if (m3 == null) {
                m3 = new LightWeightResizableGSet();
                this.map.put(bpid, m3);
            }
            if ((oldReplicaInfo = (ReplicaInfo)m3.get(replicaInfo)) != null) {
                ReplicaInfo replicaInfo2 = oldReplicaInfo;
                return replicaInfo2;
            }
            m3.put(replicaInfo);
            ReplicaInfo replicaInfo3 = replicaInfo;
            return replicaInfo3;
        }
    }

    void addAll(ReplicaMap other) {
        this.map.putAll(other.map);
    }

    void mergeAll(ReplicaMap other) {
        other.map.forEach((bp, replicaInfos) -> replicaInfos.forEach(replicaInfo -> this.add((String)bp, (ReplicaInfo)replicaInfo)));
    }

    ReplicaInfo remove(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            ReplicaInfo replicaInfo;
            LightWeightResizableGSet<Block, ReplicaInfo> m3 = this.map.get(bpid);
            if (m3 != null && (replicaInfo = (ReplicaInfo)m3.get(block)) != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
                ReplicaInfo replicaInfo2 = (ReplicaInfo)m3.remove(block);
                return replicaInfo2;
            }
        }
        return null;
    }

    ReplicaInfo remove(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m3 = this.map.get(bpid);
            if (m3 != null) {
                ReplicaInfo replicaInfo = (ReplicaInfo)m3.remove(new Block(blockId));
                return replicaInfo;
            }
        }
        return null;
    }

    int size(String bpid) {
        try (AutoCloseableLock l = this.readLock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m3 = this.map.get(bpid);
            int n = m3 != null ? m3.size() : 0;
            return n;
        }
    }

    Collection<ReplicaInfo> replicas(String bpid) {
        LightWeightResizableGSet<Block, ReplicaInfo> m3 = null;
        m3 = this.map.get(bpid);
        return m3 != null ? m3.values() : null;
    }

    void initBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m3 = this.map.get(bpid);
            if (m3 == null) {
                m3 = new LightWeightResizableGSet();
                this.map.put(bpid, m3);
            }
        }
    }

    void cleanUpBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            this.map.remove(bpid);
        }
    }

    AutoCloseableLock getLock() {
        return this.writeLock;
    }

    AutoCloseableLock getReadLock() {
        return this.readLock;
    }
}

