/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlock;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.PmemVolumeManager;
import org.apache.hadoop.io.nativeio.NativeIO;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NativePmemMappedBlock
implements MappableBlock {
    private static final Logger LOG = LoggerFactory.getLogger(NativePmemMappedBlock.class);
    private long pmemMappedAddress = -1L;
    private long length;
    private ExtendedBlockId key;

    NativePmemMappedBlock(long pmemMappedAddress, long length, ExtendedBlockId key) {
        assert (length > 0L);
        this.pmemMappedAddress = pmemMappedAddress;
        this.length = length;
        this.key = key;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getAddress() {
        return this.pmemMappedAddress;
    }

    @Override
    public ExtendedBlockId getKey() {
        return this.key;
    }

    @Override
    public void close() {
        if (this.pmemMappedAddress != -1L) {
            try {
                String cacheFilePath = PmemVolumeManager.getInstance().getCachePath(this.key);
                boolean success = NativeIO.POSIX.Pmem.unmapBlock(this.pmemMappedAddress, this.length);
                if (!success) {
                    throw new IOException("Failed to unmap the mapped file from pmem address: " + this.pmemMappedAddress);
                }
                this.pmemMappedAddress = -1L;
                FsDatasetUtil.deleteMappedFile(cacheFilePath);
                LOG.info("Successfully uncached one replica:{} from persistent memory, [cached path={}, length={}]", this.key, cacheFilePath, this.length);
            }
            catch (IOException e) {
                LOG.warn("IOException occurred for block {}!", (Object)this.key, (Object)e);
            }
        }
    }
}

