/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;

class BlockToMarkCorrupt {
    private final Block corrupted;
    private final BlockInfo stored;
    private final String reason;
    private final CorruptReplicasMap.Reason reasonCode;

    BlockToMarkCorrupt(Block corrupted, BlockInfo stored, String reason, CorruptReplicasMap.Reason reasonCode) {
        Preconditions.checkNotNull(corrupted, "corrupted is null");
        Preconditions.checkNotNull(stored, "stored is null");
        this.corrupted = corrupted;
        this.stored = stored;
        this.reason = reason;
        this.reasonCode = reasonCode;
    }

    BlockToMarkCorrupt(Block corrupted, BlockInfo stored, long gs, String reason, CorruptReplicasMap.Reason reasonCode) {
        this(corrupted, stored, reason, reasonCode);
        this.corrupted.setGenerationStamp(gs);
    }

    public boolean isCorruptedDuringWrite() {
        return this.stored.getGenerationStamp() > this.corrupted.getGenerationStamp();
    }

    public Block getCorrupted() {
        return this.corrupted;
    }

    public BlockInfo getStored() {
        return this.stored;
    }

    public String getReason() {
        return this.reason;
    }

    public CorruptReplicasMap.Reason getReasonCode() {
        return this.reasonCode;
    }

    public String toString() {
        return this.corrupted + "(" + (this.corrupted == this.stored ? "same as stored" : "stored=" + this.stored) + ")";
    }
}

