/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.ha.ZKFCProtocol;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolClientSideTranslatorPB;
import org.apache.hadoop.ha.protocolPB.ZKFCProtocolClientSideTranslatorPB;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class HAServiceTarget {
    private static final String HOST_SUBST_KEY = "host";
    private static final String PORT_SUBST_KEY = "port";
    private static final String ADDRESS_SUBST_KEY = "address";
    private HAServiceProtocol.HAServiceState transitionTargetHAStatus;

    public abstract InetSocketAddress getAddress();

    public InetSocketAddress getHealthMonitorAddress() {
        return null;
    }

    public abstract InetSocketAddress getZKFCAddress();

    public abstract NodeFencer getFencer();

    public abstract void checkFencingConfigured() throws BadFencingConfigurationException;

    public HAServiceProtocol getProxy(Configuration conf, int timeoutMs) throws IOException {
        return this.getProxyForAddress(conf, timeoutMs, this.getAddress());
    }

    public void setTransitionTargetHAStatus(HAServiceProtocol.HAServiceState status) {
        this.transitionTargetHAStatus = status;
    }

    public HAServiceProtocol.HAServiceState getTransitionTargetHAStatus() {
        return this.transitionTargetHAStatus;
    }

    public HAServiceProtocol getHealthMonitorProxy(Configuration conf, int timeoutMs) throws IOException {
        return this.getHealthMonitorProxy(conf, timeoutMs, 1);
    }

    public HAServiceProtocol getHealthMonitorProxy(Configuration conf, int timeoutMs, int retries) throws IOException {
        InetSocketAddress addr = this.getHealthMonitorAddress();
        if (addr == null) {
            addr = this.getAddress();
        }
        return this.getProxyForAddress(conf, timeoutMs, retries, addr);
    }

    private HAServiceProtocol getProxyForAddress(Configuration conf, int timeoutMs, InetSocketAddress addr) throws IOException {
        return this.getProxyForAddress(conf, timeoutMs, 1, addr);
    }

    private HAServiceProtocol getProxyForAddress(Configuration conf, int timeoutMs, int retries, InetSocketAddress addr) throws IOException {
        Configuration confCopy = new Configuration(conf);
        confCopy.setInt("ipc.client.connect.max.retries", retries);
        SocketFactory factory = NetUtils.getDefaultSocketFactory(confCopy);
        return new HAServiceProtocolClientSideTranslatorPB(addr, confCopy, factory, timeoutMs);
    }

    public ZKFCProtocol getZKFCProxy(Configuration conf, int timeoutMs) throws IOException {
        Configuration confCopy = new Configuration(conf);
        confCopy.setInt("ipc.client.connect.max.retries", 1);
        SocketFactory factory = NetUtils.getDefaultSocketFactory(confCopy);
        return new ZKFCProtocolClientSideTranslatorPB(this.getZKFCAddress(), confCopy, factory, timeoutMs);
    }

    public final Map<String, String> getFencingParameters() {
        HashMap<String, String> ret = Maps.newHashMap();
        this.addFencingParameters(ret);
        return ret;
    }

    protected void addFencingParameters(Map<String, String> ret) {
        ret.put(ADDRESS_SUBST_KEY, String.valueOf(this.getAddress()));
        ret.put(HOST_SUBST_KEY, this.getAddress().getHostName());
        ret.put(PORT_SUBST_KEY, String.valueOf(this.getAddress().getPort()));
    }

    public boolean isAutoFailoverEnabled() {
        return false;
    }

    public boolean supportObserver() {
        return false;
    }
}

