/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2;

import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.AzureADAuthenticator;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;

public class MsiTokenProvider
extends AccessTokenProvider {
    private static final Logger log = LoggerFactory.getLogger("io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.MsiTokenProvider");
    private final int localPort = -1;
    private final String tenantGuid;
    private final String clientId;
    private long tokenFetchTime = -1L;
    private static final long ONE_HOUR = 3600000L;

    public MsiTokenProvider() {
        this(null, null);
    }

    @Deprecated
    public MsiTokenProvider(int localPort) {
        this(null, null);
    }

    @Deprecated
    public MsiTokenProvider(int localPort, String tenantGuid) {
        this(tenantGuid, null);
    }

    public MsiTokenProvider(String tenantGuid, String clientId) {
        this.tenantGuid = tenantGuid;
        this.clientId = clientId;
    }

    @Override
    protected boolean isTokenAboutToExpire() {
        if (super.isTokenAboutToExpire()) {
            return true;
        }
        if (this.tokenFetchTime == -1L) {
            return true;
        }
        long offset = 3600000L;
        if (this.tokenFetchTime + offset < System.currentTimeMillis()) {
            log.debug("MSIToken: token renewing : " + offset + " milliseconds window");
            return true;
        }
        return false;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        log.debug("AADToken: refreshing token from MSI with expiry");
        AzureADToken newToken = AzureADAuthenticator.getTokenFromMsi(this.tenantGuid, this.clientId, false);
        this.tokenFetchTime = System.currentTimeMillis();
        return newToken;
    }
}

