/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.$internal.guava.collect;

import java.util.Collections;
import java.util.Spliterator;
import org.weakref.jmx.$internal.guava.annotations.GwtCompatible;
import org.weakref.jmx.$internal.guava.base.Preconditions;
import org.weakref.jmx.$internal.guava.collect.ElementTypesAreNonnullByDefault;
import org.weakref.jmx.$internal.guava.collect.ImmutableList;
import org.weakref.jmx.$internal.guava.collect.Iterators;
import org.weakref.jmx.$internal.guava.collect.UnmodifiableIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableList<E>
extends ImmutableList<E> {
    final transient E element;

    SingletonImmutableList(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex(index, 1);
        return this.element;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Collections.singleton(this.element).spliterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, 1);
        return fromIndex == toIndex ? ImmutableList.of() : this;
    }

    @Override
    public String toString() {
        String string = this.element.toString();
        return new StringBuilder(2 + String.valueOf(string).length()).append('[').append(string).append(']').toString();
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

