/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.base.Preconditions;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import java.security.Principal;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ReadOnlySystemAccessControl
implements SystemAccessControl {
    public static final String NAME = "read-only";
    private static final ReadOnlySystemAccessControl INSTANCE = new ReadOnlySystemAccessControl();

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
    }

    public void checkCanExecuteQuery(SystemSecurityContext context) {
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, Identity queryOwner) {
    }

    public Collection<Identity> filterViewQueryOwnedBy(SystemSecurityContext context, Collection<Identity> queryOwners) {
        return queryOwners;
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
    }

    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, TrinoPrincipal grantee, boolean grantOption) {
    }

    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, FunctionKind functionKind, CatalogSchemaRoutineName functionName, TrinoPrincipal grantee, boolean grantOption) {
        switch (functionKind) {
            case SCALAR: 
            case AGGREGATE: 
            case WINDOW: {
                return;
            }
            case TABLE: {
                String granteeAsString = String.format("%s '%s'", grantee.getType().name().toLowerCase(Locale.ENGLISH), grantee.getName());
                AccessDeniedException.denyGrantExecuteFunctionPrivilege((String)functionName.toString(), (Identity)context.getIdentity(), (String)granteeAsString);
            }
        }
        throw new UnsupportedOperationException("Unsupported function kind: " + functionKind);
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        return catalogs;
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        return schemaNames;
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public Set<String> filterColumns(SystemSecurityContext context, CatalogSchemaTableName tableName, Set<String> columns) {
        return columns;
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
    }

    public void checkCanShowRoles(SystemSecurityContext context) {
    }

    public void checkCanShowCurrentRoles(SystemSecurityContext context) {
    }

    public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
    }

    public static class Factory
    implements SystemAccessControlFactory {
        public String getName() {
            return ReadOnlySystemAccessControl.NAME;
        }

        public SystemAccessControl create(Map<String, String> config) {
            Preconditions.checkArgument((boolean)config.isEmpty(), (Object)"This access controller does not support any configuration properties");
            return INSTANCE;
        }
    }
}

