/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.plugin.base.security.AnyCatalogPermissionsRule;
import io.trino.plugin.base.security.AnyCatalogSchemaPermissionsRule;
import io.trino.plugin.base.security.FunctionAccessControlRule;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.function.FunctionKind;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class CatalogFunctionAccessControlRule {
    public static final CatalogFunctionAccessControlRule ALLOW_ALL = new CatalogFunctionAccessControlRule(Optional.empty(), FunctionAccessControlRule.ALLOW_ALL);
    private final Optional<Pattern> catalogRegex;
    private final FunctionAccessControlRule functionAccessControlRule;

    @JsonCreator
    public CatalogFunctionAccessControlRule(@JsonProperty(value="privileges") Set<FunctionAccessControlRule.FunctionPrivilege> privileges, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="role") Optional<Pattern> roleRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="catalog") Optional<Pattern> catalogRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex, @JsonProperty(value="function") Optional<Pattern> tableFunctionRegex, @JsonProperty(value="function_kinds") @JsonAlias(value={"functionKinds"}) Set<FunctionKind> functionKinds) {
        this(catalogRegex, new FunctionAccessControlRule(privileges, userRegex, roleRegex, groupRegex, schemaRegex, tableFunctionRegex, functionKinds));
    }

    private CatalogFunctionAccessControlRule(Optional<Pattern> catalogRegex, FunctionAccessControlRule functionAccessControlRule) {
        this.catalogRegex = Objects.requireNonNull(catalogRegex, "catalogRegex is null");
        this.functionAccessControlRule = Objects.requireNonNull(functionAccessControlRule, "functionAccessControlRule is null");
        Preconditions.checkState((functionAccessControlRule.getFunctionKinds().equals(Set.of(FunctionKind.TABLE)) || catalogRegex.isEmpty() ? 1 : 0) != 0, (Object)"Cannot define catalog for others function kinds than TABLE");
    }

    public boolean matches(String user, Set<String> roles, Set<String> groups, String functionName) {
        return this.functionAccessControlRule.matches(user, roles, groups, functionName);
    }

    public boolean matches(String user, Set<String> roles, Set<String> groups, FunctionKind functionKind, CatalogSchemaRoutineName functionName) {
        if (!this.catalogRegex.map(regex -> regex.matcher(functionName.getCatalogName()).matches()).orElse(true).booleanValue()) {
            return false;
        }
        return this.functionAccessControlRule.matches(user, roles, groups, functionKind, functionName.getSchemaRoutineName());
    }

    Optional<AnyCatalogPermissionsRule> toAnyCatalogPermissionsRule() {
        if (this.functionAccessControlRule.getPrivileges().isEmpty() || !this.functionAccessControlRule.getFunctionKinds().contains(FunctionKind.TABLE)) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogPermissionsRule(this.functionAccessControlRule.getUserRegex(), this.functionAccessControlRule.getRoleRegex(), this.functionAccessControlRule.getGroupRegex(), this.catalogRegex));
    }

    Optional<AnyCatalogSchemaPermissionsRule> toAnyCatalogSchemaPermissionsRule() {
        if (this.functionAccessControlRule.getPrivileges().isEmpty() || !this.functionAccessControlRule.getFunctionKinds().contains(FunctionKind.TABLE)) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogSchemaPermissionsRule(this.functionAccessControlRule.getUserRegex(), this.functionAccessControlRule.getRoleRegex(), this.functionAccessControlRule.getGroupRegex(), this.catalogRegex, this.functionAccessControlRule.getSchemaRegex()));
    }

    public boolean canExecuteFunction() {
        return this.functionAccessControlRule.canExecuteFunction();
    }

    public boolean canGrantExecuteFunction() {
        return this.functionAccessControlRule.canGrantExecuteFunction();
    }
}

