/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.base.security.AuthorizationRule;
import io.trino.plugin.base.security.FunctionAccessControlRule;
import io.trino.plugin.base.security.SchemaAccessControlRule;
import io.trino.plugin.base.security.SessionPropertyAccessControlRule;
import io.trino.plugin.base.security.TableAccessControlRule;
import java.util.List;
import java.util.Optional;

public class AccessControlRules {
    private final List<SchemaAccessControlRule> schemaRules;
    private final List<TableAccessControlRule> tableRules;
    private final List<SessionPropertyAccessControlRule> sessionPropertyRules;
    private final List<FunctionAccessControlRule> functionRules;
    private final List<AuthorizationRule> authorizationRules;

    @JsonCreator
    public AccessControlRules(@JsonProperty(value="schemas") Optional<List<SchemaAccessControlRule>> schemaRules, @JsonProperty(value="tables") Optional<List<TableAccessControlRule>> tableRules, @JsonProperty(value="session_properties") @JsonAlias(value={"sessionProperties"}) Optional<List<SessionPropertyAccessControlRule>> sessionPropertyRules, @JsonProperty(value="functions") Optional<List<FunctionAccessControlRule>> functionRules, @JsonProperty(value="authorization") Optional<List<AuthorizationRule>> authorizationRules) {
        this.schemaRules = schemaRules.orElse((List<SchemaAccessControlRule>)ImmutableList.of((Object)SchemaAccessControlRule.ALLOW_ALL));
        this.tableRules = tableRules.orElse((List<TableAccessControlRule>)ImmutableList.of((Object)TableAccessControlRule.ALLOW_ALL));
        this.sessionPropertyRules = sessionPropertyRules.orElse((List<SessionPropertyAccessControlRule>)ImmutableList.of((Object)SessionPropertyAccessControlRule.ALLOW_ALL));
        this.functionRules = functionRules.orElse((List<FunctionAccessControlRule>)ImmutableList.of((Object)FunctionAccessControlRule.ALLOW_ALL));
        this.authorizationRules = authorizationRules.orElse((List<AuthorizationRule>)ImmutableList.of());
    }

    public List<SchemaAccessControlRule> getSchemaRules() {
        return this.schemaRules;
    }

    public List<TableAccessControlRule> getTableRules() {
        return this.tableRules;
    }

    public List<SessionPropertyAccessControlRule> getSessionPropertyRules() {
        return this.sessionPropertyRules;
    }

    public List<FunctionAccessControlRule> getFunctionRules() {
        return this.functionRules;
    }

    public List<AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public boolean hasRoleRules() {
        return this.schemaRules.stream().anyMatch(rule -> rule.getRoleRegex().isPresent()) || this.tableRules.stream().anyMatch(rule -> rule.getRoleRegex().isPresent()) || this.sessionPropertyRules.stream().anyMatch(rule -> rule.getRoleRegex().isPresent()) || this.functionRules.stream().anyMatch(rule -> rule.getRoleRegex().isPresent()) || this.authorizationRules.stream().anyMatch(rule -> rule.getOriginalRolePattern().isPresent()) || this.authorizationRules.stream().anyMatch(rule -> rule.getNewRolePattern().isPresent());
    }
}

