/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;

public abstract class ScriptDocValues<T>
extends AbstractList<T> {
    static final boolean EXCEPTION_FOR_MISSING_VALUE = org.elasticsearch.common.Booleans.parseBoolean((String)System.getProperty("es.scripting.exception_for_missing_value", "false"));
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(ScriptDocValues.class));
    private final BiConsumer<String, String> deprecationCallback;

    public ScriptDocValues() {
        this.deprecationCallback = (x$0, x$1) -> deprecationLogger.deprecatedAndMaybeLog((String)x$0, (String)x$1, new Object[0]);
    }

    ScriptDocValues(BiConsumer<String, String> deprecationCallback) {
        this.deprecationCallback = deprecationCallback;
    }

    public abstract void setNextDocId(int var1) throws IOException;

    public final List<T> getValues() {
        this.deprecated("ScriptDocValues#getValues", "Deprecated getValues used, the field is a list and should be accessed directly. For example, use doc['foo'] instead of doc['foo'].values.");
        return this;
    }

    @Override
    public final void add(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final T set(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void sort(Comparator<? super T> c) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    protected void deprecated(final String key, final String message) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ScriptDocValues.this.deprecationCallback.accept(key, message);
                return null;
            }
        });
    }

    public static final class BytesRefs
    extends BinaryScriptDocValues<BytesRef> {
        protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(Strings.class));

        public BytesRefs(SortedBinaryDocValues in) {
            this(in, (key, message) -> deprecationLogger.deprecatedAndMaybeLog((String)key, (String)message, new Object[0]));
        }

        public BytesRefs(SortedBinaryDocValues in, BiConsumer<String, String> deprecationCallback) {
            super(in, deprecationCallback);
        }

        @Override
        public BytesRef get(int index) {
            if (this.count == 0) {
                if (EXCEPTION_FOR_MISSING_VALUE) {
                    throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
                }
                this.deprecated("scripting_missing_value_deprecation", "returning default values for missing document values is deprecated. Set system property '-Des.scripting.exception_for_missing_value=true' to make behaviour compatible with future major versions!");
                return new BytesRef();
            }
            return this.values[index].toBytesRef();
        }

        public BytesRef getValue() {
            return this.get(0);
        }
    }

    public static final class Strings
    extends BinaryScriptDocValues<String> {
        protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(Strings.class));

        public Strings(SortedBinaryDocValues in) {
            this(in, (key, message) -> deprecationLogger.deprecatedAndMaybeLog((String)key, (String)message, new Object[0]));
        }

        public Strings(SortedBinaryDocValues in, BiConsumer<String, String> deprecationCallback) {
            super(in, deprecationCallback);
        }

        @Override
        public String get(int index) {
            if (this.count == 0) {
                if (EXCEPTION_FOR_MISSING_VALUE) {
                    throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
                }
                this.deprecated("scripting_missing_value_deprecation", "returning default values for missing document values is deprecated. Set system property '-Des.scripting.exception_for_missing_value=true' to make behaviour compatible with future major versions!");
                return null;
            }
            return this.values[index].get().utf8ToString();
        }

        public String getValue() {
            return this.get(0);
        }
    }

    static abstract class BinaryScriptDocValues<T>
    extends ScriptDocValues<T> {
        private final SortedBinaryDocValues in;
        protected BytesRefBuilder[] values = new BytesRefBuilder[0];
        protected int count;

        BinaryScriptDocValues(SortedBinaryDocValues in, BiConsumer<String, String> deprecationCallback) {
            super(deprecationCallback);
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i].copyBytes(this.in.nextValue());
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            if (newSize > this.values.length) {
                int oldLength = this.values.length;
                this.values = (BytesRefBuilder[])ArrayUtil.grow((Object[])this.values, (int)this.count);
                for (int i = oldLength; i < this.values.length; ++i) {
                    this.values[i] = new BytesRefBuilder();
                }
            }
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static final class Booleans
    extends ScriptDocValues<Boolean> {
        private final SortedNumericDocValues in;
        private boolean[] values = new boolean[0];
        private int count;
        protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(Booleans.class));

        public Booleans(SortedNumericDocValues in) {
            this(in, (key, message) -> deprecationLogger.deprecatedAndMaybeLog((String)key, (String)message, new Object[0]));
        }

        public Booleans(SortedNumericDocValues in, BiConsumer<String, String> deprecationCallback) {
            super(deprecationCallback);
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue() == 1L;
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = Booleans.grow(this.values, this.count);
        }

        public boolean getValue() {
            return this.get(0);
        }

        @Override
        public Boolean get(int index) {
            if (this.count == 0) {
                if (EXCEPTION_FOR_MISSING_VALUE) {
                    throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
                }
                this.deprecated("scripting_missing_value_deprecation", "returning default values for missing document values is deprecated. Set system property '-Des.scripting.exception_for_missing_value=true' to make behaviour compatible with future major versions!");
                return false;
            }
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }

        private static boolean[] grow(boolean[] array, int minSize) {
            assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
            if (array.length < minSize) {
                return Arrays.copyOf(array, ArrayUtil.oversize((int)minSize, (int)1));
            }
            return array;
        }
    }

    public static final class GeoPoints
    extends ScriptDocValues<GeoPoint> {
        private final MultiGeoPointValues in;
        private GeoPoint[] values = new GeoPoint[0];
        private int count;
        protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(GeoPoints.class));

        public GeoPoints(MultiGeoPointValues in) {
            this(in, (key, message) -> deprecationLogger.deprecatedAndMaybeLog((String)key, (String)message, new Object[0]));
        }

        GeoPoints(MultiGeoPointValues in, BiConsumer<String, String> deprecationCallback) {
            super(deprecationCallback);
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    GeoPoint point = this.in.nextValue();
                    this.values[i] = new GeoPoint(point.lat(), point.lon());
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            if (newSize > this.values.length) {
                int oldLength = this.values.length;
                this.values = (GeoPoint[])ArrayUtil.grow((Object[])this.values, (int)this.count);
                for (int i = oldLength; i < this.values.length; ++i) {
                    this.values[i] = new GeoPoint();
                }
            }
        }

        public GeoPoint getValue() {
            return this.get(0);
        }

        public double getLat() {
            return this.getValue().lat();
        }

        public double[] getLats() {
            List points = this.getValues();
            double[] lats = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                lats[i] = ((GeoPoint)points.get(i)).lat();
            }
            return lats;
        }

        public double[] getLons() {
            List points = this.getValues();
            double[] lons = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                lons[i] = ((GeoPoint)points.get(i)).lon();
            }
            return lons;
        }

        public double getLon() {
            return this.getValue().lon();
        }

        @Override
        public GeoPoint get(int index) {
            if (this.count == 0) {
                if (EXCEPTION_FOR_MISSING_VALUE) {
                    throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
                }
                this.deprecated("scripting_missing_value_deprecation", "returning default values for missing document values is deprecated. Set system property '-Des.scripting.exception_for_missing_value=true' to make behaviour compatible with future major versions!");
                return null;
            }
            GeoPoint point = this.values[index];
            return new GeoPoint(point.lat(), point.lon());
        }

        @Override
        public int size() {
            return this.count;
        }

        public double arcDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), lat, lon);
        }

        public double arcDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.arcDistance(lat, lon);
        }

        public double planeDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.planeDistance(point.lat(), point.lon(), lat, lon);
        }

        public double planeDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.planeDistance(lat, lon);
        }

        public double geohashDistance(String geohash) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), GeoHashUtils.decodeLatitude(geohash), GeoHashUtils.decodeLongitude(geohash));
        }

        public double geohashDistanceWithDefault(String geohash, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.geohashDistance(geohash);
        }
    }

    public static final class Doubles
    extends ScriptDocValues<Double> {
        private final SortedNumericDoubleValues in;
        private double[] values = new double[0];
        private int count;
        protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(Doubles.class));

        public Doubles(SortedNumericDoubleValues in) {
            this(in, (key, message) -> deprecationLogger.deprecatedAndMaybeLog((String)key, (String)message, new Object[0]));
        }

        public Doubles(SortedNumericDoubleValues in, BiConsumer<String, String> deprecationCallback) {
            super(deprecationCallback);
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue();
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = ArrayUtil.grow((double[])this.values, (int)this.count);
        }

        public SortedNumericDoubleValues getInternalValues() {
            return this.in;
        }

        public double getValue() {
            return this.get(0);
        }

        @Override
        public Double get(int index) {
            if (this.count == 0) {
                if (EXCEPTION_FOR_MISSING_VALUE) {
                    throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
                }
                this.deprecated("scripting_missing_value_deprecation", "returning default values for missing document values is deprecated. Set system property '-Des.scripting.exception_for_missing_value=true' to make behaviour compatible with future major versions!");
                return 0.0;
            }
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static final class Dates
    extends ScriptDocValues<JodaCompatibleZonedDateTime> {
        private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(Dates.class));
        private final JodaCompatibleZonedDateTime EPOCH = new JodaCompatibleZonedDateTime(Instant.EPOCH, ZoneOffset.UTC);
        private final SortedNumericDocValues in;
        private JodaCompatibleZonedDateTime[] dates;
        private int count;

        public Dates(SortedNumericDocValues in) {
            this(in, (key, message) -> deprecationLogger.deprecatedAndMaybeLog((String)key, (String)message, new Object[0]));
        }

        Dates(SortedNumericDocValues in, BiConsumer<String, String> deprecationCallback) {
            super(deprecationCallback);
            this.in = in;
        }

        public JodaCompatibleZonedDateTime getValue() {
            return this.get(0);
        }

        @Deprecated
        public JodaCompatibleZonedDateTime getDate() {
            this.deprecated("scripting_get_date_deprecation", "getDate is no longer necessary on date fields as the value is now a date.");
            return this.getValue();
        }

        @Deprecated
        public List<JodaCompatibleZonedDateTime> getDates() {
            this.deprecated("scripting_get_date_deprecation", "getDates is no longer necessary on date fields as the values are now dates.");
            return this;
        }

        @Override
        public JodaCompatibleZonedDateTime get(int index) {
            if (this.count == 0) {
                if (EXCEPTION_FOR_MISSING_VALUE) {
                    throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
                }
                this.deprecated("scripting_missing_value_deprecation", "returning default values for missing document values is deprecated. Set system property '-Des.scripting.exception_for_missing_value=true' to make behaviour compatible with future major versions!");
                return this.EPOCH;
            }
            if (index >= this.count) {
                throw new IndexOutOfBoundsException("attempted to fetch the [" + index + "] date when there are only [" + this.count + "] dates.");
            }
            return this.dates[index];
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            this.count = this.in.advanceExact(docId) ? this.in.docValueCount() : 0;
            this.refreshArray();
        }

        void refreshArray() throws IOException {
            if (this.count == 0) {
                return;
            }
            if (this.dates == null || this.count > this.dates.length) {
                this.dates = new JodaCompatibleZonedDateTime[this.count];
            }
            for (int i = 0; i < this.count; ++i) {
                this.dates[i] = new JodaCompatibleZonedDateTime(Instant.ofEpochMilli(this.in.nextValue()), ZoneOffset.UTC);
            }
        }
    }

    public static final class Longs
    extends ScriptDocValues<Long> {
        protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(Longs.class));
        private final BiConsumer<String, String> deprecationCallback;
        private final SortedNumericDocValues in;
        private long[] values = new long[0];
        private int count;
        private Dates dates;
        private int docId = -1;

        public Longs(SortedNumericDocValues in) {
            this(in, (key, message) -> deprecationLogger.deprecatedAndMaybeLog((String)key, (String)message, new Object[0]));
        }

        Longs(SortedNumericDocValues in, BiConsumer<String, String> deprecationCallback) {
            super(deprecationCallback);
            this.deprecationCallback = deprecationCallback;
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            this.docId = docId;
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue();
                }
            } else {
                this.resize(0);
            }
            if (this.dates != null) {
                this.dates.setNextDocId(docId);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = ArrayUtil.grow((long[])this.values, (int)this.count);
        }

        public SortedNumericDocValues getInternalValues() {
            return this.in;
        }

        public long getValue() {
            return this.get(0);
        }

        @Deprecated
        public JodaCompatibleZonedDateTime getDate() throws IOException {
            this.deprecated("scripting_get_date_deprecation", "getDate on numeric fields is deprecated. Use a date field to get dates.");
            if (this.dates == null) {
                this.dates = new Dates(this.in, this.deprecationCallback);
                this.dates.setNextDocId(this.docId);
            }
            return this.dates.getValue();
        }

        @Deprecated
        public List<JodaCompatibleZonedDateTime> getDates() throws IOException {
            this.deprecated("scripting_get_date_deprecation", "getDates on numeric fields is deprecated. Use a date field to get dates.");
            if (this.dates == null) {
                this.dates = new Dates(this.in, this.deprecationCallback);
                this.dates.setNextDocId(this.docId);
            }
            return this.dates;
        }

        @Override
        public Long get(int index) {
            if (this.count == 0) {
                if (EXCEPTION_FOR_MISSING_VALUE) {
                    throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
                }
                this.deprecated("scripting_missing_value_deprecation", "returning default values for missing document values is deprecated. Set system property '-Des.scripting.exception_for_missing_value=true' to make behaviour compatible with future major versions!");
                return 0L;
            }
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }
    }
}

