/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration.validation;

import io.airlift.configuration.validation.FileExists;
import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileExistsValidator
implements ConstraintValidator<FileExists, Object> {
    public void initialize(FileExists ignored) {
        if (!ignored.message().isEmpty()) {
            throw new ConstraintDeclarationException("FileExists.message cannot be specified");
        }
    }

    public boolean isValid(Object path, ConstraintValidatorContext context) {
        if (path == null) {
            return true;
        }
        boolean fileExists = FileExistsValidator.exists(path);
        if (!fileExists) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("file does not exist: " + path).addConstraintViolation();
        }
        return fileExists;
    }

    private static boolean exists(Object path) {
        if (path instanceof String) {
            return Files.exists(Paths.get((String)path, new String[0]), new LinkOption[0]);
        }
        if (path instanceof Path) {
            return Files.exists((Path)path, new LinkOption[0]);
        }
        if (path instanceof File) {
            return ((File)path).exists();
        }
        throw new ConstraintDeclarationException("Unsupported type for @FileExists: " + path.getClass().getName());
    }
}

